/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.BoundingVoid;
import org.j3d.aviatrix3d.BoundingVolume;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Node;

public class SwitchGroup
extends Group {
    private int selectedChild = -1;
    private Node[] renderedChild = new Node[1];

    public void setChild(Node node, int n) throws InvalidWriteTimingException {
        super.setChild(node, n);
        if (n == this.selectedChild) {
            this.renderedChild[0] = node;
        }
    }

    public void removeChild(int n) throws InvalidWriteTimingException {
        if (this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n == this.selectedChild) {
            this.selectedChild = -1;
            this.renderedChild[0] = null;
        }
        super.removeChild(n);
    }

    public Node[] getRenderableChild() {
        return this.renderedChild;
    }

    public int numRenderableChildren() {
        if (this.selectedChild == -1) {
            return 0;
        }
        return 1;
    }

    public void removeAllChildren() throws InvalidWriteTimingException {
        super.removeAllChildren();
        this.renderedChild[0] = null;
        this.selectedChild = -1;
    }

    protected void recomputeBounds() {
        if (this.selectedChild == -1 || this.childList[this.selectedChild] == null) {
            this.bounds = INVALID_BOUNDS;
            return;
        }
        BoundingVolume boundingVolume = this.childList[this.selectedChild].getBounds();
        if (boundingVolume instanceof BoundingVoid) {
            this.bounds = INVALID_BOUNDS;
            return;
        }
        boundingVolume.getExtents(this.wkVec1, this.wkVec2);
        if (this.bounds == null || this.bounds instanceof BoundingVoid) {
            this.bounds = new BoundingBox();
        }
        BoundingBox boundingBox = (BoundingBox)this.bounds;
        boundingBox.setMinimum(this.wkVec1);
        boundingBox.setMaximum(this.wkVec2);
    }

    public void setActiveChild(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n > this.lastChild) {
            throw new IllegalArgumentException("Index is not valid");
        }
        this.selectedChild = n < 0 ? -1 : n;
        this.renderedChild[0] = n >= 0 ? this.childList[n] : null;
    }

    public int getActiveChild() {
        return this.selectedChild;
    }
}

