/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.util.HashMap;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.NodeComponent;
import org.j3d.aviatrix3d.RenderableObject;

public class TexCoordGeneration
extends NodeComponent
implements Comparable,
RenderableObject {
    private static final String INVALID_COORD_MSG = "The coordinate specified is not one of S,T,R or Q";
    private static final String INVALID_MODE_MSG = "The generation mode is invalid. Must be one of the MODE_x constants.";
    private static final String INVALID_PARAM_MSG = "The mode's map parameter is invalid. Must be one of the MAP_x constants.";
    public static final int TEXTURE_S = 8192;
    public static final int TEXTURE_T = 8193;
    public static final int TEXTURE_R = 8194;
    public static final int TEXTURE_Q = 8195;
    public static final int MODE_GENERIC = 9472;
    public static final int MODE_OBJECT_PLANE = 9473;
    public static final int MODE_EYE_PLANE = 9474;
    public static final int MAP_OBJECT_LINEAR = 9217;
    public static final int MAP_EYE_LINEAR = 9216;
    public static final int MAP_SPHERICAL = 9218;
    public static final int MAP_NORMALS = 34065;
    public static final int MAP_REFLECTIONS = 34066;
    private static final int[] ENABLE_MODE = new int[]{3168, 3169, 3170, 3171};
    private float[][] parameters = new float[4][];
    private int[] coordinate = new int[4];
    private int[] modes = new int[4];
    private int[] mapping = new int[4];
    private HashMap displayListMap = new HashMap();
    private HashMap deletedDisplayListMap = new HashMap();

    public TexCoordGeneration() {
    }

    public TexCoordGeneration(int n, int n2, int n3, float[] fArray) {
        this();
        this.setParameter(n, n2, n3, fArray);
    }

    public void render(GL gL, GLU gLU) {
        Integer n;
        if (this.deletedDisplayListMap.size() != 0 && (n = (Integer)this.deletedDisplayListMap.remove(gL)) != null) {
            gL.glDeleteLists(n.intValue(), 1);
        }
        if ((n = (Integer)this.displayListMap.get(gL)) == null) {
            n = new Integer(gL.glGenLists(1));
            gL.glNewList(n.intValue(), 4865);
            for (int i = 0; i < 4; ++i) {
                if (this.coordinate[i] == 0) continue;
                if (this.modes[i] == 9472) {
                    gL.glTexGeni(this.coordinate[i], this.modes[i], this.mapping[i]);
                    if (this.mapping[i] == 9217) {
                        gL.glTexGenfv(this.coordinate[i], 9473, this.parameters[i]);
                    }
                } else {
                    gL.glTexGeniv(this.coordinate[i], this.modes[i], new int[0]);
                }
                gL.glEnable(ENABLE_MODE[i]);
            }
            gL.glEndList();
            this.displayListMap.put(gL, n);
        } else {
            gL.glCallList(n.intValue());
        }
    }

    public void postRender(GL gL, GLU gLU) {
        for (int i = 0; i < 4; ++i) {
            if (this.coordinate[i] == 0) continue;
            gL.glDisable(ENABLE_MODE[i]);
        }
    }

    public int compareTo(Object object) throws ClassCastException {
        TexCoordGeneration texCoordGeneration = (TexCoordGeneration)object;
        return this.compareTo(texCoordGeneration);
    }

    public int getMode(int n) {
        int n2 = 0;
        switch (n) {
            case 8192: {
                n2 = this.modes[0];
                break;
            }
            case 8193: {
                n2 = this.modes[1];
                break;
            }
            case 8194: {
                n2 = this.modes[2];
                break;
            }
            case 8195: {
                n2 = this.modes[3];
            }
        }
        return n2;
    }

    public void clearParameter(int n) {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        switch (n) {
            case 8192: {
                this.clearActiveList();
                this.coordinate[0] = 0;
                break;
            }
            case 8193: {
                this.clearActiveList();
                this.coordinate[1] = 0;
                break;
            }
            case 8194: {
                this.clearActiveList();
                this.coordinate[2] = 0;
                break;
            }
            case 8195: {
                this.clearActiveList();
                this.coordinate[3] = 0;
            }
        }
    }

    public void setParameter(int n, int n2, int n3, float[] fArray) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.checkMode(n2);
        if (n2 == 9472) {
            this.checkParameter(n3);
        }
        switch (n) {
            case 8192: {
                this.coordinate[0] = 8192;
                this.modes[0] = n2;
                this.mapping[0] = n3;
                if (fArray != null) {
                    if (this.parameters[0] == null) {
                        this.parameters[0] = new float[4];
                    }
                    this.parameters[0][0] = fArray[0];
                    this.parameters[0][1] = fArray[1];
                    this.parameters[0][2] = fArray[2];
                    this.parameters[0][3] = fArray[3];
                }
                this.clearActiveList();
                break;
            }
            case 8193: {
                this.coordinate[1] = 8193;
                this.modes[1] = n2;
                this.mapping[1] = n3;
                if (fArray != null) {
                    if (this.parameters[1] == null) {
                        this.parameters[1] = new float[4];
                    }
                    this.parameters[1][0] = fArray[0];
                    this.parameters[1][1] = fArray[1];
                    this.parameters[1][2] = fArray[2];
                    this.parameters[1][3] = fArray[3];
                }
                this.clearActiveList();
                break;
            }
            case 8194: {
                this.coordinate[2] = 8194;
                this.modes[2] = n2;
                this.mapping[2] = n3;
                if (fArray != null) {
                    if (this.parameters[2] == null) {
                        this.parameters[2] = new float[4];
                    }
                    this.parameters[2][0] = fArray[0];
                    this.parameters[2][1] = fArray[1];
                    this.parameters[2][2] = fArray[2];
                    this.parameters[2][3] = fArray[3];
                }
                this.clearActiveList();
                break;
            }
            case 8195: {
                this.coordinate[3] = 8195;
                this.modes[3] = n2;
                this.mapping[3] = n3;
                if (fArray != null) {
                    if (this.parameters[3] == null) {
                        this.parameters[3] = new float[4];
                    }
                    this.parameters[3][0] = fArray[0];
                    this.parameters[3][1] = fArray[1];
                    this.parameters[3][2] = fArray[2];
                    this.parameters[3][3] = fArray[3];
                }
                this.clearActiveList();
                break;
            }
            default: {
                throw new IllegalArgumentException(INVALID_COORD_MSG);
            }
        }
    }

    public int compareTo(TexCoordGeneration texCoordGeneration) {
        if (texCoordGeneration == null) {
            return 1;
        }
        if (texCoordGeneration == this) {
            return 0;
        }
        for (int i = 0; i < 4; ++i) {
            if (this.coordinate[i] != texCoordGeneration.coordinate[i]) {
                return this.coordinate[i] < texCoordGeneration.coordinate[i] ? -1 : 1;
            }
            if (this.coordinate[i] == 0) continue;
            if (this.mapping[i] != texCoordGeneration.mapping[i]) {
                return this.mapping[i] < texCoordGeneration.mapping[i] ? -1 : 1;
            }
            if (this.parameters[i] != texCoordGeneration.parameters[i]) {
                if (this.parameters[i] == null) {
                    return -1;
                }
                if (texCoordGeneration.parameters[i] == null) {
                    return 1;
                }
                if (this.parameters[i][0] != texCoordGeneration.parameters[i][0]) {
                    return this.parameters[i][0] < texCoordGeneration.parameters[i][0] ? -1 : 1;
                }
                if (this.parameters[i][1] != texCoordGeneration.parameters[i][1]) {
                    return this.parameters[i][1] < texCoordGeneration.parameters[i][1] ? -1 : 1;
                }
                if (this.parameters[i][2] != texCoordGeneration.parameters[i][2]) {
                    return this.parameters[i][2] < texCoordGeneration.parameters[i][2] ? -1 : 1;
                }
                if (this.parameters[i][3] != texCoordGeneration.parameters[i][3]) {
                    return this.parameters[i][3] < texCoordGeneration.parameters[i][3] ? -1 : 1;
                }
            }
            if (this.modes[i] == texCoordGeneration.modes[i]) continue;
            return this.modes[i] < texCoordGeneration.modes[i] ? -1 : 1;
        }
        return 0;
    }

    private void checkMode(int n) throws IllegalArgumentException {
        switch (n) {
            case 9472: 
            case 9473: 
            case 9474: {
                break;
            }
            default: {
                throw new IllegalArgumentException(INVALID_MODE_MSG);
            }
        }
    }

    private void checkParameter(int n) throws IllegalArgumentException {
        switch (n) {
            case 9216: 
            case 9217: 
            case 9218: 
            case 34065: 
            case 34066: {
                break;
            }
            default: {
                throw new IllegalArgumentException(INVALID_PARAM_MSG);
            }
        }
    }

    private void clearActiveList() {
        if (this.displayListMap.size() == 0) {
            return;
        }
        this.deletedDisplayListMap.putAll(this.displayListMap);
        this.displayListMap.clear();
    }
}

