/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.Texture;
import org.j3d.aviatrix3d.TextureComponent;
import org.j3d.aviatrix3d.TextureComponent1D;
import org.j3d.aviatrix3d.TextureSource;
import org.j3d.aviatrix3d.iutil.TextureUpdateData;

public class Texture1D
extends Texture {
    public Texture1D() {
        super(3552, 1);
        this.init();
    }

    public Texture1D(int n, TextureComponent1D textureComponent1D) {
        super(3552, 1);
        this.format = n;
        this.sources = new TextureSource[1];
        this.sources[0] = textureComponent1D;
        this.width = textureComponent1D.getWidth();
        this.numSources = 1;
        this.init();
    }

    public int compareTo(Texture texture) {
        int n = super.compareTo(texture);
        if (n != 0) {
            return n;
        }
        Texture1D texture1D = (Texture1D)texture;
        if (this.boundaryModeS != texture1D.boundaryModeS) {
            return this.boundaryModeS < texture1D.boundaryModeS ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(Texture texture) {
        if (!super.equals(texture)) {
            return false;
        }
        if (!(texture instanceof Texture1D)) {
            return false;
        }
        Texture1D texture1D = (Texture1D)texture;
        return this.boundaryModeS == texture1D.boundaryModeS;
    }

    public void render(GL gL, GLU gLU) {
        int n;
        int n2;
        if (this.numSources == 0) {
            return;
        }
        Integer n3 = (Integer)this.textureIdMap.get(gL);
        if (n3 == null) {
            int[] nArray = new int[1];
            gL.glGenTextures(1, nArray);
            this.textureIdMap.put(gL, new Integer(nArray[0]));
            gL.glBindTexture(this.textureType, nArray[0]);
            this.imageChanged.put(gL, true);
            this.stateChanged.put(gL, true);
            this.updateManagers[0].addContext(gL);
        } else {
            gL.glBindTexture(this.textureType, n3.intValue());
        }
        if (this.stateChanged.getState(gL)) {
            this.stateChanged.put(gL, false);
            gL.glPixelStorei(3317, 1);
            gL.glTexParameteri(3552, 10242, this.boundaryModeS);
            int n4 = 0;
            switch (this.magFilter) {
                case 0: 
                case 2: {
                    n4 = 9728;
                    break;
                }
                case 1: 
                case 3: {
                    n4 = 9729;
                    break;
                }
                default: {
                    System.out.println("Unknown mode in MagFilter: " + this.magFilter);
                }
            }
            gL.glTexParameteri(3552, 10240, n4);
            switch (this.minFilter) {
                case 0: 
                case 2: {
                    n4 = 9728;
                    break;
                }
                case 3: {
                    n4 = 9729;
                    break;
                }
                case 5: {
                    n4 = 9987;
                    break;
                }
                case 4: {
                    n4 = 9984;
                    break;
                }
                case 1: {
                    n4 = this.numSources > 1 ? 9987 : 9729;
                    break;
                }
                default: {
                    System.out.println("Unknown mode in MinFilter: " + this.minFilter);
                }
            }
            gL.glTexParameteri(3552, 10241, n4);
            if (this.anisotropicMode != 0) {
                gL.glTexParameterf(3552, 34046, this.anisotropicDegree);
            }
            if (this.priority >= 0.0f) {
                gL.glTexParameterf(3552, 32870, this.priority);
            }
            if (this.borderColor != null) {
                gL.glTexParameterfv(3552, 4100, this.borderColor);
            }
            if (this.format == 6402) {
                gL.glTexParameterf(3552, 34891, (float)this.depthComponentMode);
                gL.glTexParameterf(3552, 34892, (float)this.compareMode);
                gL.glTexParameterf(3552, 34893, (float)this.compareFunction);
            }
        }
        if (this.imageChanged.getState(gL)) {
            this.imageChanged.put(gL, false);
            int n5 = this.mipMapMode == 0 ? 1 : this.numSources;
            int n6 = this.sources[0].getWidth();
            for (n2 = 0; n2 < n5; ++n2) {
                ByteBuffer byteBuffer = ((TextureComponent)this.sources[0]).getData(n2);
                int n7 = this.sources[0].getFormat(n2);
                int n8 = 6407;
                int n9 = 6407;
                switch (n7) {
                    case 1: {
                        n8 = 6407;
                        n9 = 6407;
                        break;
                    }
                    case 2: {
                        n8 = 6408;
                        n9 = 6408;
                        break;
                    }
                    case 3: {
                        n8 = 32992;
                        n9 = 32992;
                        break;
                    }
                    case 4: {
                        n8 = 32993;
                        n9 = 32993;
                        break;
                    }
                    case 5: {
                        n8 = 6410;
                        n9 = 6410;
                        break;
                    }
                    case 6: {
                        switch (this.format) {
                            case 32841: {
                                n8 = 32841;
                                n9 = 6409;
                                break;
                            }
                            case 6409: {
                                n8 = 6409;
                                n9 = 6409;
                                break;
                            }
                            case 6406: {
                                n8 = 6406;
                                n9 = 6406;
                            }
                        }
                        break;
                    }
                }
                gL.glTexImage1D(3552, n2, n8, n6, 0, n9, 5121, (Buffer)byteBuffer);
                byteBuffer.clear();
                byteBuffer = null;
                if (n6 <= 1) continue;
                n6 >>= 1;
            }
        }
        if ((n = this.updateManagers[0].getNumUpdatesPending(gL)) != 0) {
            TextureUpdateData[] textureUpdateDataArray = this.updateManagers[0].getUpdatesAndClear(gL);
            for (n2 = 0; n2 < n; ++n2) {
                gL.glTexSubImage1D(3552, textureUpdateDataArray[n2].level, textureUpdateDataArray[n2].x, textureUpdateDataArray[n2].width, textureUpdateDataArray[n2].format, 5121, (Buffer)textureUpdateDataArray[n2].pixels);
            }
        }
    }

    public void postRender(GL gL, GLU gLU) {
        gL.glDisable(this.textureType);
    }

    private void init() {
        if (this.numSources == 0) {
            return;
        }
        int n = this.mipMapMode == 0 ? 1 : this.sources[0].getNumLevels();
        for (int i = 0; i < n; ++i) {
            int n2 = this.sources[0].getFormat(i);
            int n3 = 6407;
            switch (n2) {
                case 1: {
                    n3 = 6407;
                    break;
                }
                case 2: {
                    n3 = 6408;
                    break;
                }
                case 3: {
                    n3 = 32992;
                    break;
                }
                case 4: {
                    n3 = 32993;
                    break;
                }
                case 5: {
                    n3 = 6410;
                    break;
                }
                case 6: {
                    switch (this.format) {
                        case 32841: {
                            n3 = 32841;
                            break;
                        }
                        case 6409: {
                            n3 = 6409;
                            break;
                        }
                        case 6406: {
                            n3 = 6406;
                        }
                    }
                    break;
                }
            }
            this.updateManagers[i].setTextureFormat(n3);
            ((TextureComponent)this.sources[i]).addUpdateListener(this.updateManagers[i]);
        }
    }
}

