/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.MultipassTextureDestination;
import org.j3d.aviatrix3d.MultipassTextureSource;
import org.j3d.aviatrix3d.OffscreenTexture2D;
import org.j3d.aviatrix3d.Texture;
import org.j3d.aviatrix3d.TextureComponent;
import org.j3d.aviatrix3d.TextureComponent2D;
import org.j3d.aviatrix3d.TextureSource;
import org.j3d.aviatrix3d.iutil.TextureUpdateData;

public class Texture2D
extends Texture
implements MultipassTextureDestination {
    protected int boundaryModeT;
    protected int height;
    protected int mpReadBuffer;
    protected int[][] mpOffsets;
    protected int mpNumSources;

    public Texture2D() {
        super(3553);
        this.height = -1;
        this.numSources = 0;
        this.mpNumSources = 0;
        this.init();
    }

    public Texture2D(int n, TextureComponent2D textureComponent2D) {
        super(3553, 1);
        this.format = n;
        this.sources = new TextureSource[1];
        this.sources[0] = textureComponent2D;
        this.numSources = 1;
        this.mipMapMode = textureComponent2D.getNumLevels() == 1 ? 0 : 1;
        this.mpNumSources = textureComponent2D instanceof MultipassTextureSource ? 1 : 0;
        this.width = textureComponent2D.getWidth();
        this.height = textureComponent2D.getHeight();
        this.init();
    }

    public int numMultipassSources() {
        return this.mpNumSources;
    }

    public void getMultipassSources(MultipassTextureSource[] multipassTextureSourceArray, int[] nArray) {
        if (this.mpNumSources == 0) {
            return;
        }
        multipassTextureSourceArray[0] = multipassTextureSourceArray[0];
        nArray[0] = 0;
    }

    public void updateMultipassSource(GL gL, GLU gLU, int n, int n2, int n3, int n4, int n5, int n6) {
        gL.glReadBuffer(this.mpReadBuffer);
        Integer n7 = (Integer)this.textureIdMap.get(gL);
        if (n7 == null) {
            int[] nArray = new int[1];
            gL.glGenTextures(1, nArray);
            this.textureIdMap.put(gL, new Integer(nArray[0]));
            gL.glBindTexture(this.textureType, nArray[0]);
            int n8 = this.sources[0].getFormat(n6);
            int n9 = 6407;
            switch (n8) {
                case 1: {
                    n9 = 6407;
                    break;
                }
                case 2: {
                    n9 = 6408;
                    break;
                }
                case 3: {
                    n9 = 32992;
                    break;
                }
                case 4: {
                    n9 = 32993;
                    break;
                }
                case 5: {
                    n9 = 6410;
                    break;
                }
                case 6: {
                    switch (this.format) {
                        case 32841: {
                            n9 = 6409;
                            break;
                        }
                        case 6406: {
                            n9 = 6406;
                        }
                    }
                    break;
                }
            }
            gL.glCopyTexImage2D(3553, n6, n9, n, n2, n3, n4, 0);
        } else {
            gL.glBindTexture(this.textureType, n7.intValue());
            gL.glCopyTexSubImage2D(3553, n6, this.mpOffsets[n6][0], this.mpOffsets[n6][1], n, n2, n3, n4);
        }
    }

    public void setReadBuffer(int n, int n2) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.mpReadBuffer = n2;
    }

    public int getReadBuffer(int n) {
        return this.mpReadBuffer;
    }

    public void setCopyOffset(int n, int n2, int n3, int n4) throws InvalidWriteTimingException {
        this.mpOffsets[n2][0] = n3;
        this.mpOffsets[n2][1] = n4;
    }

    public void getCopyOffset(int n, int n2, int[] nArray) {
        nArray[0] = this.mpOffsets[n2][0];
        nArray[1] = this.mpOffsets[n2][1];
    }

    public void setSources(int n, int n2, TextureSource[] textureSourceArray, int n3) throws InvalidWriteTimingException {
        super.setSources(n, n2, textureSourceArray, n3);
        if (n3 <= 0) {
            return;
        }
        int n4 = this.mpNumSources = textureSourceArray[0] instanceof MultipassTextureSource ? 1 : 0;
        if (this.sources[0] instanceof TextureComponent) {
            this.height = ((TextureComponent2D)this.sources[0]).getHeight();
        } else if (this.sources[0] instanceof OffscreenTexture2D) {
            this.height = ((OffscreenTexture2D)this.sources[0]).getHeight();
        } else if (this.sources[0] instanceof MultipassTextureSource) {
            this.height = ((MultipassTextureSource)this.sources[0]).getHeight();
        }
    }

    public void render(GL gL, GLU gLU) {
        int n;
        int n2;
        Object object;
        if (this.numSources == 0) {
            return;
        }
        Integer n3 = (Integer)this.textureIdMap.get(gL);
        if (n3 == null) {
            object = new int[1];
            gL.glGenTextures(1, (int[])object);
            this.textureIdMap.put(gL, new Integer(object[0]));
            gL.glBindTexture(this.textureType, object[0]);
            this.imageChanged.put(gL, true);
            this.stateChanged.put(gL, true);
            this.updateManagers[0].addContext(gL);
        } else {
            gL.glBindTexture(this.textureType, n3.intValue());
        }
        if (this.stateChanged.getState(gL)) {
            this.stateChanged.put(gL, false);
            gL.glPixelStorei(3317, 1);
            gL.glTexParameteri(3553, 10242, this.boundaryModeS);
            gL.glTexParameteri(3553, 10243, this.boundaryModeT);
            int n4 = 0;
            switch (this.magFilter) {
                case 0: 
                case 2: {
                    n4 = 9728;
                    break;
                }
                case 1: 
                case 3: {
                    n4 = 9729;
                    break;
                }
                default: {
                    System.out.println("Unknown mode in MagFilter: " + this.magFilter);
                }
            }
            gL.glTexParameteri(3553, 10240, n4);
            switch (this.minFilter) {
                case 0: 
                case 2: {
                    n4 = 9728;
                    break;
                }
                case 3: {
                    n4 = 9729;
                    break;
                }
                case 5: {
                    n4 = 9987;
                    break;
                }
                case 4: {
                    n4 = 9984;
                    break;
                }
                case 1: {
                    n4 = this.numSources > 1 ? 9987 : 9729;
                    break;
                }
                default: {
                    System.out.println("Unknown mode in MinFilter: " + this.minFilter);
                }
            }
            gL.glTexParameteri(3553, 10241, n4);
            if (this.anisotropicMode != 0) {
                gL.glTexParameterf(3553, 34046, this.anisotropicDegree);
            }
            if (this.priority >= 0.0f) {
                gL.glTexParameterf(3553, 32870, this.priority);
            }
            if (this.borderColor != null) {
                gL.glTexParameterfv(3553, 4100, this.borderColor);
            }
            if (this.format == 6402) {
                gL.glTexParameterf(3553, 34891, (float)this.depthComponentMode);
                gL.glTexParameterf(3553, 34892, (float)this.compareMode);
                gL.glTexParameterf(3553, 34893, (float)this.compareFunction);
            }
        }
        if (this.imageChanged.getState(gL)) {
            this.imageChanged.put(gL, false);
            object = (TextureComponent2D)this.sources[0];
            int n5 = this.mipMapMode == 0 ? 1 : ((TextureComponent)object).getNumLevels();
            n2 = ((TextureComponent)object).getWidth();
            int n6 = ((TextureComponent2D)object).getHeight();
            for (int i = 0; i < n5; ++i) {
                ByteBuffer byteBuffer = ((TextureComponent)object).getData(i);
                int n7 = ((TextureComponent)object).getFormat(i);
                int n8 = 6407;
                int n9 = 6407;
                switch (n7) {
                    case 1: {
                        n8 = 6407;
                        n9 = 6407;
                        break;
                    }
                    case 2: {
                        n8 = 6408;
                        n9 = 6408;
                        break;
                    }
                    case 3: {
                        n8 = 32992;
                        n9 = 32992;
                        break;
                    }
                    case 4: {
                        n8 = 32993;
                        n9 = 32993;
                        break;
                    }
                    case 5: {
                        n8 = 6410;
                        n9 = 6410;
                        break;
                    }
                    case 6: {
                        switch (this.format) {
                            case 32841: {
                                n8 = 32841;
                                n9 = 6409;
                                break;
                            }
                            case 6409: {
                                n8 = 6409;
                                n9 = 6409;
                                break;
                            }
                            case 6406: {
                                n8 = 6406;
                                n9 = 6406;
                            }
                        }
                        break;
                    }
                }
                gL.glTexImage2D(3553, i, n8, n2, n6, 0, n9, 5121, (Buffer)byteBuffer);
                byteBuffer.clear();
                byteBuffer = null;
                if (n2 > 1) {
                    n2 >>= 1;
                }
                if (n6 <= 1) continue;
                n6 >>= 1;
            }
        }
        if ((n = this.updateManagers[0].getNumUpdatesPending(gL)) != 0) {
            TextureUpdateData[] textureUpdateDataArray = this.updateManagers[0].getUpdatesAndClear(gL);
            for (n2 = 0; n2 < n; ++n2) {
                gL.glTexSubImage2D(3553, textureUpdateDataArray[n2].level, textureUpdateDataArray[n2].x, textureUpdateDataArray[n2].y, textureUpdateDataArray[n2].width, textureUpdateDataArray[n2].height, textureUpdateDataArray[n2].format, 5121, (Buffer)textureUpdateDataArray[n2].pixels);
            }
        }
    }

    public void postRender(GL gL, GLU gLU) {
        gL.glDisable(this.textureType);
    }

    public int compareTo(Texture texture) {
        int n = super.compareTo(texture);
        if (n != 0) {
            return n;
        }
        Texture2D texture2D = (Texture2D)texture;
        if (this.height != texture2D.height) {
            return this.height < texture2D.height ? -1 : 1;
        }
        if (this.boundaryModeS != texture2D.boundaryModeS) {
            return this.boundaryModeS < texture2D.boundaryModeS ? -1 : 1;
        }
        if (this.boundaryModeT != texture2D.boundaryModeT) {
            return this.boundaryModeT < texture2D.boundaryModeT ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(Texture texture) {
        if (!super.equals(texture)) {
            return false;
        }
        if (!(texture instanceof Texture2D)) {
            return false;
        }
        Texture2D texture2D = (Texture2D)texture;
        return this.height == texture2D.height && this.boundaryModeS == texture2D.boundaryModeS && this.boundaryModeT == texture2D.boundaryModeT;
    }

    public void setBoundaryModeT(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.boundaryModeT = n;
        this.stateChanged.setAll(true);
    }

    public int getBoundaryModeT() {
        return this.boundaryModeT;
    }

    public int getHeight() {
        return this.height;
    }

    private void init() {
        int n;
        this.mpReadBuffer = 1029;
        this.boundaryModeT = 10496;
        if (this.numSources == 0) {
            return;
        }
        int n2 = n = this.mipMapMode == 0 ? 1 : this.sources[0].getNumLevels();
        if (this.sources[0] instanceof MultipassTextureSource) {
            this.mpOffsets = new int[n][2];
        } else {
            for (int i = 0; i < n; ++i) {
                int n3 = this.sources[0].getFormat(i);
                int n4 = 6407;
                switch (n3) {
                    case 1: {
                        n4 = 6407;
                        break;
                    }
                    case 2: {
                        n4 = 6408;
                        break;
                    }
                    case 3: {
                        n4 = 32992;
                        break;
                    }
                    case 4: {
                        n4 = 32993;
                        break;
                    }
                    case 5: {
                        n4 = 6410;
                        break;
                    }
                    case 6: {
                        switch (this.format) {
                            case 32841: {
                                n4 = 32841;
                                break;
                            }
                            case 6409: {
                                n4 = 6409;
                                break;
                            }
                            case 6406: {
                                n4 = 6406;
                            }
                        }
                        break;
                    }
                }
                this.updateManagers[i].setTextureFormat(n4);
                ((TextureComponent)this.sources[i]).addUpdateListener(this.updateManagers[i]);
            }
        }
    }
}

