/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.nio.ByteBuffer;
import org.j3d.aviatrix3d.NodeComponent;
import org.j3d.aviatrix3d.TextureSource;
import org.j3d.aviatrix3d.iutil.SubTextureUpdateListener;

public abstract class TextureComponent
extends NodeComponent
implements TextureSource {
    private static final int LISTENER_SIZE = 1;
    private static final int LISTENER_INC = 2;
    public static final int TYPE_BYTE = 0;
    public static final int TYPE_INT = 3;
    protected int width;
    protected int format;
    protected int size;
    protected int type;
    protected ByteBuffer[] data;
    protected boolean invertY = true;
    protected int numLevels;
    protected byte[] copyBuffer;
    private SubTextureUpdateListener[] listeners;
    private int numListeners;

    public TextureComponent(int n) {
        this.data = new ByteBuffer[n];
        this.numLevels = n;
        this.listeners = new SubTextureUpdateListener[1];
    }

    public int getWidth() {
        return this.width;
    }

    public int getNumLevels() {
        return this.numLevels;
    }

    public int getFormat(int n) {
        if (this.data[n] == null) {
            this.data[n] = this.convertImage(n);
        }
        return this.format;
    }

    public void addUpdateListener(SubTextureUpdateListener subTextureUpdateListener) {
        if (this.numListeners == this.listeners.length) {
            int n = this.listeners.length;
            int n2 = n + 2;
            SubTextureUpdateListener[] subTextureUpdateListenerArray = new SubTextureUpdateListener[n2];
            System.arraycopy(this.listeners, 0, subTextureUpdateListenerArray, 0, n);
            this.listeners = subTextureUpdateListenerArray;
        }
        this.listeners[this.numListeners++] = subTextureUpdateListener;
    }

    public void removeUpdateListener(SubTextureUpdateListener subTextureUpdateListener) {
        block2: {
            block1: {
                if (this.numListeners != 1) break block1;
                if (this.listeners[0] != subTextureUpdateListener) break block2;
                this.listeners[0] = null;
                --this.numListeners;
                break block2;
            }
            for (int i = 0; i < this.numListeners; ++i) {
                if (this.listeners[i] != subTextureUpdateListener) continue;
                System.arraycopy(this.listeners, i + 1, this.listeners, i, this.numListeners - i - 1);
                break;
            }
        }
    }

    public boolean isYUp() {
        return this.invertY;
    }

    public abstract void clearLocalData();

    protected ByteBuffer getData(int n) {
        if (this.data[n] == null) {
            this.data[n] = this.convertImage(n);
        }
        return this.data[n];
    }

    protected void clearData(int n) {
        this.data[n] = null;
    }

    protected abstract ByteBuffer convertImage(int var1);

    protected void checkCopyBufferSize(int n) {
        if (this.copyBuffer == null || n > this.copyBuffer.length) {
            this.copyBuffer = new byte[n];
        }
    }

    protected void sendTextureUpdate(int n, int n2, int n3, int n4, int n5, int n6, int n7, byte[] byArray) {
        for (int i = 0; i < this.numListeners; ++i) {
            try {
                this.listeners[i].textureUpdated(n, n2, n3, n4, n5, n6, n7, byArray);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending update " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    protected int bytesPerPixel() {
        int n = 4;
        switch (this.format) {
            case 1: {
                n = 3;
                break;
            }
            case 2: {
                n = 4;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 5: {
                n = 2;
                break;
            }
            case 6: {
                n = 1;
            }
        }
        return n;
    }
}

