/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import javax.vecmath.Matrix4f;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.CyclicSceneGraphStructureException;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.NodeComponent;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.RenderableComponent;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.TexCoordGeneration;
import org.j3d.aviatrix3d.Texture;
import org.j3d.aviatrix3d.TextureAttributes;

public class TextureUnit
extends NodeComponent
implements RenderableComponent,
Comparable {
    private static boolean hasMultiTextureAPI;
    private static boolean queryComplete;
    private Texture texture;
    private int textureType;
    private TextureAttributes tatts;
    private TexCoordGeneration coordGen;
    private boolean stateChanged = false;
    private boolean validMatrix = false;
    private float[] texTransform = new float[16];

    public TextureUnit() {
        this.texTransform[0] = 1.0f;
        this.texTransform[5] = 1.0f;
        this.texTransform[10] = 1.0f;
        this.texTransform[15] = 1.0f;
    }

    public TextureUnit(Texture texture, TextureAttributes textureAttributes, TexCoordGeneration texCoordGeneration) {
        this();
        this.texture = texture;
        if (this.texture != null) {
            this.textureType = this.texture.getTextureType();
        }
        this.tatts = textureAttributes;
        this.coordGen = texCoordGeneration;
        this.stateChanged = true;
    }

    protected void checkForCyclicChild(SceneGraphObject sceneGraphObject) throws CyclicSceneGraphStructureException {
        if (sceneGraphObject == this) {
            throw new CyclicSceneGraphStructureException();
        }
        if (this.texture != null) {
            this.texture.checkForCyclicChild(sceneGraphObject);
        }
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        if (this.texture != null) {
            this.texture.setUpdateHandler(this.updateHandler);
        }
        if (this.tatts != null) {
            this.tatts.setUpdateHandler(this.updateHandler);
        }
        if (this.coordGen != null) {
            this.coordGen.setUpdateHandler(this.updateHandler);
        }
    }

    protected void setLive(boolean bl) {
        if (bl) {
            ++this.liveCount;
        } else if (this.liveCount > 0) {
            --this.liveCount;
        }
        if (this.liveCount == 0 || !this.alive) {
            super.setLive(bl);
            if (this.texture != null) {
                this.texture.setLive(bl);
            }
            if (this.tatts != null) {
                this.tatts.setLive(bl);
            }
            if (this.coordGen != null) {
                this.coordGen.setLive(bl);
            }
        }
    }

    public void render(GL gL, GLU gLU, Object object) {
        if (!queryComplete) {
            hasMultiTextureAPI = gL.isFunctionAvailable("glActiveTexture");
            queryComplete = true;
            if (!hasMultiTextureAPI) {
                System.out.println("Video card incapable of supporting multitexture, Allowing single texture only");
            }
        }
        if (this.stateChanged) {
            this.stateChanged = false;
            if (this.texture == null) {
                return;
            }
            if (hasMultiTextureAPI) {
                if ((Integer)object >= 0) {
                    gL.glActiveTexture(((Integer)object).intValue());
                } else {
                    gL.glActiveTexture(33984);
                }
            } else if ((Integer)object > 0) {
                return;
            }
            if (this.tatts != null) {
                this.tatts.render(gL, gLU);
            } else {
                gL.glTexEnvf(8960, 8704, 7681.0f);
            }
            if (this.validMatrix) {
                gL.glMatrixMode(5890);
                gL.glPushMatrix();
                gL.glMultMatrixf(this.texTransform);
                gL.glMatrixMode(5888);
            }
            this.texture.render(gL, gLU);
            gL.glEnable(this.textureType);
            if (this.coordGen != null) {
                this.coordGen.render(gL, gLU);
            }
        } else if (this.texture != null && this.texture.hasValidData()) {
            if (hasMultiTextureAPI) {
                if ((Integer)object >= 0) {
                    gL.glActiveTexture(((Integer)object).intValue());
                } else {
                    gL.glActiveTexture(33984);
                }
            } else if ((Integer)object > 0) {
                return;
            }
            gL.glEnable(this.textureType);
            if (this.tatts != null) {
                this.tatts.render(gL, gLU);
            } else {
                gL.glTexEnvf(8960, 8704, 7681.0f);
            }
            if (this.validMatrix) {
                gL.glMatrixMode(5890);
                gL.glPushMatrix();
                gL.glMultMatrixf(this.texTransform);
                gL.glMatrixMode(5888);
            }
            if (this.coordGen != null) {
                this.coordGen.render(gL, gLU);
            }
            this.texture.render(gL, gLU);
        }
    }

    public void postRender(GL gL, GLU gLU, Object object) {
        if (this.texture != null) {
            if (hasMultiTextureAPI) {
                if ((Integer)object >= 0) {
                    gL.glActiveTexture(((Integer)object).intValue());
                } else {
                    gL.glActiveTexture(33984);
                }
            } else if ((Integer)object > 0) {
                return;
            }
            if (this.tatts != null) {
                this.tatts.postRender(gL, gLU);
            }
            if (this.coordGen != null) {
                this.coordGen.postRender(gL, gLU);
            }
            if (this.validMatrix) {
                gL.glMatrixMode(5890);
                gL.glPopMatrix();
                gL.glMatrixMode(5888);
            }
            this.texture.postRender(gL, gLU);
        }
    }

    public int compareTo(Object object) throws ClassCastException {
        TextureUnit textureUnit = (TextureUnit)object;
        return this.compareTo(textureUnit);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TextureUnit)) {
            return false;
        }
        return this.equals((TextureUnit)object);
    }

    public void setTexture(Texture texture) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.texture != null) {
            this.texture.setLive(false);
        }
        this.texture = texture;
        if (this.texture != null) {
            this.texture.setUpdateHandler(this.updateHandler);
            this.textureType = this.texture.getTextureType();
            this.texture.setLive(this.alive);
        }
        this.stateChanged = true;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public void setTextureAttributes(TextureAttributes textureAttributes) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.tatts != null) {
            this.tatts.setLive(false);
        }
        this.tatts = textureAttributes;
        if (this.tatts != null) {
            this.tatts.setUpdateHandler(this.updateHandler);
            this.tatts.setLive(this.alive);
        }
        this.stateChanged = true;
    }

    public TextureAttributes getTextureAttributes() {
        return this.tatts;
    }

    public void setTexCoordGeneration(TexCoordGeneration texCoordGeneration) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.coordGen != null) {
            this.coordGen.setLive(false);
        }
        this.coordGen = texCoordGeneration;
        if (this.coordGen != null) {
            this.coordGen.setUpdateHandler(this.updateHandler);
            this.coordGen.setLive(this.alive);
        }
        this.stateChanged = true;
    }

    public TexCoordGeneration getTexCoordGeneration() {
        return this.coordGen;
    }

    public void setTextureTransform(Matrix4f matrix4f) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (matrix4f == null) {
            this.validMatrix = false;
            this.texTransform[0] = 1.0f;
            this.texTransform[4] = 0.0f;
            this.texTransform[8] = 0.0f;
            this.texTransform[12] = 0.0f;
            this.texTransform[1] = 0.0f;
            this.texTransform[5] = 1.0f;
            this.texTransform[9] = 0.0f;
            this.texTransform[13] = 0.0f;
            this.texTransform[2] = 0.0f;
            this.texTransform[6] = 0.0f;
            this.texTransform[10] = 1.0f;
            this.texTransform[14] = 0.0f;
            this.texTransform[3] = 0.0f;
            this.texTransform[7] = 0.0f;
            this.texTransform[11] = 0.0f;
            this.texTransform[15] = 1.0f;
        } else {
            this.validMatrix = true;
            this.texTransform[0] = matrix4f.m00;
            this.texTransform[4] = matrix4f.m01;
            this.texTransform[8] = matrix4f.m02;
            this.texTransform[12] = matrix4f.m03;
            this.texTransform[1] = matrix4f.m10;
            this.texTransform[5] = matrix4f.m11;
            this.texTransform[9] = matrix4f.m12;
            this.texTransform[13] = matrix4f.m13;
            this.texTransform[2] = matrix4f.m20;
            this.texTransform[6] = matrix4f.m21;
            this.texTransform[10] = matrix4f.m22;
            this.texTransform[14] = matrix4f.m23;
            this.texTransform[3] = matrix4f.m30;
            this.texTransform[7] = matrix4f.m31;
            this.texTransform[11] = matrix4f.m32;
            this.texTransform[15] = matrix4f.m33;
        }
    }

    public void getTextureTransform(Matrix4f matrix4f) {
        matrix4f.m00 = this.texTransform[0];
        matrix4f.m01 = this.texTransform[4];
        matrix4f.m02 = this.texTransform[8];
        matrix4f.m03 = this.texTransform[12];
        matrix4f.m10 = this.texTransform[1];
        matrix4f.m11 = this.texTransform[5];
        matrix4f.m12 = this.texTransform[9];
        matrix4f.m13 = this.texTransform[13];
        matrix4f.m20 = this.texTransform[2];
        matrix4f.m21 = this.texTransform[6];
        matrix4f.m22 = this.texTransform[10];
        matrix4f.m23 = this.texTransform[14];
        matrix4f.m30 = this.texTransform[3];
        matrix4f.m31 = this.texTransform[7];
        matrix4f.m32 = this.texTransform[11];
        matrix4f.m33 = this.texTransform[15];
    }

    public int compareTo(TextureUnit textureUnit) {
        int n;
        if (textureUnit == null) {
            return 1;
        }
        if (textureUnit == this) {
            return 0;
        }
        if (this.texture != textureUnit.texture) {
            if (this.texture == null) {
                return -1;
            }
            if (textureUnit.texture == null) {
                return 1;
            }
            n = this.texture.compareTo(textureUnit.texture);
            if (n != 0) {
                return n;
            }
        }
        if (this.tatts != textureUnit.tatts) {
            if (this.tatts == null) {
                return -1;
            }
            if (textureUnit.tatts == null) {
                return 1;
            }
            n = this.tatts.compareTo(textureUnit.tatts);
            if (n != 0) {
                return n;
            }
        }
        if (this.coordGen != textureUnit.coordGen) {
            if (this.coordGen == null) {
                return -1;
            }
            if (textureUnit.coordGen == null) {
                return 1;
            }
            n = this.coordGen.compareTo(textureUnit.coordGen);
            if (n != 0) {
                return n;
            }
        }
        if (this.validMatrix != textureUnit.validMatrix) {
            return this.validMatrix ? 1 : -1;
        }
        for (n = 0; n < 16; ++n) {
            if (this.texTransform[n] == textureUnit.texTransform[n]) continue;
            return this.texTransform[n] < textureUnit.texTransform[n] ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(TextureUnit textureUnit) {
        if (textureUnit == this) {
            return true;
        }
        if (textureUnit == null) {
            return false;
        }
        if (!(this.texture == textureUnit.texture || this.texture != null && this.texture.equals(textureUnit.texture))) {
            return false;
        }
        if (!(this.tatts == textureUnit.tatts || this.tatts != null && this.tatts.equals(textureUnit.tatts))) {
            return false;
        }
        if (!(this.coordGen == textureUnit.coordGen || this.coordGen != null && this.coordGen.equals(textureUnit.coordGen))) {
            return false;
        }
        if (this.validMatrix != textureUnit.validMatrix) {
            return false;
        }
        for (int i = 0; i < 16; ++i) {
            if (this.texTransform[i] == textureUnit.texTransform[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isMultiTextureAllowed() {
        return hasMultiTextureAPI;
    }
}

