/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.NotPickableException;
import org.j3d.aviatrix3d.VertexGeometry;

public class TriangleArray
extends VertexGeometry {
    private ByteBuffer edgeBuffer = ByteBuffer.allocate(0);
    private boolean[] edgeFlags;

    public TriangleArray() {
        this.initPolygonDetails(3);
    }

    public void render(GL gL, GLU gLU) {
        if ((this.vertexFormat & 7) == 0) {
            return;
        }
        this.setVertexState(gL, gLU);
        if ((this.vertexFormat & 0x10000) != 0) {
            gL.glEnableClientState(32889);
            gL.glEdgeFlagPointer(0, (Buffer)this.edgeBuffer);
        }
        gL.glDrawArrays(4, 0, this.numCoords);
        if ((this.vertexFormat & 0x10000) != 0) {
            gL.glDisableClientState(32889);
            gL.glEdgeFlag(true);
        }
        this.clearVertexState(gL, gLU);
    }

    public void postRender(GL gL, GLU gLU) {
    }

    public void setValidVertexCount(int n) throws IllegalStateException, IllegalArgumentException, InvalidWriteTimingException {
        super.setValidVertexCount(n);
        this.numRequiredCoords = n;
    }

    public void setVertices(int n, float[] fArray, int n2) throws IllegalStateException, IllegalArgumentException, InvalidWriteTimingException {
        super.setVertices(n, fArray, n2);
        this.numRequiredCoords = n2;
    }

    public boolean pickLineSegment(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        super.pickLineSegment(fArray, fArray2, bl, fArray3, n);
        float f = Float.POSITIVE_INFINITY;
        boolean bl2 = false;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = fArray2[0];
        float f6 = fArray2[1];
        float f7 = fArray2[2];
        float f8 = fArray2[0] - fArray[0];
        float f9 = fArray2[1] - fArray[1];
        float f10 = fArray2[2] - fArray[2];
        float f11 = (float)Math.sqrt(f8 * f8 + f9 * f9 + f10 * f10);
        fArray2[0] = f8;
        fArray2[1] = f9;
        fArray2[2] = f10;
        int n2 = this.numCoords / 3;
        for (int i = 0; i < n2; ++i) {
            System.arraycopy(this.coordinates, i * 9, this.wkPolygon, 0, 9);
            if (!this.ray3DTriangleChecked(fArray, fArray2, f11, fArray3)) continue;
            bl2 = true;
            if (bl) break;
            float f12 = fArray[0] - fArray3[0];
            float f13 = fArray[1] - fArray3[1];
            float f14 = fArray[2] - fArray3[2];
            float f15 = f12 * f12 + f13 * f13 + f14 * f14;
            if (!(f15 < f)) continue;
            f = f15;
            f2 = fArray3[0];
            f3 = fArray3[1];
            f4 = fArray3[2];
        }
        fArray3[0] = f2;
        fArray3[1] = f3;
        fArray3[2] = f4;
        fArray2[0] = f5;
        fArray2[1] = f6;
        fArray2[2] = f7;
        return bl2;
    }

    public boolean pickLineRay(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        super.pickLineRay(fArray, fArray2, bl, fArray3, n);
        float f = Float.POSITIVE_INFINITY;
        boolean bl2 = false;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        int n2 = this.numCoords / 3;
        for (int i = 0; i < n2; ++i) {
            System.arraycopy(this.coordinates, i * 9, this.wkPolygon, 0, 9);
            if (!this.ray3DTriangleChecked(fArray, fArray2, 0.0f, fArray3)) continue;
            bl2 = true;
            if (bl) break;
            float f5 = fArray[0] - fArray3[0];
            float f6 = fArray[1] - fArray3[1];
            float f7 = fArray[2] - fArray3[2];
            float f8 = f5 * f5 + f6 * f6 + f7 * f7;
            if (!(f8 < f)) continue;
            f = f8;
            f2 = fArray3[0];
            f3 = fArray3[1];
            f4 = fArray3[2];
        }
        fArray3[0] = f2;
        fArray3[1] = f3;
        fArray3[2] = f4;
        return bl2;
    }

    public void setEdgeFlags(boolean[] blArray) throws IllegalStateException, IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (blArray != null && blArray.length < this.numCoords) {
            throw new IllegalArgumentException("Edge flag array too short");
        }
        this.edgeFlags = blArray;
        if (this.numCoords > this.edgeBuffer.capacity()) {
            this.edgeBuffer = this.createBuffer(this.numCoords);
        } else {
            this.edgeBuffer.clear();
        }
        if (blArray == null) {
            this.vertexFormat &= 0xFFFEFFFF;
        } else {
            this.edgeBuffer.rewind();
            for (int i = 0; i < this.numCoords; ++i) {
                this.edgeBuffer.put((byte)(blArray[i] ? 1 : 0));
            }
            this.vertexFormat |= 0x10000;
        }
    }

    private ByteBuffer createBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer;
    }
}

