/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.RenderableObject;
import org.j3d.aviatrix3d.iutil.ShaderAttribValue;
import org.j3d.util.IntHashMap;

public abstract class VertexGeometry
extends Geometry
implements RenderableObject {
    private static final String INVALID_ATTRIB_SIZE_MSG = "Invalid attribute size. Must be 0 < size < 4";
    private static final String COLOR_3_SIZE_ERR = "Color array too short for 3 component colour";
    private static final String COLOR_4_SIZE_ERR = "Color array too short for 4 component colour";
    public static final int COORDINATE_2 = 2;
    public static final int COORDINATE_3 = 3;
    public static final int COORDINATE_4 = 4;
    protected static final int COORDINATE_MASK = 7;
    protected static final int COORDINATE_CLEAR = -8;
    protected static final int NORMALS = 8;
    protected static final int NORMAL_CLEAR = -9;
    protected static final int TEXTURE_MASK = 240;
    protected static final int TEXTURE_CLEAR = -241;
    protected static final int TEXTURE_COORDINATE_SINGLE = 16;
    protected static final int TEXTURE_COORDINATE_MULTI = 32;
    protected static final int TEXTURE_SET_AVAILABLE = 256;
    protected static final int TEXTURE_SET_CLEAR = -3841;
    protected static final int COLOR_MASK = 61440;
    protected static final int COLOR_CLEAR = -61441;
    protected static final int COLOR_3 = 4096;
    protected static final int COLOR_4 = 8192;
    protected static final int COLOR_SINGLE = 16384;
    protected static final int EDGE_MASK = 65536;
    protected static final int EDGE_CLEAR = -65537;
    protected static final int EDGES = 65536;
    protected static final int COLOR2_MASK = 131072;
    protected static final int COLOR2_CLEAR = -131073;
    protected static final int COLOR2 = 131072;
    protected static final int FOG_MASK = 262144;
    protected static final int FOG_CLEAR = -262145;
    protected static final int FOG = 262144;
    protected static final int ATTRIB_MASK = 524288;
    protected static final int ATTRIB_CLEAR = -524289;
    protected static final int ATTRIBS = 524288;
    public static final int TEXTURE_COORDINATE_1 = 1;
    public static final int TEXTURE_COORDINATE_2 = 2;
    public static final int TEXTURE_COORDINATE_3 = 3;
    public static final int TEXTURE_COORDINATE_4 = 4;
    public static final int INTERSECT_COORDS = 1;
    public static final int INTERSECT_COLOR = 2;
    public static final int INTERSECT_NORMAL = 4;
    public static final int INTERSECT_TEXCOORDS_SINGLE = 8;
    public static final int INTERSECT_TEXCOORDS_MULTI = 16;
    public static final int INTERSECT_ALL = -1;
    protected static boolean hasMultiTextureAPI;
    protected static int maxTextureUnits;
    private static boolean queryComplete;
    private float[] working2dCoords;
    protected float[] wkPolygon;
    protected FloatBuffer vertexBuffer = FloatBuffer.allocate(0);
    protected FloatBuffer colorBuffer;
    protected FloatBuffer normalBuffer = FloatBuffer.allocate(0);
    protected FloatBuffer fogBuffer;
    protected FloatBuffer color2Buffer;
    protected FloatBuffer[] textureBuffer;
    protected float[] coordinates;
    protected int numCoords;
    protected int numRequiredCoords;
    protected float[] normals;
    protected float[][] textures;
    protected int numTextureArrays;
    protected int[] textureSets;
    protected int[] textureTypes;
    protected int numTextureSets;
    protected int numRenderedTextureSets;
    protected float[] colors;
    protected float[] color2s;
    protected float[] fogCoords;
    protected int[] attribIds;
    protected IntHashMap attributes;
    protected int vertexFormat;

    protected VertexGeometry() {
        this.colorBuffer = FloatBuffer.allocate(0);
        this.fogBuffer = FloatBuffer.allocate(0);
        this.color2Buffer = FloatBuffer.allocate(0);
        this.textureBuffer = new FloatBuffer[1];
        this.bounds = new BoundingBox();
        this.numRenderedTextureSets = 0;
        maxTextureUnits = 16;
    }

    protected void setLive(boolean bl) {
        boolean bl2 = this.alive;
        super.setLive(bl);
        if (!bl2 && bl) {
            this.recomputeBounds();
        }
    }

    protected boolean isVisible() {
        return this.numCoords != 0;
    }

    public int getVertexType() {
        return this.vertexFormat & 7;
    }

    public int getValidVertexCount() {
        return this.numCoords;
    }

    public void setValidVertexCount(int n) throws IllegalStateException, IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Vertex count is negative");
        }
        this.numCoords = n;
    }

    public void setVertices(int n, float[] fArray) throws IllegalStateException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        int n2 = fArray == null ? 0 : fArray.length / n;
        this.setVertices(n, fArray, n2);
    }

    public void getVertices(float[] fArray) {
        int n = this.vertexFormat & 7;
        System.arraycopy(this.coordinates, 0, fArray, 0, this.numCoords * n);
    }

    public void setVertices(int n, float[] fArray, int n2) throws IllegalStateException, IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Vertex count is negative");
        }
        int n3 = n & 7;
        this.numCoords = n2;
        if (n2 == 0) {
            this.vertexFormat &= 0xFFFFFFF8;
            this.vertexBuffer.clear();
            return;
        }
        if (n2 * n3 > fArray.length) {
            throw new IllegalArgumentException("Vertex array not long enough (" + fArray.length + ") for " + "numValid * vertex_type " + n2 * n3);
        }
        this.coordinates = fArray;
        if (n2 * n3 > this.vertexBuffer.capacity()) {
            this.vertexBuffer = this.createBuffer(n2 * n3);
        } else {
            this.vertexBuffer.clear();
        }
        this.vertexBuffer.put(fArray, 0, n2 * n3);
        this.vertexBuffer.rewind();
        this.vertexFormat |= n;
    }

    public void setSingleColor(boolean bl, float[] fArray) throws IllegalStateException, IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (fArray != null) {
            if (bl) {
                if (fArray.length < 4) {
                    throw new IllegalArgumentException(COLOR_4_SIZE_ERR);
                }
                this.vertexFormat |= 0x6000;
                this.colors = new float[4];
                this.colors[0] = fArray[0];
                this.colors[1] = fArray[1];
                this.colors[2] = fArray[2];
                this.colors[3] = fArray[3];
            } else {
                if (fArray.length < 3) {
                    throw new IllegalArgumentException(COLOR_3_SIZE_ERR);
                }
                this.vertexFormat |= 0x5000;
                this.colors = new float[3];
                this.colors[0] = fArray[0];
                this.colors[1] = fArray[1];
                this.colors[2] = fArray[2];
            }
        } else {
            this.vertexFormat &= 0xFFFF0FFF;
        }
        this.validAlpha = bl;
    }

    public void setColors(boolean bl, float[] fArray) throws IllegalStateException, IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        int n = 0;
        if (fArray != null) {
            this.vertexFormat &= 0xFFFFBFFF;
            if (bl) {
                if (fArray.length < this.numRequiredCoords * 4) {
                    throw new IllegalArgumentException(COLOR_4_SIZE_ERR);
                }
                this.vertexFormat |= 0x2000;
                n = this.numRequiredCoords * 4;
            } else {
                if (fArray.length < this.numRequiredCoords * 3) {
                    throw new IllegalArgumentException(COLOR_3_SIZE_ERR);
                }
                this.vertexFormat |= 0x1000;
                n = this.numRequiredCoords * 3;
            }
        } else {
            this.vertexFormat &= 0xFFFF0FFF;
        }
        this.colors = fArray;
        if (n > this.colorBuffer.capacity()) {
            this.colorBuffer = this.createBuffer(n);
        } else {
            this.colorBuffer.clear();
        }
        if (n != 0) {
            this.colorBuffer.put(fArray, 0, n);
            this.colorBuffer.rewind();
        }
        this.validAlpha = bl;
    }

    public void getColors(float[] fArray) {
        if (this.colors != null) {
            if ((this.vertexFormat & 0x4000) != 0) {
                fArray[0] = this.colors[0];
                fArray[1] = this.colors[1];
                fArray[2] = this.colors[2];
                if (this.validAlpha) {
                    fArray[3] = this.colors[3];
                }
            } else {
                int n = this.numRequiredCoords * (this.validAlpha ? 4 : 3);
                System.arraycopy(this.colors, 0, fArray, 0, n);
            }
        }
    }

    public void setNormals(float[] fArray) throws IllegalStateException, IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (fArray != null && fArray.length < this.numRequiredCoords * 3) {
            throw new IllegalArgumentException("Normal array too short");
        }
        this.normals = fArray;
        if (this.numRequiredCoords * 3 > this.normalBuffer.capacity()) {
            this.normalBuffer = this.createBuffer(this.numRequiredCoords * 3);
        } else {
            this.normalBuffer.clear();
        }
        if (fArray == null) {
            this.vertexFormat &= 0xFFFFFFF7;
        } else {
            this.normalBuffer.put(fArray, 0, this.numRequiredCoords * 3);
            this.normalBuffer.rewind();
            this.vertexFormat |= 8;
        }
    }

    public void getNormals(float[] fArray) {
        if (this.normals != null) {
            System.arraycopy(this.normals, 0, fArray, 0, this.numRequiredCoords * 3);
        }
    }

    public void setTextureSetMap(int[] nArray) throws IllegalStateException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.setTextureSetMap(nArray, nArray == null ? 0 : nArray.length);
    }

    public void setTextureSetMap(int[] nArray, int n) throws IllegalStateException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (nArray == null || n == 0) {
            this.vertexFormat &= 0xFFFFF0FF;
            this.numTextureSets = 0;
        } else {
            this.numTextureSets = n;
            this.vertexFormat |= 0x100;
        }
        this.textureSets = nArray;
        this.numRenderedTextureSets = this.numTextureSets < maxTextureUnits ? this.numTextureSets : maxTextureUnits;
    }

    public void setTextureCoordinates(int n, int n2, float[] fArray) throws IllegalStateException, IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n2 < 0 || n2 >= this.numTextureArrays) {
            throw new IllegalArgumentException("Invalid texture set specified: " + n2);
        }
        boolean bl = false;
        if (fArray != null) {
            switch (n) {
                case 1: {
                    if (fArray.length >= this.numRequiredCoords) break;
                    throw new IllegalArgumentException("texCoord array too short for 1D texture coordiantes");
                }
                case 2: {
                    if (fArray.length >= this.numRequiredCoords * 2) break;
                    throw new IllegalArgumentException("texCoord array too short for 2D texture coordiantes");
                }
                case 3: {
                    if (fArray.length >= this.numRequiredCoords * 3) break;
                    throw new IllegalArgumentException("texCoord array too short for 3D texture coordiantes");
                }
                case 4: {
                    if (fArray.length >= this.numRequiredCoords * 4) break;
                    throw new IllegalArgumentException("texCoord array too short for 4D texture coordiantes");
                }
                default: {
                    throw new IllegalArgumentException("Invalid texture type: " + n);
                }
            }
        }
        if (fArray.length > this.textureBuffer[n2].capacity()) {
            this.textureBuffer[n2] = this.createBuffer(fArray.length);
        } else {
            this.textureBuffer[n2].clear();
        }
        this.textureBuffer[n2].put(fArray, 0, fArray.length);
    }

    public void setTextureCoordinates(int[] nArray, float[][] fArray) throws IllegalStateException, IllegalArgumentException, InvalidWriteTimingException {
        this.setTextureCoordinates(nArray, fArray, fArray == null ? 0 : fArray.length);
    }

    public void setTextureCoordinates(int[] nArray, float[][] fArray, int n) throws IllegalStateException, IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (fArray == null || n == 0) {
            this.vertexFormat &= 0xFFFFFF0F;
            for (int i = 0; i < this.numTextureArrays; ++i) {
                this.textureBuffer[i].clear();
            }
            this.numTextureArrays = 0;
        } else {
            int n2;
            if (n < 0 || fArray.length < n) {
                throw new IllegalArgumentException("Invalid set size");
            }
            if (nArray == null || nArray.length < n) {
                throw new IllegalArgumentException("Not enough types specified");
            }
            if (this.textureBuffer.length < n) {
                FloatBuffer[] floatBufferArray = new FloatBuffer[n];
                System.arraycopy(this.textureBuffer, 0, floatBufferArray, 0, this.textureBuffer.length);
                this.textureBuffer = floatBufferArray;
            }
            block7: for (n2 = 0; n2 < n; ++n2) {
                if (fArray[n2] == null || fArray[n2].length == 0) {
                    throw new IllegalArgumentException("Texture coordinate set " + n2 + " does not have " + "any texture coordinates defined but requires " + this.numCoords);
                }
                int n3 = 0;
                switch (nArray[n2]) {
                    case 1: {
                        if (fArray[n2].length < this.numRequiredCoords) {
                            throw new IllegalArgumentException("Texture coordinate set " + n2 + " does not have " + "enough values for a 1D texture. It has " + fArray[n2].length + " but requires " + this.numCoords);
                        }
                        if (this.textureBuffer[n2] == null || this.textureBuffer[n2].capacity() < this.numRequiredCoords) {
                            this.textureBuffer[n2] = this.createBuffer(this.numRequiredCoords);
                        } else {
                            this.textureBuffer[n2].clear();
                        }
                        this.textureBuffer[n2].put(fArray[n2], 0, this.numRequiredCoords);
                        continue block7;
                    }
                    case 2: {
                        n3 = this.numRequiredCoords * 2;
                        if (fArray[n2].length < n3) {
                            throw new IllegalArgumentException("Texture coordinate set " + n2 + " does not have " + "enough values for a 2D texture. It has " + fArray[n2].length + " but requires " + n3);
                        }
                        if (this.textureBuffer[n2] == null || this.textureBuffer[n2].capacity() < n3) {
                            this.textureBuffer[n2] = this.createBuffer(n3);
                        } else {
                            this.textureBuffer[n2].clear();
                        }
                        this.textureBuffer[n2].put(fArray[n2], 0, n3);
                        continue block7;
                    }
                    case 3: {
                        n3 = this.numRequiredCoords * 3;
                        if (fArray[n2].length < n3) {
                            throw new IllegalArgumentException("Texture coordinate set " + n2 + " does not have " + "enough values for a 3D texture. It has " + fArray[n2].length + " but requires " + n3);
                        }
                        if (this.textureBuffer[n2] == null || this.textureBuffer[n2].capacity() < n3) {
                            this.textureBuffer[n2] = this.createBuffer(n3);
                        } else {
                            this.textureBuffer[n2].clear();
                        }
                        this.textureBuffer[n2].put(fArray[n2], 0, n3);
                        continue block7;
                    }
                    case 4: {
                        n3 = this.numRequiredCoords * 4;
                        if (fArray[n2].length < n3) {
                            throw new IllegalArgumentException("Texture coordinate set " + n2 + " does not have " + "enough values for a 4D texture. It has " + fArray[n2].length + " but requires " + n3);
                        }
                        if (this.textureBuffer[n2] == null || this.textureBuffer[n2].capacity() < n3) {
                            this.textureBuffer[n2] = this.createBuffer(n3);
                        } else {
                            this.textureBuffer[n2].clear();
                        }
                        this.textureBuffer[n2].put(fArray[n2], 0, n3);
                        continue block7;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid texture type");
                    }
                }
            }
            this.numTextureArrays = n;
            if (this.numTextureSets == 0) {
                this.textureSets = new int[n];
                for (n2 = 0; n2 < n; ++n2) {
                    this.textureSets[n2] = n2;
                }
                this.numTextureSets = n;
            }
            this.vertexFormat |= n > 1 ? 16 : 32;
        }
        this.numRenderedTextureSets = this.numTextureSets < maxTextureUnits ? this.numTextureSets : maxTextureUnits;
        this.textures = fArray;
        this.textureTypes = nArray;
    }

    public void getTextureCoordinates(float[][] fArray) {
        if (this.textures == null) {
            return;
        }
        for (int i = 0; i < this.numTextureSets; ++i) {
            int n = 0;
            switch (this.textureTypes[i]) {
                case 1: {
                    n = 1;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 3: {
                    n = 3;
                    break;
                }
                case 4: {
                    n = 4;
                }
            }
            System.arraycopy(this.textures[i], 0, fArray[i], 0, this.numRequiredCoords * n);
        }
    }

    public void setFogCoordinates(float[] fArray) throws IllegalStateException, IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (fArray != null && fArray.length < this.numRequiredCoords) {
            throw new IllegalArgumentException("Fog coord array too short");
        }
        this.fogCoords = fArray;
        if (this.numRequiredCoords > this.fogBuffer.capacity()) {
            this.fogBuffer = this.createBuffer(this.numCoords);
        } else {
            this.fogBuffer.clear();
        }
        if (this.fogCoords == null) {
            this.vertexFormat &= 0xFFFBFFFF;
        } else {
            this.fogBuffer.rewind();
            this.fogBuffer.put(this.fogCoords, 0, this.numRequiredCoords);
            this.fogBuffer.rewind();
            this.vertexFormat |= 0x40000;
        }
    }

    public void getFogCoordinates(float[] fArray) {
        if (this.fogCoords != null) {
            System.arraycopy(this.fogCoords, 0, fArray, 0, this.numRequiredCoords);
        }
    }

    public void setSecondaryColors(float[] fArray) throws IllegalStateException, IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (fArray != null && fArray.length < this.numRequiredCoords * 3) {
            throw new IllegalArgumentException("Secondary color array too short");
        }
        this.color2s = fArray;
        if (this.numCoords * 3 > this.color2Buffer.capacity()) {
            this.color2Buffer = this.createBuffer(this.numRequiredCoords * 3);
        } else {
            this.color2Buffer.clear();
        }
        if (fArray == null) {
            this.vertexFormat &= 0xFFFDFFFF;
        } else {
            this.color2Buffer.rewind();
            this.color2Buffer.put(fArray, 0, this.numRequiredCoords * 3);
            this.vertexFormat |= 0x20000;
        }
    }

    public void getSecondaryColors(float[] fArray) {
        if (this.color2s != null) {
            System.arraycopy(this.color2s, 0, fArray, 0, this.numRequiredCoords * 3);
        }
    }

    public void setAttributes(int n, int n2, float[] fArray, boolean bl) throws IllegalStateException, IllegalArgumentException, InvalidWriteTimingException {
        FloatBuffer floatBuffer;
        ShaderAttribValue shaderAttribValue;
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n2 == -1) {
            if (this.attributes == null) {
                return;
            }
            this.attributes.remove(n);
            if (this.attributes.size() == 0) {
                this.vertexFormat &= 0xFFF7FFFF;
            }
        }
        if (fArray != null && fArray.length < this.numRequiredCoords * n2) {
            throw new IllegalArgumentException("Attrib array too short.  Expected: " + this.numRequiredCoords * n2 + " got: " + fArray.length);
        }
        if (n2 < 1 || n2 > 4) {
            throw new IllegalArgumentException(INVALID_ATTRIB_SIZE_MSG);
        }
        if (this.attributes == null) {
            this.attributes = new IntHashMap();
        }
        if ((shaderAttribValue = (ShaderAttribValue)this.attributes.get(n)) == null) {
            shaderAttribValue = new ShaderAttribValue();
            this.attributes.put(n, (Object)shaderAttribValue);
        }
        shaderAttribValue.size = n2;
        shaderAttribValue.normalise = bl;
        shaderAttribValue.dataType = 5126;
        if (shaderAttribValue.data instanceof FloatBuffer && this.numRequiredCoords * n2 < shaderAttribValue.data.capacity()) {
            floatBuffer = (FloatBuffer)shaderAttribValue.data;
            floatBuffer.clear();
        } else {
            floatBuffer = this.createBuffer(this.numRequiredCoords * n2);
            shaderAttribValue.data = floatBuffer;
        }
        floatBuffer.put(fArray, 0, this.numRequiredCoords * n2);
        floatBuffer.rewind();
        this.vertexFormat |= 0x80000;
    }

    public void setAttributes(int n, int n2, double[] dArray, boolean bl) throws IllegalStateException, IllegalArgumentException, InvalidWriteTimingException {
        DoubleBuffer doubleBuffer;
        ShaderAttribValue shaderAttribValue;
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n2 == -1) {
            if (this.attributes == null) {
                return;
            }
            this.attributes.remove(n);
            if (this.attributes.size() == 0) {
                this.vertexFormat &= 0xFFF7FFFF;
            }
        }
        if (dArray != null && dArray.length < this.numRequiredCoords * n2) {
            throw new IllegalArgumentException("Attrib array too short");
        }
        if (n2 < 1 || n2 > 4) {
            throw new IllegalArgumentException(INVALID_ATTRIB_SIZE_MSG);
        }
        if (this.attributes == null) {
            this.attributes = new IntHashMap();
        }
        if ((shaderAttribValue = (ShaderAttribValue)this.attributes.get(n)) == null) {
            shaderAttribValue = new ShaderAttribValue();
            this.attributes.put(n, (Object)shaderAttribValue);
        }
        shaderAttribValue.size = n2;
        shaderAttribValue.normalise = bl;
        shaderAttribValue.dataType = 5130;
        if (shaderAttribValue.data instanceof DoubleBuffer && this.numRequiredCoords * n2 < shaderAttribValue.data.capacity()) {
            doubleBuffer = (DoubleBuffer)shaderAttribValue.data;
            doubleBuffer.clear();
        } else {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.numRequiredCoords * n2 * 8);
            byteBuffer.order(ByteOrder.nativeOrder());
            doubleBuffer = byteBuffer.asDoubleBuffer();
            shaderAttribValue.data = doubleBuffer;
        }
        doubleBuffer.put(dArray, 0, this.numRequiredCoords * n2);
        doubleBuffer.rewind();
        this.vertexFormat |= 0x80000;
    }

    public void setAttributes(int n, int n2, int[] nArray, boolean bl, boolean bl2) throws IllegalStateException, IllegalArgumentException, InvalidWriteTimingException {
        IntBuffer intBuffer;
        ShaderAttribValue shaderAttribValue;
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n2 == -1) {
            if (this.attributes == null) {
                return;
            }
            this.attributes.remove(n);
            if (this.attributes.size() == 0) {
                this.vertexFormat &= 0xFFF7FFFF;
            }
        }
        if (nArray != null && nArray.length < this.numRequiredCoords * n2) {
            throw new IllegalArgumentException("Attrib array too short");
        }
        if (n2 < 1 || n2 > 4) {
            throw new IllegalArgumentException(INVALID_ATTRIB_SIZE_MSG);
        }
        if (this.attributes == null) {
            this.attributes = new IntHashMap();
        }
        if ((shaderAttribValue = (ShaderAttribValue)this.attributes.get(n)) == null) {
            shaderAttribValue = new ShaderAttribValue();
            this.attributes.put(n, (Object)shaderAttribValue);
        }
        shaderAttribValue.size = n2;
        shaderAttribValue.normalise = bl;
        int n3 = shaderAttribValue.dataType = bl2 ? 5124 : 5125;
        if (shaderAttribValue.data instanceof IntBuffer && this.numRequiredCoords * n2 < shaderAttribValue.data.capacity()) {
            intBuffer = (IntBuffer)shaderAttribValue.data;
            intBuffer.clear();
        } else {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.numRequiredCoords * n2 * 4);
            byteBuffer.order(ByteOrder.nativeOrder());
            intBuffer = byteBuffer.asIntBuffer();
            shaderAttribValue.data = intBuffer;
        }
        intBuffer.put(nArray, 0, this.numRequiredCoords * n2);
        intBuffer.rewind();
        this.vertexFormat |= 0x80000;
    }

    public void setAttributes(int n, int n2, short[] sArray, boolean bl, boolean bl2) throws IllegalStateException, IllegalArgumentException, InvalidWriteTimingException {
        ShortBuffer shortBuffer;
        ShaderAttribValue shaderAttribValue;
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n2 == -1) {
            if (this.attributes == null) {
                return;
            }
            this.attributes.remove(n);
            if (this.attributes.size() == 0) {
                this.vertexFormat &= 0xFFF7FFFF;
            }
        }
        if (sArray != null && sArray.length < this.numRequiredCoords * n2) {
            throw new IllegalArgumentException("Attrib array too short");
        }
        if (n2 < 1 || n2 > 4) {
            throw new IllegalArgumentException(INVALID_ATTRIB_SIZE_MSG);
        }
        if (this.attributes == null) {
            this.attributes = new IntHashMap();
        }
        if ((shaderAttribValue = (ShaderAttribValue)this.attributes.get(n)) == null) {
            shaderAttribValue = new ShaderAttribValue();
            this.attributes.put(n, (Object)shaderAttribValue);
        }
        shaderAttribValue.size = n2;
        shaderAttribValue.normalise = bl;
        int n3 = shaderAttribValue.dataType = bl2 ? 5122 : 5123;
        if (shaderAttribValue.data instanceof ShortBuffer && this.numRequiredCoords * n2 < shaderAttribValue.data.capacity()) {
            shortBuffer = (ShortBuffer)shaderAttribValue.data;
            shortBuffer.clear();
        } else {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.numRequiredCoords * n2 * 2);
            byteBuffer.order(ByteOrder.nativeOrder());
            shortBuffer = byteBuffer.asShortBuffer();
            shaderAttribValue.data = shortBuffer;
        }
        shortBuffer.put(sArray, 0, this.numRequiredCoords * n2);
        shortBuffer.rewind();
        this.vertexFormat |= 0x80000;
    }

    public void setAttributes(int n, int n2, byte[] byArray, boolean bl, boolean bl2) throws IllegalStateException, IllegalArgumentException, InvalidWriteTimingException {
        ByteBuffer byteBuffer;
        ShaderAttribValue shaderAttribValue;
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n2 == -1) {
            if (this.attributes == null) {
                return;
            }
            this.attributes.remove(n);
            if (this.attributes.size() == 0) {
                this.vertexFormat &= 0xFFF7FFFF;
            }
        }
        if (byArray != null && byArray.length < this.numRequiredCoords * n2) {
            throw new IllegalArgumentException("Attrib array too short");
        }
        if (n2 < 1 || n2 > 4) {
            throw new IllegalArgumentException(INVALID_ATTRIB_SIZE_MSG);
        }
        if (this.attributes == null) {
            this.attributes = new IntHashMap();
        }
        if ((shaderAttribValue = (ShaderAttribValue)this.attributes.get(n)) == null) {
            shaderAttribValue = new ShaderAttribValue();
            this.attributes.put(n, (Object)shaderAttribValue);
        }
        shaderAttribValue.size = n2;
        shaderAttribValue.normalise = bl;
        int n3 = shaderAttribValue.dataType = bl2 ? 5120 : 5121;
        if (shaderAttribValue.data instanceof ByteBuffer && this.numRequiredCoords * n2 < shaderAttribValue.data.capacity()) {
            byteBuffer = (ByteBuffer)shaderAttribValue.data;
            byteBuffer.clear();
        } else {
            byteBuffer = ByteBuffer.allocateDirect(this.numRequiredCoords * n2);
            byteBuffer.order(ByteOrder.nativeOrder());
            shaderAttribValue.data = byteBuffer;
        }
        byteBuffer.put(byArray, 0, this.numRequiredCoords * n2);
        byteBuffer.rewind();
        this.vertexFormat |= 0x80000;
    }

    protected final void setVertexState(GL gL, GLU gLU) {
        int n;
        int n2 = this.vertexFormat & 7;
        gL.glEnableClientState(32884);
        gL.glVertexPointer(n2, 5126, 0, (Buffer)this.vertexBuffer);
        if ((this.vertexFormat & 8) != 0) {
            gL.glEnableClientState(32885);
            gL.glNormalPointer(5126, 0, (Buffer)this.normalBuffer);
        }
        if ((this.vertexFormat & 0xF0) != 0) {
            if (this.numTextureSets == 1) {
                gL.glEnableClientState(32888);
                gL.glTexCoordPointer(this.textureTypes[0], 5126, 0, (Buffer)this.textureBuffer[0]);
            } else {
                if (!queryComplete) {
                    hasMultiTextureAPI = gL.isFunctionAvailable("glClientActiveTexture");
                    int[] nArray = new int[1];
                    gL.glGetIntegerv(34018, nArray);
                    maxTextureUnits = nArray[0];
                    this.numRenderedTextureSets = this.numTextureSets < maxTextureUnits ? this.numTextureSets : maxTextureUnits;
                    queryComplete = true;
                    if (!hasMultiTextureAPI) {
                        System.out.println("Video card incapable of supporting multitexture, Allowing single texture only");
                    }
                }
                if (hasMultiTextureAPI) {
                    for (int i = 0; i < this.numRenderedTextureSets; ++i) {
                        n = this.textureSets[i];
                        gL.glClientActiveTexture(33984 + i);
                        gL.glEnableClientState(32888);
                        gL.glTexCoordPointer(this.textureTypes[n], 5126, 0, (Buffer)this.textureBuffer[n]);
                    }
                } else {
                    gL.glEnableClientState(32888);
                    gL.glTexCoordPointer(this.textureTypes[0], 5126, 0, (Buffer)this.textureBuffer[0]);
                }
            }
        }
        if ((this.vertexFormat & 0xF000) != 0) {
            if ((this.vertexFormat & 0x4000) != 0) {
                if ((this.vertexFormat & 0x1000) != 0) {
                    gL.glColor3f(this.colors[0], this.colors[1], this.colors[2]);
                } else {
                    gL.glColor4f(this.colors[0], this.colors[1], this.colors[2], this.colors[3]);
                }
            } else {
                gL.glEnableClientState(32886);
                int n3 = (this.vertexFormat & 0x1000) != 0 ? 3 : 4;
                gL.glColorPointer(n3, 5126, 0, (Buffer)this.colorBuffer);
            }
        }
        if ((this.vertexFormat & 0x20000) != 0) {
            gL.glEnableClientState(33886);
            gL.glSecondaryColorPointer(3, 5126, 0, (Buffer)this.color2Buffer);
        }
        if ((this.vertexFormat & 0x40000) != 0) {
            gL.glFogi(33872, 33873);
            gL.glEnableClientState(33879);
            gL.glFogCoordPointer(5126, 0, (Buffer)this.fogBuffer);
        }
        if ((this.vertexFormat & 0x80000) != 0) {
            int n4 = this.attributes.size();
            this.attribIds = this.attributes.keySet(this.attribIds);
            for (n = 0; n < n4; ++n) {
                int n5 = this.attribIds[n];
                ShaderAttribValue shaderAttribValue = (ShaderAttribValue)this.attributes.get(n5);
                gL.glEnableVertexAttribArrayARB(n5);
                gL.glVertexAttribPointerARB(n5, shaderAttribValue.size, shaderAttribValue.dataType, shaderAttribValue.normalise, 0, shaderAttribValue.data);
            }
        }
    }

    protected final void clearVertexState(GL gL, GLU gLU) {
        int n;
        if ((this.vertexFormat & 0x80000) != 0) {
            n = this.attributes.size();
            for (int i = 0; i < n; ++i) {
                gL.glDisableVertexAttribArrayARB(this.attribIds[i]);
            }
        }
        if ((this.vertexFormat & 0x40000) != 0) {
            gL.glDisableClientState(33879);
            gL.glFogi(33872, 33874);
        }
        if ((this.vertexFormat & 0x20000) != 0) {
            gL.glDisableClientState(33886);
            gL.glSecondaryColor3f(1.0f, 1.0f, 1.0f);
        }
        if ((this.vertexFormat & 0xF000) != 0) {
            if ((this.vertexFormat & 0x4000) == 0) {
                gL.glDisableClientState(32886);
            }
            gL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        }
        if ((this.vertexFormat & 0xF0) != 0) {
            if (this.numTextureSets == 1) {
                gL.glDisableClientState(32888);
            } else if (hasMultiTextureAPI) {
                for (n = this.numRenderedTextureSets - 1; n >= 0; --n) {
                    gL.glClientActiveTexture(33984 + n);
                    gL.glDisableClientState(32888);
                }
            } else {
                gL.glDisableClientState(32888);
            }
        }
        if ((this.vertexFormat & 8) != 0) {
            gL.glDisableClientState(32885);
        }
        gL.glDisableClientState(32884);
    }

    protected void updateBounds() {
        if (this.numRequiredCoords != 0) {
            super.updateBounds();
        }
    }

    protected void recomputeBounds() {
        if (this.numRequiredCoords == 0) {
            return;
        }
        float f = this.coordinates[0];
        float f2 = this.coordinates[1];
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = this.coordinates[0];
        float f6 = this.coordinates[1];
        float f7 = 0.0f;
        float f8 = 0.0f;
        switch (this.vertexFormat & 7) {
            case 2: {
                int n;
                int n2 = 2;
                for (n = 1; n < this.numRequiredCoords; ++n) {
                    if (this.coordinates[n2] < f) {
                        f = this.coordinates[n2];
                    }
                    if (this.coordinates[n2] > f5) {
                        f5 = this.coordinates[n2];
                    }
                    if (this.coordinates[n2 + 1] < f2) {
                        f2 = this.coordinates[n2 + 1];
                    }
                    if (this.coordinates[n2 + 1] > f6) {
                        f6 = this.coordinates[n2 + 1];
                    }
                    n2 += 2;
                }
                break;
            }
            case 3: {
                int n;
                f3 = this.coordinates[2];
                f7 = this.coordinates[2];
                int n3 = 3;
                for (n = 1; n < this.numRequiredCoords; ++n) {
                    if (this.coordinates[n3] < f) {
                        f = this.coordinates[n3];
                    }
                    if (this.coordinates[n3] > f5) {
                        f5 = this.coordinates[n3];
                    }
                    if (this.coordinates[n3 + 1] < f2) {
                        f2 = this.coordinates[n3 + 1];
                    }
                    if (this.coordinates[n3 + 1] > f6) {
                        f6 = this.coordinates[n3 + 1];
                    }
                    if (this.coordinates[n3 + 2] < f3) {
                        f3 = this.coordinates[n3 + 2];
                    }
                    if (this.coordinates[n3 + 2] > f7) {
                        f7 = this.coordinates[n3 + 2];
                    }
                    n3 += 3;
                }
                break;
            }
            case 4: {
                int n;
                f3 = this.coordinates[2];
                f7 = this.coordinates[2];
                f4 = this.coordinates[3];
                f8 = this.coordinates[3];
                int n4 = 4;
                for (n = 1; n < this.numRequiredCoords; ++n) {
                    if (this.coordinates[n4] < f) {
                        f = this.coordinates[n4];
                    }
                    if (this.coordinates[n4] > f5) {
                        f5 = this.coordinates[n4];
                    }
                    if (this.coordinates[n4 + 1] < f2) {
                        f2 = this.coordinates[n4 + 1];
                    }
                    if (this.coordinates[n4 + 1] > f6) {
                        f6 = this.coordinates[n4 + 1];
                    }
                    if (this.coordinates[n4 + 2] < f3) {
                        f3 = this.coordinates[n4 + 2];
                    }
                    if (this.coordinates[n4 + 2] > f7) {
                        f7 = this.coordinates[n4 + 2];
                    }
                    n4 += 4;
                }
                break;
            }
        }
        BoundingBox boundingBox = (BoundingBox)this.bounds;
        boundingBox.setMinimum(f, f2, f3);
        boundingBox.setMaximum(f5, f6, f7);
    }

    private FloatBuffer createBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        return floatBuffer;
    }

    protected void initPolygonDetails(int n) {
        if (this.working2dCoords == null) {
            this.working2dCoords = new float[n * 2];
            this.wkPolygon = new float[n * 3];
        }
    }

    protected boolean ray3DTriangleChecked(float[] fArray, float[] fArray2, float f, float[] fArray3) {
        int n;
        float f2;
        float f3;
        float f4;
        float f5 = this.wkPolygon[4] - this.wkPolygon[1];
        float f6 = this.wkPolygon[8] - this.wkPolygon[5];
        float f7 = this.wkPolygon[5] - this.wkPolygon[2];
        float f8 = this.wkPolygon[7] - this.wkPolygon[4];
        float f9 = f5 * f6 - f7 * f8;
        float f10 = this.wkPolygon[6] - this.wkPolygon[3];
        float f11 = this.wkPolygon[3] - this.wkPolygon[0];
        float f12 = f7 * f10 - f11 * f6;
        float f13 = f11 * f8 - f5 * f10;
        if (f9 * f9 + f12 * f12 + f13 * f13 == 0.0f) {
            return false;
        }
        float f14 = f9 * fArray2[0] + f12 * fArray2[1] + f13 * fArray2[2];
        if (f14 == 0.0f) {
            return false;
        }
        float f15 = f9 * this.wkPolygon[0] + f12 * this.wkPolygon[1] + f13 * this.wkPolygon[2];
        float f16 = f9 * fArray[0] + f12 * fArray[1] + f13 * fArray[2];
        float f17 = (f15 - f16) / f14;
        if (f17 < 0.0f) {
            return false;
        }
        fArray3[0] = fArray[0] + fArray2[0] * f17;
        fArray3[1] = fArray[1] + fArray2[1] * f17;
        fArray3[2] = fArray[2] + fArray2[2] * f17;
        if (f != 0.0f && (f4 = fArray[0] - fArray3[0]) * f4 + (f3 = fArray[1] - fArray3[1]) * f3 + (f2 = fArray[2] - fArray3[2]) * f2 > f * f) {
            return false;
        }
        f4 = f9 >= 0.0f ? f9 : -f9;
        f3 = f12 >= 0.0f ? f12 : -f12;
        f2 = f13 >= 0.0f ? f13 : -f13;
        int n2 = f4 > f3 ? 0 : 1;
        if (n2 == 0) {
            if (f4 < f2) {
                n2 = 2;
            }
        } else if (f3 < f2) {
            n2 = 2;
        }
        int n3 = 5;
        switch (n2) {
            case 0: {
                n = 3;
                while (--n >= 0) {
                    this.working2dCoords[n3--] = this.wkPolygon[n * 3 + 2] - fArray3[2];
                    this.working2dCoords[n3--] = this.wkPolygon[n * 3 + 1] - fArray3[1];
                }
                break;
            }
            case 1: {
                n = 3;
                while (--n >= 0) {
                    this.working2dCoords[n3--] = this.wkPolygon[n * 3 + 2] - fArray3[2];
                    this.working2dCoords[n3--] = this.wkPolygon[n * 3] - fArray3[0];
                }
                break;
            }
            case 2: {
                n = 3;
                while (--n >= 0) {
                    this.working2dCoords[n3--] = this.wkPolygon[n * 3 + 1] - fArray3[1];
                    this.working2dCoords[n3--] = this.wkPolygon[n * 3] - fArray3[0];
                }
                break;
            }
        }
        int n4 = 0;
        int n5 = (double)this.working2dCoords[1] < 0.0 ? -1 : 1;
        for (n = 0; n < 3; ++n) {
            float f18;
            n3 = (n + 1) % 3;
            int n6 = n * 2;
            int n7 = n3 * 2;
            int n8 = n * 2 + 1;
            int n9 = n3 * 2 + 1;
            int n10 = (double)this.working2dCoords[n9] < 0.0 ? -1 : 1;
            if (n5 == n10) continue;
            if ((double)this.working2dCoords[n6] > 0.0 && (double)this.working2dCoords[n7] > 0.0) {
                ++n4;
            } else if (((double)this.working2dCoords[n6] > 0.0 || (double)this.working2dCoords[n7] > 0.0) && (f18 = this.working2dCoords[n6] - this.working2dCoords[n8] * (this.working2dCoords[n7] - this.working2dCoords[n6]) / (this.working2dCoords[n9] - this.working2dCoords[n8])) > 0.0f) {
                ++n4;
            }
            n5 = n10;
        }
        return n4 % 2 == 1;
    }

    protected boolean ray3DQuadChecked(float[] fArray, float[] fArray2, float f, float[] fArray3) {
        int n;
        float f2;
        float f3;
        float f4;
        float f5 = this.wkPolygon[4] - this.wkPolygon[1];
        float f6 = this.wkPolygon[8] - this.wkPolygon[5];
        float f7 = this.wkPolygon[5] - this.wkPolygon[2];
        float f8 = this.wkPolygon[7] - this.wkPolygon[4];
        float f9 = f5 * f6 - f7 * f8;
        float f10 = this.wkPolygon[6] - this.wkPolygon[3];
        float f11 = this.wkPolygon[3] - this.wkPolygon[0];
        float f12 = f7 * f10 - f11 * f6;
        float f13 = f11 * f8 - f5 * f10;
        if (f9 * f9 + f12 * f12 + f13 * f13 == 0.0f) {
            return false;
        }
        float f14 = f9 * fArray2[0] + f12 * fArray2[1] + f13 * fArray2[2];
        if (f14 == 0.0f) {
            return false;
        }
        float f15 = f9 * this.wkPolygon[0] + f12 * this.wkPolygon[1] + f13 * this.wkPolygon[2];
        float f16 = f9 * fArray[0] + f12 * fArray[1] + f13 * fArray[2];
        float f17 = (f15 - f16) / f14;
        if (f17 < 0.0f) {
            return false;
        }
        fArray3[0] = fArray[0] + fArray2[0] * f17;
        fArray3[1] = fArray[1] + fArray2[1] * f17;
        fArray3[2] = fArray[2] + fArray2[2] * f17;
        if (f != 0.0f && (f4 = fArray[0] - fArray3[0]) * f4 + (f3 = fArray[1] - fArray3[1]) * f3 + (f2 = fArray[2] - fArray3[2]) * f2 > f * f) {
            return false;
        }
        f4 = f9 >= 0.0f ? f9 : -f9;
        f3 = f12 >= 0.0f ? f12 : -f12;
        f2 = f13 >= 0.0f ? f13 : -f13;
        int n2 = f4 > f3 ? 0 : 1;
        if (n2 == 0) {
            if (f4 < f2) {
                n2 = 2;
            }
        } else if (f3 < f2) {
            n2 = 2;
        }
        int n3 = 7;
        switch (n2) {
            case 0: {
                n = 4;
                while (--n >= 0) {
                    this.working2dCoords[n3--] = this.wkPolygon[n * 3 + 2] - fArray3[2];
                    this.working2dCoords[n3--] = this.wkPolygon[n * 3 + 1] - fArray3[1];
                }
                break;
            }
            case 1: {
                n = 4;
                while (--n >= 0) {
                    this.working2dCoords[n3--] = this.wkPolygon[n * 3 + 2] - fArray3[2];
                    this.working2dCoords[n3--] = this.wkPolygon[n * 3] - fArray3[0];
                }
                break;
            }
            case 2: {
                n = 4;
                while (--n >= 0) {
                    this.working2dCoords[n3--] = this.wkPolygon[n * 3 + 1] - fArray3[1];
                    this.working2dCoords[n3--] = this.wkPolygon[n * 3] - fArray3[0];
                }
                break;
            }
        }
        int n4 = 0;
        int n5 = (double)this.working2dCoords[1] < 0.0 ? -1 : 1;
        for (n = 0; n < 4; ++n) {
            float f18;
            n3 = (n + 1) % 4;
            int n6 = n * 2;
            int n7 = n3 * 2;
            int n8 = n * 2 + 1;
            int n9 = n3 * 2 + 1;
            int n10 = (double)this.working2dCoords[n9] < 0.0 ? -1 : 1;
            if (n5 == n10) continue;
            if ((double)this.working2dCoords[n6] > 0.0 && (double)this.working2dCoords[n7] > 0.0) {
                ++n4;
            } else if (((double)this.working2dCoords[n6] > 0.0 || (double)this.working2dCoords[n7] > 0.0) && (f18 = this.working2dCoords[n6] - this.working2dCoords[n8] * (this.working2dCoords[n7] - this.working2dCoords[n6]) / (this.working2dCoords[n9] - this.working2dCoords[n8])) > 0.0f) {
                ++n4;
            }
            n5 = n10;
        }
        return n4 % 2 == 1;
    }

    public boolean isMultiTextureAllowed() {
        return hasMultiTextureAPI;
    }

    public int numTextureUnits() {
        return maxTextureUnits;
    }
}

