/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.GL14ShaderProgram;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.RenderableObject;

public class VertexShader
extends GL14ShaderProgram
implements RenderableObject,
Comparable {
    private float[][] envParameters;
    private float[][] localParameters;
    private int[] validEnvironments;
    private int numValidEnvironments;
    private int[] validLocals;
    private int numValidLocals;

    public VertexShader() {
        this(16, 96);
    }

    public VertexShader(int n, int n2) throws InvalidWriteTimingException {
        this.envParameters = new float[n2][];
        this.localParameters = new float[n2][];
        this.validEnvironments = new int[n2];
        this.validLocals = new int[n2];
    }

    public void render(GL gL, GLU gLU) {
        int n;
        if (this.programString == null) {
            return;
        }
        if (this.programChanged) {
            int[] nArray = new int[1];
            gL.glGenProgramsARB(1, nArray);
            this.programId = nArray[0];
            gL.glBindProgramARB(34336, this.programId);
            gL.glProgramStringARB(34336, 34933, this.programString.length(), this.programString);
            this.programChanged = false;
        }
        gL.glBindProgramARB(34336, this.programId);
        for (n = 0; n < this.numValidEnvironments; ++n) {
            gL.glProgramEnvParameter4fvARB(34336, this.validEnvironments[n], this.envParameters[this.validEnvironments[n]]);
        }
        for (n = 0; n < this.numValidLocals; ++n) {
            gL.glProgramEnvParameter4fvARB(34336, this.validLocals[n], this.localParameters[this.validLocals[n]]);
        }
        gL.glEnable(34336);
    }

    public void postRender(GL gL, GLU gLU) {
        gL.glDisable(34336);
    }

    public int compareTo(Object object) throws ClassCastException {
        VertexShader vertexShader = (VertexShader)object;
        return this.compareTo(vertexShader);
    }

    public boolean equals(Object object) {
        if (!(object instanceof VertexShader)) {
            return false;
        }
        return this.equals((VertexShader)object);
    }

    public void setEnvironmentParam(int n, float[] fArray) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.envParameters[n] == null) {
            this.envParameters[n] = new float[4];
        }
        this.envParameters[n][0] = fArray[0];
        this.envParameters[n][1] = fArray[1];
        this.envParameters[n][2] = fArray[2];
        this.envParameters[n][3] = fArray[3];
        boolean bl = false;
        for (int i = 0; i < this.numValidEnvironments; ++i) {
            if (this.validEnvironments[i] != n) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.validEnvironments[this.numValidEnvironments++] = n;
        }
    }

    public void setLocalParam(int n, float[] fArray) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.localParameters[n] == null) {
            this.localParameters[n] = new float[4];
        }
        this.localParameters[n][0] = fArray[0];
        this.localParameters[n][1] = fArray[1];
        this.localParameters[n][2] = fArray[2];
        this.localParameters[n][3] = fArray[3];
        boolean bl = false;
        for (int i = 0; i < this.numValidLocals; ++i) {
            if (this.validLocals[i] != n) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.validLocals[this.numValidLocals++] = n;
        }
    }

    public int compareTo(VertexShader vertexShader) {
        int n;
        int n2;
        int n3;
        int n4;
        if (vertexShader == null) {
            return 1;
        }
        if (vertexShader == this) {
            return 0;
        }
        if (this.programString != vertexShader.programString) {
            if (this.programString == null) {
                return -1;
            }
            if (vertexShader.programString == null) {
                return 1;
            }
            n4 = this.programString.compareTo(vertexShader.programString);
            if (n4 != 0) {
                return n4;
            }
        }
        if (this.numValidEnvironments != vertexShader.numValidEnvironments) {
            return this.numValidEnvironments < vertexShader.numValidEnvironments ? -1 : 1;
        }
        for (n4 = 0; n4 < this.numValidEnvironments; ++n4) {
            n3 = this.validEnvironments[n4];
            n2 = vertexShader.validEnvironments[n4];
            if (n3 != n2) {
                return n3 < n2 ? -1 : 1;
            }
            n = this.compareVector(this.envParameters[n3], vertexShader.envParameters[n2]);
            if (n == 0) continue;
            return n;
        }
        if (this.numValidLocals != vertexShader.numValidLocals) {
            return this.numValidLocals < vertexShader.numValidLocals ? -1 : 1;
        }
        for (n4 = 0; n4 < this.numValidLocals; ++n4) {
            n3 = this.validLocals[n4];
            n2 = vertexShader.validLocals[n4];
            if (n3 != n2) {
                return n3 < n2 ? -1 : 1;
            }
            n = this.compareVector(this.localParameters[n3], vertexShader.localParameters[n2]);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    public boolean equals(VertexShader vertexShader) {
        int n;
        int n2;
        int n3;
        if (vertexShader == this) {
            return true;
        }
        if (vertexShader == null) {
            return false;
        }
        if (!(this.programString == vertexShader.programString || this.programString != null && this.programString.equals(vertexShader.programString))) {
            return false;
        }
        if (this.numValidEnvironments == vertexShader.numValidEnvironments) {
            for (n3 = 0; n3 < this.numValidEnvironments; ++n3) {
                n2 = this.validEnvironments[n3];
                n = vertexShader.validEnvironments[n3];
                if (n2 == n && this.equalsVector(this.envParameters[n2], vertexShader.envParameters[n])) continue;
                return false;
            }
        }
        if (this.numValidLocals == vertexShader.numValidLocals) {
            for (n3 = 0; n3 < this.numValidLocals; ++n3) {
                n2 = this.validLocals[n3];
                n = vertexShader.validLocals[n3];
                if (n2 == n && this.equalsVector(this.localParameters[n2], vertexShader.localParameters[n])) continue;
                return false;
            }
        }
        return true;
    }

    private int compareVector(float[] fArray, float[] fArray2) {
        if (fArray[0] < fArray2[0]) {
            return -1;
        }
        if (fArray[0] > fArray2[0]) {
            return 1;
        }
        if (fArray[1] < fArray2[1]) {
            return -1;
        }
        if (fArray[1] > fArray2[1]) {
            return 1;
        }
        if (fArray[2] < fArray2[2]) {
            return -1;
        }
        if (fArray[2] > fArray2[2]) {
            return 1;
        }
        if (fArray[3] < fArray2[3]) {
            return -1;
        }
        if (fArray[3] > fArray2[3]) {
            return 1;
        }
        return 0;
    }

    private boolean equalsVector(float[] fArray, float[] fArray2) {
        return fArray[0] == fArray2[0] && fArray[1] == fArray2[1] && fArray[2] == fArray2[2] && fArray[3] == fArray2[3];
    }
}

