/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.awt.Rectangle;

public class ViewEnvironment {
    private static final String INVALID_PROJECTION_MSG = "Invalid projection type provided. Must be one of ORTHOGRAPHIC_PROJECTION or PERSPECTIVE_PROJECTION";
    private static final String INVALID_FOV_MSG = "The field of view angle provided is invalid. Must be between 0 and 180";
    private static final String NEGATIVE_CLIP_MSG = "The clip distance provided is negative ";
    private static final String INVERT_CLIP_MSG = "The near clip plane is greater than the far clip plane";
    public static final int PERSPECTIVE_PROJECTION = 1;
    public static final int ORTHOGRAPHIC_PROJECTION = 2;
    private boolean useStereo = false;
    private int projectionType = 1;
    private double fov = 45.0;
    private double nearClip = 0.01;
    private double farClip = 1000.0;
    private double aspectRatio = 1.0;
    private Rectangle viewportSize;

    public void setStereoEnabled(boolean bl) {
        this.useStereo = bl;
    }

    public boolean getStereoEnabled() {
        return this.useStereo;
    }

    public void setProjectionType(int n) throws IllegalArgumentException {
        if (n < 1 || n > 2) {
            throw new IllegalArgumentException(INVALID_PROJECTION_MSG);
        }
        this.projectionType = n;
    }

    public int getProjectionType() {
        return this.projectionType;
    }

    public void setFieldOfView(double d) throws IllegalArgumentException {
        if (d < 0.0 || d > 180.0) {
            throw new IllegalArgumentException(INVALID_FOV_MSG);
        }
        this.fov = d;
    }

    public double getFieldOfView() {
        return this.fov;
    }

    public void setAspectRatio(double d) {
        this.aspectRatio = d;
    }

    public double getAspectRatio() {
        return this.aspectRatio;
    }

    public void setViewport(Rectangle rectangle) {
        if (rectangle == null) {
            this.viewportSize = null;
        } else {
            if (this.viewportSize == null) {
                this.viewportSize = new Rectangle();
            }
            this.viewportSize.setBounds(rectangle);
        }
    }

    public Rectangle getViewport() {
        return this.viewportSize;
    }

    public void setNearClipDistance(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(NEGATIVE_CLIP_MSG);
        }
        if (d >= this.farClip) {
            throw new IllegalArgumentException(INVERT_CLIP_MSG);
        }
        this.nearClip = d;
    }

    public double getNearClipDistance() {
        return this.nearClip;
    }

    public void setClipDistance(double d, double d2) {
        if (d < 0.0) {
            throw new IllegalArgumentException(NEGATIVE_CLIP_MSG);
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException(NEGATIVE_CLIP_MSG);
        }
        if (d >= d2) {
            throw new IllegalArgumentException(INVERT_CLIP_MSG);
        }
        this.nearClip = d;
        this.farClip = d2;
    }

    public void setFarClipDistance(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(NEGATIVE_CLIP_MSG);
        }
        if (d <= this.nearClip) {
            throw new IllegalArgumentException(INVERT_CLIP_MSG);
        }
        this.farClip = d;
    }

    public double getFarClipDistance() {
        return this.farClip;
    }

    public void generateViewFrustum(double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        d4 = this.nearClip * Math.tan(this.fov * Math.PI / 360.0);
        d3 = -d4;
        if (this.aspectRatio <= 0.0) {
            if (this.viewportSize != null) {
                double d5 = (float)this.viewportSize.width / (float)this.viewportSize.height;
                d = d3 * d5;
                d2 = d4 * d5;
            } else {
                System.out.println("Implied aspect ratio and no screen size set");
                d = d3;
                d2 = d4;
            }
        } else {
            d = d3 * this.aspectRatio;
            d2 = d4 * this.aspectRatio;
        }
        dArray[0] = d;
        dArray[1] = d2;
        dArray[2] = d3;
        dArray[3] = d4;
        dArray[4] = this.nearClip;
        dArray[5] = this.farClip;
    }
}

