/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Leaf;

public class Viewpoint
extends Leaf {
    private static final float[] DIR_LOCATION = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
    private static final float[] SPOT_LOCATION = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
    private static final float[] DEFAULT_AMBIENT = new float[]{0.2f, 0.2f, 0.2f, 1.0f};
    private boolean useHeadlight = false;
    private boolean useDirectionalLight = true;
    private boolean useGlobalAmbient = false;
    private float[] globalColor;

    public void render(GL gL, GLU gLU) {
        if (this.useHeadlight) {
            gL.glEnable(16384);
            if (!this.useDirectionalLight) {
                gL.glLightfv(16384, 4611, SPOT_LOCATION);
                gL.glLightf(16384, 4614, 45.0f);
            } else {
                gL.glLightfv(16384, 4611, DIR_LOCATION);
            }
        }
        if (this.useGlobalAmbient) {
            gL.glLightModelfv(2899, this.globalColor);
        }
    }

    public void postRender(GL gL, GLU gLU) {
        if (this.useHeadlight) {
            gL.glDisable(16384);
        }
        if (this.useGlobalAmbient) {
            gL.glLightModelfv(2899, DEFAULT_AMBIENT);
        }
    }

    protected void markBoundsDirty() {
    }

    public boolean isHeadlightEnabled() {
        return this.useHeadlight;
    }

    public void setHeadlightEnabled(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.useHeadlight = bl;
    }

    public void setGlobalAmbientLightEnabled(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.useGlobalAmbient = bl;
        if (this.globalColor == null) {
            this.globalColor = new float[]{0.2f, 0.2f, 0.2f, 1.0f};
        }
    }

    public boolean isGlobalAmbientLightEnabled() {
        return this.useGlobalAmbient;
    }

    public void setGlobalAmbientColor(float[] fArray) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (fArray[0] < 0.0f || fArray[0] > 1.0f) {
            throw new IllegalArgumentException("Red component out of range");
        }
        if (fArray[1] < 0.0f || fArray[1] > 1.0f) {
            throw new IllegalArgumentException("Green component out of range");
        }
        if (fArray[2] < 0.0f || fArray[2] > 1.0f) {
            throw new IllegalArgumentException("Blue component out of range");
        }
        this.globalColor[0] = fArray[0];
        this.globalColor[1] = fArray[1];
        this.globalColor[2] = fArray[2];
    }

    public void getGlobalAmbientColor(float[] fArray) {
        fArray[0] = this.globalColor[0];
        fArray[1] = this.globalColor[1];
        fArray[2] = this.globalColor[2];
    }

    public boolean isDirectionalLight() {
        return this.useDirectionalLight;
    }

    public void setHeadlightType(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.useDirectionalLight = bl;
    }
}

