/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.audio;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import net.java.games.joal.AL;
import net.java.games.joal.ALC;
import net.java.games.joal.ALFactory;
import net.java.games.joal.OpenALException;
import org.j3d.aviatrix3d.AudioDetails;
import org.j3d.aviatrix3d.AudioDevice;
import org.j3d.aviatrix3d.AudioInstructions;
import org.j3d.aviatrix3d.DeletableSceneGraphObject;
import org.j3d.aviatrix3d.Sound;
import org.j3d.util.MatrixUtils;

public class OpenALAudioDevice
implements AudioDevice {
    private static final float[] DEFAULT_ORIENTATION = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f};
    private static final int LIST_START_SIZE = 20;
    private int numRenderables;
    private boolean initComplete = false;
    private AL al;
    private ALC.Context context;
    private ALC.Device device;
    private AudioInstructions commands;
    private MatrixUtils matrixUtils = new MatrixUtils();
    private Matrix4f tmpMatrix = new Matrix4f();
    private Point3f listenerPoint;
    private Point3f tmpPoint = new Point3f();
    private boolean initFailed = false;
    private boolean terminate = false;
    private int lastId = 0;

    public OpenALAudioDevice() {
        this.listenerPoint = new Point3f(0.0f, 0.0f, 0.0f);
    }

    public void queueDeletedObject(DeletableSceneGraphObject deletableSceneGraphObject) {
        System.out.println("Audio deletions unsupported atm");
    }

    public void setDrawableObjects(AudioInstructions audioInstructions) {
        this.commands = audioInstructions;
    }

    public void draw() {
        AudioInstructions audioInstructions = this.commands;
        int n = audioInstructions.numValid;
        if (this.initFailed || n == 0) {
            return;
        }
        if (n > this.lastId) {
            this.lastId = n;
        }
        if (!this.initComplete) {
            try {
                this.al = ALFactory.getAL();
                ALFactory.initialize();
                ALC aLC = ALFactory.getALC();
                this.device = aLC.alcOpenDevice(null);
                this.context = aLC.alcCreateContext(this.device, null);
                aLC.alcMakeContextCurrent(this.context);
                this.al.alGetError();
                this.al.alDistanceModel(53250);
                this.initComplete = true;
            }
            catch (OpenALException openALException) {
                System.out.println("OpenAL initialisation error " + openALException.getMessage());
                openALException.printStackTrace();
                this.initFailed = true;
            }
        } else {
            if (n == 0) {
                return;
            }
            try {
                ALC aLC = ALFactory.getALC();
                aLC.alcMakeContextCurrent(this.context);
                AudioDetails[] audioDetailsArray = audioInstructions.renderList;
                this.matrixUtils.inverse(audioInstructions.renderData.viewTransform, this.tmpMatrix);
                this.tmpMatrix.transform(this.listenerPoint, this.tmpPoint);
                this.al.alListener3f(4100, this.tmpPoint.x, this.tmpPoint.y, this.tmpPoint.z);
                this.al.alListenerfv(4111, DEFAULT_ORIENTATION);
                block8: for (int i = 0; i < n && !this.terminate; ++i) {
                    switch (audioInstructions.renderOps[i]) {
                        case 1: {
                            Sound sound = (Sound)audioDetailsArray[i].renderable;
                            sound.render(this.al, audioDetailsArray[i].transform);
                            continue block8;
                        }
                        case 2: {
                            Sound sound = (Sound)audioDetailsArray[i].renderable;
                            sound.postRender(this.al);
                            continue block8;
                        }
                        default: {
                            System.out.println("Unknown OP in AudioDevice");
                        }
                    }
                }
                aLC.alcFreeCurrentContext();
                if (this.terminate) {
                    return;
                }
            }
            catch (OpenALException openALException) {
                System.out.println("OpenAL exception!");
                openALException.printStackTrace();
            }
        }
    }

    public Object getSurfaceObject() {
        return null;
    }

    public void dispose() {
        this.terminate = true;
        if (this.initComplete) {
            try {
                ALC aLC = ALFactory.getALC();
                aLC.alcMakeContextCurrent(this.context);
                int[] nArray = new int[this.lastId + 1];
                for (int i = 0; i < this.lastId + 1; ++i) {
                    nArray[i] = i;
                }
                this.al.alDeleteBuffers(nArray.length, nArray);
                this.al.alDeleteSources(nArray.length, nArray);
                aLC.alcFreeCurrentContext();
                aLC.alcMakeContextCurrent(null);
                aLC.alcDestroyContext(this.context);
                aLC.alcCloseDevice(this.device);
            }
            catch (OpenALException openALException) {
                openALException.printStackTrace();
            }
        }
    }

    public void setRenderControlThread(Thread thread) {
    }
}

