/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.iutil;

import java.util.ArrayList;

public class GLStateMap {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private ArrayList entryCache;

    public GLStateMap() {
        this(5, 0.75f);
    }

    public GLStateMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
        this.entryCache = new ArrayList(n);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean containsKey(Object object) {
        Entry[] entryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public boolean getState(Object object) {
        Entry[] entryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n) {
                return entry.value;
            }
            entry = entry.next;
        }
        return false;
    }

    public void put(Object object, boolean bl) {
        Entry[] entryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n) {
                entry.value = bl;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        entry = this.getNewEntry();
        entry.set(n, bl, entryArray[n2]);
        entryArray[n2] = entry;
        ++this.count;
    }

    public boolean remove(Object object) {
        Entry[] entryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hash == n) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
                --this.count;
                this.releaseEntry(entry);
                return entry.value;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return false;
    }

    public void setAll(boolean bl) {
        if (this.count == 0) {
            return;
        }
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (--n >= 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                entry.value = bl;
                entry = entry.next;
            }
        }
    }

    public synchronized void clear() {
        if (this.count == 0) {
            return;
        }
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (--n >= 0) {
            Entry entry = entryArray[n];
            if (entry == null) continue;
            while (entry.next != null) {
                this.releaseEntry(entry);
                Entry entry2 = entry.next;
                entry.next = null;
                entry = entry2;
            }
            entryArray[n] = null;
        }
        this.count = 0;
    }

    private void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    private Entry getNewEntry() {
        int n = this.entryCache.size();
        Entry entry = n == 0 ? new Entry() : (Entry)this.entryCache.remove(n - 1);
        return entry;
    }

    private void releaseEntry(Entry entry) {
        this.entryCache.add(entry);
    }

    private static class Entry {
        int hash;
        boolean value;
        Entry next;

        protected Entry() {
        }

        protected Entry(int n, boolean bl, Entry entry) {
            this.hash = n;
            this.value = bl;
            this.next = entry;
        }

        protected void set(int n, boolean bl, Entry entry) {
            this.hash = n;
            this.value = bl;
            this.next = entry;
        }
    }
}

