/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline;

import org.j3d.aviatrix3d.AudioDevice;
import org.j3d.aviatrix3d.AudioPipeline;
import org.j3d.aviatrix3d.DeletableSceneGraphObject;
import org.j3d.aviatrix3d.pipeline.PipelineStateObserver;

class AudioPipelineThread
extends Thread {
    private boolean terminate;
    private AudioPipeline pipeline;
    private PipelineStateObserver observer;
    private Object displayLock;
    private boolean waiting;
    private boolean noProcessing;

    AudioPipelineThread(AudioPipeline audioPipeline) {
        super("Aviatrix3D audio pipeline");
        this.pipeline = audioPipeline;
        this.terminate = false;
        this.waiting = false;
        this.noProcessing = false;
        this.displayLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        AudioDevice audioDevice = this.pipeline.getAudioDevice();
        audioDevice.setRenderControlThread(this);
        while (!this.terminate) {
            try {
                if (this.noProcessing) {
                    this.pipeline.displayOnly();
                } else {
                    this.pipeline.render();
                }
                if (this.terminate) break;
                Object object = this.displayLock;
                synchronized (object) {
                    if (this.observer != null) {
                        this.observer.frameFinished();
                    }
                    if (this.terminate) {
                        break;
                    }
                    this.displayLock.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Thread.yield();
        }
        audioDevice.setRenderControlThread(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void halt() {
        this.pipeline.halt();
        try {
            Object object = this.displayLock;
            synchronized (object) {
                if (this.observer != null) {
                    this.observer.frameFinished();
                }
                this.displayLock.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displayOnly() {
        this.noProcessing = true;
        Object object = this.displayLock;
        synchronized (object) {
            this.displayLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void render() {
        this.noProcessing = false;
        Object object = this.displayLock;
        synchronized (object) {
            this.displayLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.terminate = true;
        AudioDevice audioDevice = this.pipeline.getAudioDevice();
        audioDevice.dispose();
        Object object = this.displayLock;
        synchronized (object) {
            this.displayLock.notify();
        }
    }

    void setStateObserver(PipelineStateObserver pipelineStateObserver) {
        this.observer = pipelineStateObserver;
    }

    public void queueDeletedObject(DeletableSceneGraphObject deletableSceneGraphObject) {
        AudioDevice audioDevice = this.pipeline.getAudioDevice();
        audioDevice.queueDeletedObject(deletableSceneGraphObject);
    }
}

