/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline;

import org.j3d.aviatrix3d.AudioCullStage;
import org.j3d.aviatrix3d.AudioDevice;
import org.j3d.aviatrix3d.AudioPipeline;
import org.j3d.aviatrix3d.AudioSortStage;
import org.j3d.aviatrix3d.Scene;
import org.j3d.aviatrix3d.pipeline.AudioCullToSingleSortListener;
import org.j3d.aviatrix3d.pipeline.AudioSortToSingleDeviceListener;

public class DefaultAudioPipeline
implements AudioPipeline {
    private AudioCullStage culler;
    private AudioSortStage sorter;
    private AudioDevice device;
    private AudioCullToSingleSortListener ctsListener = new AudioCullToSingleSortListener();
    private AudioSortToSingleDeviceListener stdListener = new AudioSortToSingleDeviceListener();
    private Scene sceneRoot;

    public DefaultAudioPipeline() {
    }

    public DefaultAudioPipeline(AudioCullStage audioCullStage, AudioSortStage audioSortStage) {
        this();
        this.culler = audioCullStage;
        this.sorter = audioSortStage;
        if (audioCullStage != null) {
            audioCullStage.setCulledAudioReceiver(this.ctsListener);
        }
        if (audioSortStage != null) {
            this.ctsListener.setSorter(audioSortStage);
            audioSortStage.setSortedAudioReceiver(this.stdListener);
        }
    }

    public void setAudioDevice(AudioDevice audioDevice) {
        this.stdListener.setDevice(audioDevice);
        this.device = audioDevice;
    }

    public AudioDevice getAudioDevice() {
        return this.device;
    }

    public void render() {
        if (this.sceneRoot == null) {
            return;
        }
        if (this.culler != null) {
            this.culler.cull(this.sceneRoot, 0);
            if (this.device != null) {
                this.device.draw();
            }
        }
    }

    public void displayOnly() {
        if (this.sceneRoot != null && this.device != null) {
            this.device.draw();
        }
    }

    public void setRenderableScene(Scene scene) {
        this.sceneRoot = scene;
    }

    public void halt() {
        if (this.culler != null) {
            this.culler.halt();
        }
        if (this.sorter != null) {
            this.sorter.halt();
        }
    }

    public void setSorter(AudioSortStage audioSortStage) {
        this.ctsListener.setSorter(audioSortStage);
        if (this.sorter != null) {
            this.sorter.setSortedAudioReceiver(null);
        }
        if (audioSortStage != null) {
            audioSortStage.setSortedAudioReceiver(this.stdListener);
        }
        this.sorter = audioSortStage;
    }

    public void setCuller(AudioCullStage audioCullStage) {
        if (this.culler != null) {
            this.culler.setCulledAudioReceiver(null);
        }
        if (audioCullStage != null) {
            audioCullStage.setCulledAudioReceiver(this.ctsListener);
        }
        this.culler = audioCullStage;
    }
}

