/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline;

import java.util.ArrayList;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import org.j3d.aviatrix3d.BoundingGeometry;
import org.j3d.aviatrix3d.BoundingVolume;
import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NotPickableException;
import org.j3d.aviatrix3d.PickRequest;
import org.j3d.aviatrix3d.PickableObject;
import org.j3d.aviatrix3d.SceneGraphPath;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.SharedNode;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.util.MatrixUtils;

class DefaultBatchPickingHandler {
    private static final int LIST_START_SIZE = 32;
    private static final int LIST_INCREMENT = 8;
    private int[] activePicks;
    private Node[] pickPath;
    private Matrix4f[] transformPath;
    private boolean[] validTransform;
    private int lastPathIndex;
    private float closestDistance;
    private float[][][] start;
    private float[][][] end;
    private float[][][] extraData;
    private float[] vertexPickData = new float[3];
    private Matrix4f vworldMatrix;
    private Matrix4f invertedMatrix;
    private Vector4f wkVec;
    private Vector3f wkNormal;
    private Vector4f[][] frustumPlanes;
    private MatrixUtils matrixUtils;

    public DefaultBatchPickingHandler() {
        this.pickPath = new Node[32];
        this.transformPath = new Matrix4f[32];
        this.validTransform = new boolean[32];
        for (int i = 0; i < 32; ++i) {
            this.transformPath[i] = new Matrix4f();
        }
        this.vworldMatrix = new Matrix4f();
        this.invertedMatrix = new Matrix4f();
        this.wkVec = new Vector4f();
        this.wkVec.w = 1.0f;
        this.wkNormal = new Vector3f();
        this.activePicks = new int[0];
        this.matrixUtils = new MatrixUtils();
    }

    void processPick(PickableObject pickableObject, PickRequest[] pickRequestArray, int n) throws NotPickableException {
        this.resizeForBatch(n);
        this.lastPathIndex = 0;
        this.transformPath[0].setIdentity();
        boolean bl = false;
        block14: for (int i = 0; i < n; ++i) {
            this.activePicks[i] = 0;
            pickRequestArray[i].pickCount = 0;
            if (!(pickableObject instanceof Node)) {
                System.out.println("batchPick not handling non-node root");
                continue;
            }
            Node node = (Node)((Object)pickableObject);
            BoundingVolume boundingVolume = node.getBounds();
            switch (pickRequestArray[i].pickSortType) {
                case 1: 
                case 3: {
                    if (pickRequestArray[i].foundPaths instanceof ArrayList) break;
                    pickRequestArray[i].foundPaths = new ArrayList();
                    break;
                }
                case 2: 
                case 4: {
                    if (pickRequestArray[i].foundPaths instanceof SceneGraphPath) break;
                    pickRequestArray[i].foundPaths = new SceneGraphPath();
                }
            }
            float[] fArray = this.start[i][0];
            float[] fArray2 = this.end[i][0];
            float[] fArray3 = this.extraData[i][0];
            switch (pickRequestArray[i].pickGeometryType) {
                case 1: {
                    if (!boundingVolume.checkIntersectionPoint(pickRequestArray[i].origin)) continue block14;
                    fArray[0] = pickRequestArray[i].origin[0];
                    fArray[1] = pickRequestArray[i].origin[1];
                    fArray[2] = pickRequestArray[i].origin[2];
                    int n2 = i;
                    this.activePicks[n2] = this.activePicks[n2] + 1;
                    bl = true;
                    continue block14;
                }
                case 2: {
                    if (!boundingVolume.checkIntersectionRay(pickRequestArray[i].origin, pickRequestArray[i].destination)) continue block14;
                    fArray[0] = pickRequestArray[i].origin[0];
                    fArray[1] = pickRequestArray[i].origin[1];
                    fArray[2] = pickRequestArray[i].origin[2];
                    fArray2[0] = pickRequestArray[i].destination[0];
                    fArray2[1] = pickRequestArray[i].destination[1];
                    fArray2[2] = pickRequestArray[i].destination[2];
                    int n3 = i;
                    this.activePicks[n3] = this.activePicks[n3] + 1;
                    bl = true;
                    continue block14;
                }
                case 3: {
                    if (!boundingVolume.checkIntersectionSegment(pickRequestArray[i].origin, pickRequestArray[i].destination)) continue block14;
                    fArray[0] = pickRequestArray[i].origin[0];
                    fArray[1] = pickRequestArray[i].origin[1];
                    fArray[2] = pickRequestArray[i].origin[2];
                    fArray2[0] = pickRequestArray[i].destination[0];
                    fArray2[1] = pickRequestArray[i].destination[1];
                    fArray2[2] = pickRequestArray[i].destination[2];
                    int n4 = i;
                    this.activePicks[n4] = this.activePicks[n4] + 1;
                    bl = true;
                    continue block14;
                }
                case 4: 
                case 5: {
                    float f = pickRequestArray[i].origin[0] - pickRequestArray[i].destination[0];
                    float f2 = pickRequestArray[i].origin[1] - pickRequestArray[i].destination[1];
                    float f3 = pickRequestArray[i].origin[2] - pickRequestArray[i].destination[2];
                    float f4 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
                    if (f4 == 0.0f) {
                        return;
                    }
                    fArray[0] = (pickRequestArray[i].origin[0] + pickRequestArray[i].destination[0]) * 0.5f;
                    fArray[1] = (pickRequestArray[i].origin[1] + pickRequestArray[i].destination[0]) * 0.5f;
                    fArray[2] = (pickRequestArray[i].origin[2] + pickRequestArray[i].destination[0]) * 0.5f;
                    fArray2[0] = f;
                    fArray2[1] = f2;
                    fArray2[2] = f3;
                    float f5 = pickRequestArray[i].additionalData;
                    if (!boundingVolume.checkIntersectionCylinder(fArray, fArray2, f5, f4)) continue block14;
                    fArray3[0] = f5;
                    fArray3[1] = f4;
                    int n5 = i;
                    this.activePicks[n5] = this.activePicks[n5] + 1;
                    bl = true;
                    continue block14;
                }
                case 6: 
                case 7: {
                    if (!boundingVolume.checkIntersectionCone(pickRequestArray[i].origin, pickRequestArray[i].destination, pickRequestArray[i].additionalData)) continue block14;
                    fArray[0] = pickRequestArray[i].origin[0];
                    fArray[1] = pickRequestArray[i].origin[1];
                    fArray[2] = pickRequestArray[i].origin[2];
                    fArray2[0] = pickRequestArray[i].destination[0];
                    fArray2[1] = pickRequestArray[i].destination[1];
                    fArray2[2] = pickRequestArray[i].destination[2];
                    fArray3[0] = pickRequestArray[i].additionalData;
                    int n6 = i;
                    this.activePicks[n6] = this.activePicks[n6] + 1;
                    bl = true;
                    continue block14;
                }
                case 8: {
                    if (!boundingVolume.checkIntersectionBox(pickRequestArray[i].origin, pickRequestArray[i].destination)) continue block14;
                    fArray[0] = pickRequestArray[i].origin[0];
                    fArray[1] = pickRequestArray[i].origin[1];
                    fArray[2] = pickRequestArray[i].origin[2];
                    fArray2[0] = pickRequestArray[i].destination[0];
                    fArray2[1] = pickRequestArray[i].destination[1];
                    fArray2[2] = pickRequestArray[i].destination[2];
                    int n7 = i;
                    this.activePicks[n7] = this.activePicks[n7] + 1;
                    bl = true;
                    continue block14;
                }
                case 10: {
                    this.frustumPlanes[i][0].x = pickRequestArray[i].origin[0];
                    this.frustumPlanes[i][0].y = pickRequestArray[i].origin[1];
                    this.frustumPlanes[i][0].z = pickRequestArray[i].origin[2];
                    this.frustumPlanes[i][0].w = pickRequestArray[i].origin[3];
                    this.frustumPlanes[i][1].x = pickRequestArray[i].origin[4];
                    this.frustumPlanes[i][1].y = pickRequestArray[i].origin[5];
                    this.frustumPlanes[i][1].z = pickRequestArray[i].origin[6];
                    this.frustumPlanes[i][1].w = pickRequestArray[i].origin[7];
                    this.frustumPlanes[i][2].x = pickRequestArray[i].origin[8];
                    this.frustumPlanes[i][2].y = pickRequestArray[i].origin[9];
                    this.frustumPlanes[i][2].z = pickRequestArray[i].origin[10];
                    this.frustumPlanes[i][2].w = pickRequestArray[i].origin[11];
                    this.frustumPlanes[i][3].x = pickRequestArray[i].origin[12];
                    this.frustumPlanes[i][3].y = pickRequestArray[i].origin[13];
                    this.frustumPlanes[i][3].z = pickRequestArray[i].origin[14];
                    this.frustumPlanes[i][3].w = pickRequestArray[i].origin[15];
                    this.frustumPlanes[i][4].x = pickRequestArray[i].origin[16];
                    this.frustumPlanes[i][4].y = pickRequestArray[i].origin[17];
                    this.frustumPlanes[i][4].z = pickRequestArray[i].origin[18];
                    this.frustumPlanes[i][4].w = pickRequestArray[i].origin[19];
                    this.frustumPlanes[i][5].x = pickRequestArray[i].origin[20];
                    this.frustumPlanes[i][5].y = pickRequestArray[i].origin[21];
                    this.frustumPlanes[i][5].z = pickRequestArray[i].origin[22];
                    this.frustumPlanes[i][5].w = pickRequestArray[i].origin[23];
                    if (boundingVolume.checkIntersectionFrustum(this.frustumPlanes[i], this.transformPath[this.lastPathIndex]) != 0) continue block14;
                    int n8 = i;
                    this.activePicks[n8] = this.activePicks[n8] + 1;
                    bl = true;
                    continue block14;
                }
                case 9: {
                    if (!boundingVolume.checkIntersectionSphere(pickRequestArray[i].origin, pickRequestArray[i].additionalData)) continue block14;
                    fArray[0] = pickRequestArray[i].origin[0];
                    fArray[1] = pickRequestArray[i].origin[1];
                    fArray[2] = pickRequestArray[i].origin[2];
                    fArray3[0] = pickRequestArray[i].additionalData;
                    int n9 = i;
                    this.activePicks[n9] = this.activePicks[n9] + 1;
                    bl = true;
                    continue block14;
                }
                default: {
                    System.out.println("No picking type has been specified");
                }
            }
        }
        if (bl) {
            this.descendTree((Node)((Object)pickableObject), pickRequestArray, n);
        }
    }

    private void descendTree(Node node, PickRequest[] pickRequestArray, int n) {
        int n2;
        Object object;
        BoundingVolume boundingVolume = node.getBounds();
        Node node2 = node;
        int n3 = 0;
        if (boundingVolume instanceof BoundingGeometry) {
            object = (BoundingGeometry)boundingVolume;
            node2 = ((BoundingGeometry)object).getProxyGeometry();
        }
        if (node2 instanceof Group) {
            object = (Group)node2;
            n3 = ((Group)object).numRenderableChildren();
            if (n3 == 0) {
                return;
            }
        } else {
            if (node2 instanceof SharedNode) {
                this.descendSharedTree((SharedNode)node2, pickRequestArray, n);
                return;
            }
            if (node2 instanceof Shape3D) {
                this.testShape((Shape3D)node2, pickRequestArray, n);
                return;
            }
        }
        if (node2 instanceof TransformGroup) {
            object = this.transformPath[this.lastPathIndex];
            ((TransformGroup)node2).getTransform((Matrix4f)object);
            this.matrixUtils.inverse((Matrix4f)object, this.invertedMatrix);
            float f = this.invertedMatrix.getScale();
            object.mul(this.transformPath[this.lastPathIndex - 1], (Matrix4f)object);
            this.validTransform[this.lastPathIndex] = true;
            block20: for (n2 = 0; n2 < n; ++n2) {
                if (this.activePicks[n2] < this.lastPathIndex) continue;
                switch (pickRequestArray[n2].pickGeometryType) {
                    case 1: {
                        this.transform(this.invertedMatrix, this.start[n2][this.lastPathIndex], this.start[n2][this.lastPathIndex + 1]);
                        continue block20;
                    }
                    case 2: {
                        this.transform(this.invertedMatrix, this.start[n2][this.lastPathIndex], this.start[n2][this.lastPathIndex + 1]);
                        this.transformNormal(this.invertedMatrix, this.end[n2][this.lastPathIndex], this.end[n2][this.lastPathIndex + 1]);
                        continue block20;
                    }
                    case 3: {
                        this.transform(this.invertedMatrix, this.start[n2][this.lastPathIndex], this.start[n2][this.lastPathIndex + 1]);
                        this.transform(this.invertedMatrix, this.end[n2][this.lastPathIndex], this.end[n2][this.lastPathIndex + 1]);
                        continue block20;
                    }
                    case 4: 
                    case 5: {
                        this.transform(this.invertedMatrix, this.start[n2][this.lastPathIndex], this.start[n2][this.lastPathIndex + 1]);
                        this.transformNormal(this.invertedMatrix, this.end[n2][this.lastPathIndex], this.end[n2][this.lastPathIndex + 1]);
                        this.extraData[n2][this.lastPathIndex + 1][0] = f * this.extraData[n2][this.lastPathIndex][0];
                        this.extraData[n2][this.lastPathIndex + 1][1] = f * this.extraData[n2][this.lastPathIndex][1];
                        continue block20;
                    }
                    case 6: 
                    case 7: {
                        this.transform(this.invertedMatrix, this.start[n2][this.lastPathIndex], this.start[n2][this.lastPathIndex + 1]);
                        this.transformNormal(this.invertedMatrix, this.end[n2][this.lastPathIndex], this.end[n2][this.lastPathIndex + 1]);
                        this.extraData[n2][this.lastPathIndex + 1][0] = f * this.extraData[n2][this.lastPathIndex][0];
                        continue block20;
                    }
                    case 8: {
                        this.transform(this.invertedMatrix, this.start[n2][this.lastPathIndex], this.start[n2][this.lastPathIndex + 1]);
                        this.transform(this.invertedMatrix, this.end[n2][this.lastPathIndex], this.end[n2][this.lastPathIndex + 1]);
                        continue block20;
                    }
                    case 10: {
                        continue block20;
                    }
                    case 9: {
                        this.transform(this.invertedMatrix, this.start[n2][this.lastPathIndex], this.start[n2][this.lastPathIndex + 1]);
                        this.extraData[n2][this.lastPathIndex + 1][0] = f * this.extraData[n2][this.lastPathIndex][0];
                        continue block20;
                    }
                }
            }
        } else {
            this.validTransform[this.lastPathIndex] = false;
            if (this.lastPathIndex == 0) {
                this.transformPath[this.lastPathIndex].setIdentity();
            } else {
                this.transformPath[this.lastPathIndex].set(this.transformPath[this.lastPathIndex - 1]);
            }
            for (int i = 0; i < n; ++i) {
                if (this.activePicks[i] < this.lastPathIndex) continue;
                this.start[i][this.lastPathIndex + 1][0] = this.start[i][this.lastPathIndex][0];
                this.start[i][this.lastPathIndex + 1][1] = this.start[i][this.lastPathIndex][1];
                this.start[i][this.lastPathIndex + 1][2] = this.start[i][this.lastPathIndex][2];
                this.end[i][this.lastPathIndex + 1][0] = this.end[i][this.lastPathIndex][0];
                this.end[i][this.lastPathIndex + 1][1] = this.end[i][this.lastPathIndex][1];
                this.end[i][this.lastPathIndex + 1][2] = this.end[i][this.lastPathIndex][2];
                this.extraData[i][this.lastPathIndex + 1][0] = this.extraData[i][this.lastPathIndex][0];
                this.extraData[i][this.lastPathIndex + 1][1] = this.extraData[i][this.lastPathIndex][1];
            }
        }
        Group group = (Group)node2;
        Node[] nodeArray = group.getRenderableChild();
        this.pickPath[this.lastPathIndex] = group;
        ++this.lastPathIndex;
        for (int i = 0; i < n3; ++i) {
            int n4;
            n2 = 0;
            if (nodeArray[i] == null) continue;
            boundingVolume = nodeArray[i].getBounds();
            block23: for (n4 = 0; n4 < n; ++n4) {
                if (this.activePicks[n4] < this.lastPathIndex) continue;
                switch (pickRequestArray[n4].pickGeometryType) {
                    case 1: {
                        if (!boundingVolume.checkIntersectionPoint(this.start[n4][this.lastPathIndex])) continue block23;
                        n2 = 1;
                        int n5 = n4;
                        this.activePicks[n5] = this.activePicks[n5] + 1;
                        continue block23;
                    }
                    case 2: {
                        if (!boundingVolume.checkIntersectionRay(this.start[n4][this.lastPathIndex], this.end[n4][this.lastPathIndex])) continue block23;
                        n2 = 1;
                        int n6 = n4;
                        this.activePicks[n6] = this.activePicks[n6] + 1;
                        continue block23;
                    }
                    case 3: {
                        if (!boundingVolume.checkIntersectionSegment(this.start[n4][this.lastPathIndex], this.end[n4][this.lastPathIndex])) continue block23;
                        n2 = 1;
                        int n7 = n4;
                        this.activePicks[n7] = this.activePicks[n7] + 1;
                        continue block23;
                    }
                    case 4: 
                    case 5: {
                        if (!boundingVolume.checkIntersectionCylinder(this.start[n4][this.lastPathIndex], this.end[n4][this.lastPathIndex], this.extraData[n4][this.lastPathIndex][0], this.extraData[n4][this.lastPathIndex][1])) continue block23;
                        n2 = 1;
                        int n8 = n4;
                        this.activePicks[n8] = this.activePicks[n8] + 1;
                        continue block23;
                    }
                    case 6: 
                    case 7: {
                        if (!boundingVolume.checkIntersectionCone(this.start[n4][this.lastPathIndex], this.end[n4][this.lastPathIndex], this.extraData[n4][this.lastPathIndex][0])) continue block23;
                        n2 = 1;
                        int n9 = n4;
                        this.activePicks[n9] = this.activePicks[n9] + 1;
                        continue block23;
                    }
                    case 8: {
                        if (!boundingVolume.checkIntersectionBox(this.start[n4][this.lastPathIndex], this.end[n4][this.lastPathIndex])) continue block23;
                        n2 = 1;
                        int n10 = n4;
                        this.activePicks[n10] = this.activePicks[n10] + 1;
                        continue block23;
                    }
                    case 10: {
                        if (boundingVolume.checkIntersectionFrustum(this.frustumPlanes[n4], this.transformPath[this.lastPathIndex]) != 0) continue block23;
                        n2 = 1;
                        int n11 = n4;
                        this.activePicks[n11] = this.activePicks[n11] + 1;
                        continue block23;
                    }
                    case 9: {
                        if (!boundingVolume.checkIntersectionSphere(this.start[n4][this.lastPathIndex], this.extraData[n4][this.lastPathIndex][0])) continue block23;
                        n2 = 1;
                        int n12 = n4;
                        this.activePicks[n12] = this.activePicks[n12] + 1;
                        continue block23;
                    }
                }
            }
            if (n2 == 0) continue;
            this.descendTree(nodeArray[i], pickRequestArray, n);
            for (n4 = 0; n4 < n; ++n4) {
                if (this.activePicks[n4] <= this.lastPathIndex) continue;
                int n13 = n4;
                this.activePicks[n13] = this.activePicks[n13] - 1;
            }
        }
        --this.lastPathIndex;
        this.pickPath[this.lastPathIndex] = null;
    }

    private void descendSharedTree(SharedNode sharedNode, PickRequest[] pickRequestArray, int n) {
        int n2 = sharedNode.getPickMask();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if ((n2 & pickRequestArray[i].pickType) == 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        Node node = sharedNode.getChild();
        if (node instanceof Group) {
            this.descendTree((Group)node, pickRequestArray, n);
        } else if (node instanceof SharedNode) {
            this.descendSharedTree((SharedNode)node, pickRequestArray, n);
        } else if (node instanceof Shape3D) {
            this.testShape((Shape3D)node, pickRequestArray, n);
        }
    }

    private void testShape(Shape3D shape3D, PickRequest[] pickRequestArray, int n) {
        int n2 = shape3D.getPickMask();
        BoundingVolume boundingVolume = shape3D.getBounds();
        for (int i = 0; i < n; ++i) {
            Object object;
            if (this.activePicks[i] < this.lastPathIndex || (n2 & pickRequestArray[i].pickType) == 0 || pickRequestArray[i].pickSortType == 2 && pickRequestArray[i].pickCount == 1) continue;
            boolean bl = false;
            switch (pickRequestArray[i].pickGeometryType) {
                case 1: {
                    bl = boundingVolume.checkIntersectionPoint(this.start[i][this.lastPathIndex]);
                    break;
                }
                case 2: {
                    if (!boundingVolume.checkIntersectionRay(this.start[i][this.lastPathIndex], this.end[i][this.lastPathIndex])) break;
                    if (pickRequestArray[i].useGeometry) {
                        object = shape3D.getGeometry();
                        boolean bl2 = pickRequestArray[i].pickSortType == 4 || pickRequestArray[i].pickSortType == 3;
                        bl = ((Geometry)object).pickLineRay(this.start[i][this.lastPathIndex], this.end[i][this.lastPathIndex], bl2, this.vertexPickData, 0);
                        bl = true;
                        break;
                    }
                    bl = true;
                    break;
                }
                case 3: {
                    if (!boundingVolume.checkIntersectionSegment(this.start[i][this.lastPathIndex], this.end[i][this.lastPathIndex])) break;
                    if (pickRequestArray[i].useGeometry) {
                        object = shape3D.getGeometry();
                        boolean bl3 = pickRequestArray[i].pickSortType == 4 || pickRequestArray[i].pickSortType == 3;
                        bl = ((Geometry)object).pickLineSegment(this.start[i][this.lastPathIndex], this.end[i][this.lastPathIndex], bl3, this.vertexPickData, 0);
                        bl = true;
                        break;
                    }
                    bl = true;
                    break;
                }
                case 4: 
                case 5: {
                    bl = boundingVolume.checkIntersectionCylinder(this.start[i][this.lastPathIndex], this.end[i][this.lastPathIndex], this.extraData[i][this.lastPathIndex][0], this.extraData[i][this.lastPathIndex][1]);
                    break;
                }
                case 6: 
                case 7: {
                    bl = boundingVolume.checkIntersectionCone(this.start[i][this.lastPathIndex], this.end[i][this.lastPathIndex], this.extraData[i][this.lastPathIndex][0]);
                    break;
                }
                case 8: {
                    bl = boundingVolume.checkIntersectionBox(this.start[i][this.lastPathIndex], this.end[i][this.lastPathIndex]);
                    break;
                }
                case 10: {
                    bl = boundingVolume.checkIntersectionFrustum(this.frustumPlanes[i], this.transformPath[this.lastPathIndex]) == 0;
                    break;
                }
                case 9: {
                    bl = boundingVolume.checkIntersectionSphere(this.start[i][this.lastPathIndex], this.extraData[i][this.lastPathIndex][0]);
                    break;
                }
            }
            if (!bl) continue;
            this.resizePath();
            this.pickPath[this.lastPathIndex] = shape3D;
            this.validTransform[this.lastPathIndex] = false;
            ++this.lastPathIndex;
            object = null;
            switch (pickRequestArray[i].pickSortType) {
                case 1: 
                case 3: {
                    ArrayList arrayList = (ArrayList)pickRequestArray[i].foundPaths;
                    if (pickRequestArray[i].pickCount >= arrayList.size()) {
                        object = new SceneGraphPath();
                        arrayList.add(object);
                        break;
                    }
                    object = (SceneGraphPath)arrayList.get(pickRequestArray[i].pickCount);
                    break;
                }
                case 2: 
                case 4: {
                    object = (SceneGraphPath)pickRequestArray[i].foundPaths;
                }
            }
            if (pickRequestArray[i].generateVWorldMatrix) {
                this.matrixUtils.inverse(this.transformPath[this.lastPathIndex - 1], this.vworldMatrix);
            } else {
                this.vworldMatrix.setIdentity();
            }
            ((SceneGraphPath)object).updatePath(this.pickPath, this.lastPathIndex, this.transformPath[this.lastPathIndex - 1], this.vworldMatrix);
            ++pickRequestArray[i].pickCount;
            --this.lastPathIndex;
        }
    }

    private final void resizePath() {
        if (this.lastPathIndex == this.pickPath.length) {
            int n = this.pickPath.length;
            int n2 = n + 8;
            Node[] nodeArray = new Node[n2];
            System.arraycopy(this.pickPath, 0, nodeArray, 0, n);
            this.pickPath = nodeArray;
            Matrix4f[] matrix4fArray = new Matrix4f[n2];
            System.arraycopy(this.transformPath, 0, matrix4fArray, 0, n);
            this.transformPath = matrix4fArray;
            for (int i = n; i < n2; ++i) {
                this.transformPath[i] = new Matrix4f();
            }
            boolean[] blArray = new boolean[n2];
            System.arraycopy(this.validTransform, 0, blArray, 0, n);
            this.validTransform = blArray;
        }
    }

    private void resizeForBatch(int n) {
        if (n <= this.activePicks.length) {
            return;
        }
        this.activePicks = new int[n];
        int n2 = this.lastPathIndex == 0 ? 32 : this.lastPathIndex;
        this.start = new float[n][n2][3];
        this.end = new float[n][n2][3];
        this.extraData = new float[n][n2][2];
        this.frustumPlanes = new Vector4f[n][6];
        for (int i = 0; i < n; ++i) {
            this.frustumPlanes[i][0] = new Vector4f();
            this.frustumPlanes[i][1] = new Vector4f();
            this.frustumPlanes[i][2] = new Vector4f();
            this.frustumPlanes[i][3] = new Vector4f();
            this.frustumPlanes[i][4] = new Vector4f();
            this.frustumPlanes[i][5] = new Vector4f();
        }
    }

    private void transform(Matrix4f matrix4f, float[] fArray, float[] fArray2) {
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        fArray2[0] = f * matrix4f.m00 + f2 * matrix4f.m01 + f3 * matrix4f.m02 + matrix4f.m03;
        fArray2[1] = f * matrix4f.m10 + f2 * matrix4f.m11 + f3 * matrix4f.m12 + matrix4f.m13;
        fArray2[2] = f * matrix4f.m20 + f2 * matrix4f.m21 + f3 * matrix4f.m22 + matrix4f.m23;
    }

    private void transformNormal(Matrix4f matrix4f, float[] fArray, float[] fArray2) {
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        fArray2[0] = f * matrix4f.m00 + f2 * matrix4f.m01 + f3 * matrix4f.m02;
        fArray2[1] = f * matrix4f.m10 + f2 * matrix4f.m11 + f3 * matrix4f.m12;
        fArray2[2] = f * matrix4f.m20 + f2 * matrix4f.m21 + f3 * matrix4f.m22;
    }
}

