/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline;

import java.util.ArrayList;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import org.j3d.aviatrix3d.BoundingGeometry;
import org.j3d.aviatrix3d.BoundingVolume;
import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NotPickableException;
import org.j3d.aviatrix3d.PickRequest;
import org.j3d.aviatrix3d.PickableObject;
import org.j3d.aviatrix3d.PickingHandler;
import org.j3d.aviatrix3d.SceneGraphPath;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.SharedNode;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.aviatrix3d.pipeline.DefaultBatchPickingHandler;
import org.j3d.util.MatrixUtils;

public class DefaultPickingHandler
implements PickingHandler {
    private static final int LIST_START_SIZE = 32;
    private static final int LIST_INCREMENT = 8;
    private DefaultBatchPickingHandler batchPicker;
    private Node[] pickPath;
    private Matrix4f[] transformPath;
    private boolean[] validTransform;
    private int lastPathIndex;
    private float closestDistance;
    private float[] start = new float[4];
    private float[] end = new float[4];
    private float[] vertexPickData;
    private Matrix4f vworldMatrix;
    private Matrix4f invertedMatrix;
    private Vector4f wkVec;
    private Vector3f wkNormal;
    private Vector4f[] frustumPlanes;
    private MatrixUtils matrixUtils;

    public DefaultPickingHandler() {
        this.start[3] = 1.0f;
        this.end[3] = 1.0f;
        this.vertexPickData = new float[3];
        this.pickPath = new Node[32];
        this.transformPath = new Matrix4f[32];
        this.validTransform = new boolean[32];
        for (int i = 0; i < 32; ++i) {
            this.transformPath[i] = new Matrix4f();
        }
        this.vworldMatrix = new Matrix4f();
        this.invertedMatrix = new Matrix4f();
        this.wkVec = new Vector4f();
        this.wkVec.w = 1.0f;
        this.wkNormal = new Vector3f();
        this.frustumPlanes = new Vector4f[]{new Vector4f(), new Vector4f(), new Vector4f(), new Vector4f(), new Vector4f(), new Vector4f()};
        this.matrixUtils = new MatrixUtils();
    }

    public void pickBatch(PickableObject pickableObject, PickRequest[] pickRequestArray, int n) throws NotPickableException {
        if (n == 0 || pickableObject == null || pickRequestArray == null || pickRequestArray.length == 0) {
            return;
        }
        if (n == 1 || pickRequestArray.length == 1) {
            this.pickSingle(pickableObject, pickRequestArray[0]);
        }
        if (this.batchPicker == null) {
            this.batchPicker = new DefaultBatchPickingHandler();
        }
        this.batchPicker.processPick(pickableObject, pickRequestArray, n);
    }

    public void pickSingle(PickableObject pickableObject, PickRequest pickRequest) throws NotPickableException {
        if (pickableObject == null || pickRequest == null) {
            return;
        }
        if ((pickableObject.getPickMask() & pickRequest.pickType) == 0) {
            pickRequest.pickCount = 0;
            return;
        }
        switch (pickRequest.pickGeometryType) {
            case 1: {
                this.pickPoint(pickableObject, pickRequest);
                break;
            }
            case 2: {
                this.pickRay(pickableObject, pickRequest);
                break;
            }
            case 3: {
                this.pickLineSegment(pickableObject, pickRequest);
                break;
            }
            case 4: 
            case 5: {
                this.pickCylinder(pickableObject, pickRequest);
                break;
            }
            case 6: 
            case 7: {
                this.pickCone(pickableObject, pickRequest);
                break;
            }
            case 8: {
                this.pickBox(pickableObject, pickRequest);
                break;
            }
            case 10: {
                this.pickFrustum(pickableObject, pickRequest);
                break;
            }
            case 9: {
                this.pickSphere(pickableObject, pickRequest);
                break;
            }
            default: {
                System.out.println("No picking type has been specified");
            }
        }
    }

    private void pickPoint(PickableObject pickableObject, PickRequest pickRequest) {
        switch (pickRequest.pickSortType) {
            case 1: 
            case 3: {
                this.pickAllPoint(pickableObject, pickRequest);
                break;
            }
            case 2: 
            case 4: {
                this.pickSinglePoint(pickableObject, pickRequest);
                break;
            }
            default: {
                System.out.println("No sort type has been specified");
            }
        }
    }

    private void pickSinglePoint(PickableObject pickableObject, PickRequest pickRequest) {
        SceneGraphPath sceneGraphPath = null;
        if (pickRequest.foundPaths instanceof SceneGraphPath) {
            sceneGraphPath = (SceneGraphPath)pickRequest.foundPaths;
        } else {
            sceneGraphPath = new SceneGraphPath();
            pickRequest.foundPaths = sceneGraphPath;
        }
        boolean bl = false;
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        if (pickableObject instanceof Node) {
            Object object;
            Node node = (Node)((Object)pickableObject);
            BoundingVolume boundingVolume = node.getBounds();
            if (!boundingVolume.checkIntersectionPoint(pickRequest.origin)) {
                pickRequest.pickCount = 0;
                return;
            }
            if (boundingVolume instanceof BoundingGeometry) {
                object = (BoundingGeometry)boundingVolume;
                node = ((BoundingGeometry)object).getProxyGeometry();
            }
            if (node instanceof Group) {
                object = (Group)node;
                int n = ((Group)object).numRenderableChildren();
                if (n != 0) {
                    if (node instanceof TransformGroup) {
                        ((TransformGroup)node).getTransform(this.transformPath[0]);
                        this.matrixUtils.inverse(this.transformPath[0], this.invertedMatrix);
                        this.transform(this.invertedMatrix, this.start);
                    } else {
                        this.transformPath[0].setIdentity();
                    }
                    this.validTransform[0] = true;
                    this.pickPath[0] = object;
                    Node[] nodeArray = ((Group)object).getRenderableChild();
                    for (int i = 0; i < n && !bl; ++i) {
                        this.lastPathIndex = 1;
                        if (nodeArray[i] instanceof Group) {
                            bl = this.pickSinglePoint((Group)nodeArray[i], pickRequest.pickType, this.start, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue;
                        }
                        if (nodeArray[i] instanceof SharedNode) {
                            bl = this.pickSinglePoint((SharedNode)nodeArray[i], pickRequest.pickType, this.start, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue;
                        }
                        if (!(nodeArray[i] instanceof Shape3D)) continue;
                        bl = this.pickSinglePoint((Shape3D)nodeArray[i], pickRequest.pickType, this.start, sceneGraphPath, pickRequest.generateVWorldMatrix);
                    }
                }
            } else if (node instanceof SharedNode) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (SharedNode)node;
                this.lastPathIndex = 1;
                bl = this.pickSinglePoint((SharedNode)node, pickRequest.pickType, this.start, sceneGraphPath, pickRequest.generateVWorldMatrix);
            } else if (node instanceof Shape3D) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (Shape3D)node;
                this.lastPathIndex = 1;
                bl = this.pickSinglePoint((Shape3D)node, pickRequest.pickType, this.start, sceneGraphPath, pickRequest.generateVWorldMatrix);
            } else {
                System.out.println("pickSinglePoint not handling non-shape/group root proxy");
            }
            pickRequest.pickCount = bl ? 1 : 0;
        } else {
            System.out.println("pickSinglePoint not handling non-node root");
        }
    }

    private boolean pickSinglePoint(SharedNode sharedNode, int n, float[] fArray, SceneGraphPath sceneGraphPath, boolean bl) {
        if ((sharedNode.getPickMask() & n) == 0) {
            return false;
        }
        Node node = sharedNode.getChild();
        if (node instanceof Group) {
            return this.pickSinglePoint((Group)node, n, fArray, sceneGraphPath, bl);
        }
        if (node instanceof SharedNode) {
            return this.pickSinglePoint((SharedNode)node, n, fArray, sceneGraphPath, bl);
        }
        if (node instanceof Shape3D) {
            return this.pickSinglePoint((Shape3D)node, n, fArray, sceneGraphPath, bl);
        }
        return false;
    }

    private boolean pickSinglePoint(Group group, int n, float[] fArray, SceneGraphPath sceneGraphPath, boolean bl) {
        if ((group.getPickMask() & n) == 0) {
            return false;
        }
        BoundingVolume boundingVolume = group.getBounds();
        if (!boundingVolume.checkIntersectionPoint(fArray)) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof Group) {
                return this.pickSinglePoint((Group)node, n, fArray, sceneGraphPath, bl);
            }
            if (node instanceof SharedNode) {
                return this.pickSinglePoint((SharedNode)node, n, fArray, sceneGraphPath, bl);
            }
            if (node instanceof Shape3D) {
                return this.pickSinglePoint((Shape3D)node, n, fArray, sceneGraphPath, bl);
            }
            if (node != null) {
                System.out.println("pickSinglePoint node handling oddball proxy geom");
            }
        }
        boolean bl2 = false;
        int n2 = group.numRenderableChildren();
        if (n2 != 0) {
            Node[] nodeArray;
            this.resizePath();
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            if (group instanceof TransformGroup) {
                nodeArray = this.transformPath[this.lastPathIndex];
                ((TransformGroup)group).getTransform((Matrix4f)nodeArray);
                this.matrixUtils.inverse((Matrix4f)nodeArray, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = group;
            ++this.lastPathIndex;
            nodeArray = group.getRenderableChild();
            for (int i = 0; i < n2 && !bl2; ++i) {
                Node node = nodeArray[i];
                if (node == null) continue;
                if (node instanceof Group) {
                    bl2 = this.pickSinglePoint((Group)node, n, fArray, sceneGraphPath, bl);
                    continue;
                }
                if (node instanceof SharedNode) {
                    bl2 = this.pickSinglePoint((SharedNode)node, n, fArray, sceneGraphPath, bl);
                    continue;
                }
                if (!(node instanceof Shape3D)) continue;
                bl2 = this.pickSinglePoint((Shape3D)node, n, fArray, sceneGraphPath, bl);
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
        }
        return bl2;
    }

    private boolean pickSinglePoint(Shape3D shape3D, int n, float[] fArray, SceneGraphPath sceneGraphPath, boolean bl) {
        if ((shape3D.getPickMask() & n) == 0) {
            return false;
        }
        boolean bl2 = false;
        BoundingVolume boundingVolume = shape3D.getBounds();
        if (boundingVolume.checkIntersectionPoint(fArray)) {
            this.resizePath();
            this.pickPath[this.lastPathIndex] = shape3D;
            this.validTransform[this.lastPathIndex] = false;
            ++this.lastPathIndex;
            if (bl) {
                this.buildVWorldTransform();
            } else {
                this.vworldMatrix.setIdentity();
            }
            sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
            bl2 = true;
            --this.lastPathIndex;
        }
        return bl2;
    }

    private void pickAllPoint(PickableObject pickableObject, PickRequest pickRequest) {
        int n = 0;
        ArrayList arrayList = null;
        if (pickRequest.foundPaths instanceof ArrayList) {
            arrayList = (ArrayList)pickRequest.foundPaths;
        } else {
            pickRequest.foundPaths = arrayList = new ArrayList();
        }
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        if (pickableObject instanceof Node) {
            Object object;
            Node node = (Node)((Object)pickableObject);
            BoundingVolume boundingVolume = node.getBounds();
            if (!boundingVolume.checkIntersectionPoint(pickRequest.origin)) {
                pickRequest.pickCount = 0;
                return;
            }
            if (boundingVolume instanceof BoundingGeometry) {
                object = (BoundingGeometry)boundingVolume;
                node = ((BoundingGeometry)object).getProxyGeometry();
            }
            if (node instanceof Group) {
                object = (Group)node;
                int n2 = ((Group)object).numRenderableChildren();
                if (n2 != 0) {
                    if (node instanceof TransformGroup) {
                        ((TransformGroup)node).getTransform(this.transformPath[0]);
                        this.matrixUtils.inverse(this.transformPath[0], this.invertedMatrix);
                        this.transform(this.invertedMatrix, this.start);
                    } else {
                        this.transformPath[0].setIdentity();
                    }
                    this.validTransform[0] = true;
                    this.pickPath[0] = object;
                    Node[] nodeArray = ((Group)object).getRenderableChild();
                    for (int i = 0; i < n2; ++i) {
                        this.lastPathIndex = 1;
                        if (nodeArray[i] instanceof Group) {
                            n += this.pickAllPoint((Group)nodeArray[i], pickRequest.pickType, this.start, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue;
                        }
                        if (nodeArray[i] instanceof SharedNode) {
                            n += this.pickAllPoint((SharedNode)nodeArray[i], pickRequest.pickType, this.start, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue;
                        }
                        if (!(nodeArray[i] instanceof Shape3D)) continue;
                        n += this.pickAllPoint((Shape3D)nodeArray[i], pickRequest.pickType, this.start, arrayList, n, pickRequest.generateVWorldMatrix);
                    }
                    pickRequest.pickCount = n;
                }
            } else if (node instanceof SharedNode) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (SharedNode)node;
                this.lastPathIndex = 1;
                pickRequest.pickCount = n += this.pickAllPoint((SharedNode)node, pickRequest.pickType, this.start, arrayList, 0, pickRequest.generateVWorldMatrix);
            } else if (node instanceof Shape3D) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (Shape3D)node;
                this.lastPathIndex = 1;
                pickRequest.pickCount = n += this.pickAllPoint((Shape3D)node, pickRequest.pickType, this.start, arrayList, 0, pickRequest.generateVWorldMatrix);
            } else {
                System.out.println("pickAllPoint not handling non-shape/group root proxy");
            }
        } else {
            System.out.println("pickAllPoint not handling non-node root");
        }
    }

    private int pickAllPoint(Group group, int n, float[] fArray, ArrayList arrayList, int n2, boolean bl) {
        if ((group.getPickMask() & n) == 0) {
            return 0;
        }
        BoundingVolume boundingVolume = group.getBounds();
        if (!boundingVolume.checkIntersectionPoint(fArray)) {
            return 0;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof Group) {
                return this.pickAllPoint((Group)node, n, fArray, arrayList, n2, bl);
            }
            if (node instanceof SharedNode) {
                return this.pickAllPoint((SharedNode)node, n, fArray, arrayList, n2, bl);
            }
            if (node instanceof Shape3D) {
                return this.pickAllPoint((Shape3D)node, n, fArray, arrayList, n2, bl);
            }
            if (node != null) {
                System.out.println("pickAllPoint node handling oddball proxy geom");
            }
        }
        int n3 = 0;
        int n4 = group.numRenderableChildren();
        if (n4 != 0) {
            Node[] nodeArray;
            this.resizePath();
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            if (group instanceof TransformGroup) {
                nodeArray = this.transformPath[this.lastPathIndex];
                ((TransformGroup)group).getTransform((Matrix4f)nodeArray);
                this.matrixUtils.inverse((Matrix4f)nodeArray, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = group;
            ++this.lastPathIndex;
            nodeArray = group.getRenderableChild();
            for (int i = 0; i < n4; ++i) {
                Node node = nodeArray[i];
                if (node == null) continue;
                if (node instanceof Group) {
                    n3 += this.pickAllPoint((Group)node, n, fArray, arrayList, n2 + n3, bl);
                    continue;
                }
                if (node instanceof SharedNode) {
                    n3 += this.pickAllPoint((SharedNode)node, n, fArray, arrayList, n2 + n3, bl);
                    continue;
                }
                if (!(node instanceof Shape3D)) continue;
                n3 += this.pickAllPoint((Shape3D)node, n, fArray, arrayList, n2 + n3, bl);
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
        }
        return n3;
    }

    private int pickAllPoint(SharedNode sharedNode, int n, float[] fArray, ArrayList arrayList, int n2, boolean bl) {
        if ((sharedNode.getPickMask() & n) == 0) {
            return 0;
        }
        Node node = sharedNode.getChild();
        if (node instanceof Group) {
            return this.pickAllPoint((Group)node, n, fArray, arrayList, n2, bl);
        }
        if (node instanceof SharedNode) {
            return this.pickAllPoint((SharedNode)node, n, fArray, arrayList, n2, bl);
        }
        if (node instanceof Shape3D) {
            return this.pickAllPoint((Shape3D)node, n, fArray, arrayList, n2, bl);
        }
        return 0;
    }

    private int pickAllPoint(Shape3D shape3D, int n, float[] fArray, ArrayList arrayList, int n2, boolean bl) {
        if ((shape3D.getPickMask() & n) == 0) {
            return 0;
        }
        int n3 = 0;
        BoundingVolume boundingVolume = shape3D.getBounds();
        if (boundingVolume.checkIntersectionPoint(fArray)) {
            SceneGraphPath sceneGraphPath;
            this.resizePath();
            this.pickPath[this.lastPathIndex] = shape3D;
            this.validTransform[this.lastPathIndex] = false;
            ++this.lastPathIndex;
            if (n2 >= arrayList.size()) {
                sceneGraphPath = new SceneGraphPath();
                arrayList.add(sceneGraphPath);
            } else {
                sceneGraphPath = (SceneGraphPath)arrayList.get(n2);
            }
            if (bl) {
                this.buildVWorldTransform();
            } else {
                this.vworldMatrix.setIdentity();
            }
            sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
            n3 = 1;
            --this.lastPathIndex;
        }
        return n3;
    }

    private void pickLineSegment(PickableObject pickableObject, PickRequest pickRequest) {
        switch (pickRequest.pickSortType) {
            case 1: {
                this.pickAllLineSegment(pickableObject, pickRequest);
                break;
            }
            case 3: {
                this.pickAllLineSegmentSorted(pickableObject, pickRequest);
                break;
            }
            case 2: {
                this.pickSingleLineSegment(pickableObject, pickRequest);
                break;
            }
            case 4: {
                this.pickSingleLineSegmentSorted(pickableObject, pickRequest);
                break;
            }
            default: {
                System.out.println("No sort type has been specified");
            }
        }
    }

    private void pickSingleLineSegment(PickableObject pickableObject, PickRequest pickRequest) {
        SceneGraphPath sceneGraphPath = null;
        if (pickRequest.foundPaths instanceof SceneGraphPath) {
            sceneGraphPath = (SceneGraphPath)pickRequest.foundPaths;
        } else {
            sceneGraphPath = new SceneGraphPath();
            pickRequest.foundPaths = sceneGraphPath;
        }
        boolean bl = false;
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        this.end[0] = pickRequest.destination[0];
        this.end[1] = pickRequest.destination[1];
        this.end[2] = pickRequest.destination[2];
        if (pickableObject instanceof Node) {
            Object object;
            Node node = (Node)((Object)pickableObject);
            BoundingVolume boundingVolume = node.getBounds();
            if (!boundingVolume.checkIntersectionSegment(pickRequest.origin, pickRequest.destination)) {
                pickRequest.pickCount = 0;
                return;
            }
            if (boundingVolume instanceof BoundingGeometry) {
                object = (BoundingGeometry)boundingVolume;
                node = ((BoundingGeometry)object).getProxyGeometry();
            }
            if (node instanceof Group) {
                object = (Group)node;
                int n = ((Group)object).numRenderableChildren();
                if (n != 0) {
                    if (node instanceof TransformGroup) {
                        ((TransformGroup)node).getTransform(this.transformPath[0]);
                        this.matrixUtils.inverse(this.transformPath[0], this.invertedMatrix);
                        this.transform(this.invertedMatrix, this.start);
                        this.transform(this.invertedMatrix, this.end);
                    } else {
                        this.transformPath[0].setIdentity();
                    }
                    this.validTransform[0] = true;
                    this.pickPath[0] = object;
                    Node[] nodeArray = ((Group)object).getRenderableChild();
                    for (int i = 0; i < n && !bl; ++i) {
                        this.lastPathIndex = 1;
                        if (nodeArray[i] instanceof Group) {
                            bl = this.pickSingleLineSegment((Group)nodeArray[i], pickRequest.pickType, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                            continue;
                        }
                        if (nodeArray[i] instanceof SharedNode) {
                            bl = this.pickSingleLineSegment((SharedNode)nodeArray[i], pickRequest.pickType, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                            continue;
                        }
                        if (!(nodeArray[i] instanceof Shape3D)) continue;
                        bl = this.pickSingleLineSegment((Shape3D)nodeArray[i], pickRequest.pickType, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry, false);
                    }
                }
            } else if (node instanceof SharedNode) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (SharedNode)node;
                this.lastPathIndex = 1;
                bl = this.pickSingleLineSegment((SharedNode)node, pickRequest.pickType, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
            } else if (node instanceof Shape3D) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (Shape3D)node;
                this.lastPathIndex = 1;
                bl = this.pickSingleLineSegment((Shape3D)node, pickRequest.pickType, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry, false);
            } else {
                System.out.println("pickSingleLineSegment not handling non-shape/group root proxy");
            }
            pickRequest.pickCount = bl ? 1 : 0;
        } else {
            System.out.println("pickSingleLineSegment not handling non-node root");
        }
    }

    private boolean pickSingleLineSegment(SharedNode sharedNode, int n, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl, boolean bl2) {
        if ((sharedNode.getPickMask() & n) == 0) {
            return false;
        }
        Node node = sharedNode.getChild();
        if (node instanceof Group) {
            return this.pickSingleLineSegment((Group)node, n, fArray, fArray2, sceneGraphPath, bl, bl2);
        }
        if (node instanceof SharedNode) {
            return this.pickSingleLineSegment((SharedNode)node, n, fArray, fArray2, sceneGraphPath, bl, bl2);
        }
        if (node instanceof Shape3D) {
            return this.pickSingleLineSegment((Shape3D)node, n, fArray, fArray2, sceneGraphPath, bl, bl2, false);
        }
        return false;
    }

    private boolean pickSingleLineSegment(Group group, int n, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl, boolean bl2) {
        if ((group.getPickMask() & n) == 0) {
            return false;
        }
        BoundingVolume boundingVolume = group.getBounds();
        if (!boundingVolume.checkIntersectionSegment(fArray, fArray2)) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof Group) {
                return this.pickSingleLineSegment((Group)node, n, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node instanceof SharedNode) {
                return this.pickSingleLineSegment((SharedNode)node, n, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node instanceof Shape3D) {
                return this.pickSingleLineSegment((Shape3D)node, n, fArray, fArray2, sceneGraphPath, bl, bl2, false);
            }
            if (node != null) {
                System.out.println("pickSingleLineSegment node handling oddball proxy geom");
            }
        }
        boolean bl3 = false;
        int n2 = group.numRenderableChildren();
        if (n2 != 0) {
            Node[] nodeArray;
            this.resizePath();
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray2[0];
            float f5 = fArray2[1];
            float f6 = fArray2[2];
            if (group instanceof TransformGroup) {
                nodeArray = this.transformPath[this.lastPathIndex];
                ((TransformGroup)group).getTransform((Matrix4f)nodeArray);
                this.matrixUtils.inverse((Matrix4f)nodeArray, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transform(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = group;
            ++this.lastPathIndex;
            nodeArray = group.getRenderableChild();
            for (int i = 0; i < n2 && !bl3; ++i) {
                Node node = nodeArray[i];
                if (node == null) continue;
                if (node instanceof Group) {
                    bl3 = this.pickSingleLineSegment((Group)node, n, fArray, fArray2, sceneGraphPath, bl, bl2);
                    continue;
                }
                if (node instanceof SharedNode) {
                    bl3 = this.pickSingleLineSegment((SharedNode)node, n, fArray, fArray2, sceneGraphPath, bl, bl2);
                    continue;
                }
                if (!(node instanceof Shape3D)) continue;
                bl3 = this.pickSingleLineSegment((Shape3D)node, n, fArray, fArray2, sceneGraphPath, bl, bl2, false);
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            fArray2[0] = f4;
            fArray2[1] = f5;
            fArray2[2] = f6;
        }
        return bl3;
    }

    private boolean pickSingleLineSegment(Shape3D shape3D, int n, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl, boolean bl2, boolean bl3) {
        if ((shape3D.getPickMask() & n) == 0) {
            return false;
        }
        boolean bl4 = false;
        BoundingVolume boundingVolume = shape3D.getBounds();
        if (boundingVolume.checkIntersectionSegment(fArray, fArray2)) {
            if (bl2) {
                Geometry geometry = shape3D.getGeometry();
                if (geometry.pickLineSegment(fArray, fArray2, bl3, this.vertexPickData, 0)) {
                    this.resizePath();
                    this.pickPath[this.lastPathIndex] = shape3D;
                    this.validTransform[this.lastPathIndex] = false;
                    ++this.lastPathIndex;
                    if (bl) {
                        this.buildVWorldTransform();
                    } else {
                        this.vworldMatrix.setIdentity();
                    }
                    sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
                    bl4 = true;
                    --this.lastPathIndex;
                }
            } else {
                this.resizePath();
                this.pickPath[this.lastPathIndex] = shape3D;
                this.validTransform[this.lastPathIndex] = false;
                ++this.lastPathIndex;
                if (bl) {
                    this.buildVWorldTransform();
                } else {
                    this.vworldMatrix.setIdentity();
                }
                sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
                bl4 = true;
                --this.lastPathIndex;
            }
        }
        return bl4;
    }

    private void pickAllLineSegment(PickableObject pickableObject, PickRequest pickRequest) {
        int n = 0;
        ArrayList arrayList = null;
        if (pickRequest.foundPaths instanceof ArrayList) {
            arrayList = (ArrayList)pickRequest.foundPaths;
        } else {
            pickRequest.foundPaths = arrayList = new ArrayList();
        }
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        this.end[0] = pickRequest.destination[0];
        this.end[1] = pickRequest.destination[1];
        this.end[2] = pickRequest.destination[2];
        if (pickableObject instanceof Node) {
            Object object;
            Node node = (Node)((Object)pickableObject);
            BoundingVolume boundingVolume = node.getBounds();
            if (!boundingVolume.checkIntersectionSegment(pickRequest.origin, pickRequest.destination)) {
                pickRequest.pickCount = 0;
                return;
            }
            if (boundingVolume instanceof BoundingGeometry) {
                object = (BoundingGeometry)boundingVolume;
                node = ((BoundingGeometry)object).getProxyGeometry();
            }
            if (node instanceof Group) {
                object = (Group)node;
                int n2 = ((Group)object).numRenderableChildren();
                if (n2 != 0) {
                    if (node instanceof TransformGroup) {
                        ((TransformGroup)node).getTransform(this.transformPath[0]);
                        this.matrixUtils.inverse(this.transformPath[0], this.invertedMatrix);
                        this.transform(this.invertedMatrix, this.start);
                        this.transform(this.invertedMatrix, this.end);
                    } else {
                        this.transformPath[0].setIdentity();
                    }
                    this.validTransform[0] = true;
                    this.pickPath[0] = object;
                    Node[] nodeArray = ((Group)object).getRenderableChild();
                    for (int i = 0; i < n2; ++i) {
                        this.lastPathIndex = 1;
                        if (nodeArray[i] instanceof Group) {
                            n += this.pickAllLineSegment((Group)nodeArray[i], pickRequest.pickType, this.start, this.end, arrayList, n, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                            continue;
                        }
                        if (nodeArray[i] instanceof SharedNode) {
                            n += this.pickAllLineSegment((SharedNode)nodeArray[i], pickRequest.pickType, this.start, this.end, arrayList, n, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                            continue;
                        }
                        if (!(nodeArray[i] instanceof Shape3D)) continue;
                        n += this.pickAllLineSegment((Shape3D)nodeArray[i], pickRequest.pickType, this.start, this.end, arrayList, n, pickRequest.generateVWorldMatrix, pickRequest.useGeometry, false);
                    }
                }
            } else if (node instanceof SharedNode) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (SharedNode)node;
                this.lastPathIndex = 1;
                n += this.pickAllLineSegment((SharedNode)node, pickRequest.pickType, this.start, this.end, arrayList, 0, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
            } else if (node instanceof Shape3D) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (Shape3D)node;
                this.lastPathIndex = 1;
                n += this.pickAllLineSegment((Shape3D)node, pickRequest.pickType, this.start, this.end, arrayList, 0, pickRequest.generateVWorldMatrix, pickRequest.useGeometry, false);
            }
        } else {
            System.out.println("pickAllLineSegment not handling non-node root");
        }
        pickRequest.pickCount = n;
    }

    private int pickAllLineSegment(SharedNode sharedNode, int n, float[] fArray, float[] fArray2, ArrayList arrayList, int n2, boolean bl, boolean bl2) {
        if ((sharedNode.getPickMask() & n) == 0) {
            return 0;
        }
        Node node = sharedNode.getChild();
        if (node instanceof Group) {
            return this.pickAllLineSegment((Group)node, n, fArray, fArray2, arrayList, n2, bl, bl2);
        }
        if (node instanceof SharedNode) {
            return this.pickAllLineSegment((SharedNode)node, n, fArray, fArray2, arrayList, n2, bl, bl2);
        }
        if (node instanceof Shape3D) {
            return this.pickAllLineSegment((Shape3D)node, n, fArray, fArray2, arrayList, n2, bl, bl2, false);
        }
        return 0;
    }

    private int pickAllLineSegment(Group group, int n, float[] fArray, float[] fArray2, ArrayList arrayList, int n2, boolean bl, boolean bl2) {
        if ((group.getPickMask() & n) == 0) {
            return 0;
        }
        BoundingVolume boundingVolume = group.getBounds();
        if (!boundingVolume.checkIntersectionSegment(fArray, fArray2)) {
            return 0;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof Group) {
                return this.pickAllLineSegment((Group)node, n, fArray, fArray2, arrayList, n2, bl, bl2);
            }
            if (node instanceof SharedNode) {
                return this.pickAllLineSegment((SharedNode)node, n, fArray, fArray2, arrayList, n2, bl, bl2);
            }
            if (node instanceof Shape3D) {
                return this.pickAllLineSegment((Shape3D)node, n, fArray, fArray2, arrayList, n2, bl, bl2, false);
            }
            if (node != null) {
                System.out.println("pickAllLineSegment node handling oddball proxy geom");
            }
        }
        int n3 = 0;
        int n4 = group.numRenderableChildren();
        if (n4 != 0) {
            Node[] nodeArray;
            this.resizePath();
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray2[0];
            float f5 = fArray2[1];
            float f6 = fArray2[2];
            if (group instanceof TransformGroup) {
                nodeArray = this.transformPath[this.lastPathIndex];
                ((TransformGroup)group).getTransform((Matrix4f)nodeArray);
                this.matrixUtils.inverse((Matrix4f)nodeArray, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transform(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = group;
            ++this.lastPathIndex;
            nodeArray = group.getRenderableChild();
            for (int i = 0; i < n4; ++i) {
                Node node = nodeArray[i];
                if (node == null) continue;
                if (node instanceof Group) {
                    n3 += this.pickAllLineSegment((Group)node, n, fArray, fArray2, arrayList, n2 + n3, bl, bl2);
                    continue;
                }
                if (node instanceof SharedNode) {
                    n3 += this.pickAllLineSegment((SharedNode)node, n, fArray, fArray2, arrayList, n2 + n3, bl, bl2);
                    continue;
                }
                if (!(node instanceof Shape3D)) continue;
                n3 += this.pickAllLineSegment((Shape3D)node, n, fArray, fArray2, arrayList, n2 + n3, bl, bl2, false);
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            fArray2[0] = f4;
            fArray2[1] = f5;
            fArray2[2] = f6;
        }
        return n3;
    }

    private int pickAllLineSegment(Shape3D shape3D, int n, float[] fArray, float[] fArray2, ArrayList arrayList, int n2, boolean bl, boolean bl2, boolean bl3) {
        if ((shape3D.getPickMask() & n) == 0) {
            return 0;
        }
        int n3 = 0;
        BoundingVolume boundingVolume = shape3D.getBounds();
        if (boundingVolume.checkIntersectionSegment(fArray, fArray2)) {
            if (bl2) {
                Geometry geometry = shape3D.getGeometry();
                if (geometry.pickLineSegment(fArray, fArray2, bl3, this.vertexPickData, 0)) {
                    SceneGraphPath sceneGraphPath;
                    this.resizePath();
                    this.pickPath[this.lastPathIndex] = shape3D;
                    this.validTransform[this.lastPathIndex] = false;
                    ++this.lastPathIndex;
                    if (n2 >= arrayList.size()) {
                        sceneGraphPath = new SceneGraphPath();
                        arrayList.add(sceneGraphPath);
                    } else {
                        sceneGraphPath = (SceneGraphPath)arrayList.get(n2);
                    }
                    if (bl) {
                        this.buildVWorldTransform();
                    } else {
                        this.vworldMatrix.setIdentity();
                    }
                    sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
                    n3 = 1;
                    --this.lastPathIndex;
                }
            } else {
                SceneGraphPath sceneGraphPath;
                this.resizePath();
                this.pickPath[this.lastPathIndex] = shape3D;
                this.validTransform[this.lastPathIndex] = false;
                ++this.lastPathIndex;
                if (n2 >= arrayList.size()) {
                    sceneGraphPath = new SceneGraphPath();
                    arrayList.add(sceneGraphPath);
                } else {
                    sceneGraphPath = (SceneGraphPath)arrayList.get(n2);
                }
                if (bl) {
                    this.buildVWorldTransform();
                } else {
                    this.vworldMatrix.setIdentity();
                }
                sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
                n3 = 1;
                --this.lastPathIndex;
            }
        }
        return n3;
    }

    private void pickSingleLineSegmentSorted(PickableObject pickableObject, PickRequest pickRequest) {
        SceneGraphPath sceneGraphPath = null;
        if (pickRequest.foundPaths instanceof SceneGraphPath) {
            sceneGraphPath = (SceneGraphPath)pickRequest.foundPaths;
        } else {
            sceneGraphPath = new SceneGraphPath();
            pickRequest.foundPaths = sceneGraphPath;
        }
        boolean bl = false;
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        this.end[0] = pickRequest.destination[0];
        this.end[1] = pickRequest.destination[1];
        this.end[2] = pickRequest.destination[2];
        if (pickableObject instanceof Node) {
            Object object;
            Node node = (Node)((Object)pickableObject);
            BoundingVolume boundingVolume = node.getBounds();
            if (!boundingVolume.checkIntersectionSegment(pickRequest.origin, pickRequest.destination)) {
                pickRequest.pickCount = 0;
                return;
            }
            if (boundingVolume instanceof BoundingGeometry) {
                object = (BoundingGeometry)boundingVolume;
                node = ((BoundingGeometry)object).getProxyGeometry();
            }
            if (node instanceof Group) {
                object = (Group)node;
                int n = ((Group)object).numRenderableChildren();
                if (n != 0) {
                    if (node instanceof TransformGroup) {
                        ((TransformGroup)node).getTransform(this.transformPath[0]);
                        this.matrixUtils.inverse(this.transformPath[0], this.invertedMatrix);
                        this.transform(this.invertedMatrix, this.start);
                        this.transform(this.invertedMatrix, this.end);
                    } else {
                        this.transformPath[0].setIdentity();
                    }
                    this.validTransform[0] = true;
                    this.pickPath[0] = object;
                    Node[] nodeArray = ((Group)object).getRenderableChild();
                    for (int i = 0; i < n && !bl; ++i) {
                        this.lastPathIndex = 1;
                        if (nodeArray[i] instanceof Group) {
                            bl = this.pickSingleLineSegmentSorted((Group)nodeArray[i], pickRequest.pickType, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                            continue;
                        }
                        if (nodeArray[i] instanceof SharedNode) {
                            bl = this.pickSingleLineSegmentSorted((SharedNode)nodeArray[i], pickRequest.pickType, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                            continue;
                        }
                        if (!(nodeArray[i] instanceof Shape3D)) continue;
                        bl = this.pickSingleLineSegment((Shape3D)nodeArray[i], pickRequest.pickType, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry, true);
                    }
                }
            } else if (node instanceof SharedNode) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (SharedNode)node;
                this.lastPathIndex = 1;
                bl = this.pickSingleLineSegmentSorted((SharedNode)node, pickRequest.pickType, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
            } else if (node instanceof Shape3D) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (Shape3D)node;
                this.lastPathIndex = 1;
                bl = this.pickSingleLineSegment((Shape3D)node, pickRequest.pickType, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry, false);
            }
            pickRequest.pickCount = bl ? 1 : 0;
        } else {
            System.out.println("pickSingleLineSegment not handling non-node root");
        }
    }

    private boolean pickSingleLineSegmentSorted(SharedNode sharedNode, int n, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl, boolean bl2) {
        if ((sharedNode.getPickMask() & n) == 0) {
            return false;
        }
        Node node = sharedNode.getChild();
        if (node instanceof Group) {
            return this.pickSingleLineSegmentSorted((Group)node, n, fArray, fArray2, sceneGraphPath, bl, bl2);
        }
        if (node instanceof SharedNode) {
            return this.pickSingleLineSegmentSorted((SharedNode)node, n, fArray, fArray2, sceneGraphPath, bl, bl2);
        }
        if (node instanceof Shape3D) {
            return this.pickSingleLineSegment((Shape3D)node, n, fArray, fArray2, sceneGraphPath, bl, bl2, true);
        }
        return false;
    }

    private boolean pickSingleLineSegmentSorted(Group group, int n, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl, boolean bl2) {
        if ((group.getPickMask() & n) == 0) {
            return false;
        }
        BoundingVolume boundingVolume = group.getBounds();
        if (!boundingVolume.checkIntersectionSegment(fArray, fArray2)) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof Group) {
                return this.pickSingleLineSegmentSorted((Group)node, n, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node instanceof SharedNode) {
                return this.pickSingleLineSegmentSorted((SharedNode)node, n, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node instanceof Shape3D) {
                return this.pickSingleLineSegment((Shape3D)node, n, fArray, fArray2, sceneGraphPath, bl, bl2, true);
            }
            if (node != null) {
                System.out.println("pickSingleLineSegmentSorted node handling oddball proxy geom");
            }
        }
        boolean bl3 = false;
        int n2 = group.numRenderableChildren();
        if (n2 != 0) {
            Node[] nodeArray;
            this.resizePath();
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray2[0];
            float f5 = fArray2[1];
            float f6 = fArray2[2];
            if (group instanceof TransformGroup) {
                nodeArray = this.transformPath[this.lastPathIndex];
                ((TransformGroup)group).getTransform((Matrix4f)nodeArray);
                this.matrixUtils.inverse((Matrix4f)nodeArray, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transform(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = group;
            ++this.lastPathIndex;
            nodeArray = group.getRenderableChild();
            for (int i = 0; i < n2 && !bl3; ++i) {
                Node node = nodeArray[i];
                if (node == null) continue;
                if (node instanceof Group) {
                    bl3 = this.pickSingleLineSegmentSorted((Group)node, n, fArray, fArray2, sceneGraphPath, bl, bl2);
                    continue;
                }
                if (node instanceof SharedNode) {
                    bl3 = this.pickSingleLineSegmentSorted((SharedNode)node, n, fArray, fArray2, sceneGraphPath, bl, bl2);
                    continue;
                }
                if (!(node instanceof Shape3D)) continue;
                bl3 = this.pickSingleLineSegment((Shape3D)node, n, fArray, fArray2, sceneGraphPath, bl, bl2, true);
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            fArray2[0] = f4;
            fArray2[1] = f5;
            fArray2[2] = f6;
        }
        return bl3;
    }

    private void pickAllLineSegmentSorted(PickableObject pickableObject, PickRequest pickRequest) {
    }

    private void pickRay(PickableObject pickableObject, PickRequest pickRequest) {
        switch (pickRequest.pickSortType) {
            case 1: 
            case 3: {
                this.pickAllRay(pickableObject, pickRequest);
                break;
            }
            case 2: 
            case 4: {
                this.pickSingleRay(pickableObject, pickRequest);
                break;
            }
            default: {
                System.out.println("No sort type has been specified");
            }
        }
    }

    private void pickSingleRay(PickableObject pickableObject, PickRequest pickRequest) {
        SceneGraphPath sceneGraphPath = null;
        if (pickRequest.foundPaths instanceof SceneGraphPath) {
            sceneGraphPath = (SceneGraphPath)pickRequest.foundPaths;
        } else {
            sceneGraphPath = new SceneGraphPath();
            pickRequest.foundPaths = sceneGraphPath;
        }
        boolean bl = false;
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        this.end[0] = pickRequest.destination[0];
        this.end[1] = pickRequest.destination[1];
        this.end[2] = pickRequest.destination[2];
        if (pickableObject instanceof Node) {
            Object object;
            Node node = (Node)((Object)pickableObject);
            BoundingVolume boundingVolume = node.getBounds();
            if (!boundingVolume.checkIntersectionRay(pickRequest.origin, pickRequest.destination)) {
                pickRequest.pickCount = 0;
                return;
            }
            if (boundingVolume instanceof BoundingGeometry) {
                object = (BoundingGeometry)boundingVolume;
                node = ((BoundingGeometry)object).getProxyGeometry();
            }
            if (node instanceof Group) {
                object = (Group)node;
                int n = ((Group)object).numRenderableChildren();
                if (n != 0) {
                    if (node instanceof TransformGroup) {
                        ((TransformGroup)node).getTransform(this.transformPath[0]);
                        this.matrixUtils.inverse(this.transformPath[0], this.invertedMatrix);
                        this.transform(this.invertedMatrix, this.start);
                        this.transformNormal(this.invertedMatrix, this.end);
                    } else {
                        this.transformPath[0].setIdentity();
                    }
                    this.validTransform[0] = true;
                    this.pickPath[0] = object;
                    Node[] nodeArray = ((Group)object).getRenderableChild();
                    for (int i = 0; i < n && !bl; ++i) {
                        this.lastPathIndex = 1;
                        if (nodeArray[i] instanceof Group) {
                            bl = this.pickSingleRay((Group)nodeArray[i], pickRequest.pickType, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                            continue;
                        }
                        if (nodeArray[i] instanceof SharedNode) {
                            bl = this.pickSingleRay((SharedNode)nodeArray[i], pickRequest.pickType, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                            continue;
                        }
                        if (!(nodeArray[i] instanceof Shape3D)) continue;
                        bl = this.pickSingleRay((Shape3D)nodeArray[i], pickRequest.pickType, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry, false);
                    }
                }
            } else if (node instanceof SharedNode) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (SharedNode)node;
                this.lastPathIndex = 1;
                bl = this.pickSingleRay((SharedNode)node, pickRequest.pickType, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
            } else if (node instanceof Shape3D) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (Shape3D)node;
                this.lastPathIndex = 1;
                bl = this.pickSingleRay((Shape3D)node, pickRequest.pickType, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry, false);
            }
            pickRequest.pickCount = bl ? 1 : 0;
        } else {
            System.out.println("pickSingleRay not handling non-node root");
        }
    }

    private boolean pickSingleRay(SharedNode sharedNode, int n, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl, boolean bl2) {
        if ((sharedNode.getPickMask() & n) == 0) {
            return false;
        }
        Node node = sharedNode.getChild();
        if (node instanceof Group) {
            return this.pickSingleRay((Group)node, n, fArray, fArray2, sceneGraphPath, bl, bl2);
        }
        if (node instanceof SharedNode) {
            return this.pickSingleRay((SharedNode)node, n, fArray, fArray2, sceneGraphPath, bl, bl2);
        }
        if (node instanceof Shape3D) {
            return this.pickSingleRay((Shape3D)node, n, fArray, fArray2, sceneGraphPath, bl, bl2, true);
        }
        return false;
    }

    private boolean pickSingleRay(Group group, int n, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl, boolean bl2) {
        if ((group.getPickMask() & n) == 0) {
            return false;
        }
        BoundingVolume boundingVolume = group.getBounds();
        if (!boundingVolume.checkIntersectionRay(fArray, fArray2)) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof Group) {
                return this.pickSingleRay((Group)node, n, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node instanceof SharedNode) {
                return this.pickSingleRay((SharedNode)node, n, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node instanceof Shape3D) {
                return this.pickSingleRay((Shape3D)node, n, fArray, fArray2, sceneGraphPath, bl, bl2, false);
            }
            if (node != null) {
                System.out.println("pickSingleRay node handling oddball proxy geom");
            }
        }
        boolean bl3 = false;
        int n2 = group.numRenderableChildren();
        if (n2 != 0) {
            Node[] nodeArray;
            this.resizePath();
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray2[0];
            float f5 = fArray2[1];
            float f6 = fArray2[2];
            if (group instanceof TransformGroup) {
                nodeArray = this.transformPath[this.lastPathIndex];
                ((TransformGroup)group).getTransform((Matrix4f)nodeArray);
                this.matrixUtils.inverse((Matrix4f)nodeArray, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transformNormal(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = group;
            ++this.lastPathIndex;
            nodeArray = group.getRenderableChild();
            for (int i = 0; i < n2 && !bl3; ++i) {
                Node node = nodeArray[i];
                if (node == null) continue;
                if (node instanceof Group) {
                    bl3 = this.pickSingleRay((Group)node, n, fArray, fArray2, sceneGraphPath, bl, bl2);
                    continue;
                }
                if (node instanceof SharedNode) {
                    bl3 = this.pickSingleRay((SharedNode)node, n, fArray, fArray2, sceneGraphPath, bl, bl2);
                    continue;
                }
                if (!(node instanceof Shape3D)) continue;
                bl3 = this.pickSingleRay((Shape3D)node, n, fArray, fArray2, sceneGraphPath, bl, bl2, false);
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            fArray2[0] = f4;
            fArray2[1] = f5;
            fArray2[2] = f6;
        }
        return bl3;
    }

    private boolean pickSingleRay(Shape3D shape3D, int n, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl, boolean bl2, boolean bl3) {
        if ((shape3D.getPickMask() & n) == 0) {
            return false;
        }
        boolean bl4 = false;
        BoundingVolume boundingVolume = shape3D.getBounds();
        if (boundingVolume.checkIntersectionRay(fArray, fArray2)) {
            if (bl2) {
                Geometry geometry = shape3D.getGeometry();
                if (geometry.pickLineRay(fArray, fArray2, bl3, this.vertexPickData, 0)) {
                    this.resizePath();
                    this.pickPath[this.lastPathIndex] = shape3D;
                    this.validTransform[this.lastPathIndex] = false;
                    ++this.lastPathIndex;
                    if (bl) {
                        this.buildVWorldTransform();
                    } else {
                        this.vworldMatrix.setIdentity();
                    }
                    sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
                    bl4 = true;
                    --this.lastPathIndex;
                }
            } else {
                this.resizePath();
                this.pickPath[this.lastPathIndex] = shape3D;
                this.validTransform[this.lastPathIndex] = false;
                ++this.lastPathIndex;
                if (bl) {
                    this.buildVWorldTransform();
                } else {
                    this.vworldMatrix.setIdentity();
                }
                sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
                bl4 = true;
                --this.lastPathIndex;
            }
        }
        return bl4;
    }

    private void pickAllRay(PickableObject pickableObject, PickRequest pickRequest) {
        int n = 0;
        ArrayList arrayList = null;
        if (pickRequest.foundPaths instanceof ArrayList) {
            arrayList = (ArrayList)pickRequest.foundPaths;
        } else {
            pickRequest.foundPaths = arrayList = new ArrayList();
        }
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        this.end[0] = pickRequest.destination[0];
        this.end[1] = pickRequest.destination[1];
        this.end[2] = pickRequest.destination[2];
        if (pickableObject instanceof Node) {
            Object object;
            Node node = (Node)((Object)pickableObject);
            BoundingVolume boundingVolume = node.getBounds();
            if (!boundingVolume.checkIntersectionRay(pickRequest.origin, pickRequest.destination)) {
                pickRequest.pickCount = 0;
                return;
            }
            if (boundingVolume instanceof BoundingGeometry) {
                object = (BoundingGeometry)boundingVolume;
                node = ((BoundingGeometry)object).getProxyGeometry();
            }
            if (node instanceof Group) {
                object = (Group)node;
                int n2 = ((Group)object).numRenderableChildren();
                if (n2 != 0) {
                    if (node instanceof TransformGroup) {
                        ((TransformGroup)node).getTransform(this.transformPath[0]);
                        this.matrixUtils.inverse(this.transformPath[0], this.invertedMatrix);
                        this.transform(this.invertedMatrix, this.start);
                        this.transformNormal(this.invertedMatrix, this.end);
                    } else {
                        this.transformPath[0].setIdentity();
                    }
                    this.validTransform[0] = true;
                    this.pickPath[0] = object;
                    Node[] nodeArray = ((Group)object).getRenderableChild();
                    for (int i = 0; i < n2; ++i) {
                        this.lastPathIndex = 1;
                        if (nodeArray[i] instanceof Group) {
                            n += this.pickAllRay((Group)nodeArray[i], pickRequest.pickType, this.start, this.end, arrayList, n, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                            continue;
                        }
                        if (nodeArray[i] instanceof SharedNode) {
                            n += this.pickAllRay((SharedNode)nodeArray[i], pickRequest.pickType, this.start, this.end, arrayList, n, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                            continue;
                        }
                        if (!(nodeArray[i] instanceof Shape3D)) continue;
                        n += this.pickAllRay((Shape3D)nodeArray[i], pickRequest.pickType, this.start, this.end, arrayList, n, pickRequest.generateVWorldMatrix, pickRequest.useGeometry, false);
                    }
                }
            } else if (node instanceof SharedNode) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (SharedNode)node;
                this.lastPathIndex = 1;
                n += this.pickAllRay((SharedNode)node, pickRequest.pickType, this.start, this.end, arrayList, 0, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
            } else if (node instanceof Shape3D) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (Shape3D)node;
                this.lastPathIndex = 1;
                n += this.pickAllRay((Shape3D)node, pickRequest.pickType, this.start, this.end, arrayList, 0, pickRequest.generateVWorldMatrix, pickRequest.useGeometry, false);
            }
        } else {
            System.out.println("pickAllRay not handling non-node root");
        }
        pickRequest.pickCount = n;
    }

    private int pickAllRay(SharedNode sharedNode, int n, float[] fArray, float[] fArray2, ArrayList arrayList, int n2, boolean bl, boolean bl2) {
        if ((sharedNode.getPickMask() & n) == 0) {
            return 0;
        }
        Node node = sharedNode.getChild();
        if (node instanceof Group) {
            return this.pickAllRay((Group)node, n, fArray, fArray2, arrayList, n2, bl, bl2);
        }
        if (node instanceof SharedNode) {
            return this.pickAllRay((SharedNode)node, n, fArray, fArray2, arrayList, n2, bl, bl2);
        }
        if (node instanceof Shape3D) {
            return this.pickAllRay((Shape3D)node, n, fArray, fArray2, arrayList, n2, bl, bl2, false);
        }
        return 0;
    }

    private int pickAllRay(Group group, int n, float[] fArray, float[] fArray2, ArrayList arrayList, int n2, boolean bl, boolean bl2) {
        if ((group.getPickMask() & n) == 0) {
            return 0;
        }
        BoundingVolume boundingVolume = group.getBounds();
        if (!boundingVolume.checkIntersectionRay(fArray, fArray2)) {
            return 0;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof Group) {
                return this.pickAllRay((Group)node, n, fArray, fArray2, arrayList, n2, bl, bl2);
            }
            if (node instanceof SharedNode) {
                return this.pickAllRay((SharedNode)node, n, fArray, fArray2, arrayList, n2, bl, bl2);
            }
            if (node instanceof Shape3D) {
                return this.pickAllRay((Shape3D)node, n, fArray, fArray2, arrayList, n2, bl, bl2, false);
            }
            if (node != null) {
                System.out.println("pickAllRay node handling oddball proxy geom");
            }
        }
        int n3 = 0;
        int n4 = group.numRenderableChildren();
        if (n4 != 0) {
            Node[] nodeArray;
            this.resizePath();
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray2[0];
            float f5 = fArray2[1];
            float f6 = fArray2[2];
            if (group instanceof TransformGroup) {
                nodeArray = this.transformPath[this.lastPathIndex];
                ((TransformGroup)group).getTransform((Matrix4f)nodeArray);
                this.matrixUtils.inverse((Matrix4f)nodeArray, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transformNormal(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = group;
            ++this.lastPathIndex;
            nodeArray = group.getRenderableChild();
            for (int i = 0; i < n4; ++i) {
                Node node = nodeArray[i];
                if (node == null) continue;
                if (node instanceof Group) {
                    n3 += this.pickAllRay((Group)node, n, fArray, fArray2, arrayList, n2 + n3, bl, bl2);
                    continue;
                }
                if (node instanceof SharedNode) {
                    n3 += this.pickAllRay((SharedNode)node, n, fArray, fArray2, arrayList, n2 + n3, bl, bl2);
                    continue;
                }
                if (!(node instanceof Shape3D)) continue;
                n3 += this.pickAllRay((Shape3D)node, n, fArray, fArray2, arrayList, n2 + n3, bl, bl2, false);
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            fArray2[0] = f4;
            fArray2[1] = f5;
            fArray2[2] = f6;
        }
        return n3;
    }

    private int pickAllRay(Shape3D shape3D, int n, float[] fArray, float[] fArray2, ArrayList arrayList, int n2, boolean bl, boolean bl2, boolean bl3) {
        if ((shape3D.getPickMask() & n) == 0) {
            return 0;
        }
        int n3 = 0;
        BoundingVolume boundingVolume = shape3D.getBounds();
        if (boundingVolume.checkIntersectionRay(fArray, fArray2)) {
            if (bl2) {
                Geometry geometry = shape3D.getGeometry();
                if (geometry.pickLineRay(fArray, fArray2, bl3, this.vertexPickData, 0)) {
                    SceneGraphPath sceneGraphPath;
                    this.resizePath();
                    this.pickPath[this.lastPathIndex] = shape3D;
                    this.validTransform[this.lastPathIndex] = false;
                    ++this.lastPathIndex;
                    if (n2 >= arrayList.size()) {
                        sceneGraphPath = new SceneGraphPath();
                        arrayList.add(sceneGraphPath);
                    } else {
                        sceneGraphPath = (SceneGraphPath)arrayList.get(n2);
                    }
                    if (bl) {
                        this.buildVWorldTransform();
                    } else {
                        this.vworldMatrix.setIdentity();
                    }
                    sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
                    n3 = 1;
                    --this.lastPathIndex;
                }
            } else {
                SceneGraphPath sceneGraphPath;
                this.resizePath();
                this.pickPath[this.lastPathIndex] = shape3D;
                this.validTransform[this.lastPathIndex] = false;
                ++this.lastPathIndex;
                if (n2 >= arrayList.size()) {
                    sceneGraphPath = new SceneGraphPath();
                    arrayList.add(sceneGraphPath);
                } else {
                    sceneGraphPath = (SceneGraphPath)arrayList.get(n2);
                }
                if (bl) {
                    this.buildVWorldTransform();
                } else {
                    this.vworldMatrix.setIdentity();
                }
                sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
                n3 = 1;
                --this.lastPathIndex;
            }
        }
        return n3;
    }

    private void pickSingleRaySorted(PickableObject pickableObject, PickRequest pickRequest) {
        SceneGraphPath sceneGraphPath = null;
        if (pickRequest.foundPaths instanceof SceneGraphPath) {
            sceneGraphPath = (SceneGraphPath)pickRequest.foundPaths;
        } else {
            sceneGraphPath = new SceneGraphPath();
            pickRequest.foundPaths = sceneGraphPath;
        }
        boolean bl = false;
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        this.end[0] = pickRequest.destination[0];
        this.end[1] = pickRequest.destination[1];
        this.end[2] = pickRequest.destination[2];
        if (pickableObject instanceof Node) {
            Object object;
            Node node = (Node)((Object)pickableObject);
            BoundingVolume boundingVolume = node.getBounds();
            if (!boundingVolume.checkIntersectionRay(pickRequest.origin, pickRequest.destination)) {
                return;
            }
            if (boundingVolume instanceof BoundingGeometry) {
                object = (BoundingGeometry)boundingVolume;
                node = ((BoundingGeometry)object).getProxyGeometry();
            }
            if (node instanceof Group) {
                object = (Group)node;
                int n = ((Group)object).numRenderableChildren();
                if (n != 0) {
                    if (node instanceof TransformGroup) {
                        ((TransformGroup)node).getTransform(this.transformPath[0]);
                        this.matrixUtils.inverse(this.transformPath[0], this.invertedMatrix);
                        this.transform(this.invertedMatrix, this.start);
                        this.transform(this.invertedMatrix, this.end);
                    } else {
                        this.transformPath[0].setIdentity();
                    }
                    this.validTransform[0] = true;
                    this.pickPath[0] = object;
                    Node[] nodeArray = ((Group)object).getRenderableChild();
                    for (int i = 0; i < n && !bl; ++i) {
                        this.lastPathIndex = 1;
                        if (nodeArray[i] instanceof Group) {
                            bl = this.pickSingleRaySorted((Group)nodeArray[i], pickRequest.pickType, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                            continue;
                        }
                        if (nodeArray[i] instanceof SharedNode) {
                            bl = this.pickSingleRaySorted((SharedNode)nodeArray[i], pickRequest.pickType, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                            continue;
                        }
                        if (!(nodeArray[i] instanceof Shape3D)) continue;
                        bl = this.pickSingleRay((Shape3D)nodeArray[i], pickRequest.pickType, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry, true);
                    }
                }
            } else if (node instanceof SharedNode) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (SharedNode)node;
                this.lastPathIndex = 1;
                bl = this.pickSingleRaySorted((SharedNode)node, pickRequest.pickType, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
            } else if (node instanceof Shape3D) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (Shape3D)node;
                this.lastPathIndex = 1;
                bl = this.pickSingleRay((Shape3D)node, pickRequest.pickType, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry, false);
            }
            pickRequest.pickCount = bl ? 1 : 0;
        } else {
            System.out.println("pickSingleRay not handling non-node root");
        }
    }

    private boolean pickSingleRaySorted(SharedNode sharedNode, int n, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl, boolean bl2) {
        if ((sharedNode.getPickMask() & n) == 0) {
            return false;
        }
        Node node = sharedNode.getChild();
        if (node instanceof Group) {
            return this.pickSingleRaySorted((Group)node, n, fArray, fArray2, sceneGraphPath, bl, bl2);
        }
        if (node instanceof SharedNode) {
            return this.pickSingleRaySorted((SharedNode)node, n, fArray, fArray2, sceneGraphPath, bl, bl2);
        }
        if (node instanceof Shape3D) {
            return this.pickSingleRay((Shape3D)node, n, fArray, fArray2, sceneGraphPath, bl, bl2, true);
        }
        return false;
    }

    private boolean pickSingleRaySorted(Group group, int n, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl, boolean bl2) {
        if ((group.getPickMask() & n) == 0) {
            return false;
        }
        BoundingVolume boundingVolume = group.getBounds();
        if (!boundingVolume.checkIntersectionRay(fArray, fArray2)) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof Group) {
                return this.pickSingleRaySorted((Group)node, n, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node instanceof SharedNode) {
                return this.pickSingleRaySorted((SharedNode)node, n, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node instanceof Shape3D) {
                return this.pickSingleRay((Shape3D)node, n, fArray, fArray2, sceneGraphPath, bl, bl2, true);
            }
            if (node != null) {
                System.out.println("pickSingleRaySorted node handling oddball proxy geom");
            }
        }
        boolean bl3 = false;
        int n2 = group.numRenderableChildren();
        if (n2 != 0) {
            Node[] nodeArray;
            this.resizePath();
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray2[0];
            float f5 = fArray2[1];
            float f6 = fArray2[2];
            if (group instanceof TransformGroup) {
                nodeArray = this.transformPath[this.lastPathIndex];
                ((TransformGroup)group).getTransform((Matrix4f)nodeArray);
                this.matrixUtils.inverse((Matrix4f)nodeArray, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transform(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = group;
            ++this.lastPathIndex;
            nodeArray = group.getRenderableChild();
            for (int i = 0; i < n2 && !bl3; ++i) {
                Node node = nodeArray[i];
                if (node == null) continue;
                if (node instanceof Group) {
                    bl3 = this.pickSingleRaySorted((Group)node, n, fArray, fArray2, sceneGraphPath, bl, bl2);
                    continue;
                }
                if (node instanceof SharedNode) {
                    bl3 = this.pickSingleRaySorted((SharedNode)node, n, fArray, fArray2, sceneGraphPath, bl, bl2);
                    continue;
                }
                if (!(node instanceof Shape3D)) continue;
                bl3 = this.pickSingleRay((Shape3D)node, n, fArray, fArray2, sceneGraphPath, bl, bl2, true);
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            fArray2[0] = f4;
            fArray2[1] = f5;
            fArray2[2] = f6;
        }
        return bl3;
    }

    private void pickCylinder(PickableObject pickableObject, PickRequest pickRequest) {
        switch (pickRequest.pickSortType) {
            case 1: 
            case 3: {
                this.pickAllCylinder(pickableObject, pickRequest);
                break;
            }
            case 2: 
            case 4: {
                this.pickSingleCylinder(pickableObject, pickRequest);
            }
        }
    }

    private void pickSingleCylinder(PickableObject pickableObject, PickRequest pickRequest) {
        SceneGraphPath sceneGraphPath = null;
        if (pickRequest.foundPaths instanceof SceneGraphPath) {
            sceneGraphPath = (SceneGraphPath)pickRequest.foundPaths;
        } else {
            sceneGraphPath = new SceneGraphPath();
            pickRequest.foundPaths = sceneGraphPath;
        }
        boolean bl = false;
        if (pickableObject instanceof Node) {
            Object object;
            Node node = (Node)((Object)pickableObject);
            BoundingVolume boundingVolume = node.getBounds();
            float f = pickRequest.origin[0] - pickRequest.destination[0];
            float f2 = pickRequest.origin[1] - pickRequest.destination[1];
            float f3 = pickRequest.origin[2] - pickRequest.destination[2];
            float f4 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
            if (f4 == 0.0f) {
                pickRequest.pickCount = 0;
                return;
            }
            this.start[0] = (pickRequest.origin[0] + pickRequest.destination[0]) * 0.5f;
            this.start[1] = (pickRequest.origin[1] + pickRequest.destination[0]) * 0.5f;
            this.start[2] = (pickRequest.origin[2] + pickRequest.destination[0]) * 0.5f;
            this.end[0] = f;
            this.end[1] = f2;
            this.end[2] = f3;
            float f5 = pickRequest.additionalData;
            if (!boundingVolume.checkIntersectionCylinder(this.start, this.end, f5, f4)) {
                pickRequest.pickCount = 0;
                return;
            }
            if (boundingVolume instanceof BoundingGeometry) {
                object = (BoundingGeometry)boundingVolume;
                node = ((BoundingGeometry)object).getProxyGeometry();
            }
            if (node instanceof Group) {
                object = (Group)node;
                int n = ((Group)object).numRenderableChildren();
                if (n != 0) {
                    if (node instanceof TransformGroup) {
                        ((TransformGroup)node).getTransform(this.transformPath[0]);
                        this.matrixUtils.inverse(this.transformPath[0], this.invertedMatrix);
                        this.transform(this.invertedMatrix, this.start);
                        this.transformNormal(this.invertedMatrix, this.end);
                        float f6 = this.invertedMatrix.getScale();
                        f5 *= f6;
                        f4 *= f6;
                    } else {
                        this.transformPath[0].setIdentity();
                    }
                    this.validTransform[0] = true;
                    this.pickPath[0] = object;
                    Node[] nodeArray = ((Group)object).getRenderableChild();
                    for (int i = 0; i < n && !bl; ++i) {
                        this.lastPathIndex = 1;
                        if (nodeArray[i] instanceof Group) {
                            bl = this.pickSingleCylinder((Group)nodeArray[i], pickRequest.pickType, this.start, this.end, f5, f4, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue;
                        }
                        if (nodeArray[i] instanceof SharedNode) {
                            bl = this.pickSingleCylinder((SharedNode)nodeArray[i], pickRequest.pickType, this.start, this.end, f5, f4, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue;
                        }
                        if (!(nodeArray[i] instanceof Shape3D)) continue;
                        bl = this.pickSingleCylinder((Shape3D)nodeArray[i], pickRequest.pickType, this.start, this.end, f5, f4, sceneGraphPath, pickRequest.generateVWorldMatrix);
                    }
                }
            } else if (node instanceof SharedNode) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (SharedNode)node;
                this.lastPathIndex = 1;
                bl = this.pickSingleCylinder((SharedNode)node, pickRequest.pickType, this.start, this.end, f5, f4, sceneGraphPath, pickRequest.generateVWorldMatrix);
            } else if (node instanceof Shape3D) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (Shape3D)node;
                this.lastPathIndex = 1;
                bl = this.pickSingleCylinder((Shape3D)node, pickRequest.pickType, this.start, this.end, f5, f4, sceneGraphPath, pickRequest.generateVWorldMatrix);
            } else {
                System.out.println("pickSingleCylinder not handling non-shape/group root proxy");
            }
            pickRequest.pickCount = bl ? 1 : 0;
        } else {
            System.out.println("pickSingleCylinder not handling non-node root");
        }
    }

    private boolean pickSingleCylinder(SharedNode sharedNode, int n, float[] fArray, float[] fArray2, float f, float f2, SceneGraphPath sceneGraphPath, boolean bl) {
        if ((sharedNode.getPickMask() & n) == 0) {
            return false;
        }
        Node node = sharedNode.getChild();
        if (node instanceof Group) {
            return this.pickSingleCylinder((Group)node, n, fArray, fArray2, f, f2, sceneGraphPath, bl);
        }
        if (node instanceof SharedNode) {
            return this.pickSingleCylinder((SharedNode)node, n, fArray, fArray2, f, f2, sceneGraphPath, bl);
        }
        if (node instanceof Shape3D) {
            return this.pickSingleCylinder((Shape3D)node, n, fArray, fArray2, f, f2, sceneGraphPath, bl);
        }
        return false;
    }

    private boolean pickSingleCylinder(Group group, int n, float[] fArray, float[] fArray2, float f, float f2, SceneGraphPath sceneGraphPath, boolean bl) {
        if ((group.getPickMask() & n) == 0) {
            return false;
        }
        BoundingVolume boundingVolume = group.getBounds();
        if (!boundingVolume.checkIntersectionCylinder(fArray, fArray2, f, f2)) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof Group) {
                return this.pickSingleCylinder((Group)node, n, fArray, fArray2, f, f2, sceneGraphPath, bl);
            }
            if (node instanceof SharedNode) {
                return this.pickSingleCylinder((SharedNode)node, n, fArray, fArray2, f, f2, sceneGraphPath, bl);
            }
            if (node instanceof Shape3D) {
                return this.pickSingleCylinder((Shape3D)node, n, fArray, fArray2, f, f2, sceneGraphPath, bl);
            }
            if (node != null) {
                System.out.println("pickSingleCylinder node handling oddball proxy geom");
            }
        }
        boolean bl2 = false;
        int n2 = group.numRenderableChildren();
        if (n2 != 0) {
            Node[] nodeArray;
            this.resizePath();
            float f3 = fArray[0];
            float f4 = fArray[1];
            float f5 = fArray[2];
            float f6 = fArray2[0];
            float f7 = fArray2[1];
            float f8 = fArray2[2];
            if (group instanceof TransformGroup) {
                nodeArray = this.transformPath[this.lastPathIndex];
                ((TransformGroup)group).getTransform((Matrix4f)nodeArray);
                this.matrixUtils.inverse((Matrix4f)nodeArray, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transformNormal(this.invertedMatrix, fArray2);
                float f9 = this.invertedMatrix.getScale();
                f *= f9;
                f2 *= f9;
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = group;
            ++this.lastPathIndex;
            nodeArray = group.getRenderableChild();
            for (int i = 0; i < n2 && !bl2; ++i) {
                Node node = nodeArray[i];
                if (node == null) continue;
                if (node instanceof Group) {
                    bl2 = this.pickSingleCylinder((Group)node, n, fArray, fArray2, f, f2, sceneGraphPath, bl);
                    continue;
                }
                if (node instanceof SharedNode) {
                    bl2 = this.pickSingleCylinder((SharedNode)node, n, fArray, fArray2, f, f2, sceneGraphPath, bl);
                    continue;
                }
                if (!(node instanceof Shape3D)) continue;
                bl2 = this.pickSingleCylinder((Shape3D)node, n, fArray, fArray2, f, f2, sceneGraphPath, bl);
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f3;
            fArray[1] = f4;
            fArray[2] = f5;
            fArray2[0] = f6;
            fArray2[1] = f7;
            fArray2[2] = f8;
        }
        return bl2;
    }

    private boolean pickSingleCylinder(Shape3D shape3D, int n, float[] fArray, float[] fArray2, float f, float f2, SceneGraphPath sceneGraphPath, boolean bl) {
        if ((shape3D.getPickMask() & n) == 0) {
            return false;
        }
        boolean bl2 = false;
        BoundingVolume boundingVolume = shape3D.getBounds();
        if (boundingVolume.checkIntersectionCylinder(fArray, fArray2, f, f2)) {
            this.resizePath();
            this.pickPath[this.lastPathIndex] = shape3D;
            this.validTransform[this.lastPathIndex] = false;
            ++this.lastPathIndex;
            if (bl) {
                this.buildVWorldTransform();
            } else {
                this.vworldMatrix.setIdentity();
            }
            sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
            bl2 = true;
            --this.lastPathIndex;
        }
        return bl2;
    }

    private void pickAllCylinder(PickableObject pickableObject, PickRequest pickRequest) {
        int n = 0;
        ArrayList arrayList = null;
        if (pickRequest.foundPaths instanceof ArrayList) {
            arrayList = (ArrayList)pickRequest.foundPaths;
        } else {
            pickRequest.foundPaths = arrayList = new ArrayList();
        }
        if (pickableObject instanceof Node) {
            Object object;
            Node node = (Node)((Object)pickableObject);
            BoundingVolume boundingVolume = node.getBounds();
            float f = pickRequest.origin[0] - pickRequest.destination[0];
            float f2 = pickRequest.origin[1] - pickRequest.destination[1];
            float f3 = pickRequest.origin[2] - pickRequest.destination[2];
            float f4 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
            if (f4 == 0.0f) {
                pickRequest.pickCount = 0;
                return;
            }
            this.start[0] = (pickRequest.origin[0] + pickRequest.destination[0]) * 0.5f;
            this.start[1] = (pickRequest.origin[1] + pickRequest.destination[0]) * 0.5f;
            this.start[2] = (pickRequest.origin[2] + pickRequest.destination[0]) * 0.5f;
            this.end[0] = f;
            this.end[1] = f2;
            this.end[2] = f3;
            float f5 = pickRequest.additionalData;
            if (!boundingVolume.checkIntersectionCylinder(this.start, this.end, f5, f4)) {
                pickRequest.pickCount = 0;
                return;
            }
            if (boundingVolume instanceof BoundingGeometry) {
                object = (BoundingGeometry)boundingVolume;
                node = ((BoundingGeometry)object).getProxyGeometry();
            }
            if (node instanceof Group) {
                object = (Group)node;
                int n2 = ((Group)object).numRenderableChildren();
                if (n2 != 0) {
                    if (node instanceof TransformGroup) {
                        ((TransformGroup)node).getTransform(this.transformPath[0]);
                        this.matrixUtils.inverse(this.transformPath[0], this.invertedMatrix);
                        this.transform(this.invertedMatrix, this.start);
                        this.transformNormal(this.invertedMatrix, this.end);
                        float f6 = this.invertedMatrix.getScale();
                        f5 *= f6;
                        f4 *= f6;
                    } else {
                        this.transformPath[0].setIdentity();
                    }
                    this.validTransform[0] = true;
                    this.pickPath[0] = object;
                    Node[] nodeArray = ((Group)object).getRenderableChild();
                    for (int i = 0; i < n2; ++i) {
                        this.lastPathIndex = 1;
                        if (nodeArray[i] instanceof Group) {
                            n += this.pickAllCylinder((Group)nodeArray[i], pickRequest.pickType, this.start, this.end, f5, f4, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue;
                        }
                        if (nodeArray[i] instanceof SharedNode) {
                            n += this.pickAllCylinder((SharedNode)nodeArray[i], pickRequest.pickType, this.start, this.end, f5, f4, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue;
                        }
                        if (!(nodeArray[i] instanceof Shape3D)) continue;
                        n += this.pickAllCylinder((Shape3D)nodeArray[i], pickRequest.pickType, this.start, this.end, f5, f4, arrayList, n, pickRequest.generateVWorldMatrix);
                    }
                    pickRequest.pickCount = n;
                }
            } else if (node instanceof SharedNode) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (SharedNode)node;
                this.lastPathIndex = 1;
                pickRequest.pickCount = n += this.pickAllCylinder((SharedNode)node, pickRequest.pickType, this.start, this.end, f5, f4, arrayList, 0, pickRequest.generateVWorldMatrix);
            } else if (node instanceof Shape3D) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (Shape3D)node;
                this.lastPathIndex = 1;
                pickRequest.pickCount = n += this.pickAllCylinder((Shape3D)node, pickRequest.pickType, this.start, this.end, f5, f4, arrayList, 0, pickRequest.generateVWorldMatrix);
            } else {
                System.out.println("pickAllCylinder not handling non-shape/group root proxy");
            }
        } else {
            System.out.println("pickAllCylinder not handling non-node root");
        }
    }

    private int pickAllCylinder(Group group, int n, float[] fArray, float[] fArray2, float f, float f2, ArrayList arrayList, int n2, boolean bl) {
        if ((group.getPickMask() & n) == 0) {
            return 0;
        }
        BoundingVolume boundingVolume = group.getBounds();
        if (!boundingVolume.checkIntersectionCylinder(fArray, fArray2, f, f2)) {
            return 0;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof Group) {
                return this.pickAllCylinder((Group)node, n, fArray, fArray2, f, f2, arrayList, n2, bl);
            }
            if (node instanceof SharedNode) {
                return this.pickAllCylinder((SharedNode)node, n, fArray, fArray2, f, f2, arrayList, n2, bl);
            }
            if (node instanceof Shape3D) {
                return this.pickAllCylinder((Shape3D)node, n, fArray, fArray2, f, f2, arrayList, n2, bl);
            }
            if (node != null) {
                System.out.println("pickAllCylinder node handling oddball proxy geom");
            }
        }
        int n3 = 0;
        int n4 = group.numRenderableChildren();
        if (n4 != 0) {
            Node[] nodeArray;
            this.resizePath();
            float f3 = fArray[0];
            float f4 = fArray[1];
            float f5 = fArray[2];
            float f6 = fArray2[0];
            float f7 = fArray2[1];
            float f8 = fArray2[2];
            if (group instanceof TransformGroup) {
                nodeArray = this.transformPath[this.lastPathIndex];
                ((TransformGroup)group).getTransform((Matrix4f)nodeArray);
                this.matrixUtils.inverse((Matrix4f)nodeArray, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transformNormal(this.invertedMatrix, fArray2);
                float f9 = this.invertedMatrix.getScale();
                f *= f9;
                f2 *= f9;
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = group;
            ++this.lastPathIndex;
            nodeArray = group.getRenderableChild();
            for (int i = 0; i < n4; ++i) {
                Node node = nodeArray[i];
                if (node == null) continue;
                if (node instanceof Group) {
                    n3 += this.pickAllCylinder((Group)node, n, fArray, fArray2, f, f2, arrayList, n2 + n3, bl);
                    continue;
                }
                if (node instanceof SharedNode) {
                    n3 += this.pickAllCylinder((SharedNode)node, n, fArray, fArray2, f, f2, arrayList, n2 + n3, bl);
                    continue;
                }
                if (!(node instanceof Shape3D)) continue;
                n3 += this.pickAllCylinder((Shape3D)node, n, fArray, fArray2, f, f2, arrayList, n2 + n3, bl);
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f3;
            fArray[1] = f4;
            fArray[2] = f5;
            fArray2[0] = f6;
            fArray2[1] = f7;
            fArray2[2] = f8;
        }
        return n3;
    }

    private int pickAllCylinder(SharedNode sharedNode, int n, float[] fArray, float[] fArray2, float f, float f2, ArrayList arrayList, int n2, boolean bl) {
        if ((sharedNode.getPickMask() & n) == 0) {
            return 0;
        }
        Node node = sharedNode.getChild();
        if (node instanceof Group) {
            return this.pickAllCylinder((Group)node, n, fArray, fArray2, f, f2, arrayList, n2, bl);
        }
        if (node instanceof SharedNode) {
            return this.pickAllCylinder((SharedNode)node, n, fArray, fArray2, f, f2, arrayList, n2, bl);
        }
        if (node instanceof Shape3D) {
            return this.pickAllCylinder((Shape3D)node, n, fArray, fArray2, f, f2, arrayList, n2, bl);
        }
        return 0;
    }

    private int pickAllCylinder(Shape3D shape3D, int n, float[] fArray, float[] fArray2, float f, float f2, ArrayList arrayList, int n2, boolean bl) {
        if ((shape3D.getPickMask() & n) == 0) {
            return 0;
        }
        int n3 = 0;
        BoundingVolume boundingVolume = shape3D.getBounds();
        if (boundingVolume.checkIntersectionCylinder(fArray, fArray2, f, f2)) {
            SceneGraphPath sceneGraphPath;
            this.resizePath();
            this.pickPath[this.lastPathIndex] = shape3D;
            this.validTransform[this.lastPathIndex] = false;
            ++this.lastPathIndex;
            if (n2 >= arrayList.size()) {
                sceneGraphPath = new SceneGraphPath();
                arrayList.add(sceneGraphPath);
            } else {
                sceneGraphPath = (SceneGraphPath)arrayList.get(n2);
            }
            if (bl) {
                this.buildVWorldTransform();
            } else {
                this.vworldMatrix.setIdentity();
            }
            sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
            n3 = 1;
            --this.lastPathIndex;
        }
        return n3;
    }

    private void pickCone(PickableObject pickableObject, PickRequest pickRequest) {
        switch (pickRequest.pickSortType) {
            case 1: 
            case 3: {
                this.pickAllCone(pickableObject, pickRequest);
                break;
            }
            case 2: 
            case 4: {
                this.pickSingleCone(pickableObject, pickRequest);
                break;
            }
            default: {
                System.out.println("No sort type has been specified");
            }
        }
    }

    private void pickSingleCone(PickableObject pickableObject, PickRequest pickRequest) {
        SceneGraphPath sceneGraphPath = null;
        if (pickRequest.foundPaths instanceof SceneGraphPath) {
            sceneGraphPath = (SceneGraphPath)pickRequest.foundPaths;
        } else {
            sceneGraphPath = new SceneGraphPath();
            pickRequest.foundPaths = sceneGraphPath;
        }
        boolean bl = false;
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        this.end[0] = pickRequest.destination[0];
        this.end[1] = pickRequest.destination[1];
        this.end[2] = pickRequest.destination[2];
        if (pickableObject instanceof Node) {
            Object object;
            Node node = (Node)((Object)pickableObject);
            BoundingVolume boundingVolume = node.getBounds();
            float f = pickRequest.additionalData;
            if (!boundingVolume.checkIntersectionCone(pickRequest.origin, pickRequest.destination, pickRequest.additionalData)) {
                pickRequest.pickCount = 0;
                return;
            }
            if (boundingVolume instanceof BoundingGeometry) {
                object = (BoundingGeometry)boundingVolume;
                node = ((BoundingGeometry)object).getProxyGeometry();
            }
            if (node instanceof Group) {
                object = (Group)node;
                int n = ((Group)object).numRenderableChildren();
                if (n != 0) {
                    if (node instanceof TransformGroup) {
                        ((TransformGroup)node).getTransform(this.transformPath[0]);
                        this.matrixUtils.inverse(this.transformPath[0], this.invertedMatrix);
                        this.transform(this.invertedMatrix, this.start);
                        this.transformNormal(this.invertedMatrix, this.end);
                    } else {
                        this.transformPath[0].setIdentity();
                    }
                    this.validTransform[0] = true;
                    this.pickPath[0] = object;
                    Node[] nodeArray = ((Group)object).getRenderableChild();
                    for (int i = 0; i < n && !bl; ++i) {
                        this.lastPathIndex = 1;
                        if (nodeArray[i] instanceof Group) {
                            bl = this.pickSingleCone((Group)nodeArray[i], pickRequest.pickType, this.start, this.end, f, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue;
                        }
                        if (nodeArray[i] instanceof SharedNode) {
                            bl = this.pickSingleCone((SharedNode)nodeArray[i], pickRequest.pickType, this.start, this.end, f, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue;
                        }
                        if (!(nodeArray[i] instanceof Shape3D)) continue;
                        bl = this.pickSingleCone((Shape3D)nodeArray[i], pickRequest.pickType, this.start, this.end, f, sceneGraphPath, pickRequest.generateVWorldMatrix);
                    }
                }
            } else if (node instanceof SharedNode) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (SharedNode)node;
                this.lastPathIndex = 1;
                bl = this.pickSingleCone((SharedNode)node, pickRequest.pickType, this.start, this.end, f, sceneGraphPath, pickRequest.generateVWorldMatrix);
            } else if (node instanceof Shape3D) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (Shape3D)node;
                this.lastPathIndex = 1;
                bl = this.pickSingleCone((Shape3D)node, pickRequest.pickType, this.start, this.end, f, sceneGraphPath, pickRequest.generateVWorldMatrix);
            } else {
                System.out.println("pickSingleCone not handling non-shape/group root proxy");
            }
            pickRequest.pickCount = bl ? 1 : 0;
        } else {
            System.out.println("pickSingleCone not handling non-node root");
        }
    }

    private boolean pickSingleCone(SharedNode sharedNode, int n, float[] fArray, float[] fArray2, float f, SceneGraphPath sceneGraphPath, boolean bl) {
        if ((sharedNode.getPickMask() & n) == 0) {
            return false;
        }
        Node node = sharedNode.getChild();
        if (node instanceof Group) {
            return this.pickSingleCone((Group)node, n, fArray, fArray2, f, sceneGraphPath, bl);
        }
        if (node instanceof SharedNode) {
            return this.pickSingleCone((SharedNode)node, n, fArray, fArray2, f, sceneGraphPath, bl);
        }
        if (node instanceof Shape3D) {
            return this.pickSingleCone((Shape3D)node, n, fArray, fArray2, f, sceneGraphPath, bl);
        }
        return false;
    }

    private boolean pickSingleCone(Group group, int n, float[] fArray, float[] fArray2, float f, SceneGraphPath sceneGraphPath, boolean bl) {
        if ((group.getPickMask() & n) == 0) {
            return false;
        }
        BoundingVolume boundingVolume = group.getBounds();
        if (!boundingVolume.checkIntersectionCone(fArray, fArray2, f)) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof Group) {
                return this.pickSingleCone((Group)node, n, fArray, fArray2, f, sceneGraphPath, bl);
            }
            if (node instanceof SharedNode) {
                return this.pickSingleCone((SharedNode)node, n, fArray, fArray2, f, sceneGraphPath, bl);
            }
            if (node instanceof Shape3D) {
                return this.pickSingleCone((Shape3D)node, n, fArray, fArray2, f, sceneGraphPath, bl);
            }
            if (node != null) {
                System.out.println("pickSingleCone node handling oddball proxy geom");
            }
        }
        boolean bl2 = false;
        int n2 = group.numRenderableChildren();
        if (n2 != 0) {
            Node[] nodeArray;
            this.resizePath();
            float f2 = fArray[0];
            float f3 = fArray[1];
            float f4 = fArray[2];
            float f5 = fArray2[0];
            float f6 = fArray2[1];
            float f7 = fArray2[2];
            if (group instanceof TransformGroup) {
                nodeArray = this.transformPath[this.lastPathIndex];
                ((TransformGroup)group).getTransform((Matrix4f)nodeArray);
                this.matrixUtils.inverse((Matrix4f)nodeArray, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transformNormal(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = group;
            ++this.lastPathIndex;
            nodeArray = group.getRenderableChild();
            for (int i = 0; i < n2 && !bl2; ++i) {
                Node node = nodeArray[i];
                if (node == null) continue;
                if (node instanceof Group) {
                    bl2 = this.pickSingleCone((Group)node, n, fArray, fArray2, f, sceneGraphPath, bl);
                    continue;
                }
                if (node instanceof SharedNode) {
                    bl2 = this.pickSingleCone((SharedNode)node, n, fArray, fArray2, f, sceneGraphPath, bl);
                    continue;
                }
                if (!(node instanceof Shape3D)) continue;
                bl2 = this.pickSingleCone((Shape3D)node, n, fArray, fArray2, f, sceneGraphPath, bl);
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f2;
            fArray[1] = f3;
            fArray[2] = f4;
            fArray2[0] = f5;
            fArray2[1] = f6;
            fArray2[2] = f7;
        }
        return bl2;
    }

    private boolean pickSingleCone(Shape3D shape3D, int n, float[] fArray, float[] fArray2, float f, SceneGraphPath sceneGraphPath, boolean bl) {
        if ((shape3D.getPickMask() & n) == 0) {
            return false;
        }
        boolean bl2 = false;
        BoundingVolume boundingVolume = shape3D.getBounds();
        if (boundingVolume.checkIntersectionCone(fArray, fArray2, f)) {
            this.resizePath();
            this.pickPath[this.lastPathIndex] = shape3D;
            this.validTransform[this.lastPathIndex] = false;
            ++this.lastPathIndex;
            if (bl) {
                this.buildVWorldTransform();
            } else {
                this.vworldMatrix.setIdentity();
            }
            sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
            bl2 = true;
            --this.lastPathIndex;
        }
        return bl2;
    }

    private void pickAllCone(PickableObject pickableObject, PickRequest pickRequest) {
        int n = 0;
        ArrayList arrayList = null;
        if (pickRequest.foundPaths instanceof ArrayList) {
            arrayList = (ArrayList)pickRequest.foundPaths;
        } else {
            pickRequest.foundPaths = arrayList = new ArrayList();
        }
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        this.end[0] = pickRequest.destination[0];
        this.end[1] = pickRequest.destination[1];
        this.end[2] = pickRequest.destination[2];
        if (pickableObject instanceof Node) {
            Object object;
            Node node = (Node)((Object)pickableObject);
            BoundingVolume boundingVolume = node.getBounds();
            float f = pickRequest.additionalData;
            if (!boundingVolume.checkIntersectionCone(pickRequest.origin, pickRequest.destination, pickRequest.additionalData)) {
                pickRequest.pickCount = 0;
                return;
            }
            if (boundingVolume instanceof BoundingGeometry) {
                object = (BoundingGeometry)boundingVolume;
                node = ((BoundingGeometry)object).getProxyGeometry();
            }
            if (node instanceof Group) {
                object = (Group)node;
                int n2 = ((Group)object).numRenderableChildren();
                if (n2 != 0) {
                    if (node instanceof TransformGroup) {
                        ((TransformGroup)node).getTransform(this.transformPath[0]);
                        this.matrixUtils.inverse(this.transformPath[0], this.invertedMatrix);
                        this.transform(this.invertedMatrix, this.start);
                        this.transformNormal(this.invertedMatrix, this.end);
                    } else {
                        this.transformPath[0].setIdentity();
                    }
                    this.validTransform[0] = true;
                    this.pickPath[0] = object;
                    Node[] nodeArray = ((Group)object).getRenderableChild();
                    for (int i = 0; i < n2; ++i) {
                        this.lastPathIndex = 1;
                        if (nodeArray[i] instanceof Group) {
                            n += this.pickAllCone((Group)nodeArray[i], pickRequest.pickType, this.start, this.end, f, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue;
                        }
                        if (nodeArray[i] instanceof SharedNode) {
                            n += this.pickAllCone((SharedNode)nodeArray[i], pickRequest.pickType, this.start, this.end, f, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue;
                        }
                        if (!(nodeArray[i] instanceof Shape3D)) continue;
                        n += this.pickAllCone((Shape3D)nodeArray[i], pickRequest.pickType, this.start, this.end, f, arrayList, n, pickRequest.generateVWorldMatrix);
                    }
                    pickRequest.pickCount = n;
                }
            } else if (node instanceof SharedNode) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (SharedNode)node;
                this.lastPathIndex = 1;
                pickRequest.pickCount = n += this.pickAllCone((SharedNode)node, pickRequest.pickType, this.start, this.end, f, arrayList, 0, pickRequest.generateVWorldMatrix);
            } else if (node instanceof Shape3D) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (Shape3D)node;
                this.lastPathIndex = 1;
                pickRequest.pickCount = n += this.pickAllCone((Shape3D)node, pickRequest.pickType, this.start, this.end, f, arrayList, 0, pickRequest.generateVWorldMatrix);
            } else {
                System.out.println("pickAllCone not handling non-shape/group root proxy");
            }
        } else {
            System.out.println("pickAllCone not handling non-node root");
        }
    }

    private int pickAllCone(Group group, int n, float[] fArray, float[] fArray2, float f, ArrayList arrayList, int n2, boolean bl) {
        if ((group.getPickMask() & n) == 0) {
            return 0;
        }
        BoundingVolume boundingVolume = group.getBounds();
        if (!boundingVolume.checkIntersectionCone(fArray, fArray2, f)) {
            return 0;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof Group) {
                return this.pickAllCone((Group)node, n, fArray, fArray2, f, arrayList, n2, bl);
            }
            if (node instanceof SharedNode) {
                return this.pickAllCone((SharedNode)node, n, fArray, fArray2, f, arrayList, n2, bl);
            }
            if (node instanceof Shape3D) {
                return this.pickAllCone((Shape3D)node, n, fArray, fArray2, f, arrayList, n2, bl);
            }
            if (node != null) {
                System.out.println("pickAllCone node handling oddball proxy geom");
            }
        }
        int n3 = 0;
        int n4 = group.numRenderableChildren();
        if (n4 != 0) {
            Node[] nodeArray;
            this.resizePath();
            float f2 = fArray[0];
            float f3 = fArray[1];
            float f4 = fArray[2];
            float f5 = fArray2[0];
            float f6 = fArray2[1];
            float f7 = fArray2[2];
            if (group instanceof TransformGroup) {
                nodeArray = this.transformPath[this.lastPathIndex];
                ((TransformGroup)group).getTransform((Matrix4f)nodeArray);
                this.matrixUtils.inverse((Matrix4f)nodeArray, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transformNormal(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = group;
            ++this.lastPathIndex;
            nodeArray = group.getRenderableChild();
            for (int i = 0; i < n4; ++i) {
                Node node = nodeArray[i];
                if (node == null) continue;
                if (node instanceof Group) {
                    n3 += this.pickAllCone((Group)node, n, fArray, fArray2, f, arrayList, n2 + n3, bl);
                    continue;
                }
                if (node instanceof SharedNode) {
                    n3 += this.pickAllCone((SharedNode)node, n, fArray, fArray2, f, arrayList, n2 + n3, bl);
                    continue;
                }
                if (!(node instanceof Shape3D)) continue;
                n3 += this.pickAllCone((Shape3D)node, n, fArray, fArray2, f, arrayList, n2 + n3, bl);
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f2;
            fArray[1] = f3;
            fArray[2] = f4;
            fArray2[0] = f5;
            fArray2[1] = f6;
            fArray2[2] = f7;
        }
        return n3;
    }

    private int pickAllCone(SharedNode sharedNode, int n, float[] fArray, float[] fArray2, float f, ArrayList arrayList, int n2, boolean bl) {
        if ((sharedNode.getPickMask() & n) == 0) {
            return 0;
        }
        Node node = sharedNode.getChild();
        if (node instanceof Group) {
            return this.pickAllCone((Group)node, n, fArray, fArray2, f, arrayList, n2, bl);
        }
        if (node instanceof SharedNode) {
            return this.pickAllCone((SharedNode)node, n, fArray, fArray2, f, arrayList, n2, bl);
        }
        if (node instanceof Shape3D) {
            return this.pickAllCone((Shape3D)node, n, fArray, fArray2, f, arrayList, n2, bl);
        }
        return 0;
    }

    private int pickAllCone(Shape3D shape3D, int n, float[] fArray, float[] fArray2, float f, ArrayList arrayList, int n2, boolean bl) {
        if ((shape3D.getPickMask() & n) == 0) {
            return 0;
        }
        int n3 = 0;
        BoundingVolume boundingVolume = shape3D.getBounds();
        if (boundingVolume.checkIntersectionCone(fArray, fArray2, f)) {
            SceneGraphPath sceneGraphPath;
            this.resizePath();
            this.pickPath[this.lastPathIndex] = shape3D;
            this.validTransform[this.lastPathIndex] = false;
            ++this.lastPathIndex;
            if (n2 >= arrayList.size()) {
                sceneGraphPath = new SceneGraphPath();
                arrayList.add(sceneGraphPath);
            } else {
                sceneGraphPath = (SceneGraphPath)arrayList.get(n2);
            }
            if (bl) {
                this.buildVWorldTransform();
            } else {
                this.vworldMatrix.setIdentity();
            }
            sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
            n3 = 1;
            --this.lastPathIndex;
        }
        return n3;
    }

    private void pickBox(PickableObject pickableObject, PickRequest pickRequest) {
        switch (pickRequest.pickSortType) {
            case 1: 
            case 3: {
                this.pickAllBox(pickableObject, pickRequest);
                break;
            }
            case 2: 
            case 4: {
                this.pickSingleBox(pickableObject, pickRequest);
                break;
            }
            default: {
                System.out.println("No sort type has been specified");
            }
        }
    }

    private void pickSingleBox(PickableObject pickableObject, PickRequest pickRequest) {
        SceneGraphPath sceneGraphPath = null;
        if (pickRequest.foundPaths instanceof SceneGraphPath) {
            sceneGraphPath = (SceneGraphPath)pickRequest.foundPaths;
        } else {
            sceneGraphPath = new SceneGraphPath();
            pickRequest.foundPaths = sceneGraphPath;
        }
        boolean bl = false;
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        this.end[0] = pickRequest.destination[0];
        this.end[1] = pickRequest.destination[1];
        this.end[2] = pickRequest.destination[2];
        if (pickableObject instanceof Node) {
            Object object;
            Node node = (Node)((Object)pickableObject);
            BoundingVolume boundingVolume = node.getBounds();
            if (!boundingVolume.checkIntersectionBox(pickRequest.origin, pickRequest.destination)) {
                pickRequest.pickCount = 0;
                return;
            }
            if (boundingVolume instanceof BoundingGeometry) {
                object = (BoundingGeometry)boundingVolume;
                node = ((BoundingGeometry)object).getProxyGeometry();
            }
            if (node instanceof Group) {
                object = (Group)node;
                int n = ((Group)object).numRenderableChildren();
                if (n != 0) {
                    if (node instanceof TransformGroup) {
                        ((TransformGroup)node).getTransform(this.transformPath[0]);
                        this.matrixUtils.inverse(this.transformPath[0], this.invertedMatrix);
                        this.transform(this.invertedMatrix, this.start);
                        this.transform(this.invertedMatrix, this.end);
                    } else {
                        this.transformPath[0].setIdentity();
                    }
                    this.validTransform[0] = true;
                    this.pickPath[0] = object;
                    Node[] nodeArray = ((Group)object).getRenderableChild();
                    for (int i = 0; i < n && !bl; ++i) {
                        this.lastPathIndex = 1;
                        if (nodeArray[i] instanceof Group) {
                            bl = this.pickSingleBox((Group)nodeArray[i], pickRequest.pickType, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue;
                        }
                        if (nodeArray[i] instanceof SharedNode) {
                            bl = this.pickSingleBox((SharedNode)nodeArray[i], pickRequest.pickType, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue;
                        }
                        if (!(nodeArray[i] instanceof Shape3D)) continue;
                        bl = this.pickSingleBox((Shape3D)nodeArray[i], pickRequest.pickType, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix);
                    }
                }
            } else if (node instanceof SharedNode) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (SharedNode)node;
                this.lastPathIndex = 1;
                bl = this.pickSingleBox((SharedNode)node, pickRequest.pickType, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix);
            } else if (node instanceof Shape3D) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (Shape3D)node;
                this.lastPathIndex = 1;
                bl = this.pickSingleBox((Shape3D)node, pickRequest.pickType, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix);
            } else {
                System.out.println("pickSingleBox not handling non-shape/group root proxy");
            }
            pickRequest.pickCount = bl ? 1 : 0;
        } else {
            System.out.println("pickSingleBox not handling non-node root");
        }
    }

    private boolean pickSingleBox(SharedNode sharedNode, int n, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl) {
        if ((sharedNode.getPickMask() & n) == 0) {
            return false;
        }
        Node node = sharedNode.getChild();
        if (node instanceof Group) {
            return this.pickSingleBox((Group)node, n, fArray, fArray2, sceneGraphPath, bl);
        }
        if (node instanceof SharedNode) {
            return this.pickSingleBox((SharedNode)node, n, fArray, fArray2, sceneGraphPath, bl);
        }
        if (node instanceof Shape3D) {
            return this.pickSingleBox((Shape3D)node, n, fArray, fArray2, sceneGraphPath, bl);
        }
        return false;
    }

    private boolean pickSingleBox(Group group, int n, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl) {
        if ((group.getPickMask() & n) == 0) {
            return false;
        }
        BoundingVolume boundingVolume = group.getBounds();
        if (!boundingVolume.checkIntersectionBox(fArray, fArray2)) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof Group) {
                return this.pickSingleBox((Group)node, n, fArray, fArray2, sceneGraphPath, bl);
            }
            if (node instanceof SharedNode) {
                return this.pickSingleBox((SharedNode)node, n, fArray, fArray2, sceneGraphPath, bl);
            }
            if (node instanceof Shape3D) {
                return this.pickSingleBox((Shape3D)node, n, fArray, fArray2, sceneGraphPath, bl);
            }
            if (node != null) {
                System.out.println("pickSingleBox node handling oddball proxy geom");
            }
        }
        boolean bl2 = false;
        int n2 = group.numRenderableChildren();
        if (n2 != 0) {
            Node[] nodeArray;
            this.resizePath();
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray2[0];
            float f5 = fArray2[1];
            float f6 = fArray2[2];
            if (group instanceof TransformGroup) {
                nodeArray = this.transformPath[this.lastPathIndex];
                ((TransformGroup)group).getTransform((Matrix4f)nodeArray);
                this.matrixUtils.inverse((Matrix4f)nodeArray, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transform(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = group;
            ++this.lastPathIndex;
            nodeArray = group.getRenderableChild();
            for (int i = 0; i < n2 && !bl2; ++i) {
                Node node = nodeArray[i];
                if (node == null) continue;
                if (node instanceof Group) {
                    bl2 = this.pickSingleBox((Group)node, n, fArray, fArray2, sceneGraphPath, bl);
                    continue;
                }
                if (node instanceof SharedNode) {
                    bl2 = this.pickSingleBox((SharedNode)node, n, fArray, fArray2, sceneGraphPath, bl);
                    continue;
                }
                if (!(node instanceof Shape3D)) continue;
                bl2 = this.pickSingleBox((Shape3D)node, n, fArray, fArray2, sceneGraphPath, bl);
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            fArray2[0] = f4;
            fArray2[1] = f5;
            fArray2[2] = f6;
        }
        return bl2;
    }

    private boolean pickSingleBox(Shape3D shape3D, int n, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl) {
        if ((shape3D.getPickMask() & n) == 0) {
            return false;
        }
        boolean bl2 = false;
        BoundingVolume boundingVolume = shape3D.getBounds();
        if (boundingVolume.checkIntersectionBox(fArray, fArray2)) {
            this.resizePath();
            this.pickPath[this.lastPathIndex] = shape3D;
            this.validTransform[this.lastPathIndex] = false;
            ++this.lastPathIndex;
            if (bl) {
                this.buildVWorldTransform();
            } else {
                this.vworldMatrix.setIdentity();
            }
            sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
            bl2 = true;
            --this.lastPathIndex;
        }
        return bl2;
    }

    private void pickAllBox(PickableObject pickableObject, PickRequest pickRequest) {
        int n = 0;
        ArrayList arrayList = null;
        if (pickRequest.foundPaths instanceof ArrayList) {
            arrayList = (ArrayList)pickRequest.foundPaths;
        } else {
            pickRequest.foundPaths = arrayList = new ArrayList();
        }
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        this.end[0] = pickRequest.destination[0];
        this.end[1] = pickRequest.destination[1];
        this.end[2] = pickRequest.destination[2];
        if (pickableObject instanceof Node) {
            Object object;
            Node node = (Node)((Object)pickableObject);
            BoundingVolume boundingVolume = node.getBounds();
            if (!boundingVolume.checkIntersectionBox(pickRequest.origin, pickRequest.destination)) {
                pickRequest.pickCount = 0;
                return;
            }
            if (boundingVolume instanceof BoundingGeometry) {
                object = (BoundingGeometry)boundingVolume;
                node = ((BoundingGeometry)object).getProxyGeometry();
            }
            if (node instanceof Group) {
                object = (Group)node;
                int n2 = ((Group)object).numRenderableChildren();
                if (n2 != 0) {
                    if (node instanceof TransformGroup) {
                        ((TransformGroup)node).getTransform(this.transformPath[0]);
                        this.matrixUtils.inverse(this.transformPath[0], this.invertedMatrix);
                        this.transform(this.invertedMatrix, this.start);
                        this.transform(this.invertedMatrix, this.end);
                    } else {
                        this.transformPath[0].setIdentity();
                    }
                    this.validTransform[0] = true;
                    this.pickPath[0] = object;
                    Node[] nodeArray = ((Group)object).getRenderableChild();
                    for (int i = 0; i < n2; ++i) {
                        this.lastPathIndex = 1;
                        if (nodeArray[i] instanceof Group) {
                            n += this.pickAllBox((Group)nodeArray[i], pickRequest.pickType, this.start, this.end, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue;
                        }
                        if (nodeArray[i] instanceof SharedNode) {
                            n += this.pickAllBox((SharedNode)nodeArray[i], pickRequest.pickType, this.start, this.end, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue;
                        }
                        if (!(nodeArray[i] instanceof Shape3D)) continue;
                        n += this.pickAllBox((Shape3D)nodeArray[i], pickRequest.pickType, this.start, this.end, arrayList, n, pickRequest.generateVWorldMatrix);
                    }
                    pickRequest.pickCount = n;
                }
            } else if (node instanceof SharedNode) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (SharedNode)node;
                this.lastPathIndex = 1;
                pickRequest.pickCount = n += this.pickAllBox((SharedNode)node, pickRequest.pickType, this.start, this.end, arrayList, 0, pickRequest.generateVWorldMatrix);
            } else if (node instanceof Shape3D) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (Shape3D)node;
                this.lastPathIndex = 1;
                pickRequest.pickCount = n += this.pickAllBox((Shape3D)node, pickRequest.pickType, this.start, this.end, arrayList, 0, pickRequest.generateVWorldMatrix);
            } else {
                System.out.println("pickAllBox not handling non-shape/group root proxy");
            }
        } else {
            System.out.println("pickAllBox not handling non-node root");
        }
    }

    private int pickAllBox(Group group, int n, float[] fArray, float[] fArray2, ArrayList arrayList, int n2, boolean bl) {
        if ((group.getPickMask() & n) == 0) {
            return 0;
        }
        BoundingVolume boundingVolume = group.getBounds();
        if (!boundingVolume.checkIntersectionBox(fArray, fArray2)) {
            return 0;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof Group) {
                return this.pickAllBox((Group)node, n, fArray, fArray2, arrayList, n2, bl);
            }
            if (node instanceof SharedNode) {
                return this.pickAllBox((SharedNode)node, n, fArray, fArray2, arrayList, n2, bl);
            }
            if (node instanceof Shape3D) {
                return this.pickAllBox((Shape3D)node, n, fArray, fArray2, arrayList, n2, bl);
            }
            if (node != null) {
                System.out.println("pickAllBox node handling oddball proxy geom");
            }
        }
        int n3 = 0;
        int n4 = group.numRenderableChildren();
        if (n4 != 0) {
            Node[] nodeArray;
            this.resizePath();
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray2[0];
            float f5 = fArray2[1];
            float f6 = fArray2[2];
            if (group instanceof TransformGroup) {
                nodeArray = this.transformPath[this.lastPathIndex];
                ((TransformGroup)group).getTransform((Matrix4f)nodeArray);
                this.matrixUtils.inverse((Matrix4f)nodeArray, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transform(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = group;
            ++this.lastPathIndex;
            nodeArray = group.getRenderableChild();
            for (int i = 0; i < n4; ++i) {
                Node node = nodeArray[i];
                if (node == null) continue;
                if (node instanceof Group) {
                    n3 += this.pickAllBox((Group)node, n, fArray, fArray2, arrayList, n2 + n3, bl);
                    continue;
                }
                if (node instanceof SharedNode) {
                    n3 += this.pickAllBox((SharedNode)node, n, fArray, fArray2, arrayList, n2 + n3, bl);
                    continue;
                }
                if (!(node instanceof Shape3D)) continue;
                n3 += this.pickAllBox((Shape3D)node, n, fArray, fArray2, arrayList, n2 + n3, bl);
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            fArray2[0] = f4;
            fArray2[1] = f5;
            fArray2[2] = f6;
        }
        return n3;
    }

    private int pickAllBox(SharedNode sharedNode, int n, float[] fArray, float[] fArray2, ArrayList arrayList, int n2, boolean bl) {
        if ((sharedNode.getPickMask() & n) == 0) {
            return 0;
        }
        Node node = sharedNode.getChild();
        if (node instanceof Group) {
            return this.pickAllBox((Group)node, n, fArray, fArray2, arrayList, n2, bl);
        }
        if (node instanceof SharedNode) {
            return this.pickAllBox((SharedNode)node, n, fArray, fArray2, arrayList, n2, bl);
        }
        if (node instanceof Shape3D) {
            return this.pickAllBox((Shape3D)node, n, fArray, fArray2, arrayList, n2, bl);
        }
        return 0;
    }

    private int pickAllBox(Shape3D shape3D, int n, float[] fArray, float[] fArray2, ArrayList arrayList, int n2, boolean bl) {
        if ((shape3D.getPickMask() & n) == 0) {
            return 0;
        }
        int n3 = 0;
        BoundingVolume boundingVolume = shape3D.getBounds();
        if (boundingVolume.checkIntersectionBox(fArray, fArray2)) {
            SceneGraphPath sceneGraphPath;
            this.resizePath();
            this.pickPath[this.lastPathIndex] = shape3D;
            this.validTransform[this.lastPathIndex] = false;
            ++this.lastPathIndex;
            if (n2 >= arrayList.size()) {
                sceneGraphPath = new SceneGraphPath();
                arrayList.add(sceneGraphPath);
            } else {
                sceneGraphPath = (SceneGraphPath)arrayList.get(n2);
            }
            if (bl) {
                this.buildVWorldTransform();
            } else {
                this.vworldMatrix.setIdentity();
            }
            sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
            n3 = 1;
            --this.lastPathIndex;
        }
        return n3;
    }

    private void pickFrustum(PickableObject pickableObject, PickRequest pickRequest) {
        switch (pickRequest.pickSortType) {
            case 1: 
            case 3: {
                this.pickAllFrustum(pickableObject, pickRequest);
                break;
            }
            case 2: 
            case 4: {
                this.pickSingleFrustum(pickableObject, pickRequest);
                break;
            }
            default: {
                System.out.println("No sort type has been specified");
            }
        }
    }

    private void pickSingleFrustum(PickableObject pickableObject, PickRequest pickRequest) {
        SceneGraphPath sceneGraphPath = null;
        if (pickRequest.foundPaths instanceof SceneGraphPath) {
            sceneGraphPath = (SceneGraphPath)pickRequest.foundPaths;
        } else {
            sceneGraphPath = new SceneGraphPath();
            pickRequest.foundPaths = sceneGraphPath;
        }
        this.frustumPlanes[0].x = pickRequest.origin[0];
        this.frustumPlanes[0].y = pickRequest.origin[1];
        this.frustumPlanes[0].z = pickRequest.origin[2];
        this.frustumPlanes[0].w = pickRequest.origin[3];
        this.frustumPlanes[1].x = pickRequest.origin[4];
        this.frustumPlanes[1].y = pickRequest.origin[5];
        this.frustumPlanes[1].z = pickRequest.origin[6];
        this.frustumPlanes[1].w = pickRequest.origin[7];
        this.frustumPlanes[2].x = pickRequest.origin[8];
        this.frustumPlanes[2].y = pickRequest.origin[9];
        this.frustumPlanes[2].z = pickRequest.origin[10];
        this.frustumPlanes[2].w = pickRequest.origin[11];
        this.frustumPlanes[3].x = pickRequest.origin[12];
        this.frustumPlanes[3].y = pickRequest.origin[13];
        this.frustumPlanes[3].z = pickRequest.origin[14];
        this.frustumPlanes[3].w = pickRequest.origin[15];
        this.frustumPlanes[4].x = pickRequest.origin[16];
        this.frustumPlanes[4].y = pickRequest.origin[17];
        this.frustumPlanes[4].z = pickRequest.origin[18];
        this.frustumPlanes[4].w = pickRequest.origin[19];
        this.frustumPlanes[5].x = pickRequest.origin[20];
        this.frustumPlanes[5].y = pickRequest.origin[21];
        this.frustumPlanes[5].z = pickRequest.origin[22];
        this.frustumPlanes[5].w = pickRequest.origin[23];
        boolean bl = false;
        if (pickableObject instanceof Node) {
            Object object;
            Node node = (Node)((Object)pickableObject);
            BoundingVolume boundingVolume = node.getBounds();
            this.transformPath[0].setIdentity();
            if (boundingVolume.checkIntersectionFrustum(this.frustumPlanes, this.transformPath[0]) == 0) {
                pickRequest.pickCount = 0;
                return;
            }
            if (boundingVolume instanceof BoundingGeometry) {
                object = (BoundingGeometry)boundingVolume;
                node = ((BoundingGeometry)object).getProxyGeometry();
            }
            if (node instanceof Group) {
                object = (Group)node;
                int n = ((Group)object).numRenderableChildren();
                if (n != 0) {
                    if (node instanceof TransformGroup) {
                        ((TransformGroup)node).getTransform(this.transformPath[0]);
                    }
                    this.validTransform[0] = true;
                    this.pickPath[0] = object;
                    Node[] nodeArray = ((Group)object).getRenderableChild();
                    for (int i = 0; i < n && !bl; ++i) {
                        this.lastPathIndex = 1;
                        if (nodeArray[i] instanceof Group) {
                            bl = this.pickSingleFrustum((Group)nodeArray[i], pickRequest.pickType, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue;
                        }
                        if (nodeArray[i] instanceof SharedNode) {
                            bl = this.pickSingleFrustum((SharedNode)nodeArray[i], pickRequest.pickType, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue;
                        }
                        if (!(nodeArray[i] instanceof Shape3D)) continue;
                        bl = this.pickSingleFrustum((Shape3D)nodeArray[i], pickRequest.pickType, sceneGraphPath, pickRequest.generateVWorldMatrix);
                    }
                }
            } else if (node instanceof SharedNode) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (SharedNode)node;
                this.lastPathIndex = 1;
                bl = this.pickSingleFrustum((SharedNode)node, pickRequest.pickType, sceneGraphPath, pickRequest.generateVWorldMatrix);
            } else if (node instanceof Shape3D) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (Shape3D)node;
                this.lastPathIndex = 1;
                bl = this.pickSingleFrustum((Shape3D)node, pickRequest.pickType, sceneGraphPath, pickRequest.generateVWorldMatrix);
            } else {
                System.out.println("pickSingleFrustum not handling non-shape/group root proxy");
            }
            pickRequest.pickCount = bl ? 1 : 0;
        } else {
            System.out.println("pickSingleFrustum not handling non-node root");
        }
    }

    private boolean pickSingleFrustum(SharedNode sharedNode, int n, SceneGraphPath sceneGraphPath, boolean bl) {
        if ((sharedNode.getPickMask() & n) == 0) {
            return false;
        }
        Node node = sharedNode.getChild();
        if (node instanceof Group) {
            return this.pickSingleFrustum((Group)node, n, sceneGraphPath, bl);
        }
        if (node instanceof SharedNode) {
            return this.pickSingleFrustum((SharedNode)node, n, sceneGraphPath, bl);
        }
        if (node instanceof Shape3D) {
            return this.pickSingleFrustum((Shape3D)node, n, sceneGraphPath, bl);
        }
        return false;
    }

    private boolean pickSingleFrustum(Group group, int n, SceneGraphPath sceneGraphPath, boolean bl) {
        if ((group.getPickMask() & n) == 0) {
            return false;
        }
        BoundingVolume boundingVolume = group.getBounds();
        if (boundingVolume.checkIntersectionFrustum(this.frustumPlanes, this.transformPath[this.lastPathIndex]) == 0) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof Group) {
                return this.pickSingleFrustum((Group)node, n, sceneGraphPath, bl);
            }
            if (node instanceof SharedNode) {
                return this.pickSingleFrustum((SharedNode)node, n, sceneGraphPath, bl);
            }
            if (node instanceof Shape3D) {
                return this.pickSingleFrustum((Shape3D)node, n, sceneGraphPath, bl);
            }
            if (node != null) {
                System.out.println("pickSingleFrustum node handling oddball proxy geom");
            }
        }
        boolean bl2 = false;
        int n2 = group.numRenderableChildren();
        if (n2 != 0) {
            Node[] nodeArray;
            this.resizePath();
            if (group instanceof TransformGroup) {
                nodeArray = this.transformPath[this.lastPathIndex];
                ((TransformGroup)group).getTransform((Matrix4f)nodeArray);
                nodeArray.mul(this.transformPath[this.lastPathIndex - 1], (Matrix4f)nodeArray);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                nodeArray = this.transformPath[this.lastPathIndex - 1];
                this.transformPath[this.lastPathIndex].set((Matrix4f)nodeArray);
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = group;
            ++this.lastPathIndex;
            nodeArray = group.getRenderableChild();
            for (int i = 0; i < n2 && !bl2; ++i) {
                Node node = nodeArray[i];
                if (node == null) continue;
                if (node instanceof Group) {
                    bl2 = this.pickSingleFrustum((Group)node, n, sceneGraphPath, bl);
                    continue;
                }
                if (node instanceof SharedNode) {
                    bl2 = this.pickSingleFrustum((SharedNode)node, n, sceneGraphPath, bl);
                    continue;
                }
                if (!(node instanceof Shape3D)) continue;
                bl2 = this.pickSingleFrustum((Shape3D)node, n, sceneGraphPath, bl);
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
        }
        return bl2;
    }

    private boolean pickSingleFrustum(Shape3D shape3D, int n, SceneGraphPath sceneGraphPath, boolean bl) {
        if ((shape3D.getPickMask() & n) == 0) {
            return false;
        }
        boolean bl2 = false;
        BoundingVolume boundingVolume = shape3D.getBounds();
        if (boundingVolume.checkIntersectionFrustum(this.frustumPlanes, this.transformPath[this.lastPathIndex - 1]) != 0) {
            this.resizePath();
            this.pickPath[this.lastPathIndex] = shape3D;
            this.validTransform[this.lastPathIndex] = false;
            ++this.lastPathIndex;
            if (bl) {
                this.matrixUtils.inverse(this.transformPath[this.lastPathIndex - 2], this.vworldMatrix);
            } else {
                this.vworldMatrix.setIdentity();
            }
            sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.transformPath[this.lastPathIndex - 2], this.vworldMatrix);
            bl2 = true;
            --this.lastPathIndex;
        }
        return bl2;
    }

    private void pickAllFrustum(PickableObject pickableObject, PickRequest pickRequest) {
        int n = 0;
        ArrayList arrayList = null;
        if (pickRequest.foundPaths instanceof ArrayList) {
            arrayList = (ArrayList)pickRequest.foundPaths;
        } else {
            pickRequest.foundPaths = arrayList = new ArrayList();
        }
        this.frustumPlanes[0].x = pickRequest.origin[0];
        this.frustumPlanes[0].y = pickRequest.origin[1];
        this.frustumPlanes[0].z = pickRequest.origin[2];
        this.frustumPlanes[0].w = pickRequest.origin[3];
        this.frustumPlanes[1].x = pickRequest.origin[4];
        this.frustumPlanes[1].y = pickRequest.origin[5];
        this.frustumPlanes[1].z = pickRequest.origin[6];
        this.frustumPlanes[1].w = pickRequest.origin[7];
        this.frustumPlanes[2].x = pickRequest.origin[8];
        this.frustumPlanes[2].y = pickRequest.origin[9];
        this.frustumPlanes[2].z = pickRequest.origin[10];
        this.frustumPlanes[2].w = pickRequest.origin[11];
        this.frustumPlanes[3].x = pickRequest.origin[12];
        this.frustumPlanes[3].y = pickRequest.origin[13];
        this.frustumPlanes[3].z = pickRequest.origin[14];
        this.frustumPlanes[3].w = pickRequest.origin[15];
        this.frustumPlanes[4].x = pickRequest.origin[16];
        this.frustumPlanes[4].y = pickRequest.origin[17];
        this.frustumPlanes[4].z = pickRequest.origin[18];
        this.frustumPlanes[4].w = pickRequest.origin[19];
        this.frustumPlanes[5].x = pickRequest.origin[20];
        this.frustumPlanes[5].y = pickRequest.origin[21];
        this.frustumPlanes[5].z = pickRequest.origin[22];
        this.frustumPlanes[5].w = pickRequest.origin[23];
        if (pickableObject instanceof Node) {
            Object object;
            Node node = (Node)((Object)pickableObject);
            BoundingVolume boundingVolume = node.getBounds();
            this.transformPath[0].setIdentity();
            if (boundingVolume.checkIntersectionFrustum(this.frustumPlanes, this.transformPath[0]) == 0) {
                pickRequest.pickCount = 0;
                return;
            }
            if (boundingVolume instanceof BoundingGeometry) {
                object = (BoundingGeometry)boundingVolume;
                node = ((BoundingGeometry)object).getProxyGeometry();
            }
            if (node instanceof Group) {
                object = (Group)node;
                int n2 = ((Group)object).numRenderableChildren();
                if (n2 != 0) {
                    if (node instanceof TransformGroup) {
                        ((TransformGroup)node).getTransform(this.transformPath[0]);
                    }
                    this.validTransform[0] = true;
                    this.pickPath[0] = object;
                    Node[] nodeArray = ((Group)object).getRenderableChild();
                    for (int i = 0; i < n2; ++i) {
                        this.lastPathIndex = 1;
                        if (nodeArray[i] instanceof Group) {
                            n += this.pickAllFrustum((Group)nodeArray[i], pickRequest.pickType, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue;
                        }
                        if (nodeArray[i] instanceof SharedNode) {
                            n += this.pickAllFrustum((SharedNode)nodeArray[i], pickRequest.pickType, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue;
                        }
                        if (!(nodeArray[i] instanceof Shape3D)) continue;
                        n += this.pickAllFrustum((Shape3D)nodeArray[i], pickRequest.pickType, arrayList, n, pickRequest.generateVWorldMatrix);
                    }
                    pickRequest.pickCount = n;
                }
            } else if (node instanceof SharedNode) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (SharedNode)node;
                this.lastPathIndex = 1;
                pickRequest.pickCount = n += this.pickAllFrustum((SharedNode)node, pickRequest.pickType, arrayList, 0, pickRequest.generateVWorldMatrix);
            } else if (node instanceof Shape3D) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (Shape3D)node;
                this.lastPathIndex = 1;
                pickRequest.pickCount = n += this.pickAllFrustum((Shape3D)node, pickRequest.pickType, arrayList, 0, pickRequest.generateVWorldMatrix);
            } else {
                System.out.println("pickAllFrustum not handling non-shape/group root proxy");
            }
        } else {
            System.out.println("pickAllFrustum not handling non-node root");
        }
    }

    private int pickAllFrustum(SharedNode sharedNode, int n, ArrayList arrayList, int n2, boolean bl) {
        if ((sharedNode.getPickMask() & n) == 0) {
            return 0;
        }
        Node node = sharedNode.getChild();
        if (node instanceof Group) {
            return this.pickAllFrustum((Group)node, n, arrayList, n2, bl);
        }
        if (node instanceof SharedNode) {
            return this.pickAllFrustum((SharedNode)node, n, arrayList, n2, bl);
        }
        if (node instanceof Shape3D) {
            return this.pickAllFrustum((Shape3D)node, n, arrayList, n2, bl);
        }
        return 0;
    }

    private int pickAllFrustum(Group group, int n, ArrayList arrayList, int n2, boolean bl) {
        if ((group.getPickMask() & n) == 0) {
            return 0;
        }
        BoundingVolume boundingVolume = group.getBounds();
        if (boundingVolume.checkIntersectionFrustum(this.frustumPlanes, this.transformPath[this.lastPathIndex - 1]) == 0) {
            return 0;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof Group) {
                return this.pickAllFrustum((Group)node, n, arrayList, n2, bl);
            }
            if (node instanceof SharedNode) {
                return this.pickAllFrustum((SharedNode)node, n, arrayList, n2, bl);
            }
            if (node instanceof Shape3D) {
                return this.pickAllFrustum((Shape3D)node, n, arrayList, n2, bl);
            }
            if (node != null) {
                System.out.println("pickAllFrustum node handling oddball proxy geom");
            }
        }
        int n3 = 0;
        int n4 = group.numRenderableChildren();
        if (n4 != 0) {
            Node[] nodeArray;
            this.resizePath();
            if (group instanceof TransformGroup) {
                nodeArray = this.transformPath[this.lastPathIndex];
                ((TransformGroup)group).getTransform((Matrix4f)nodeArray);
                nodeArray.mul(this.transformPath[this.lastPathIndex - 1], (Matrix4f)nodeArray);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                nodeArray = this.transformPath[this.lastPathIndex - 1];
                this.transformPath[this.lastPathIndex].set((Matrix4f)nodeArray);
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = group;
            ++this.lastPathIndex;
            nodeArray = group.getRenderableChild();
            for (int i = 0; i < n4; ++i) {
                Node node = nodeArray[i];
                if (node == null) continue;
                if (node instanceof Group) {
                    n3 += this.pickAllFrustum((Group)node, n, arrayList, n2 + n3, bl);
                    continue;
                }
                if (node instanceof SharedNode) {
                    n3 += this.pickAllFrustum((SharedNode)node, n, arrayList, n2 + n3, bl);
                    continue;
                }
                if (!(node instanceof Shape3D)) continue;
                n3 += this.pickAllFrustum((Shape3D)node, n, arrayList, n2 + n3, bl);
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
        }
        return n3;
    }

    private int pickAllFrustum(Shape3D shape3D, int n, ArrayList arrayList, int n2, boolean bl) {
        if ((shape3D.getPickMask() & n) == 0) {
            return 0;
        }
        int n3 = 0;
        BoundingVolume boundingVolume = shape3D.getBounds();
        if (boundingVolume.checkIntersectionFrustum(this.frustumPlanes, this.transformPath[this.lastPathIndex - 1]) != 0) {
            SceneGraphPath sceneGraphPath;
            this.resizePath();
            this.pickPath[this.lastPathIndex] = shape3D;
            this.validTransform[this.lastPathIndex] = false;
            ++this.lastPathIndex;
            if (n2 >= arrayList.size()) {
                sceneGraphPath = new SceneGraphPath();
                arrayList.add(sceneGraphPath);
            } else {
                sceneGraphPath = (SceneGraphPath)arrayList.get(n2);
            }
            if (bl) {
                this.matrixUtils.inverse(this.transformPath[this.lastPathIndex - 2], this.vworldMatrix);
            } else {
                this.vworldMatrix.setIdentity();
            }
            sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.transformPath[this.lastPathIndex - 2], this.vworldMatrix);
            n3 = 1;
            --this.lastPathIndex;
        }
        return n3;
    }

    private void pickSphere(PickableObject pickableObject, PickRequest pickRequest) {
        switch (pickRequest.pickSortType) {
            case 1: 
            case 3: {
                this.pickAllSphere(pickableObject, pickRequest);
                break;
            }
            case 2: 
            case 4: {
                this.pickSingleSphere(pickableObject, pickRequest);
                break;
            }
            default: {
                System.out.println("No sort type has been specified");
            }
        }
    }

    private void pickSingleSphere(PickableObject pickableObject, PickRequest pickRequest) {
        SceneGraphPath sceneGraphPath = null;
        if (pickRequest.foundPaths instanceof SceneGraphPath) {
            sceneGraphPath = (SceneGraphPath)pickRequest.foundPaths;
        } else {
            sceneGraphPath = new SceneGraphPath();
            pickRequest.foundPaths = sceneGraphPath;
        }
        boolean bl = false;
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        if (pickableObject instanceof Node) {
            Object object;
            Node node = (Node)((Object)pickableObject);
            BoundingVolume boundingVolume = node.getBounds();
            if (!boundingVolume.checkIntersectionSphere(pickRequest.origin, pickRequest.additionalData)) {
                pickRequest.pickCount = 0;
                return;
            }
            if (boundingVolume instanceof BoundingGeometry) {
                object = (BoundingGeometry)boundingVolume;
                node = ((BoundingGeometry)object).getProxyGeometry();
            }
            if (node instanceof Group) {
                object = (Group)node;
                int n = ((Group)object).numRenderableChildren();
                if (n != 0) {
                    float f = pickRequest.additionalData;
                    if (node instanceof TransformGroup) {
                        ((TransformGroup)node).getTransform(this.transformPath[0]);
                        this.matrixUtils.inverse(this.transformPath[0], this.invertedMatrix);
                        this.transform(this.invertedMatrix, this.start);
                        f *= this.invertedMatrix.getScale();
                    } else {
                        this.transformPath[0].setIdentity();
                    }
                    this.validTransform[0] = true;
                    this.pickPath[0] = object;
                    Node[] nodeArray = ((Group)object).getRenderableChild();
                    for (int i = 0; i < n && !bl; ++i) {
                        this.lastPathIndex = 1;
                        if (nodeArray[i] instanceof Group) {
                            bl = this.pickSingleSphere((Group)nodeArray[i], pickRequest.pickType, this.start, f, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue;
                        }
                        if (nodeArray[i] instanceof SharedNode) {
                            bl = this.pickSingleSphere((SharedNode)nodeArray[i], pickRequest.pickType, this.start, f, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue;
                        }
                        if (!(nodeArray[i] instanceof Shape3D)) continue;
                        bl = this.pickSingleSphere((Shape3D)nodeArray[i], pickRequest.pickType, this.start, f, sceneGraphPath, pickRequest.generateVWorldMatrix);
                    }
                }
            } else if (node instanceof SharedNode) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (SharedNode)node;
                this.lastPathIndex = 1;
                bl = this.pickSingleSphere((SharedNode)node, pickRequest.pickType, this.start, pickRequest.additionalData, sceneGraphPath, pickRequest.generateVWorldMatrix);
            } else if (node instanceof Shape3D) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (Shape3D)node;
                this.lastPathIndex = 1;
                bl = this.pickSingleSphere((Shape3D)node, pickRequest.pickType, this.start, pickRequest.additionalData, sceneGraphPath, pickRequest.generateVWorldMatrix);
            } else {
                System.out.println("pickSingleSphere not handling non-shape/group root proxy");
            }
            pickRequest.pickCount = bl ? 1 : 0;
        } else {
            System.out.println("pickSingleSphere not handling non-node root");
        }
    }

    private boolean pickSingleSphere(SharedNode sharedNode, int n, float[] fArray, float f, SceneGraphPath sceneGraphPath, boolean bl) {
        if ((sharedNode.getPickMask() & n) == 0) {
            return false;
        }
        Node node = sharedNode.getChild();
        if (node instanceof Group) {
            return this.pickSingleSphere((Group)node, n, fArray, f, sceneGraphPath, bl);
        }
        if (node instanceof SharedNode) {
            return this.pickSingleSphere((SharedNode)node, n, fArray, f, sceneGraphPath, bl);
        }
        if (node instanceof Shape3D) {
            return this.pickSingleSphere((Shape3D)node, n, fArray, f, sceneGraphPath, bl);
        }
        return false;
    }

    private boolean pickSingleSphere(Group group, int n, float[] fArray, float f, SceneGraphPath sceneGraphPath, boolean bl) {
        if ((group.getPickMask() & n) == 0) {
            return false;
        }
        BoundingVolume boundingVolume = group.getBounds();
        if (!boundingVolume.checkIntersectionSphere(fArray, f)) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof Group) {
                return this.pickSingleSphere((Group)node, n, fArray, f, sceneGraphPath, bl);
            }
            if (node instanceof SharedNode) {
                return this.pickSingleSphere((SharedNode)node, n, fArray, f, sceneGraphPath, bl);
            }
            if (node instanceof Shape3D) {
                return this.pickSingleSphere((Shape3D)node, n, fArray, f, sceneGraphPath, bl);
            }
            if (node != null) {
                System.out.println("pickSingleSphere node handling oddball proxy geom");
            }
        }
        boolean bl2 = false;
        int n2 = group.numRenderableChildren();
        if (n2 != 0) {
            Node[] nodeArray;
            this.resizePath();
            float f2 = fArray[0];
            float f3 = fArray[1];
            float f4 = fArray[2];
            float f5 = f;
            if (group instanceof TransformGroup) {
                nodeArray = this.transformPath[this.lastPathIndex];
                ((TransformGroup)group).getTransform((Matrix4f)nodeArray);
                this.matrixUtils.inverse((Matrix4f)nodeArray, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                f *= this.invertedMatrix.getScale();
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = group;
            ++this.lastPathIndex;
            nodeArray = group.getRenderableChild();
            for (int i = 0; i < n2 && !bl2; ++i) {
                Node node = nodeArray[i];
                if (node == null) continue;
                if (node instanceof Group) {
                    bl2 = this.pickSingleSphere((Group)node, n, fArray, f, sceneGraphPath, bl);
                    continue;
                }
                if (node instanceof SharedNode) {
                    bl2 = this.pickSingleSphere((SharedNode)node, n, fArray, f, sceneGraphPath, bl);
                    continue;
                }
                if (!(node instanceof Shape3D)) continue;
                bl2 = this.pickSingleSphere((Shape3D)node, n, fArray, f, sceneGraphPath, bl);
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f2;
            fArray[1] = f3;
            fArray[2] = f4;
            f = f5;
        }
        return bl2;
    }

    private boolean pickSingleSphere(Shape3D shape3D, int n, float[] fArray, float f, SceneGraphPath sceneGraphPath, boolean bl) {
        if ((shape3D.getPickMask() & n) == 0) {
            return false;
        }
        boolean bl2 = false;
        BoundingVolume boundingVolume = shape3D.getBounds();
        if (boundingVolume.checkIntersectionSphere(fArray, f)) {
            this.resizePath();
            this.pickPath[this.lastPathIndex] = shape3D;
            this.validTransform[this.lastPathIndex] = false;
            ++this.lastPathIndex;
            if (bl) {
                this.buildVWorldTransform();
            } else {
                this.vworldMatrix.setIdentity();
            }
            sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
            --this.lastPathIndex;
            bl2 = true;
        }
        return bl2;
    }

    private void pickAllSphere(PickableObject pickableObject, PickRequest pickRequest) {
        int n = 0;
        ArrayList arrayList = null;
        if (pickRequest.foundPaths instanceof ArrayList) {
            arrayList = (ArrayList)pickRequest.foundPaths;
        } else {
            pickRequest.foundPaths = arrayList = new ArrayList();
        }
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        if (pickableObject instanceof Node) {
            Object object;
            Node node = (Node)((Object)pickableObject);
            BoundingVolume boundingVolume = node.getBounds();
            if (!boundingVolume.checkIntersectionSphere(pickRequest.origin, pickRequest.additionalData)) {
                pickRequest.pickCount = 0;
                return;
            }
            if (boundingVolume instanceof BoundingGeometry) {
                object = (BoundingGeometry)boundingVolume;
                node = ((BoundingGeometry)object).getProxyGeometry();
            }
            if (node instanceof Group) {
                object = (Group)node;
                int n2 = ((Group)object).numRenderableChildren();
                if (n2 != 0) {
                    float f = pickRequest.additionalData;
                    if (node instanceof TransformGroup) {
                        ((TransformGroup)node).getTransform(this.transformPath[0]);
                        this.matrixUtils.inverse(this.transformPath[0], this.invertedMatrix);
                        this.transform(this.invertedMatrix, this.start);
                        f *= this.invertedMatrix.getScale();
                    } else {
                        this.transformPath[0].setIdentity();
                    }
                    this.validTransform[0] = true;
                    this.pickPath[0] = object;
                    Node[] nodeArray = ((Group)object).getRenderableChild();
                    for (int i = 0; i < n2; ++i) {
                        this.lastPathIndex = 1;
                        if (nodeArray[i] instanceof Group) {
                            n += this.pickAllSphere((Group)nodeArray[i], pickRequest.pickType, this.start, f, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue;
                        }
                        if (nodeArray[i] instanceof SharedNode) {
                            n += this.pickAllSphere((SharedNode)nodeArray[i], pickRequest.pickType, this.start, f, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue;
                        }
                        if (!(nodeArray[i] instanceof Shape3D)) continue;
                        n += this.pickAllSphere((Shape3D)nodeArray[i], pickRequest.pickType, this.start, f, arrayList, n, pickRequest.generateVWorldMatrix);
                    }
                    pickRequest.pickCount = n;
                }
            } else if (node instanceof SharedNode) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (SharedNode)node;
                this.lastPathIndex = 1;
                pickRequest.pickCount = n += this.pickAllSphere((SharedNode)node, pickRequest.pickType, this.start, pickRequest.additionalData, arrayList, 0, pickRequest.generateVWorldMatrix);
            } else if (node instanceof Shape3D) {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (Shape3D)node;
                this.lastPathIndex = 1;
                pickRequest.pickCount = n += this.pickAllSphere((Shape3D)node, pickRequest.pickType, this.start, pickRequest.additionalData, arrayList, 0, pickRequest.generateVWorldMatrix);
            } else {
                System.out.println("pickAllSphere not handling non-shape/group root proxy");
            }
        } else {
            System.out.println("pickAllSphere not handling non-node root");
        }
    }

    private int pickAllSphere(Group group, int n, float[] fArray, float f, ArrayList arrayList, int n2, boolean bl) {
        if ((group.getPickMask() & n) == 0) {
            return 0;
        }
        BoundingVolume boundingVolume = group.getBounds();
        if (!boundingVolume.checkIntersectionSphere(fArray, f)) {
            return 0;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof Group) {
                return this.pickAllSphere((Group)node, n, fArray, f, arrayList, n2, bl);
            }
            if (node instanceof SharedNode) {
                return this.pickAllSphere((SharedNode)node, n, fArray, f, arrayList, n2, bl);
            }
            if (node instanceof Shape3D) {
                return this.pickAllSphere((Shape3D)node, n, fArray, f, arrayList, n2, bl);
            }
            if (node != null) {
                System.out.println("pickAllSphere node handling oddball proxy geom");
            }
        }
        int n3 = 0;
        int n4 = group.numRenderableChildren();
        if (n4 != 0) {
            Node[] nodeArray;
            this.resizePath();
            float f2 = fArray[0];
            float f3 = fArray[1];
            float f4 = fArray[2];
            float f5 = f;
            if (group instanceof TransformGroup) {
                nodeArray = this.transformPath[this.lastPathIndex];
                ((TransformGroup)group).getTransform((Matrix4f)nodeArray);
                this.matrixUtils.inverse((Matrix4f)nodeArray, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                f *= this.invertedMatrix.getScale();
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = group;
            ++this.lastPathIndex;
            nodeArray = group.getRenderableChild();
            for (int i = 0; i < n4; ++i) {
                Node node = nodeArray[i];
                if (node == null) continue;
                if (node instanceof Group) {
                    n3 += this.pickAllSphere((Group)node, n, fArray, f, arrayList, n2 + n3, bl);
                    continue;
                }
                if (node instanceof SharedNode) {
                    n3 += this.pickAllSphere((SharedNode)node, n, fArray, f, arrayList, n2 + n3, bl);
                    continue;
                }
                if (!(node instanceof Shape3D)) continue;
                n3 += this.pickAllSphere((Shape3D)node, n, fArray, f, arrayList, n2 + n3, bl);
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f2;
            fArray[1] = f3;
            fArray[2] = f4;
            f = f5;
        }
        return n3;
    }

    private int pickAllSphere(SharedNode sharedNode, int n, float[] fArray, float f, ArrayList arrayList, int n2, boolean bl) {
        if ((sharedNode.getPickMask() & n) == 0) {
            return 0;
        }
        Node node = sharedNode.getChild();
        if (node instanceof Group) {
            return this.pickAllSphere((Group)node, n, fArray, f, arrayList, n2, bl);
        }
        if (node instanceof SharedNode) {
            return this.pickAllSphere((SharedNode)node, n, fArray, f, arrayList, n2, bl);
        }
        if (node instanceof Shape3D) {
            return this.pickAllSphere((Shape3D)node, n, fArray, f, arrayList, n2, bl);
        }
        return 0;
    }

    private int pickAllSphere(Shape3D shape3D, int n, float[] fArray, float f, ArrayList arrayList, int n2, boolean bl) {
        if ((shape3D.getPickMask() & n) == 0) {
            return 0;
        }
        int n3 = 0;
        BoundingVolume boundingVolume = shape3D.getBounds();
        if (boundingVolume.checkIntersectionSphere(fArray, f)) {
            SceneGraphPath sceneGraphPath;
            this.resizePath();
            this.pickPath[this.lastPathIndex] = shape3D;
            this.validTransform[this.lastPathIndex] = false;
            ++this.lastPathIndex;
            if (n2 >= arrayList.size()) {
                sceneGraphPath = new SceneGraphPath();
                arrayList.add(sceneGraphPath);
            } else {
                sceneGraphPath = (SceneGraphPath)arrayList.get(n2);
            }
            if (bl) {
                this.buildVWorldTransform();
            } else {
                this.vworldMatrix.setIdentity();
            }
            sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
            --this.lastPathIndex;
            n3 = 1;
        }
        return n3;
    }

    private final void resizePath() {
        if (this.lastPathIndex == this.pickPath.length) {
            int n = this.pickPath.length;
            int n2 = n + 8;
            Node[] nodeArray = new Node[n2];
            System.arraycopy(this.pickPath, 0, nodeArray, 0, n);
            this.pickPath = nodeArray;
            Matrix4f[] matrix4fArray = new Matrix4f[n2];
            System.arraycopy(this.transformPath, 0, matrix4fArray, 0, n);
            this.transformPath = matrix4fArray;
            for (int i = n; i < n2; ++i) {
                this.transformPath[i] = new Matrix4f();
            }
            boolean[] blArray = new boolean[n2];
            System.arraycopy(this.validTransform, 0, blArray, 0, n);
            this.validTransform = blArray;
        }
    }

    private void transform(Matrix4f matrix4f, float[] fArray) {
        this.wkVec.set(fArray);
        matrix4f.transform((Tuple4f)this.wkVec);
        this.wkVec.get(fArray);
    }

    private void transformNormal(Matrix4f matrix4f, float[] fArray) {
        this.wkNormal.set(fArray);
        matrix4f.transform(this.wkNormal);
        this.wkNormal.get(fArray);
    }

    private void buildVWorldTransform() {
        boolean bl = false;
        this.vworldMatrix.set(this.transformPath[0]);
        for (int i = 1; i < this.lastPathIndex; ++i) {
            if (!this.validTransform[i]) continue;
            this.vworldMatrix.mul(this.transformPath[i]);
        }
        this.matrixUtils.inverse(this.vworldMatrix, this.invertedMatrix);
    }
}

