/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline;

import org.j3d.aviatrix3d.CullStage;
import org.j3d.aviatrix3d.DrawableSurface;
import org.j3d.aviatrix3d.Layer;
import org.j3d.aviatrix3d.RenderPipeline;
import org.j3d.aviatrix3d.Scene;
import org.j3d.aviatrix3d.SortStage;
import org.j3d.aviatrix3d.pipeline.CullToSingleSortListener;
import org.j3d.aviatrix3d.pipeline.SortToSingleDrawListener;

public class DefaultRenderPipeline
implements RenderPipeline {
    private CullStage culler;
    private SortStage sorter;
    private DrawableSurface drawable;
    private CullToSingleSortListener ctsListener = new CullToSingleSortListener();
    private SortToSingleDrawListener stdListener = new SortToSingleDrawListener();
    private Scene sceneRoot;
    private float[] screenOrientation = new float[4];
    private float[] eyePoint = new float[3];
    private boolean useOrientation = false;
    private boolean useEyePoint = false;

    public DefaultRenderPipeline() {
    }

    public DefaultRenderPipeline(CullStage cullStage, SortStage sortStage) {
        this();
        this.culler = cullStage;
        this.sorter = sortStage;
        if (cullStage != null) {
            cullStage.setCulledGeometryReceiver(this.ctsListener);
        }
        if (sortStage != null) {
            this.ctsListener.setSorter(sortStage);
            sortStage.setSortedGeometryReceiver(this.stdListener);
        }
    }

    public void setDrawableSurface(DrawableSurface drawableSurface) {
        this.stdListener.setSurface(drawableSurface);
        this.drawable = drawableSurface;
    }

    public DrawableSurface getDrawableSurface() {
        return this.drawable;
    }

    public void render() {
        if (this.sceneRoot == null) {
            return;
        }
        if (this.culler != null) {
            this.culler.cull(this.sceneRoot, 0);
            if (this.drawable != null) {
                this.drawable.draw();
            }
        }
    }

    public void displayOnly() {
        if (this.sceneRoot != null && this.drawable != null) {
            this.drawable.draw();
        }
    }

    public void swapBuffers() {
        if (this.drawable != null) {
            this.drawable.swap();
        }
    }

    public void setRenderableScene(Scene scene) {
        this.sceneRoot = scene;
    }

    public void setRenderableLayers(Layer[] layerArray, int n) {
    }

    public void setEyePointOffset(float f, float f2, float f3) {
        if (this.culler != null) {
            this.culler.setEyePointOffset(f, f2, f3);
        }
        this.useEyePoint = true;
        this.eyePoint[0] = f;
        this.eyePoint[1] = f2;
        this.eyePoint[2] = f3;
    }

    public void setScreenOrientation(float f, float f2, float f3, float f4) throws IllegalArgumentException {
        if (this.culler != null) {
            this.culler.setScreenOrientation(f, f2, f3, f4);
        }
        this.useOrientation = true;
        this.screenOrientation[0] = f;
        this.screenOrientation[1] = f2;
        this.screenOrientation[2] = f3;
        this.screenOrientation[3] = f4;
    }

    public void halt() {
        if (this.culler != null) {
            this.culler.halt();
        }
        if (this.sorter != null) {
            this.sorter.halt();
        }
    }

    public void setSorter(SortStage sortStage) {
        this.ctsListener.setSorter(sortStage);
        if (this.sorter != null) {
            this.sorter.setSortedGeometryReceiver(null);
        }
        if (sortStage != null) {
            sortStage.setSortedGeometryReceiver(this.stdListener);
        }
        this.sorter = sortStage;
    }

    public void setCuller(CullStage cullStage) {
        if (this.culler != null) {
            this.culler.setCulledGeometryReceiver(null);
        }
        if (cullStage != null) {
            cullStage.setCulledGeometryReceiver(this.ctsListener);
            if (this.useEyePoint) {
                cullStage.setEyePointOffset(this.eyePoint[0], this.eyePoint[1], this.eyePoint[2]);
            }
            if (this.useOrientation) {
                cullStage.setScreenOrientation(this.screenOrientation[0], this.screenOrientation[1], this.screenOrientation[2], this.screenOrientation[3]);
            }
        }
        this.culler = cullStage;
    }
}

