/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline;

import java.util.HashMap;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import org.j3d.aviatrix3d.Appearance;
import org.j3d.aviatrix3d.BoundingVolume;
import org.j3d.aviatrix3d.ClipDetails;
import org.j3d.aviatrix3d.CullOutputDetails;
import org.j3d.aviatrix3d.CustomRenderable;
import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.LightDetails;
import org.j3d.aviatrix3d.Material;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.PBufferTextureSource;
import org.j3d.aviatrix3d.RenderDetails;
import org.j3d.aviatrix3d.RenderEnvironmentData;
import org.j3d.aviatrix3d.RenderInstructions;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.SortStage;
import org.j3d.aviatrix3d.SortedGeometryReceiver;
import org.j3d.aviatrix3d.Texture;
import org.j3d.aviatrix3d.TextureUnit;
import org.j3d.util.MatrixUtils;

public class DepthSortedTransparencyStage
implements SortStage {
    private static final String INVALID_DEPTH_MSG = "The depthBits must be greater than or equal to 1";
    private static final int LIST_START_SIZE = 1;
    private static final int TRANSPARENT_LIST_SIZE = 200;
    private static final int DEFAULT_DEPTH_BITS = 16;
    private final int depthAccuracy;
    private SortedGeometryReceiver receiver;
    private RenderInstructions[] commandList;
    private CullOutputDetails[] transparentList;
    private CullOutputDetails[] unsortedTransparentList;
    private float[] depthList1;
    private int[] depthList2;
    private int[] countList;
    private TextureUnit[] textureTmp;
    private int lastGlobalId;
    private HashMap instructionMap;
    private Matrix4f modelMatrix;
    private Matrix4f cameraMatrix;
    private Point3f wkPoint;
    private float[] center;
    private MatrixUtils matrixUtils;
    private boolean terminate;

    public DepthSortedTransparencyStage() {
        this(1, 16);
    }

    public DepthSortedTransparencyStage(int n) {
        this(n, 16);
    }

    public DepthSortedTransparencyStage(int n, int n2) {
        int n3;
        if (n2 < 1) {
            throw new IllegalArgumentException(INVALID_DEPTH_MSG);
        }
        int n4 = 1;
        for (n3 = 1; n3 < n2; ++n3) {
            n4 <<= 1;
        }
        this.depthAccuracy = n4;
        this.transparentList = new CullOutputDetails[200];
        this.unsortedTransparentList = new CullOutputDetails[200];
        this.depthList1 = new float[200];
        this.depthList2 = new int[200];
        this.countList = new int[this.depthAccuracy];
        this.textureTmp = new TextureUnit[32];
        this.instructionMap = new HashMap();
        this.wkPoint = new Point3f();
        this.modelMatrix = new Matrix4f();
        this.cameraMatrix = new Matrix4f();
        this.center = new float[3];
        this.lastGlobalId = 0;
        this.commandList = new RenderInstructions[n];
        for (n3 = 0; n3 < n; ++n3) {
            this.commandList[n3] = new RenderInstructions();
        }
        this.matrixUtils = new MatrixUtils();
    }

    public void sort(RenderEnvironmentData[] renderEnvironmentDataArray, CullOutputDetails[][] cullOutputDetailsArray, int[] nArray, SceneGraphObject[][] sceneGraphObjectArray, int n, int n2) {
        int n3;
        this.terminate = false;
        if (this.commandList.length < n) {
            RenderInstructions[] renderInstructionsArray = new RenderInstructions[n];
            System.arraycopy(this.commandList, 0, renderInstructionsArray, 0, this.commandList.length);
            for (n3 = this.commandList.length; n3 < n; ++n3) {
                renderInstructionsArray[n3] = new RenderInstructions();
            }
            this.commandList = renderInstructionsArray;
        }
        int n4 = 0;
        n3 = 0;
        for (int i = 0; i < n && !this.terminate; ++i) {
            if (sceneGraphObjectArray[i][0] == null) {
                n4 = i;
                continue;
            }
            this.commandList[n3].pbuffer = (PBufferTextureSource)((Object)sceneGraphObjectArray[i][0]);
            this.commandList[n3].parentSource = (PBufferTextureSource)((Object)sceneGraphObjectArray[i][1]);
            this.commandList[n3].renderData = renderEnvironmentDataArray[i];
            RenderInstructions renderInstructions = (RenderInstructions)this.instructionMap.get(sceneGraphObjectArray[i][0]);
            if (renderInstructions != null) {
                this.commandList[n3].copyOf = renderInstructions;
            } else {
                this.commandList[n3].copyOf = null;
                this.sortSingle(renderEnvironmentDataArray[i].viewTransform, cullOutputDetailsArray[i], nArray[i], this.commandList[n3]);
                this.instructionMap.put(sceneGraphObjectArray[i][0], this.commandList[n3]);
            }
            ++n3;
        }
        if (this.terminate) {
            this.instructionMap.clear();
            return;
        }
        this.commandList[n3].pbuffer = null;
        this.commandList[n3].renderData = renderEnvironmentDataArray[n4];
        this.sortSingle(renderEnvironmentDataArray[n4].viewTransform, cullOutputDetailsArray[n4], nArray[n4], this.commandList[n3]);
        if (this.terminate) {
            this.instructionMap.clear();
            return;
        }
        ++n3;
        if (this.receiver != null) {
            this.receiver.sortedOutput(this.commandList, n);
        }
        this.instructionMap.clear();
    }

    public void setSortedGeometryReceiver(SortedGeometryReceiver sortedGeometryReceiver) {
        this.receiver = sortedGeometryReceiver;
    }

    public void halt() {
        this.terminate = true;
    }

    private void sortSingle(Matrix4f matrix4f, CullOutputDetails[] cullOutputDetailsArray, int n, RenderInstructions renderInstructions) {
        int n2;
        int n3;
        Object object;
        SceneGraphObject sceneGraphObject;
        int n4;
        int n5;
        int n6 = 2 + n << 1;
        for (n5 = 0; n5 < n; ++n5) {
            n6 += cullOutputDetailsArray[n5].numLights << 1;
        }
        if (renderInstructions.renderList.length < n6) {
            RenderDetails[] renderDetailsArray = new RenderDetails[n6];
            System.arraycopy(renderInstructions.renderList, 0, renderDetailsArray, 0, renderInstructions.renderList.length);
            for (n4 = renderInstructions.renderList.length; n4 < n6; ++n4) {
                renderDetailsArray[n4] = new RenderDetails();
            }
            renderInstructions.renderList = renderDetailsArray;
            renderInstructions.renderOps = new int[n6];
        }
        if (this.transparentList.length < n6) {
            this.transparentList = new CullOutputDetails[n6];
            this.unsortedTransparentList = new CullOutputDetails[n6];
            this.depthList1 = new float[n6];
            this.depthList2 = new int[n6];
        }
        n5 = 0;
        n4 = 0;
        for (int i = 0; i < n && !this.terminate; ++i) {
            if (cullOutputDetailsArray[i].renderable instanceof Shape3D) {
                Shape3D shape3D = (Shape3D)cullOutputDetailsArray[i].renderable;
                Appearance appearance = shape3D.getAppearance();
                if (appearance != null) {
                    sceneGraphObject = appearance.getBlendAttributes();
                    if (sceneGraphObject != null) {
                        this.unsortedTransparentList[n4++] = cullOutputDetailsArray[i];
                        continue;
                    }
                    object = appearance.getMaterial();
                    if (object != null && ((Material)object).getTransparency() != 1.0f) {
                        this.unsortedTransparentList[n4++] = cullOutputDetailsArray[i];
                        continue;
                    }
                    n3 = appearance.numTextureUnits();
                    if (n3 != 0) {
                        boolean bl = false;
                        appearance.getTextureUnits(this.textureTmp);
                        for (int j = 0; j < n3; ++j) {
                            Texture texture = this.textureTmp[j].getTexture();
                            if (texture == null) continue;
                            switch (texture.getFormat()) {
                                case 6406: 
                                case 6408: 
                                case 6410: {
                                    this.unsortedTransparentList[n4++] = cullOutputDetailsArray[i];
                                    bl = true;
                                    j = n3;
                                }
                            }
                        }
                        if (bl) continue;
                    }
                }
                if (((Geometry)(sceneGraphObject = shape3D.getGeometry())).hasTransparency()) {
                    this.unsortedTransparentList[n4++] = cullOutputDetailsArray[i];
                    continue;
                }
            } else if (cullOutputDetailsArray[i].renderable instanceof CustomRenderable) {
                if (((CustomRenderable)cullOutputDetailsArray[i].renderable).hasTransparency()) {
                    this.unsortedTransparentList[n4++] = cullOutputDetailsArray[i];
                    continue;
                }
            } else {
                System.out.println("Non-shape node in sorter " + cullOutputDetailsArray[i].renderable);
                continue;
            }
            n5 = this.appendOutputShape(n5, cullOutputDetailsArray[i], renderInstructions);
        }
        switch (n4) {
            case 0: {
                renderInstructions.numValid = n5;
                return;
            }
            case 1: {
                renderInstructions.renderOps[n5++] = 11;
                n5 = this.appendOutputShape(n5, this.unsortedTransparentList[0], renderInstructions);
                this.unsortedTransparentList[0] = null;
                renderInstructions.renderOps[n5++] = 12;
                renderInstructions.numValid = n5;
                return;
            }
        }
        float f = Float.NEGATIVE_INFINITY;
        float f2 = Float.POSITIVE_INFINITY;
        this.matrixUtils.inverse(matrix4f, this.cameraMatrix);
        for (int i = 0; i < n4 && !this.terminate; ++i) {
            this.modelMatrix.set(this.unsortedTransparentList[i].transform);
            sceneGraphObject = (Shape3D)this.unsortedTransparentList[i].renderable;
            object = ((Node)sceneGraphObject).getBounds();
            ((BoundingVolume)object).getCenter(this.center);
            this.wkPoint.x = this.center[0];
            this.wkPoint.y = this.center[1];
            this.wkPoint.z = this.center[2];
            this.modelMatrix.transform(this.wkPoint);
            this.cameraMatrix.transform(this.wkPoint);
            this.depthList1[i] = this.wkPoint.z;
            if (f < this.wkPoint.z) {
                f = this.wkPoint.z;
            }
            if (!(f2 > this.wkPoint.z)) continue;
            f2 = this.wkPoint.z;
        }
        float f3 = f - f2;
        float f4 = (float)(this.depthAccuracy - 1) / f3;
        for (n2 = 0; n2 < n4; ++n2) {
            this.depthList2[n2] = (int)((this.depthList1[n2] - f2) * f4);
        }
        if (this.terminate) {
            return;
        }
        for (n2 = 0; n2 < this.depthAccuracy; ++n2) {
            this.countList[n2] = 0;
        }
        if (this.terminate) {
            return;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            int n7 = this.depthList2[n2];
            this.countList[n7] = this.countList[n7] + 1;
        }
        if (this.terminate) {
            return;
        }
        for (n2 = 1; n2 < this.depthAccuracy; ++n2) {
            int n8 = n2;
            this.countList[n8] = this.countList[n8] + this.countList[n2 - 1];
        }
        if (this.terminate) {
            return;
        }
        n2 = n4;
        while (--n2 >= 0 && !this.terminate) {
            n3 = this.depthList2[n2];
            this.transparentList[this.countList[n3] - 1] = this.unsortedTransparentList[n2];
            int n9 = n3;
            this.countList[n9] = this.countList[n9] - 1;
        }
        renderInstructions.renderOps[n5++] = 11;
        for (n2 = 0; n2 < n4 && !this.terminate; ++n2) {
            n5 = this.appendOutputShape(n5, this.transparentList[n2], renderInstructions);
            this.transparentList[n2] = null;
        }
        renderInstructions.renderOps[n5++] = 12;
        renderInstructions.numValid = n5;
    }

    private int appendOutputShape(int n, CullOutputDetails cullOutputDetails, RenderInstructions renderInstructions) {
        Object object;
        Object object2;
        int n2;
        if (cullOutputDetails.numLights != 0) {
            for (n2 = 0; n2 < cullOutputDetails.numLights; ++n2) {
                object2 = cullOutputDetails.lights[n2];
                renderInstructions.renderList[n].renderable = ((LightDetails)object2).getLight();
                System.arraycopy(((LightDetails)object2).getTransform(), 0, renderInstructions.renderList[n].transform, 0, 16);
                ++this.lastGlobalId;
                renderInstructions.renderList[n].id = renderInstructions.renderList[n].id;
                renderInstructions.renderOps[n] = 9;
                ++n;
            }
        }
        if (cullOutputDetails.numClipPlanes != 0) {
            for (n2 = 0; n2 < cullOutputDetails.numClipPlanes; ++n2) {
                object2 = cullOutputDetails.clipPlanes[n2];
                renderInstructions.renderList[n].renderable = ((ClipDetails)object2).getClipPlane();
                System.arraycopy(((ClipDetails)object2).getTransform(), 0, renderInstructions.renderList[n].transform, 0, 16);
                ++this.lastGlobalId;
                renderInstructions.renderList[n].id = renderInstructions.renderList[n].id;
                renderInstructions.renderOps[n] = 17;
                ++n;
            }
        }
        n2 = 0;
        if (cullOutputDetails.localFog != null) {
            renderInstructions.renderList[n].id = n2 = this.lastGlobalId++;
            renderInstructions.renderList[n].renderable = cullOutputDetails.localFog;
            renderInstructions.renderOps[n] = 19;
            ++n;
        }
        if (cullOutputDetails.renderable instanceof Shape3D) {
            renderInstructions.renderList[n].renderable = cullOutputDetails.renderable;
            renderInstructions.renderList[n].transform[0] = cullOutputDetails.transform.m00;
            renderInstructions.renderList[n].transform[1] = cullOutputDetails.transform.m10;
            renderInstructions.renderList[n].transform[2] = cullOutputDetails.transform.m20;
            renderInstructions.renderList[n].transform[3] = cullOutputDetails.transform.m30;
            renderInstructions.renderList[n].transform[4] = cullOutputDetails.transform.m01;
            renderInstructions.renderList[n].transform[5] = cullOutputDetails.transform.m11;
            renderInstructions.renderList[n].transform[6] = cullOutputDetails.transform.m21;
            renderInstructions.renderList[n].transform[7] = cullOutputDetails.transform.m31;
            renderInstructions.renderList[n].transform[8] = cullOutputDetails.transform.m02;
            renderInstructions.renderList[n].transform[9] = cullOutputDetails.transform.m12;
            renderInstructions.renderList[n].transform[10] = cullOutputDetails.transform.m22;
            renderInstructions.renderList[n].transform[11] = cullOutputDetails.transform.m32;
            renderInstructions.renderList[n].transform[12] = cullOutputDetails.transform.m03;
            renderInstructions.renderList[n].transform[13] = cullOutputDetails.transform.m13;
            renderInstructions.renderList[n].transform[14] = cullOutputDetails.transform.m23;
            renderInstructions.renderList[n].transform[15] = cullOutputDetails.transform.m33;
            renderInstructions.renderOps[n] = 1;
            renderInstructions.renderList[++n].renderable = cullOutputDetails.renderable;
            renderInstructions.renderOps[n] = 2;
            ++n;
        } else if (cullOutputDetails.renderable instanceof CustomRenderable) {
            renderInstructions.renderList[n].renderable = cullOutputDetails.renderable;
            renderInstructions.renderList[n].instructions = cullOutputDetails.customData;
            object2 = cullOutputDetails.transform;
            renderInstructions.renderList[n].transform[0] = ((Matrix4f)object2).m00;
            renderInstructions.renderList[n].transform[1] = ((Matrix4f)object2).m10;
            renderInstructions.renderList[n].transform[2] = ((Matrix4f)object2).m20;
            renderInstructions.renderList[n].transform[3] = ((Matrix4f)object2).m30;
            renderInstructions.renderList[n].transform[4] = ((Matrix4f)object2).m01;
            renderInstructions.renderList[n].transform[5] = ((Matrix4f)object2).m11;
            renderInstructions.renderList[n].transform[6] = ((Matrix4f)object2).m21;
            renderInstructions.renderList[n].transform[7] = ((Matrix4f)object2).m31;
            renderInstructions.renderList[n].transform[8] = ((Matrix4f)object2).m02;
            renderInstructions.renderList[n].transform[9] = ((Matrix4f)object2).m12;
            renderInstructions.renderList[n].transform[10] = ((Matrix4f)object2).m22;
            renderInstructions.renderList[n].transform[11] = ((Matrix4f)object2).m32;
            renderInstructions.renderList[n].transform[12] = ((Matrix4f)object2).m03;
            renderInstructions.renderList[n].transform[13] = ((Matrix4f)object2).m13;
            renderInstructions.renderList[n].transform[14] = ((Matrix4f)object2).m23;
            renderInstructions.renderList[n].transform[15] = ((Matrix4f)object2).m33;
            renderInstructions.renderOps[n] = 4;
            ++n;
        }
        if (cullOutputDetails.localFog != null) {
            renderInstructions.renderList[n].id = n2;
            renderInstructions.renderList[n].renderable = cullOutputDetails.localFog;
            renderInstructions.renderOps[n] = 20;
            ++n;
        }
        if (cullOutputDetails.numClipPlanes != 0) {
            for (int i = cullOutputDetails.numClipPlanes - 1; i >= 0; --i) {
                object = cullOutputDetails.clipPlanes[i];
                renderInstructions.renderList[n].renderable = ((ClipDetails)object).getClipPlane();
                renderInstructions.renderList[n].id = this.lastGlobalId - (1 + i);
                renderInstructions.renderOps[n] = 18;
                ++n;
            }
        }
        if (cullOutputDetails.numLights != 0) {
            for (int i = cullOutputDetails.numLights - 1; i >= 0; --i) {
                object = cullOutputDetails.lights[i];
                renderInstructions.renderList[n].renderable = ((LightDetails)object).getLight();
                renderInstructions.renderList[n].id = this.lastGlobalId - (1 + i);
                renderInstructions.renderOps[n] = 10;
                ++n;
            }
        }
        return n;
    }
}

