/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.j3d.aviatrix3d.ApplicationUpdateObserver;
import org.j3d.aviatrix3d.AudioPipeline;
import org.j3d.aviatrix3d.DeletableSceneGraphObject;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.InternalNodeUpdateListener;
import org.j3d.aviatrix3d.InvalidListenerSetTimingException;
import org.j3d.aviatrix3d.Layer;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.PickingHandler;
import org.j3d.aviatrix3d.RenderPipeline;
import org.j3d.aviatrix3d.RenderPipelineManager;
import org.j3d.aviatrix3d.Scene;
import org.j3d.aviatrix3d.ShaderSceneGraphObject;
import org.j3d.aviatrix3d.pipeline.AudioPipelineThread;
import org.j3d.aviatrix3d.pipeline.DefaultPickingHandler;
import org.j3d.aviatrix3d.pipeline.PipelineStateObserver;
import org.j3d.aviatrix3d.pipeline.PipelineThread;
import org.j3d.aviatrix3d.pipeline.ShutdownThread;
import org.j3d.aviatrix3d.pipeline.ThreadPrivilegedAction;
import org.j3d.aviatrix3d.pipeline.WorldRootGroup;
import org.j3d.util.HashSet;

public class MultiThreadRenderManager
implements Runnable,
NodeUpdateHandler,
RenderPipelineManager,
PipelineStateObserver {
    private static final String ACTIVE_RENDERING_MSG = "You cannot make this call now because the system is currently rendering. To make this call, first disable the rendering. ";
    private static final int CHANGELIST_START_SIZE = 200;
    private static final int CHANGELIST_INCREMENT = 100;
    private static final int SHADERLIST_START_SIZE = 64;
    private static final int SHADERLIST_INCREMENT = 32;
    private WorldRootGroup root;
    private Scene worldScene;
    private NodeUpdateListener[] dataChangeList;
    private NodeUpdateListener[] boundsChangeList;
    private Object[] dataSourceList;
    private Object[] boundsSourceList;
    private InternalNodeUpdateListener[] boundsInternalList;
    private int lastDataChangeItem;
    private int lastBoundsChangeItem;
    private HashSet dataChangeListenerSet;
    private HashSet dataChangeSrcSet;
    private HashSet boundsChangeListenerSet;
    private HashSet boundsChangeSrcSet;
    private ShaderSceneGraphObject[] shaderInitList;
    private ShaderSceneGraphObject[] shaderLogList;
    private int lastShaderInitItem;
    private int lastShaderLogItem;
    private HashSet shaderInitSet;
    private HashSet shaderLogSet;
    private RenderPipeline[] pipeline;
    private AudioPipeline[] audioPipeline;
    private PipelineThread[] pipelineThread;
    private AudioPipelineThread[] audioPipelineThread;
    private int numPipelines;
    private int numAudioPipelines;
    private PickingHandler pickHandler;
    private int minimumCycleTime;
    private boolean enabled = false;
    private Thread runtimeThread;
    private boolean terminate = false;
    private ApplicationUpdateObserver observer;
    private ReferenceQueue deletionQueue;
    private boolean pickPermitted = false;
    private Object writableBoundsObject;
    private Object writableDataObject;
    private Object frameFinishLock;
    private int completedFrameCount;
    private Object renderWaitLock;
    private boolean processing = false;
    private boolean sceneChanged = false;
    private Thread shutdownThread;

    public MultiThreadRenderManager() {
        this(2, 1);
    }

    public MultiThreadRenderManager(int n, int n2) {
        this.pipeline = new RenderPipeline[n];
        this.pipelineThread = new PipelineThread[n];
        this.audioPipeline = new AudioPipeline[n2];
        this.audioPipelineThread = new AudioPipelineThread[n2];
        this.renderWaitLock = new Object();
        this.frameFinishLock = new Object();
        this.dataChangeList = new NodeUpdateListener[200];
        this.dataSourceList = new Object[200];
        this.dataChangeListenerSet = new HashSet(200);
        this.dataChangeSrcSet = new HashSet(200);
        this.boundsChangeList = new NodeUpdateListener[200];
        this.boundsInternalList = new InternalNodeUpdateListener[200];
        this.boundsSourceList = new Object[200];
        this.boundsChangeListenerSet = new HashSet(200);
        this.boundsChangeSrcSet = new HashSet(200);
        this.shaderInitList = new ShaderSceneGraphObject[64];
        this.shaderInitSet = new HashSet(64);
        this.shaderLogList = new ShaderSceneGraphObject[64];
        this.shaderLogSet = new HashSet(64);
        this.pickHandler = new DefaultPickingHandler();
        this.deletionQueue = new ReferenceQueue();
        this.lastDataChangeItem = 0;
        this.lastBoundsChangeItem = 0;
        this.lastShaderInitItem = 0;
        this.lastShaderLogItem = 0;
        this.minimumCycleTime = 0;
        this.completedFrameCount = 0;
        this.root = new WorldRootGroup();
        this.root.addChild(null);
        this.root.setUpdateHandler(this);
        this.root.setLive(true);
        this.shutdownThread = new ShutdownThread(this);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Runtime runtime = Runtime.getRuntime();
                runtime.addShutdownHook(MultiThreadRenderManager.this.shutdownThread);
                return null;
            }
        });
    }

    public void setEnabled(boolean bl) {
        if (this.enabled == bl) {
            return;
        }
        if (bl) {
            this.enabled = true;
            this.terminate = false;
            this.pickPermitted = false;
            if (this.runtimeThread == null) {
                ThreadPrivilegedAction threadPrivilegedAction = new ThreadPrivilegedAction(this);
                this.runtimeThread = threadPrivilegedAction.getThread();
            }
        } else {
            int n;
            this.enabled = false;
            this.terminate = true;
            this.pickPermitted = true;
            for (n = 0; n < this.numPipelines; ++n) {
                this.pipelineThread[n].halt();
            }
            for (n = 0; n < this.numAudioPipelines; ++n) {
                this.audioPipelineThread[n].halt();
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void renderOnce() throws IllegalStateException {
        int n;
        if (this.enabled) {
            throw new IllegalStateException(ACTIVE_RENDERING_MSG);
        }
        this.processChangeList();
        this.processShaderLists();
        for (n = 0; n < this.numPipelines; ++n) {
            this.pipelineThread[n].render();
        }
        for (n = 0; n < this.numAudioPipelines; ++n) {
            this.audioPipelineThread[n].render();
        }
        for (n = 0; n < this.numPipelines; ++n) {
            this.pipeline[n].swapBuffers();
        }
    }

    public void requestFullSceneRender() {
        this.sceneChanged = true;
    }

    public void setScene(Scene scene) {
        int n;
        Group group = null;
        if (scene != null) {
            group = scene.getRenderedGeometry();
        }
        this.worldScene = scene;
        this.writableBoundsObject = this.root;
        this.root.setChild(group, 0);
        this.writableBoundsObject = null;
        for (n = 0; n < this.numPipelines; ++n) {
            this.pipeline[n].setRenderableScene(scene);
        }
        for (n = 0; n < this.numAudioPipelines; ++n) {
            this.audioPipeline[n].setRenderableScene(scene);
        }
        this.sceneChanged = true;
    }

    public Scene getScene() {
        return this.worldScene;
    }

    public void setLayers(Layer[] layerArray, int n) {
    }

    public int numLayers() {
        return 0;
    }

    public void getLayers(Layer[] layerArray) {
    }

    public void setMinimumFrameInterval(int n) {
        this.minimumCycleTime = n;
    }

    public int getMinimumFrameInterval() {
        return this.minimumCycleTime;
    }

    public void addPipeline(RenderPipeline renderPipeline) throws IllegalStateException {
        if (this.enabled) {
            throw new IllegalStateException(ACTIVE_RENDERING_MSG);
        }
        if (renderPipeline == null) {
            return;
        }
        if (this.numPipelines == this.pipeline.length) {
            RenderPipeline[] renderPipelineArray = new RenderPipeline[this.numPipelines + 2];
            System.arraycopy(this.pipeline, 0, renderPipelineArray, 0, this.numPipelines);
            this.pipeline = renderPipelineArray;
            PipelineThread[] pipelineThreadArray = new PipelineThread[this.numPipelines + 2];
            System.arraycopy(this.pipelineThread, 0, pipelineThreadArray, 0, this.numPipelines);
            this.pipelineThread = pipelineThreadArray;
        }
        renderPipeline.setRenderableScene(this.worldScene);
        this.pipeline[this.numPipelines] = renderPipeline;
        this.pipelineThread[this.numPipelines] = new PipelineThread(renderPipeline);
        this.pipelineThread[this.numPipelines].setStateObserver(this);
        ++this.numPipelines;
    }

    public void addAudioPipeline(AudioPipeline audioPipeline) throws IllegalStateException {
        if (this.enabled) {
            throw new IllegalStateException(ACTIVE_RENDERING_MSG);
        }
        if (audioPipeline == null) {
            return;
        }
        if (this.numAudioPipelines == this.audioPipeline.length) {
            AudioPipeline[] audioPipelineArray = new AudioPipeline[this.numAudioPipelines + 2];
            System.arraycopy(this.audioPipeline, 0, audioPipelineArray, 0, this.numAudioPipelines);
            this.audioPipeline = audioPipelineArray;
            AudioPipelineThread[] audioPipelineThreadArray = new AudioPipelineThread[this.numAudioPipelines + 2];
            System.arraycopy(this.audioPipelineThread, 0, audioPipelineThreadArray, 0, this.numAudioPipelines);
            this.audioPipelineThread = audioPipelineThreadArray;
        }
        audioPipeline.setRenderableScene(this.worldScene);
        this.audioPipeline[this.numAudioPipelines] = audioPipeline;
        this.audioPipelineThread[this.numAudioPipelines] = new AudioPipelineThread(audioPipeline);
        this.audioPipelineThread[this.numAudioPipelines].setStateObserver(this);
        ++this.numAudioPipelines;
    }

    public void removePipeline(RenderPipeline renderPipeline) throws IllegalStateException {
        if (this.enabled) {
            throw new IllegalStateException(ACTIVE_RENDERING_MSG);
        }
        for (int i = 0; i < this.numPipelines; ++i) {
            if (this.pipeline[i] != renderPipeline) continue;
            this.pipelineThread[i].shutdown();
            this.pipelineThread[i].setStateObserver(null);
            System.arraycopy(this.pipeline, i + 1, this.pipeline, i, this.numPipelines - i - 1);
            System.arraycopy(this.pipelineThread, i + 1, this.pipelineThread, i, this.numPipelines - i - 1);
            --this.numPipelines;
            renderPipeline.setRenderableScene(null);
            break;
        }
    }

    public void removeAudioPipeline(AudioPipeline audioPipeline) throws IllegalStateException {
        if (this.enabled) {
            throw new IllegalStateException(ACTIVE_RENDERING_MSG);
        }
        for (int i = 0; i < this.numAudioPipelines; ++i) {
            if (this.audioPipeline[i] != audioPipeline) continue;
            this.audioPipelineThread[i].shutdown();
            this.audioPipelineThread[i].setStateObserver(null);
            System.arraycopy(this.audioPipeline, i + 1, this.pipeline, i, this.numAudioPipelines - i - 1);
            System.arraycopy(this.audioPipelineThread, i + 1, this.audioPipelineThread, i, this.numAudioPipelines - i - 1);
            --this.numAudioPipelines;
            audioPipeline.setRenderableScene(null);
            break;
        }
    }

    public void setApplicationObserver(ApplicationUpdateObserver applicationUpdateObserver) {
        this.observer = applicationUpdateObserver;
    }

    public void disableInternalShutdown() {
        if (this.shutdownThread != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Runtime runtime = Runtime.getRuntime();
                    runtime.removeShutdownHook(MultiThreadRenderManager.this.shutdownThread);
                    return null;
                }
            });
            this.shutdownThread = null;
        }
    }

    public void shutdown() {
        if (this.terminate || !this.enabled) {
            return;
        }
        this.terminate = true;
        this.setEnabled(false);
        if (this.shutdownThread != null && this.observer != null) {
            try {
                this.observer.appShutdown();
            }
            catch (Exception exception) {
                System.out.println("Error in user callback for shutdown " + exception.getMessage());
                exception.printStackTrace();
            }
            this.observer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int n;
        for (n = 0; n < this.numPipelines; ++n) {
            if (this.pipelineThread[n].isAlive()) continue;
            this.pipelineThread[n].start();
        }
        for (n = 0; n < this.numAudioPipelines; ++n) {
            if (this.audioPipelineThread[n].isAlive()) continue;
            this.audioPipelineThread[n].start();
        }
        while (!this.terminate) {
            int n2;
            Object object;
            Reference reference;
            long l = System.currentTimeMillis();
            if (!this.terminate && this.observer != null) {
                this.pickPermitted = true;
                this.observer.updateSceneGraph();
                this.pickPermitted = false;
            }
            if (this.terminate) break;
            while ((reference = this.deletionQueue.poll()) != null) {
                object = (DeletableSceneGraphObject)reference.get();
                for (n2 = 0; n2 < this.numPipelines; ++n2) {
                    this.pipelineThread[n2].queueDeletedObject((DeletableSceneGraphObject)object);
                }
            }
            if (this.terminate) break;
            this.processShaderLists();
            if (this.terminate) break;
            object = this.frameFinishLock;
            synchronized (object) {
                if (this.lastDataChangeItem == 0 && this.lastBoundsChangeItem == 0 && !this.sceneChanged) {
                    for (n2 = 0; n2 < this.numPipelines; ++n2) {
                        this.pipelineThread[n2].displayOnly();
                    }
                    for (n2 = 0; n2 < this.numAudioPipelines; ++n2) {
                        this.audioPipelineThread[n2].displayOnly();
                    }
                } else {
                    this.processChangeList();
                    if (this.terminate) {
                        break;
                    }
                    this.sceneChanged = false;
                    for (n2 = 0; n2 < this.numPipelines; ++n2) {
                        this.pipelineThread[n2].render();
                    }
                    for (n2 = 0; n2 < this.numAudioPipelines; ++n2) {
                        this.audioPipelineThread[n2].render();
                    }
                }
                if (this.terminate) {
                    break;
                }
            }
            if (this.numPipelines + this.numAudioPipelines != 0) {
                try {
                    object = this.renderWaitLock;
                    synchronized (object) {
                        this.renderWaitLock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.terminate) break;
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            if (l3 < (long)this.minimumCycleTime) {
                try {
                    Thread.sleep((long)this.minimumCycleTime - l3);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Thread.yield();
        }
        this.runtimeThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void frameFinished() {
        Object object = this.frameFinishLock;
        synchronized (object) {
            if (++this.completedFrameCount >= this.numPipelines + this.numAudioPipelines) {
                Object object2 = this.renderWaitLock;
                synchronized (object2) {
                    this.completedFrameCount = 0;
                    this.renderWaitLock.notify();
                }
            }
        }
    }

    public boolean isDataWritePermitted(Object object) {
        return object == this.writableDataObject || !this.enabled;
    }

    public boolean isBoundsWritePermitted(Object object) {
        return object == this.writableBoundsObject || !this.enabled;
    }

    public boolean isPickingPermitted() {
        return this.pickPermitted;
    }

    public synchronized boolean boundsChanged(NodeUpdateListener nodeUpdateListener, Object object, InternalNodeUpdateListener internalNodeUpdateListener) throws InvalidListenerSetTimingException {
        if (this.processing) {
            throw new InvalidListenerSetTimingException("boundsChanged cannot be called in NodeUpdateListener");
        }
        if (this.boundsChangeSrcSet.contains(object) && this.boundsChangeListenerSet.contains((Object)nodeUpdateListener)) {
            return false;
        }
        this.boundsChangeListenerSet.add((Object)nodeUpdateListener);
        this.boundsChangeSrcSet.add(object);
        this.resizeBoundsChangeList();
        this.boundsChangeList[this.lastBoundsChangeItem] = nodeUpdateListener;
        this.boundsInternalList[this.lastBoundsChangeItem] = internalNodeUpdateListener;
        this.boundsSourceList[this.lastBoundsChangeItem] = object;
        ++this.lastBoundsChangeItem;
        return true;
    }

    public synchronized void dataChanged(NodeUpdateListener nodeUpdateListener, Object object) throws InvalidListenerSetTimingException {
        if (this.processing) {
            throw new InvalidListenerSetTimingException("dataChanged cannot be called in NodeUpdateListener.  Need to fix for threaded content.");
        }
        if (this.dataChangeSrcSet.contains(object) && this.dataChangeListenerSet.contains((Object)nodeUpdateListener)) {
            return;
        }
        this.dataChangeListenerSet.add((Object)nodeUpdateListener);
        this.dataChangeSrcSet.add(object);
        this.resizeDataChangeList();
        this.dataChangeList[this.lastDataChangeItem] = nodeUpdateListener;
        this.dataSourceList[this.lastDataChangeItem] = object;
        ++this.lastDataChangeItem;
    }

    public void shaderRequiresInit(ShaderSceneGraphObject shaderSceneGraphObject, boolean bl) {
        if (this.processing && !bl) {
            throw new RuntimeException("shaderRequiresInit cannot be called in NodeUpdateListener");
        }
        if (this.shaderInitSet.contains((Object)shaderSceneGraphObject)) {
            return;
        }
        this.shaderInitSet.add((Object)shaderSceneGraphObject);
        this.resizeShaderInitList();
        this.shaderInitList[this.lastShaderInitItem] = shaderSceneGraphObject;
        ++this.lastShaderInitItem;
    }

    public void shaderRequiresLogInfo(ShaderSceneGraphObject shaderSceneGraphObject, boolean bl) {
        if (this.processing && !bl) {
            throw new RuntimeException("shaderRequiresLog cannot be called in NodeUpdateListener");
        }
        if (this.shaderLogSet.contains((Object)shaderSceneGraphObject)) {
            return;
        }
        this.shaderLogSet.add((Object)shaderSceneGraphObject);
        this.resizeShaderLogList();
        this.shaderLogList[this.lastShaderLogItem] = shaderSceneGraphObject;
        ++this.lastShaderLogItem;
    }

    public void objectRemoved(DeletableSceneGraphObject deletableSceneGraphObject) {
        new SoftReference<DeletableSceneGraphObject>(deletableSceneGraphObject, this.deletionQueue);
    }

    public PickingHandler getPickHandler() {
        return this.pickHandler;
    }

    private void processChangeList() {
        int n;
        this.processing = true;
        for (n = 0; n < this.lastBoundsChangeItem; ++n) {
            this.writableBoundsObject = this.boundsSourceList[n];
            this.boundsChangeList[n].updateNodeBoundsChanges(this.boundsSourceList[n]);
            this.boundsChangeList[n] = null;
            this.boundsSourceList[n] = null;
        }
        this.writableBoundsObject = null;
        for (n = 0; n < this.lastBoundsChangeItem; ++n) {
            this.boundsInternalList[n].updateBoundsAndNotify();
            this.boundsInternalList[n] = null;
        }
        this.lastBoundsChangeItem = 0;
        this.boundsChangeSrcSet.clear();
        this.boundsChangeListenerSet.clear();
        for (n = 0; n < this.lastDataChangeItem; ++n) {
            this.writableDataObject = this.dataSourceList[n];
            this.dataChangeList[n].updateNodeDataChanges(this.dataSourceList[n]);
            this.dataChangeList[n] = null;
            this.dataSourceList[n] = null;
        }
        this.writableDataObject = null;
        this.lastDataChangeItem = 0;
        this.dataChangeSrcSet.clear();
        this.dataChangeListenerSet.clear();
        this.processing = false;
    }

    private void processShaderLists() {
        int n;
        if (this.lastShaderInitItem == 0 && this.lastShaderLogItem == 0) {
            return;
        }
        for (n = 0; n < this.numPipelines; ++n) {
            this.pipelineThread[n].queueShaderRequests(this.shaderInitList, this.lastShaderInitItem, this.shaderLogList, this.lastShaderLogItem);
        }
        for (n = 0; n < this.lastShaderInitItem; ++n) {
            this.shaderInitList[0] = null;
        }
        for (n = 0; n < this.lastShaderLogItem; ++n) {
            this.shaderLogList[0] = null;
        }
        this.lastShaderInitItem = 0;
        this.lastShaderLogItem = 0;
        this.shaderInitSet.clear();
        this.shaderLogSet.clear();
    }

    private final void resizeDataChangeList() {
        if (this.lastDataChangeItem + 1 == this.dataChangeList.length) {
            int n = this.dataChangeList.length;
            int n2 = n + 100;
            NodeUpdateListener[] nodeUpdateListenerArray = new NodeUpdateListener[n2];
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.dataChangeList, 0, nodeUpdateListenerArray, 0, n);
            System.arraycopy(this.dataSourceList, 0, objectArray, 0, n);
            this.dataChangeList = nodeUpdateListenerArray;
            this.dataSourceList = objectArray;
        }
    }

    private final void resizeBoundsChangeList() {
        if (this.lastBoundsChangeItem + 1 == this.boundsChangeList.length) {
            int n = this.boundsChangeList.length;
            int n2 = n + 100;
            NodeUpdateListener[] nodeUpdateListenerArray = new NodeUpdateListener[n2];
            InternalNodeUpdateListener[] internalNodeUpdateListenerArray = new InternalNodeUpdateListener[n2];
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.boundsChangeList, 0, nodeUpdateListenerArray, 0, n);
            System.arraycopy(this.boundsSourceList, 0, objectArray, 0, n);
            System.arraycopy(this.boundsInternalList, 0, internalNodeUpdateListenerArray, 0, n);
            this.boundsChangeList = nodeUpdateListenerArray;
            this.boundsSourceList = objectArray;
            this.boundsInternalList = internalNodeUpdateListenerArray;
        }
    }

    private final void resizeShaderInitList() {
        if (this.lastShaderInitItem + 1 == this.shaderInitList.length) {
            int n = this.shaderInitList.length;
            int n2 = n + 32;
            ShaderSceneGraphObject[] shaderSceneGraphObjectArray = new ShaderSceneGraphObject[n2];
            System.arraycopy(this.shaderInitList, 0, shaderSceneGraphObjectArray, 0, n);
            this.shaderInitList = shaderSceneGraphObjectArray;
        }
    }

    private final void resizeShaderLogList() {
        if (this.lastShaderLogItem + 1 == this.shaderLogList.length) {
            int n = this.shaderLogList.length;
            int n2 = n + 32;
            ShaderSceneGraphObject[] shaderSceneGraphObjectArray = new ShaderSceneGraphObject[n2];
            System.arraycopy(this.shaderLogList, 0, shaderSceneGraphObjectArray, 0, n);
            this.shaderLogList = shaderSceneGraphObjectArray;
        }
    }
}

