/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline;

import javax.vecmath.Matrix4f;
import org.j3d.aviatrix3d.AudioCullStage;
import org.j3d.aviatrix3d.AudioEnvironmentData;
import org.j3d.aviatrix3d.CullAudioOutputDetails;
import org.j3d.aviatrix3d.CulledAudioReceiver;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Layer;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.Scene;
import org.j3d.aviatrix3d.SharedGroup;
import org.j3d.aviatrix3d.SharedNode;
import org.j3d.aviatrix3d.Sound;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.aviatrix3d.ViewEnvironment;

public class NullAudioCullStage
implements AudioCullStage {
    private static final String SHARED_VP_MSG = "The path from the root of the scene graph to the viewpoint contains a SharedGroup or SharedNode instance. This is not permitted.";
    private static final int TRANSFORM_DEPTH_SIZE = 64;
    private static final int STACK_INCREMENT = 32;
    private static final int LIST_START_DEPTH = 200;
    private static final int LIST_INCREMENT = 20;
    private CullAudioOutputDetails[][] outputCullList;
    private CullAudioOutputDetails[][] validCullList;
    private CullAudioOutputDetails[] workCullList;
    private int[] outputCullSize;
    private AudioEnvironmentData[] validEnvData;
    private AudioEnvironmentData[] outputEnvData;
    private int[] validCullSize;
    private int lastOutputList;
    private Matrix4f[] transformStack;
    private int lastTxStack;
    private CulledAudioReceiver receiver;
    private TransformGroup[] currentViewpointPath;
    private Matrix4f viewMatrix1;
    private Matrix4f viewMatrix2;
    private boolean terminate;

    public NullAudioCullStage() {
        int n;
        int n2 = 1;
        this.outputCullList = new CullAudioOutputDetails[n2][];
        this.validCullList = new CullAudioOutputDetails[n2][200];
        this.outputEnvData = new AudioEnvironmentData[n2];
        this.validEnvData = new AudioEnvironmentData[n2];
        this.outputCullSize = new int[n2];
        this.validCullSize = new int[n2];
        this.currentViewpointPath = new TransformGroup[64];
        this.viewMatrix1 = new Matrix4f();
        this.viewMatrix2 = new Matrix4f();
        for (n = 0; n < n2; ++n) {
            this.validEnvData[n] = new AudioEnvironmentData();
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < 200; ++i) {
                this.validCullList[n][i] = new CullAudioOutputDetails();
            }
        }
        this.transformStack = new Matrix4f[64];
        for (n = 0; n < 64; ++n) {
            this.transformStack[n] = new Matrix4f();
        }
    }

    public void cull(Scene scene, int n) {
        this.terminate = false;
        this.lastOutputList = 0;
        this.lastTxStack = 0;
        this.workCullList = this.validCullList[0];
        Group group = scene.getRenderedGeometry();
        this.fillEnvData(scene, this.validEnvData[0]);
        if (group instanceof Group) {
            if (group instanceof TransformGroup) {
                ((TransformGroup)group).getTransform(this.transformStack[0]);
            } else {
                this.transformStack[0].setIdentity();
            }
            this.validCullSize[0] = this.findAllNodes(group, 0);
            this.validCullList[0] = this.workCullList;
            ++this.lastOutputList;
        } else if (group instanceof SharedNode) {
            this.transformStack[0].setIdentity();
            this.validCullSize[0] = this.findNextNode((SharedNode)((Object)group), 0);
            this.validCullList[0] = this.workCullList;
            ++this.lastOutputList;
        } else if (group instanceof Sound && ((Sound)((Object)group)).isEnabled()) {
            this.workCullList[0].renderable = (Sound)((Object)group);
            this.workCullList[0].transform.setIdentity();
            this.validCullSize[0] = 1;
            this.validCullList[0] = this.workCullList;
            ++this.lastOutputList;
        }
        this.outputCullList[0] = this.validCullList[0];
        this.outputCullSize[0] = this.validCullSize[0];
        this.outputEnvData[0] = this.validEnvData[0];
        if (this.lastOutputList != 0 && this.receiver != null && !this.terminate) {
            this.receiver.culledOutput(this.outputEnvData[0], this.outputCullList[0], this.outputCullSize[0]);
        }
    }

    public void cull(Layer[] layerArray, int n, int n2) {
    }

    public void setCulledAudioReceiver(CulledAudioReceiver culledAudioReceiver) {
        this.receiver = culledAudioReceiver;
    }

    public void halt() {
        this.terminate = true;
    }

    private int cullSingle(Group group) {
        this.transformStack[0].setIdentity();
        if (group instanceof TransformGroup) {
            ((TransformGroup)group).getTransform(this.transformStack[0]);
        }
        return this.findAllNodes(group, 0);
    }

    private int findAllNodes(Group group, int n) {
        if (this.terminate) {
            return 0;
        }
        Node[] nodeArray = group.getRenderableChild();
        int n2 = group.numRenderableChildren();
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            if (nodeArray[i] instanceof Group) {
                boolean bl = nodeArray[i] instanceof TransformGroup;
                if (bl) {
                    this.resizeStack();
                    TransformGroup transformGroup = (TransformGroup)nodeArray[i];
                    transformGroup.getTransform(this.transformStack[this.lastTxStack + 1]);
                    this.transformStack[this.lastTxStack + 1].mul(this.transformStack[this.lastTxStack], this.transformStack[this.lastTxStack + 1]);
                    ++this.lastTxStack;
                }
                n3 = this.findAllNodes((Group)nodeArray[i], n3);
                if (!bl) continue;
                --this.lastTxStack;
                continue;
            }
            if (nodeArray[i] instanceof Sound) {
                if (!((Sound)nodeArray[i]).isEnabled()) continue;
                this.resizeCullList(n3);
                this.workCullList[n3].renderable = (Sound)nodeArray[i];
                Matrix4f matrix4f = this.transformStack[this.lastTxStack];
                this.workCullList[n3].transform.set(matrix4f);
                ++n3;
                continue;
            }
            if (!(nodeArray[i] instanceof SharedNode)) continue;
            n3 = this.findNextNode((SharedNode)nodeArray[i], n3);
        }
        return n3;
    }

    private int findNextNode(SharedNode sharedNode, int n) {
        if (this.terminate) {
            return 0;
        }
        int n2 = n;
        Node node = sharedNode.getChild();
        while (node != null && node instanceof SharedNode) {
            node = ((SharedNode)node).getChild();
        }
        if (node instanceof Group) {
            boolean bl = node instanceof TransformGroup;
            if (bl) {
                this.resizeStack();
                TransformGroup transformGroup = (TransformGroup)node;
                transformGroup.getTransform(this.transformStack[this.lastTxStack + 1]);
                this.transformStack[this.lastTxStack + 1].mul(this.transformStack[this.lastTxStack], this.transformStack[this.lastTxStack + 1]);
                ++this.lastTxStack;
            }
            n2 = this.findAllNodes((Group)node, n);
            if (bl) {
                --this.lastTxStack;
            }
        } else if (node instanceof Sound) {
            if (!((Sound)node).isEnabled()) {
                return n2;
            }
            this.resizeCullList(n);
            this.workCullList[n].renderable = (Sound)node;
            Matrix4f matrix4f = this.transformStack[this.lastTxStack];
            this.workCullList[n].transform.set(matrix4f);
            ++n;
            ++n2;
        }
        return n2;
    }

    private void fillEnvData(Scene scene, AudioEnvironmentData audioEnvironmentData) {
        ViewEnvironment viewEnvironment = scene.getViewEnvironment();
        audioEnvironmentData.userData = scene.getUserData();
        audioEnvironmentData.viewpoint = scene.getActiveView();
        Node node = audioEnvironmentData.viewpoint.getParent();
        int n = 0;
        while (node != null) {
            if (node instanceof SharedGroup || node instanceof SharedNode) {
                throw new IllegalArgumentException(SHARED_VP_MSG);
            }
            node = node.getParent();
            ++n;
        }
        if (this.currentViewpointPath.length < n) {
            this.currentViewpointPath = new TransformGroup[n];
        }
        int n2 = 0;
        for (node = audioEnvironmentData.viewpoint.getParent(); node != null; node = node.getParent()) {
            if (!(node instanceof TransformGroup)) continue;
            this.currentViewpointPath[n2++] = (TransformGroup)node;
        }
        this.viewMatrix2.setIdentity();
        if (n2 != 0) {
            for (int i = n2 - 1; i >= 0; --i) {
                this.currentViewpointPath[i].getTransform(this.viewMatrix1);
                this.viewMatrix2.mul(this.viewMatrix1);
            }
        }
        audioEnvironmentData.viewTransform.set(this.viewMatrix2);
    }

    private final void resizeCullList(int n) {
        if (n + 1 == this.workCullList.length) {
            int n2 = this.workCullList.length;
            int n3 = n2 + 20;
            CullAudioOutputDetails[] cullAudioOutputDetailsArray = new CullAudioOutputDetails[n3];
            System.arraycopy(this.workCullList, 0, cullAudioOutputDetailsArray, 0, n2);
            for (int i = n2; i < n3; ++i) {
                cullAudioOutputDetailsArray[i] = new CullAudioOutputDetails();
            }
            this.workCullList = cullAudioOutputDetailsArray;
        }
    }

    private final void resizeStack() {
        if (this.lastTxStack + 1 == this.transformStack.length) {
            int n = this.transformStack.length;
            int n2 = n + 32;
            Matrix4f[] matrix4fArray = new Matrix4f[n2];
            System.arraycopy(this.transformStack, 0, matrix4fArray, 0, n);
            for (int i = n; i < n2; ++i) {
                matrix4fArray[i] = new Matrix4f();
            }
            this.transformStack = matrix4fArray;
        }
    }
}

