/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline;

import javax.vecmath.Matrix4f;
import org.j3d.aviatrix3d.AudioDetails;
import org.j3d.aviatrix3d.AudioEnvironmentData;
import org.j3d.aviatrix3d.AudioInstructions;
import org.j3d.aviatrix3d.AudioSortStage;
import org.j3d.aviatrix3d.BackgroundSound;
import org.j3d.aviatrix3d.CullAudioOutputDetails;
import org.j3d.aviatrix3d.SortedAudioReceiver;
import org.j3d.aviatrix3d.Sound;
import org.j3d.util.MatrixUtils;

public class NullAudioSortStage
implements AudioSortStage {
    private static final int LIST_START_SIZE = 1;
    private SortedAudioReceiver receiver;
    private AudioInstructions commandList = new AudioInstructions();
    private int lastGlobalId = 0;
    private MatrixUtils matrixUtils = new MatrixUtils();
    private boolean terminate;

    public void sort(AudioEnvironmentData audioEnvironmentData, CullAudioOutputDetails[] cullAudioOutputDetailsArray, int n, int n2) {
        this.terminate = false;
        this.commandList.renderData = audioEnvironmentData;
        this.sortSingle(cullAudioOutputDetailsArray, n, this.commandList);
        if (this.terminate) {
            return;
        }
        if (this.receiver != null) {
            this.receiver.sortedOutput(this.commandList);
        }
    }

    public void setSortedAudioReceiver(SortedAudioReceiver sortedAudioReceiver) {
        this.receiver = sortedAudioReceiver;
    }

    public void halt() {
        this.terminate = true;
    }

    private void sortSingle(CullAudioOutputDetails[] cullAudioOutputDetailsArray, int n, AudioInstructions audioInstructions) {
        int n2;
        int n3 = n << 1;
        if (audioInstructions.renderList.length < n3) {
            AudioDetails[] audioDetailsArray = new AudioDetails[n3];
            System.arraycopy(audioInstructions.renderList, 0, audioDetailsArray, 0, audioInstructions.renderList.length);
            for (n2 = audioInstructions.renderList.length; n2 < n3; ++n2) {
                audioDetailsArray[n2] = new AudioDetails();
            }
            audioInstructions.renderList = audioDetailsArray;
            audioInstructions.renderOps = new int[n3];
        }
        int n4 = 0;
        for (n2 = 0; n2 < n && !this.terminate; ++n2) {
            if (cullAudioOutputDetailsArray[n2].renderable instanceof Sound) {
                audioInstructions.renderList[n4].renderable = cullAudioOutputDetailsArray[n2].renderable;
                if (!(cullAudioOutputDetailsArray[n2].renderable instanceof BackgroundSound)) {
                    Matrix4f matrix4f = cullAudioOutputDetailsArray[n2].transform;
                    this.matrixUtils.inverse(matrix4f, matrix4f);
                    audioInstructions.renderList[n4].transform = matrix4f;
                }
                audioInstructions.renderOps[n4] = 1;
                audioInstructions.renderList[++n4].renderable = cullAudioOutputDetailsArray[n2].renderable;
                audioInstructions.renderOps[n4] = 2;
                ++n4;
                continue;
            }
            System.out.println("Non-sound node in sorter " + cullAudioOutputDetailsArray[n2].renderable);
        }
        audioInstructions.numValid = n4;
    }
}

