/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline;

import java.util.HashMap;
import javax.vecmath.Matrix4f;
import org.j3d.aviatrix3d.ClipDetails;
import org.j3d.aviatrix3d.CullOutputDetails;
import org.j3d.aviatrix3d.CustomRenderable;
import org.j3d.aviatrix3d.LightDetails;
import org.j3d.aviatrix3d.PBufferTextureSource;
import org.j3d.aviatrix3d.RenderDetails;
import org.j3d.aviatrix3d.RenderEnvironmentData;
import org.j3d.aviatrix3d.RenderInstructions;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.SortStage;
import org.j3d.aviatrix3d.SortedGeometryReceiver;

public class NullSortStage
implements SortStage {
    private static final int LIST_START_SIZE = 1;
    private SortedGeometryReceiver receiver;
    private RenderInstructions[] commandList;
    private int lastGlobalId;
    private HashMap instructionMap;
    private boolean terminate;

    public NullSortStage() {
        this(1);
    }

    public NullSortStage(int n) {
        this.commandList = new RenderInstructions[n];
        this.lastGlobalId = 0;
        for (int i = 0; i < n; ++i) {
            this.commandList[i] = new RenderInstructions();
        }
        this.instructionMap = new HashMap();
    }

    public void sort(RenderEnvironmentData[] renderEnvironmentDataArray, CullOutputDetails[][] cullOutputDetailsArray, int[] nArray, SceneGraphObject[][] sceneGraphObjectArray, int n, int n2) {
        int n3;
        this.terminate = false;
        if (this.commandList.length < n) {
            RenderInstructions[] renderInstructionsArray = new RenderInstructions[n];
            System.arraycopy(this.commandList, 0, renderInstructionsArray, 0, this.commandList.length);
            for (n3 = this.commandList.length; n3 < n; ++n3) {
                renderInstructionsArray[n3] = new RenderInstructions();
            }
            this.commandList = renderInstructionsArray;
        }
        int n4 = 0;
        n3 = 0;
        for (int i = 0; i < n && !this.terminate; ++i) {
            if (sceneGraphObjectArray[i][0] == null) {
                n4 = i;
                continue;
            }
            this.commandList[n3].pbuffer = (PBufferTextureSource)((Object)sceneGraphObjectArray[i][0]);
            this.commandList[n3].parentSource = (PBufferTextureSource)((Object)sceneGraphObjectArray[i][1]);
            this.commandList[n3].renderData = renderEnvironmentDataArray[i];
            RenderInstructions renderInstructions = (RenderInstructions)this.instructionMap.get(sceneGraphObjectArray[i][0]);
            if (renderInstructions != null) {
                this.commandList[n3].copyOf = renderInstructions;
            } else {
                this.commandList[n3].copyOf = null;
                this.sortSingle(cullOutputDetailsArray[i], nArray[i], this.commandList[n3]);
                this.instructionMap.put(sceneGraphObjectArray[i][0], this.commandList[n3]);
            }
            ++n3;
        }
        if (this.terminate) {
            this.instructionMap.clear();
            return;
        }
        this.commandList[n3].pbuffer = null;
        this.commandList[n3].renderData = renderEnvironmentDataArray[n4];
        this.sortSingle(cullOutputDetailsArray[n4], nArray[n4], this.commandList[n3]);
        if (this.terminate) {
            this.instructionMap.clear();
            return;
        }
        ++n3;
        if (this.receiver != null) {
            this.receiver.sortedOutput(this.commandList, n);
        }
        this.instructionMap.clear();
    }

    public void setSortedGeometryReceiver(SortedGeometryReceiver sortedGeometryReceiver) {
        this.receiver = sortedGeometryReceiver;
    }

    public void halt() {
        this.terminate = true;
    }

    private void sortSingle(CullOutputDetails[] cullOutputDetailsArray, int n, RenderInstructions renderInstructions) {
        int n2;
        int n3;
        int n4 = n << 1;
        for (n3 = 0; n3 < n; ++n3) {
            n4 += cullOutputDetailsArray[n3].numLights << 1;
            n4 += cullOutputDetailsArray[n3].numClipPlanes << 1;
        }
        if (renderInstructions.renderList.length < n4) {
            RenderDetails[] renderDetailsArray = new RenderDetails[n4];
            System.arraycopy(renderInstructions.renderList, 0, renderDetailsArray, 0, renderInstructions.renderList.length);
            for (n2 = renderInstructions.renderList.length; n2 < n4; ++n2) {
                renderDetailsArray[n2] = new RenderDetails();
            }
            renderInstructions.renderList = renderDetailsArray;
            renderInstructions.renderOps = new int[n4];
        }
        n3 = 0;
        n2 = 0;
        for (int i = 0; i < n && !this.terminate; ++i) {
            Object object;
            int n5;
            if (cullOutputDetailsArray[i].numLights != 0) {
                for (n5 = 0; n5 < cullOutputDetailsArray[i].numLights; ++n5) {
                    object = cullOutputDetailsArray[i].lights[n5];
                    renderInstructions.renderList[n3].renderable = ((LightDetails)object).getLight();
                    System.arraycopy(((LightDetails)object).getTransform(), 0, renderInstructions.renderList[n3].transform, 0, 16);
                    ++this.lastGlobalId;
                    renderInstructions.renderList[n3].id = renderInstructions.renderList[n3].id;
                    renderInstructions.renderOps[n3] = 9;
                    ++n3;
                }
            }
            if (cullOutputDetailsArray[i].numClipPlanes != 0) {
                for (n5 = 0; n5 < cullOutputDetailsArray[i].numClipPlanes; ++n5) {
                    object = cullOutputDetailsArray[i].clipPlanes[n5];
                    renderInstructions.renderList[n3].renderable = ((ClipDetails)object).getClipPlane();
                    System.arraycopy(((ClipDetails)object).getTransform(), 0, renderInstructions.renderList[n3].transform, 0, 16);
                    ++this.lastGlobalId;
                    renderInstructions.renderList[n3].id = renderInstructions.renderList[n3].id;
                    renderInstructions.renderOps[n3] = 17;
                    ++n3;
                }
            }
            if (cullOutputDetailsArray[i].localFog != null) {
                ++this.lastGlobalId;
                renderInstructions.renderList[n3].id = n2;
                renderInstructions.renderList[n3].renderable = cullOutputDetailsArray[i].localFog;
                renderInstructions.renderOps[n3] = 19;
                ++n3;
            }
            if (cullOutputDetailsArray[i].renderable instanceof Shape3D) {
                renderInstructions.renderList[n3].renderable = cullOutputDetailsArray[i].renderable;
                Matrix4f matrix4f = cullOutputDetailsArray[i].transform;
                renderInstructions.renderList[n3].transform[0] = matrix4f.m00;
                renderInstructions.renderList[n3].transform[1] = matrix4f.m10;
                renderInstructions.renderList[n3].transform[2] = matrix4f.m20;
                renderInstructions.renderList[n3].transform[3] = matrix4f.m30;
                renderInstructions.renderList[n3].transform[4] = matrix4f.m01;
                renderInstructions.renderList[n3].transform[5] = matrix4f.m11;
                renderInstructions.renderList[n3].transform[6] = matrix4f.m21;
                renderInstructions.renderList[n3].transform[7] = matrix4f.m31;
                renderInstructions.renderList[n3].transform[8] = matrix4f.m02;
                renderInstructions.renderList[n3].transform[9] = matrix4f.m12;
                renderInstructions.renderList[n3].transform[10] = matrix4f.m22;
                renderInstructions.renderList[n3].transform[11] = matrix4f.m32;
                renderInstructions.renderList[n3].transform[12] = matrix4f.m03;
                renderInstructions.renderList[n3].transform[13] = matrix4f.m13;
                renderInstructions.renderList[n3].transform[14] = matrix4f.m23;
                renderInstructions.renderList[n3].transform[15] = matrix4f.m33;
                renderInstructions.renderOps[n3] = 1;
                renderInstructions.renderList[++n3].renderable = cullOutputDetailsArray[i].renderable;
                renderInstructions.renderOps[n3] = 2;
                ++n3;
            } else if (cullOutputDetailsArray[i].renderable instanceof CustomRenderable) {
                renderInstructions.renderList[n3].renderable = cullOutputDetailsArray[i].renderable;
                renderInstructions.renderList[n3].instructions = cullOutputDetailsArray[i].customData;
                Matrix4f matrix4f = cullOutputDetailsArray[i].transform;
                renderInstructions.renderList[n3].transform[0] = matrix4f.m00;
                renderInstructions.renderList[n3].transform[1] = matrix4f.m10;
                renderInstructions.renderList[n3].transform[2] = matrix4f.m20;
                renderInstructions.renderList[n3].transform[3] = matrix4f.m30;
                renderInstructions.renderList[n3].transform[4] = matrix4f.m01;
                renderInstructions.renderList[n3].transform[5] = matrix4f.m11;
                renderInstructions.renderList[n3].transform[6] = matrix4f.m21;
                renderInstructions.renderList[n3].transform[7] = matrix4f.m31;
                renderInstructions.renderList[n3].transform[8] = matrix4f.m02;
                renderInstructions.renderList[n3].transform[9] = matrix4f.m12;
                renderInstructions.renderList[n3].transform[10] = matrix4f.m22;
                renderInstructions.renderList[n3].transform[11] = matrix4f.m32;
                renderInstructions.renderList[n3].transform[12] = matrix4f.m03;
                renderInstructions.renderList[n3].transform[13] = matrix4f.m13;
                renderInstructions.renderList[n3].transform[14] = matrix4f.m23;
                renderInstructions.renderList[n3].transform[15] = matrix4f.m33;
                renderInstructions.renderOps[n3] = 4;
                ++n3;
            } else {
                System.out.println("Non-shape node in sorter " + cullOutputDetailsArray[i].renderable);
            }
            if (cullOutputDetailsArray[i].localFog != null) {
                renderInstructions.renderList[n3].id = n2;
                renderInstructions.renderList[n3].renderable = cullOutputDetailsArray[i].localFog;
                renderInstructions.renderOps[n3] = 20;
                ++n3;
            }
            if (cullOutputDetailsArray[i].numClipPlanes != 0) {
                for (int j = cullOutputDetailsArray[i].numClipPlanes - 1; j >= 0; --j) {
                    object = cullOutputDetailsArray[i].clipPlanes[j];
                    renderInstructions.renderList[n3].renderable = ((ClipDetails)object).getClipPlane();
                    renderInstructions.renderList[n3].id = this.lastGlobalId - (1 + j);
                    renderInstructions.renderOps[n3] = 18;
                    ++n3;
                }
            }
            if (cullOutputDetailsArray[i].numLights == 0) continue;
            for (int j = cullOutputDetailsArray[i].numLights - 1; j >= 0; --j) {
                object = cullOutputDetailsArray[i].lights[j];
                renderInstructions.renderList[n3].renderable = ((LightDetails)object).getLight();
                renderInstructions.renderList[n3].id = this.lastGlobalId - (1 + j);
                renderInstructions.renderOps[n3] = 10;
                ++n3;
            }
        }
        renderInstructions.numValid = n3;
    }
}

