/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline;

import org.j3d.aviatrix3d.DeletableSceneGraphObject;
import org.j3d.aviatrix3d.DrawableSurface;
import org.j3d.aviatrix3d.RenderPipeline;
import org.j3d.aviatrix3d.ShaderSceneGraphObject;
import org.j3d.aviatrix3d.pipeline.PipelineStateObserver;

class PipelineThread
extends Thread {
    private boolean terminate;
    private RenderPipeline pipeline;
    private PipelineStateObserver observer;
    private Object displayLock;
    private boolean waiting;
    private boolean noProcessing;

    PipelineThread(RenderPipeline renderPipeline) {
        super("Aviatrix3D multithreaded render pipeline");
        this.pipeline = renderPipeline;
        this.terminate = false;
        this.waiting = false;
        this.noProcessing = false;
        this.displayLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DrawableSurface drawableSurface = this.pipeline.getDrawableSurface();
        drawableSurface.setRenderControlThread(this);
        while (!this.terminate) {
            try {
                if (this.noProcessing) {
                    this.pipeline.displayOnly();
                } else {
                    this.pipeline.render();
                }
                if (this.terminate) break;
                Object object = this.displayLock;
                synchronized (object) {
                    if (this.observer != null) {
                        this.observer.frameFinished();
                    }
                    if (this.terminate) {
                        break;
                    }
                    this.displayLock.wait();
                }
                Thread.yield();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.terminate) break;
            this.pipeline.swapBuffers();
        }
        drawableSurface.setRenderControlThread(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void halt() {
        this.pipeline.halt();
        try {
            Object object = this.displayLock;
            synchronized (object) {
                if (this.observer != null) {
                    this.observer.frameFinished();
                }
                this.displayLock.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displayOnly() {
        this.noProcessing = true;
        Object object = this.displayLock;
        synchronized (object) {
            this.displayLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void render() {
        this.noProcessing = false;
        Object object = this.displayLock;
        synchronized (object) {
            this.displayLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.terminate = true;
        DrawableSurface drawableSurface = this.pipeline.getDrawableSurface();
        drawableSurface.dispose();
        this.pipeline.halt();
        Object object = this.displayLock;
        synchronized (object) {
            this.displayLock.notify();
        }
    }

    void setStateObserver(PipelineStateObserver pipelineStateObserver) {
        this.observer = pipelineStateObserver;
    }

    public void queueDeletedObject(DeletableSceneGraphObject deletableSceneGraphObject) {
        DrawableSurface drawableSurface = this.pipeline.getDrawableSurface();
        drawableSurface.queueDeletedObject(deletableSceneGraphObject);
    }

    public void queueShaderRequests(ShaderSceneGraphObject[] shaderSceneGraphObjectArray, int n, ShaderSceneGraphObject[] shaderSceneGraphObjectArray2, int n2) {
        DrawableSurface drawableSurface = this.pipeline.getDrawableSurface();
        drawableSurface.queueShaderRequests(shaderSceneGraphObjectArray, n, shaderSceneGraphObjectArray2, n2);
    }
}

