/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline;

import java.awt.Rectangle;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector4f;
import org.j3d.aviatrix3d.Appearance;
import org.j3d.aviatrix3d.BoundingVolume;
import org.j3d.aviatrix3d.ClipDetails;
import org.j3d.aviatrix3d.ClipPlane;
import org.j3d.aviatrix3d.CullOutputDetails;
import org.j3d.aviatrix3d.CullStage;
import org.j3d.aviatrix3d.CulledGeometryReceiver;
import org.j3d.aviatrix3d.Fog;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Layer;
import org.j3d.aviatrix3d.Leaf;
import org.j3d.aviatrix3d.Light;
import org.j3d.aviatrix3d.LightDetails;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.PBufferTextureSource;
import org.j3d.aviatrix3d.RenderEnvironmentData;
import org.j3d.aviatrix3d.Scene;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.SharedGroup;
import org.j3d.aviatrix3d.SharedNode;
import org.j3d.aviatrix3d.Texture;
import org.j3d.aviatrix3d.TextureUnit;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.aviatrix3d.ViewEnvironment;
import org.j3d.util.HashSet;
import org.j3d.util.MatrixUtils;

public class SimpleFrustumCullStage
implements CullStage {
    private static final String SHARED_VP_MSG = "The path from the root of the scene graph to the viewpoint contains a SharedGroup instance. This is not permitted.";
    private static final String SHARED_BG_MSG = "The path from the root of the scene graph to the background contains a SharedGroup instance. This is not permitted.";
    private static final int INITIAL_PATH_DEPTH = 64;
    private static final int TRANSFORM_DEPTH_SIZE = 64;
    private static final int STACK_INCREMENT = 32;
    private static final int LIST_START_DEPTH = 200;
    private static final int LIST_START_LENGTH = 1;
    private static final int LIST_INCREMENT = 20;
    private static final int LIGHT_START_SIZE = 32;
    private static final int LIGHT_INCREMENT = 8;
    private boolean checkOffscreens;
    private PBufferTextureSource[] pendingSubscenes;
    private PBufferTextureSource[] pendingParents;
    private int lastSubscene;
    private SceneGraphObject[][] outputSceneParents;
    private SceneGraphObject[][] validSceneParents;
    private CullOutputDetails[][] outputCullList;
    private CullOutputDetails[][] validCullList;
    private CullOutputDetails[] workCullList;
    private int[] outputCullSize;
    private RenderEnvironmentData[] validEnvData;
    private RenderEnvironmentData[] outputEnvData;
    private int[] validCullSize;
    private int lastOutputList;
    private Matrix4f[] transformStack;
    private int lastTxStack;
    private Light[] lightList;
    private float[][] transformList;
    private int lastLight;
    private Fog[] fogStack;
    private int lastFogStack;
    private ClipPlane[] clipList;
    private float[][] clipTxList;
    private int lastClip;
    private TextureUnit[] textureUnits;
    private HashSet processedPBufferTextures;
    private HashSet visitedNodes;
    private CulledGeometryReceiver receiver;
    private PBufferTextureSource activeParent;
    private double[] viewFrustum;
    private Matrix4f viewMatrix;
    private Point4f[] frustumPoints;
    private Vector4f[] frustumPlanes;
    private Matrix4f prjMatrix;
    private TransformGroup[] currentViewpointPath;
    private Matrix4f viewMatrix1;
    private Matrix4f viewMatrix2;
    private Matrix4f orientationMatrix;
    private float[] screenOrientation;
    private float[] eyePoint;
    private boolean useOrientation;
    private boolean useEyePoint;
    private MatrixUtils matrixUtils;
    private boolean terminate;

    public SimpleFrustumCullStage() {
        this(1);
    }

    public SimpleFrustumCullStage(int n) {
        int n2;
        this.outputCullList = new CullOutputDetails[n][];
        this.validCullList = new CullOutputDetails[n][200];
        this.outputSceneParents = new SceneGraphObject[n][2];
        this.validSceneParents = new SceneGraphObject[n][2];
        this.pendingSubscenes = new PBufferTextureSource[n];
        this.pendingParents = new PBufferTextureSource[n];
        this.outputEnvData = new RenderEnvironmentData[n];
        this.validEnvData = new RenderEnvironmentData[n];
        this.outputCullSize = new int[n];
        this.validCullSize = new int[n];
        this.textureUnits = new TextureUnit[32];
        this.processedPBufferTextures = new HashSet();
        this.visitedNodes = new HashSet();
        this.orientationMatrix = new Matrix4f();
        this.orientationMatrix.setIdentity();
        this.screenOrientation = new float[4];
        this.eyePoint = new float[3];
        this.useEyePoint = false;
        this.useOrientation = false;
        for (n2 = 0; n2 < n; ++n2) {
            this.validEnvData[n2] = new RenderEnvironmentData();
        }
        for (n2 = 0; n2 < n; ++n2) {
            for (int i = 0; i < 200; ++i) {
                this.validCullList[n2][i] = new CullOutputDetails();
            }
        }
        this.transformStack = new Matrix4f[64];
        for (n2 = 0; n2 < 64; ++n2) {
            this.transformStack[n2] = new Matrix4f();
        }
        this.fogStack = new Fog[64];
        this.lightList = new Light[32];
        this.transformList = new float[32][16];
        this.checkOffscreens = true;
        this.prjMatrix = new Matrix4f();
        this.frustumPoints = new Point4f[8];
        for (n2 = 0; n2 < 8; ++n2) {
            this.frustumPoints[n2] = new Point4f();
        }
        this.frustumPlanes = new Vector4f[6];
        for (n2 = 0; n2 < 6; ++n2) {
            this.frustumPlanes[n2] = new Vector4f();
        }
        this.clipList = new ClipPlane[32];
        this.clipTxList = new float[32][16];
        this.currentViewpointPath = new TransformGroup[64];
        this.viewMatrix = new Matrix4f();
        this.viewMatrix1 = new Matrix4f();
        this.viewMatrix2 = new Matrix4f();
        this.matrixUtils = new MatrixUtils();
    }

    public void cull(Scene scene, int n) {
        this.terminate = false;
        this.lastOutputList = 0;
        this.lastLight = 0;
        this.lastClip = 0;
        this.lastTxStack = 0;
        this.lastFogStack = 0;
        this.lastSubscene = 0;
        this.activeParent = null;
        this.workCullList = this.validCullList[0];
        this.validSceneParents[0][0] = null;
        this.validSceneParents[0][1] = null;
        Group group = scene.getRenderedGeometry();
        this.fillEnvData(scene, this.validEnvData[0]);
        if (this.terminate) {
            return;
        }
        if (group instanceof Group) {
            this.transformStack[0].setIdentity();
            if (group instanceof TransformGroup) {
                ((TransformGroup)group).getTransform(this.transformStack[0]);
            }
            this.viewFrustum = this.validEnvData[0].viewFrustum;
            this.viewMatrix.set(this.validEnvData[0].viewTransform);
            this.updateFrustum(this.validEnvData[0]);
            this.validCullSize[0] = this.findAllNodes(group, false, false, 0);
            this.validCullList[0] = this.workCullList;
            ++this.lastOutputList;
        } else if (group instanceof SharedNode) {
            this.transformStack[0].setIdentity();
            this.viewFrustum = this.validEnvData[0].viewFrustum;
            this.viewMatrix.set(this.validEnvData[0].viewTransform);
            this.updateFrustum(this.validEnvData[0]);
            this.validCullSize[0] = this.findNextNode((SharedNode)((Object)group), false, false, 0);
            this.validCullList[0] = this.workCullList;
            ++this.lastOutputList;
        } else if (group instanceof Shape3D && ((Shape3D)((Object)group)).isVisible()) {
            if (this.checkOffscreens) {
                this.checkForOffscreens((Shape3D)((Object)group));
            }
            this.workCullList[0].renderable = (Shape3D)((Object)group);
            this.workCullList[0].transform.setIdentity();
            this.workCullList[0].numLights = 0;
            this.workCullList[0].numClipPlanes = 0;
            this.validCullSize[0] = 1;
            this.validCullList[0] = this.workCullList;
            ++this.lastOutputList;
        }
        if (this.checkOffscreens) {
            int n2;
            this.resizeOutputLists();
            for (n2 = 0; n2 < this.lastSubscene && !this.terminate; ++n2) {
                this.activeParent = this.pendingSubscenes[n2];
                this.visitedNodes.clear();
                if (this.processedPBufferTextures.contains((Object)this.pendingSubscenes[n2])) {
                    this.validSceneParents[this.lastOutputList][0] = (SceneGraphObject)((Object)this.pendingSubscenes[n2]);
                    this.validSceneParents[this.lastOutputList][1] = (SceneGraphObject)((Object)this.pendingParents[n2]);
                } else {
                    Scene scene2 = this.pendingSubscenes[n2].getRenderedScene();
                    Group group2 = scene2.getRenderedGeometry();
                    if (group2 == null) continue;
                    this.processedPBufferTextures.add((Object)this.pendingSubscenes[n2]);
                    this.lastLight = 0;
                    this.lastClip = 0;
                    this.lastTxStack = 0;
                    this.lastFogStack = 0;
                    this.workCullList = this.validCullList[this.lastOutputList];
                    this.validSceneParents[this.lastOutputList][0] = (SceneGraphObject)((Object)this.pendingSubscenes[n2]);
                    this.validSceneParents[this.lastOutputList][1] = (SceneGraphObject)((Object)this.pendingParents[n2]);
                    this.fillEnvData(scene2, this.validEnvData[this.lastOutputList]);
                    this.viewFrustum = this.validEnvData[this.lastOutputList].viewFrustum;
                    this.viewMatrix.set(this.validEnvData[this.lastOutputList].viewTransform);
                    this.updateFrustum(this.validEnvData[this.lastOutputList]);
                    this.validCullSize[this.lastOutputList] = this.cullSingle(group2);
                    this.validCullList[this.lastOutputList] = this.workCullList;
                }
                ++this.lastOutputList;
            }
            if (this.outputCullList.length < this.lastOutputList) {
                this.outputCullList = new CullOutputDetails[this.lastOutputList][];
                this.outputCullSize = new int[this.lastOutputList];
                this.outputEnvData = new RenderEnvironmentData[this.lastOutputList];
                this.outputSceneParents = new SceneGraphObject[this.lastOutputList][2];
            }
            for (n2 = 0; n2 < this.lastOutputList; ++n2) {
                this.outputCullList[n2] = this.validCullList[this.lastOutputList - n2 - 1];
                this.outputCullSize[n2] = this.validCullSize[this.lastOutputList - n2 - 1];
                this.outputEnvData[n2] = this.validEnvData[this.lastOutputList - n2 - 1];
                this.outputSceneParents[n2][0] = this.validSceneParents[this.lastOutputList - n2 - 1][0];
                this.outputSceneParents[n2][1] = this.validSceneParents[this.lastOutputList - n2 - 1][1];
            }
        } else {
            this.outputCullList[0] = this.validCullList[0];
            this.outputCullSize[0] = this.validCullSize[0];
            this.outputEnvData[0] = this.validEnvData[0];
            this.outputSceneParents[0][0] = this.validSceneParents[0][0];
            this.outputSceneParents[0][1] = this.validSceneParents[0][1];
        }
        this.processedPBufferTextures.clear();
        if (this.lastOutputList != 0 && this.receiver != null && !this.terminate) {
            this.receiver.culledOutput(this.outputEnvData, this.outputCullList, this.outputCullSize, this.outputSceneParents, this.lastOutputList);
        }
    }

    public void cull(Layer[] layerArray, int n, int n2) {
    }

    public void setCulledGeometryReceiver(CulledGeometryReceiver culledGeometryReceiver) {
        this.receiver = culledGeometryReceiver;
    }

    public void setOffscreenCheckEnabled(boolean bl) {
        this.checkOffscreens = bl;
    }

    public boolean isOffscreenCheckEnabled() {
        return this.checkOffscreens;
    }

    public void setEyePointOffset(float f, float f2, float f3) {
        this.useEyePoint = true;
        this.eyePoint[0] = f;
        this.eyePoint[1] = f2;
        this.eyePoint[2] = f3;
    }

    public void setScreenOrientation(float f, float f2, float f3, float f4) throws IllegalArgumentException {
        float f5 = f * f + f2 * f2 + f3 * f3;
        if (f5 == 0.0f) {
            throw new IllegalArgumentException("Zero length axis vector");
        }
        this.useOrientation = true;
        this.screenOrientation[0] = f;
        this.screenOrientation[1] = f2;
        this.screenOrientation[2] = f3;
        this.screenOrientation[3] = f4;
        double d = Math.cos(f4);
        double d2 = Math.sin(f4);
        this.orientationMatrix.m00 = (float)(d + (double)(f * f) * (1.0 - d));
        this.orientationMatrix.m01 = (float)((double)f3 * d2 + (double)(f2 * f) * (1.0 - d));
        this.orientationMatrix.m02 = (float)((double)(-f2) * d2 + (double)(f3 * f) * (1.0 - d));
        this.orientationMatrix.m10 = (float)((double)(-f3) * d2 + (double)(f * f2) * (1.0 - d));
        this.orientationMatrix.m11 = (float)(d + (double)(f2 * f2) * (1.0 - d));
        this.orientationMatrix.m12 = (float)((double)f * d2 + (double)(f3 * f2) * (1.0 - d));
        this.orientationMatrix.m20 = (float)((double)f2 * d2 + (double)(f * f3) * (1.0 - d));
        this.orientationMatrix.m21 = (float)((double)(-f) * d2 + (double)(f2 * f3) * (1.0 - d));
        this.orientationMatrix.m22 = (float)(d + (double)(f3 * f3) * (1.0 - d));
    }

    public void halt() {
        this.terminate = true;
    }

    private int cullSingle(Group group) {
        this.transformStack[0].setIdentity();
        if (group instanceof TransformGroup) {
            ((TransformGroup)group).getTransform(this.transformStack[0]);
        }
        return this.findAllNodes(group, false, false, 0);
    }

    private int findAllNodes(Group group, boolean bl, boolean bl2, int n) {
        int n2;
        int n3;
        Matrix4f matrix4f;
        int n4;
        if (this.terminate) {
            return 0;
        }
        BoundingVolume boundingVolume = group.getBounds();
        boolean bl3 = false;
        if (!bl) {
            n4 = bl2 ? this.lastTxStack - 1 : this.lastTxStack;
            matrix4f = this.transformStack[n4];
            n3 = boundingVolume.checkIntersectionFrustum(this.frustumPlanes, matrix4f);
            switch (n3) {
                case 0: {
                    return n;
                }
                case 2: {
                    bl3 = true;
                    break;
                }
            }
        }
        matrix4f = group.getRenderableChild();
        n4 = group.numRenderableChildren();
        n3 = 0;
        int n5 = 0;
        int n6 = n;
        boolean bl4 = false;
        for (n2 = 0; n2 < n4 && !this.terminate; ++n2) {
            Matrix4f matrix4f2;
            Leaf leaf;
            if (matrix4f[n2] instanceof Light) {
                leaf = (Light)matrix4f[n2];
                if (!((Light)leaf).isEnabled()) continue;
                this.resizeLightList();
                this.lightList[this.lastLight] = leaf;
                matrix4f2 = this.transformStack[this.lastTxStack];
                this.transformList[this.lastLight][0] = matrix4f2.m00;
                this.transformList[this.lastLight][1] = matrix4f2.m10;
                this.transformList[this.lastLight][2] = matrix4f2.m20;
                this.transformList[this.lastLight][3] = matrix4f2.m30;
                this.transformList[this.lastLight][4] = matrix4f2.m01;
                this.transformList[this.lastLight][5] = matrix4f2.m11;
                this.transformList[this.lastLight][6] = matrix4f2.m21;
                this.transformList[this.lastLight][7] = matrix4f2.m31;
                this.transformList[this.lastLight][8] = matrix4f2.m02;
                this.transformList[this.lastLight][9] = matrix4f2.m12;
                this.transformList[this.lastLight][10] = matrix4f2.m22;
                this.transformList[this.lastLight][11] = matrix4f2.m32;
                this.transformList[this.lastLight][12] = matrix4f2.m03;
                this.transformList[this.lastLight][13] = matrix4f2.m13;
                this.transformList[this.lastLight][14] = matrix4f2.m23;
                this.transformList[this.lastLight][15] = matrix4f2.m33;
                ++this.lastLight;
                ++n3;
                continue;
            }
            if (matrix4f[n2] instanceof ClipPlane) {
                leaf = (ClipPlane)matrix4f[n2];
                if (!((ClipPlane)leaf).isEnabled()) continue;
                this.resizeClipList();
                this.clipList[this.lastClip] = leaf;
                matrix4f2 = this.transformStack[this.lastTxStack];
                this.clipTxList[this.lastClip][0] = matrix4f2.m00;
                this.clipTxList[this.lastClip][1] = matrix4f2.m10;
                this.clipTxList[this.lastClip][2] = matrix4f2.m20;
                this.clipTxList[this.lastClip][3] = matrix4f2.m30;
                this.clipTxList[this.lastClip][4] = matrix4f2.m01;
                this.clipTxList[this.lastClip][5] = matrix4f2.m11;
                this.clipTxList[this.lastClip][6] = matrix4f2.m21;
                this.clipTxList[this.lastClip][7] = matrix4f2.m31;
                this.clipTxList[this.lastClip][8] = matrix4f2.m02;
                this.clipTxList[this.lastClip][9] = matrix4f2.m12;
                this.clipTxList[this.lastClip][10] = matrix4f2.m22;
                this.clipTxList[this.lastClip][11] = matrix4f2.m32;
                this.clipTxList[this.lastClip][12] = matrix4f2.m03;
                this.clipTxList[this.lastClip][13] = matrix4f2.m13;
                this.clipTxList[this.lastClip][14] = matrix4f2.m23;
                this.clipTxList[this.lastClip][15] = matrix4f2.m33;
                ++this.lastClip;
                ++n5;
                continue;
            }
            if (!(matrix4f[n2] instanceof Fog) || !((Fog)(leaf = (Fog)matrix4f[n2])).isEnabled() || ((Fog)leaf).isGlobalOnly() || bl4) continue;
            this.resizeFogStack();
            bl4 = true;
            ++this.lastFogStack;
            this.fogStack[this.lastFogStack] = leaf;
        }
        for (n2 = 0; n2 < n4 && !this.terminate; ++n2) {
            if (matrix4f[n2] instanceof Group) {
                boolean bl5 = matrix4f[n2] instanceof TransformGroup;
                if (bl5) {
                    this.resizeStack();
                    TransformGroup transformGroup = (TransformGroup)matrix4f[n2];
                    transformGroup.getTransform(this.transformStack[this.lastTxStack + 1]);
                    this.transformStack[this.lastTxStack + 1].mul(this.transformStack[this.lastTxStack], this.transformStack[this.lastTxStack + 1]);
                    ++this.lastTxStack;
                    n6 = this.findAllNodes((Group)matrix4f[n2], bl3, true, n6);
                } else {
                    n6 = this.findAllNodes((Group)matrix4f[n2], bl3, false, n6);
                }
                if (!bl5) continue;
                --this.lastTxStack;
                continue;
            }
            if (matrix4f[n2] instanceof Shape3D) {
                int n7;
                int n8;
                LightDetails[] lightDetailsArray;
                int n9;
                if (!((Shape3D)matrix4f[n2]).isVisible()) continue;
                if (this.checkOffscreens) {
                    this.checkForOffscreens((Shape3D)matrix4f[n2]);
                }
                this.resizeCullList(n6);
                this.workCullList[n6].renderable = (Shape3D)matrix4f[n2];
                this.workCullList[n6].localFog = this.fogStack[this.lastFogStack];
                Matrix4f matrix4f3 = this.transformStack[this.lastTxStack];
                this.workCullList[n6].transform.set(matrix4f3);
                int n10 = n9 = this.workCullList[n6].lights == null ? 0 : this.workCullList[n6].lights.length;
                if (n9 < this.lastLight) {
                    lightDetailsArray = new LightDetails[this.lastLight];
                    if (n9 != 0) {
                        System.arraycopy(this.workCullList[n6].lights, 0, lightDetailsArray, 0, n9);
                    }
                    for (n8 = n9; n8 < this.lastLight; ++n8) {
                        lightDetailsArray[n8] = new LightDetails();
                    }
                    this.workCullList[n6].lights = lightDetailsArray;
                }
                lightDetailsArray = this.workCullList[n6].lights;
                this.workCullList[n6].numLights = this.lastLight;
                for (n8 = 0; n8 < this.lastLight; ++n8) {
                    lightDetailsArray[n8].update(this.lightList[n8], this.transformList[n8]);
                }
                int n11 = n9 = this.workCullList[n6].clipPlanes == null ? 0 : this.workCullList[n6].clipPlanes.length;
                if (n9 < this.lastClip) {
                    ClipDetails[] clipDetailsArray = new ClipDetails[this.lastClip];
                    if (n9 != 0) {
                        System.arraycopy(this.workCullList[n6].clipPlanes, 0, clipDetailsArray, 0, n9);
                    }
                    for (n7 = n9; n7 < this.lastClip; ++n7) {
                        clipDetailsArray[n7] = new ClipDetails();
                    }
                    this.workCullList[n6].clipPlanes = clipDetailsArray;
                }
                ClipDetails[] clipDetailsArray = this.workCullList[n6].clipPlanes;
                this.workCullList[n6].numClipPlanes = this.lastClip;
                for (n7 = 0; n7 < this.lastClip; ++n7) {
                    clipDetailsArray[n7].update(this.clipList[n7], this.clipTxList[n7]);
                }
                ++n6;
                continue;
            }
            if (!(matrix4f[n2] instanceof SharedNode)) continue;
            n6 = this.findNextNode((SharedNode)matrix4f[n2], bl3, false, n6);
        }
        this.lastLight -= n3;
        this.lastClip -= n5;
        if (bl4) {
            this.fogStack[this.lastFogStack] = null;
            --this.lastFogStack;
        }
        return n6;
    }

    private int findNextNode(SharedNode sharedNode, boolean bl, boolean bl2, int n) {
        if (this.terminate) {
            return 0;
        }
        int n2 = n;
        Node node = sharedNode.getChild();
        while (node != null && node instanceof SharedNode) {
            node = ((SharedNode)node).getChild();
        }
        if (node instanceof Group) {
            boolean bl3 = node instanceof TransformGroup;
            if (bl3) {
                this.resizeStack();
                TransformGroup transformGroup = (TransformGroup)node;
                transformGroup.getTransform(this.transformStack[this.lastTxStack + 1]);
                this.transformStack[this.lastTxStack + 1].mul(this.transformStack[this.lastTxStack], this.transformStack[this.lastTxStack + 1]);
                ++this.lastTxStack;
                n2 = this.findAllNodes((Group)node, bl, true, n2);
                --this.lastTxStack;
            } else {
                n2 = this.findAllNodes((Group)node, bl, false, n2);
            }
        } else if (node instanceof Shape3D) {
            int n3;
            int n4;
            LightDetails[] lightDetailsArray;
            int n5;
            if (!((Shape3D)node).isVisible()) {
                return n2;
            }
            if (this.checkOffscreens) {
                this.checkForOffscreens((Shape3D)node);
            }
            this.resizeCullList(n);
            this.workCullList[n].renderable = (Shape3D)node;
            this.workCullList[n].localFog = this.fogStack[this.lastFogStack];
            Matrix4f matrix4f = this.transformStack[this.lastTxStack];
            this.workCullList[n].transform.set(matrix4f);
            int n6 = n5 = this.workCullList[n].lights == null ? 0 : this.workCullList[n].lights.length;
            if (n5 < this.lastLight) {
                lightDetailsArray = new LightDetails[this.lastLight];
                if (n5 != 0) {
                    System.arraycopy(this.workCullList[n].lights, 0, lightDetailsArray, 0, n5);
                }
                for (n4 = n5; n4 < this.lastLight; ++n4) {
                    lightDetailsArray[n4] = new LightDetails();
                }
                this.workCullList[n].lights = lightDetailsArray;
            }
            lightDetailsArray = this.workCullList[n].lights;
            this.workCullList[n].numLights = this.lastLight;
            for (n4 = 0; n4 < this.lastLight; ++n4) {
                lightDetailsArray[n4].update(this.lightList[n4], this.transformList[n4]);
            }
            int n7 = n5 = this.workCullList[n].clipPlanes == null ? 0 : this.workCullList[n].clipPlanes.length;
            if (n5 < this.lastClip) {
                ClipDetails[] clipDetailsArray = new ClipDetails[this.lastClip];
                if (n5 != 0) {
                    System.arraycopy(this.workCullList[n].clipPlanes, 0, clipDetailsArray, 0, n5);
                }
                for (n3 = n5; n3 < this.lastClip; ++n3) {
                    clipDetailsArray[n3] = new ClipDetails();
                }
                this.workCullList[n].clipPlanes = clipDetailsArray;
            }
            ClipDetails[] clipDetailsArray = this.workCullList[n].clipPlanes;
            this.workCullList[n].numClipPlanes = this.lastClip;
            for (n3 = 0; n3 < this.lastClip; ++n3) {
                clipDetailsArray[n3].update(this.clipList[n3], this.clipTxList[n3]);
            }
            ++n;
            ++n2;
        }
        return n2;
    }

    private void fillEnvData(Scene scene, RenderEnvironmentData renderEnvironmentData) {
        int n;
        ViewEnvironment viewEnvironment = scene.getViewEnvironment();
        renderEnvironmentData.userData = scene.getUserData();
        renderEnvironmentData.effectsProcessor = scene.getRenderEffectsProcessor();
        renderEnvironmentData.viewpoint = scene.getActiveView();
        renderEnvironmentData.background = scene.getActiveBackground();
        renderEnvironmentData.viewEnvironment = viewEnvironment;
        Fog fog = scene.getActiveFog();
        renderEnvironmentData.fog = fog != null && fog.isEnabled() ? fog : null;
        renderEnvironmentData.eyeOffset[0] = this.eyePoint[0];
        renderEnvironmentData.eyeOffset[1] = this.eyePoint[1];
        renderEnvironmentData.eyeOffset[2] = this.eyePoint[2];
        if (viewEnvironment == null) {
            double d = 1.0;
            double d2 = 0.1;
            double d3 = 1000.0;
            double d4 = 45.0;
            double d5 = d2 * Math.tan(d4 * Math.PI / 360.0);
            double d6 = -d5;
            double d7 = d6 * d;
            double d8 = d5 * d;
            renderEnvironmentData.viewFrustum[0] = d7;
            renderEnvironmentData.viewFrustum[1] = d8;
            renderEnvironmentData.viewFrustum[2] = d6;
            renderEnvironmentData.viewFrustum[3] = d5;
            renderEnvironmentData.viewFrustum[4] = d2;
            renderEnvironmentData.viewFrustum[5] = d3;
        } else {
            Rectangle rectangle = viewEnvironment.getViewport();
            if (rectangle == null) {
                renderEnvironmentData.hasViewport = false;
            } else {
                renderEnvironmentData.hasViewport = true;
                renderEnvironmentData.viewport.setBounds(rectangle);
            }
            viewEnvironment.generateViewFrustum(renderEnvironmentData.viewFrustum);
        }
        if (this.useEyePoint) {
            renderEnvironmentData.viewFrustum[0] = renderEnvironmentData.viewFrustum[0] - (double)this.eyePoint[0];
            renderEnvironmentData.viewFrustum[1] = renderEnvironmentData.viewFrustum[1] - (double)this.eyePoint[0];
            renderEnvironmentData.viewFrustum[2] = renderEnvironmentData.viewFrustum[2] - (double)this.eyePoint[1];
            renderEnvironmentData.viewFrustum[3] = renderEnvironmentData.viewFrustum[3] - (double)this.eyePoint[1];
            renderEnvironmentData.viewFrustum[4] = renderEnvironmentData.viewFrustum[4] - (double)this.eyePoint[2];
            renderEnvironmentData.viewFrustum[5] = renderEnvironmentData.viewFrustum[5] - (double)this.eyePoint[2];
        }
        Node node = renderEnvironmentData.viewpoint.getParent();
        int n2 = 0;
        while (node != null) {
            if (node instanceof SharedGroup || node instanceof SharedNode) {
                throw new IllegalArgumentException(SHARED_VP_MSG);
            }
            node = node.getParent();
            ++n2;
        }
        if (this.currentViewpointPath.length < n2) {
            this.currentViewpointPath = new TransformGroup[n2];
        }
        int n3 = 0;
        for (node = renderEnvironmentData.viewpoint.getParent(); node != null; node = node.getParent()) {
            if (!(node instanceof TransformGroup)) continue;
            this.currentViewpointPath[n3++] = (TransformGroup)node;
        }
        this.viewMatrix2.setIdentity();
        if (n3 != 0) {
            for (n = n3 - 1; n >= 0; --n) {
                this.currentViewpointPath[n].getTransform(this.viewMatrix1);
                this.viewMatrix2.mul(this.viewMatrix1);
            }
        }
        if (this.useOrientation) {
            this.viewMatrix2.mul(this.orientationMatrix);
        }
        renderEnvironmentData.viewTransform.set(this.viewMatrix2);
        if (renderEnvironmentData.background != null) {
            node = renderEnvironmentData.background.getParent();
            n2 = 0;
            while (node != null) {
                if (node instanceof SharedGroup || node instanceof SharedNode) {
                    throw new IllegalArgumentException(SHARED_BG_MSG);
                }
                node = node.getParent();
                ++n2;
            }
            if (this.currentViewpointPath.length < n2) {
                this.currentViewpointPath = new TransformGroup[n2];
            }
            n3 = 0;
            for (node = renderEnvironmentData.background.getParent(); node != null; node = node.getParent()) {
                if (!(node instanceof TransformGroup)) continue;
                this.currentViewpointPath[n3++] = (TransformGroup)node;
            }
            this.viewMatrix2.setIdentity();
            if (n3 != 0) {
                for (n = n3 - 1; n >= 0; --n) {
                    this.currentViewpointPath[n].getTransform(this.viewMatrix1);
                    this.viewMatrix2.mul(this.viewMatrix1);
                }
            }
            Matrix4f matrix4f = renderEnvironmentData.backgroundTransform;
            matrix4f.m00 = this.viewMatrix2.m00;
            matrix4f.m01 = this.viewMatrix2.m01;
            matrix4f.m02 = this.viewMatrix2.m02;
            matrix4f.m03 = this.viewMatrix2.m03;
            matrix4f.m10 = this.viewMatrix2.m10;
            matrix4f.m11 = this.viewMatrix2.m11;
            matrix4f.m12 = this.viewMatrix2.m12;
            matrix4f.m13 = this.viewMatrix2.m13;
            matrix4f.m20 = this.viewMatrix2.m20;
            matrix4f.m21 = this.viewMatrix2.m21;
            matrix4f.m22 = this.viewMatrix2.m22;
            matrix4f.m23 = this.viewMatrix2.m23;
            matrix4f.m30 = 0.0f;
            matrix4f.m31 = 0.0f;
            matrix4f.m32 = 0.0f;
            matrix4f.m33 = this.viewMatrix2.m33;
        }
    }

    private void checkForOffscreens(Shape3D shape3D) {
        Appearance appearance = shape3D.getAppearance();
        if (appearance == null) {
            return;
        }
        int n = appearance.numTextureUnits();
        if (n == 0) {
            return;
        }
        appearance.getTextureUnits(this.textureUnits);
        for (int i = 0; i < n; ++i) {
            Texture texture = this.textureUnits[i].getTexture();
            if (!(texture instanceof PBufferTextureSource) || this.visitedNodes.contains((Object)texture) || !((PBufferTextureSource)((Object)texture)).isRepaintRequired()) continue;
            this.resizeOffscreenList();
            this.pendingSubscenes[this.lastSubscene] = (PBufferTextureSource)((Object)texture);
            this.pendingParents[this.lastSubscene] = this.activeParent;
            this.visitedNodes.add((Object)texture);
            ++this.lastSubscene;
        }
    }

    private final void resizeCullList(int n) {
        if (n + 1 == this.workCullList.length) {
            int n2 = this.workCullList.length;
            int n3 = n2 + 20;
            CullOutputDetails[] cullOutputDetailsArray = new CullOutputDetails[n3];
            System.arraycopy(this.workCullList, 0, cullOutputDetailsArray, 0, n2);
            for (int i = n2; i < n3; ++i) {
                cullOutputDetailsArray[i] = new CullOutputDetails();
            }
            this.workCullList = cullOutputDetailsArray;
        }
    }

    private final void resizeOutputLists() {
        if (this.lastSubscene + 1 < this.validCullList.length) {
            return;
        }
        int n = this.validCullList.length;
        int n2 = n + 20;
        CullOutputDetails[][] cullOutputDetailsArrayArray = new CullOutputDetails[n2][];
        System.arraycopy(this.validCullList, 0, cullOutputDetailsArrayArray, 0, n);
        for (int i = n; i < n2; ++i) {
            cullOutputDetailsArrayArray[i] = new CullOutputDetails[200];
            for (int j = 0; j < 200; ++j) {
                cullOutputDetailsArrayArray[i][j] = new CullOutputDetails();
            }
        }
        this.validCullList = cullOutputDetailsArrayArray;
        int[] nArray = new int[n2];
        System.arraycopy(this.validCullSize, 0, nArray, 0, n);
        this.validCullSize = nArray;
        SceneGraphObject[][] sceneGraphObjectArrayArray = new SceneGraphObject[n2][];
        System.arraycopy(this.validSceneParents, 0, sceneGraphObjectArrayArray, 0, n);
        for (int i = n; i < n2; ++i) {
            sceneGraphObjectArrayArray[i] = new SceneGraphObject[2];
        }
        this.validSceneParents = sceneGraphObjectArrayArray;
        RenderEnvironmentData[] renderEnvironmentDataArray = new RenderEnvironmentData[n2];
        System.arraycopy(this.validEnvData, 0, renderEnvironmentDataArray, 0, n);
        for (int i = n; i < n2; ++i) {
            renderEnvironmentDataArray[i] = new RenderEnvironmentData();
        }
        this.validEnvData = renderEnvironmentDataArray;
    }

    private final void resizeOffscreenList() {
        if (this.lastSubscene + 1 == this.pendingSubscenes.length) {
            int n = this.pendingSubscenes.length;
            int n2 = n + 20;
            PBufferTextureSource[] pBufferTextureSourceArray = new PBufferTextureSource[n2];
            System.arraycopy(this.pendingSubscenes, 0, pBufferTextureSourceArray, 0, n);
            this.pendingSubscenes = pBufferTextureSourceArray;
            pBufferTextureSourceArray = new PBufferTextureSource[n2];
            System.arraycopy(this.pendingParents, 0, pBufferTextureSourceArray, 0, n);
            this.pendingParents = pBufferTextureSourceArray;
        }
    }

    private final void resizeLightList() {
        if (this.lastLight + 1 == this.lightList.length) {
            int n = this.lightList.length;
            int n2 = n + 20;
            Light[] lightArray = new Light[n2];
            System.arraycopy(this.lightList, 0, lightArray, 0, n);
            this.lightList = lightArray;
            float[][] fArrayArray = new float[n2][];
            System.arraycopy(this.transformList, 0, fArrayArray, 0, n);
            for (int i = n; i < n2; ++i) {
                fArrayArray[i] = new float[16];
            }
            this.transformList = fArrayArray;
        }
    }

    private final void resizeClipList() {
        if (this.lastClip + 1 == this.clipList.length) {
            int n = this.clipList.length;
            int n2 = n + 20;
            ClipPlane[] clipPlaneArray = new ClipPlane[n2];
            System.arraycopy(this.clipList, 0, clipPlaneArray, 0, n);
            this.clipList = clipPlaneArray;
            float[][] fArrayArray = new float[n2][];
            System.arraycopy(this.clipTxList, 0, fArrayArray, 0, n);
            for (int i = n; i < n2; ++i) {
                fArrayArray[i] = new float[16];
            }
            this.clipTxList = fArrayArray;
        }
    }

    private final void resizeStack() {
        if (this.lastTxStack + 1 == this.transformStack.length) {
            int n = this.transformStack.length;
            int n2 = n + 32;
            Matrix4f[] matrix4fArray = new Matrix4f[n2];
            System.arraycopy(this.transformStack, 0, matrix4fArray, 0, n);
            for (int i = n; i < n2; ++i) {
                matrix4fArray[i] = new Matrix4f();
            }
            this.transformStack = matrix4fArray;
        }
    }

    private final void resizeFogStack() {
        if (this.lastFogStack + 1 == this.fogStack.length) {
            int n = this.fogStack.length;
            int n2 = n + 32;
            Fog[] fogArray = new Fog[n2];
            System.arraycopy(this.fogStack, 0, fogArray, 0, n);
            this.fogStack = fogArray;
        }
    }

    private void updateFrustum(RenderEnvironmentData renderEnvironmentData) {
        float f = (float)this.viewFrustum[0];
        float f2 = (float)this.viewFrustum[1];
        float f3 = (float)this.viewFrustum[2];
        float f4 = (float)this.viewFrustum[3];
        float f5 = (float)this.viewFrustum[4];
        float f6 = (float)this.viewFrustum[5];
        float f7 = 2.0f * f5 / (f2 - f);
        float f8 = 2.0f * f5 / (f4 - f3);
        float f9 = (f2 + f) / (f2 - f);
        float f10 = (f4 + f3) / (f4 - f3);
        float f11 = -(f6 + f5) / (f6 - f5);
        float f12 = -(2.0f * f6 * f5) / (f6 - f5);
        this.prjMatrix.m00 = f7;
        this.prjMatrix.m01 = 0.0f;
        this.prjMatrix.m02 = f9;
        this.prjMatrix.m03 = 0.0f;
        this.prjMatrix.m10 = 0.0f;
        this.prjMatrix.m11 = f8;
        this.prjMatrix.m12 = f10;
        this.prjMatrix.m13 = 0.0f;
        this.prjMatrix.m20 = 0.0f;
        this.prjMatrix.m21 = 0.0f;
        this.prjMatrix.m22 = f11;
        this.prjMatrix.m23 = f12;
        this.prjMatrix.m30 = 0.0f;
        this.prjMatrix.m31 = 0.0f;
        this.prjMatrix.m32 = -1.0f;
        this.prjMatrix.m33 = 0.0f;
        renderEnvironmentData.projectionMatrix.set(this.prjMatrix);
        this.matrixUtils.inverse(this.viewMatrix, this.viewMatrix);
        this.viewMatrix.mul(this.prjMatrix, this.viewMatrix);
        this.prjMatrix.m00 = this.viewMatrix.m00;
        this.prjMatrix.m01 = this.viewMatrix.m10;
        this.prjMatrix.m02 = this.viewMatrix.m20;
        this.prjMatrix.m03 = this.viewMatrix.m30;
        this.prjMatrix.m10 = this.viewMatrix.m01;
        this.prjMatrix.m11 = this.viewMatrix.m11;
        this.prjMatrix.m12 = this.viewMatrix.m21;
        this.prjMatrix.m13 = this.viewMatrix.m31;
        this.prjMatrix.m20 = this.viewMatrix.m02;
        this.prjMatrix.m21 = this.viewMatrix.m12;
        this.prjMatrix.m22 = this.viewMatrix.m22;
        this.prjMatrix.m23 = this.viewMatrix.m32;
        this.prjMatrix.m30 = this.viewMatrix.m03;
        this.prjMatrix.m31 = this.viewMatrix.m13;
        this.prjMatrix.m32 = this.viewMatrix.m23;
        this.prjMatrix.m33 = this.viewMatrix.m33;
        f7 = this.prjMatrix.m03 - this.prjMatrix.m00;
        f8 = this.prjMatrix.m13 - this.prjMatrix.m10;
        float f13 = this.prjMatrix.m23 - this.prjMatrix.m20;
        float f14 = this.prjMatrix.m33 - this.prjMatrix.m30;
        this.frustumPlanes[0].x = f7;
        this.frustumPlanes[0].y = f8;
        this.frustumPlanes[0].z = f13;
        this.frustumPlanes[0].w = f14;
        f7 = this.prjMatrix.m03 + this.prjMatrix.m00;
        f8 = this.prjMatrix.m13 + this.prjMatrix.m10;
        f13 = this.prjMatrix.m23 + this.prjMatrix.m20;
        f14 = this.prjMatrix.m33 + this.prjMatrix.m30;
        this.frustumPlanes[1].x = f7;
        this.frustumPlanes[1].y = f8;
        this.frustumPlanes[1].z = f13;
        this.frustumPlanes[1].w = f14;
        f7 = this.prjMatrix.m03 + this.prjMatrix.m01;
        f8 = this.prjMatrix.m13 + this.prjMatrix.m11;
        f13 = this.prjMatrix.m23 + this.prjMatrix.m21;
        f14 = this.prjMatrix.m33 + this.prjMatrix.m31;
        this.frustumPlanes[2].x = f7;
        this.frustumPlanes[2].y = f8;
        this.frustumPlanes[2].z = f13;
        this.frustumPlanes[2].w = f14;
        f7 = this.prjMatrix.m03 - this.prjMatrix.m01;
        f8 = this.prjMatrix.m13 - this.prjMatrix.m11;
        f13 = this.prjMatrix.m23 - this.prjMatrix.m21;
        f14 = this.prjMatrix.m33 - this.prjMatrix.m31;
        this.frustumPlanes[3].x = f7;
        this.frustumPlanes[3].y = f8;
        this.frustumPlanes[3].z = f13;
        this.frustumPlanes[3].w = f14;
        f7 = this.prjMatrix.m03 - this.prjMatrix.m02;
        f8 = this.prjMatrix.m13 - this.prjMatrix.m12;
        f13 = this.prjMatrix.m23 - this.prjMatrix.m22;
        f14 = this.prjMatrix.m33 - this.prjMatrix.m32;
        this.frustumPlanes[4].x = f7;
        this.frustumPlanes[4].y = f8;
        this.frustumPlanes[4].z = f13;
        this.frustumPlanes[4].w = f14;
        f7 = this.prjMatrix.m03 + this.prjMatrix.m02;
        f8 = this.prjMatrix.m13 + this.prjMatrix.m12;
        f13 = this.prjMatrix.m23 + this.prjMatrix.m22;
        f14 = this.prjMatrix.m33 + this.prjMatrix.m32;
        this.frustumPlanes[5].x = f7;
        this.frustumPlanes[5].y = f8;
        this.frustumPlanes[5].z = f13;
        this.frustumPlanes[5].w = f14;
    }
}

