/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline;

import java.util.HashMap;
import org.j3d.aviatrix3d.Appearance;
import org.j3d.aviatrix3d.ClipDetails;
import org.j3d.aviatrix3d.CullOutputDetails;
import org.j3d.aviatrix3d.CustomRenderable;
import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.LightDetails;
import org.j3d.aviatrix3d.Material;
import org.j3d.aviatrix3d.NodeComponent;
import org.j3d.aviatrix3d.PBufferTextureSource;
import org.j3d.aviatrix3d.RenderDetails;
import org.j3d.aviatrix3d.RenderEnvironmentData;
import org.j3d.aviatrix3d.RenderInstructions;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.SortStage;
import org.j3d.aviatrix3d.SortedGeometryReceiver;
import org.j3d.aviatrix3d.Texture;
import org.j3d.aviatrix3d.TextureUnit;

public class SimpleTransparencySortStage
implements SortStage {
    private static final int LIST_START_SIZE = 1;
    private static final int TRANSPARENT_LIST_SIZE = 200;
    private SortedGeometryReceiver receiver;
    private RenderInstructions[] commandList;
    private CullOutputDetails[] transparentList;
    private TextureUnit[] textureTmp;
    private int lastGlobalId;
    private HashMap instructionMap;
    private boolean terminate;

    public SimpleTransparencySortStage() {
        this(1);
    }

    public SimpleTransparencySortStage(int n) {
        this.commandList = new RenderInstructions[n];
        this.transparentList = new CullOutputDetails[200];
        this.textureTmp = new TextureUnit[32];
        this.lastGlobalId = 0;
        for (int i = 0; i < n; ++i) {
            this.commandList[i] = new RenderInstructions();
        }
        this.instructionMap = new HashMap();
    }

    public void sort(RenderEnvironmentData[] renderEnvironmentDataArray, CullOutputDetails[][] cullOutputDetailsArray, int[] nArray, SceneGraphObject[][] sceneGraphObjectArray, int n, int n2) {
        int n3;
        this.terminate = false;
        if (this.commandList.length < n) {
            RenderInstructions[] renderInstructionsArray = new RenderInstructions[n];
            System.arraycopy(this.commandList, 0, renderInstructionsArray, 0, this.commandList.length);
            for (n3 = this.commandList.length; n3 < n; ++n3) {
                renderInstructionsArray[n3] = new RenderInstructions();
            }
            this.commandList = renderInstructionsArray;
        }
        int n4 = 0;
        n3 = 0;
        for (int i = 0; i < n && !this.terminate; ++i) {
            if (sceneGraphObjectArray[i][0] == null) {
                n4 = i;
                continue;
            }
            this.commandList[n3].pbuffer = (PBufferTextureSource)((Object)sceneGraphObjectArray[i][0]);
            this.commandList[n3].parentSource = (PBufferTextureSource)((Object)sceneGraphObjectArray[i][1]);
            this.commandList[n3].renderData = renderEnvironmentDataArray[i];
            RenderInstructions renderInstructions = (RenderInstructions)this.instructionMap.get(sceneGraphObjectArray[i][0]);
            if (renderInstructions != null) {
                this.commandList[n3].copyOf = renderInstructions;
            } else {
                this.commandList[n3].copyOf = null;
                this.sortSingle(cullOutputDetailsArray[i], nArray[i], this.commandList[n3]);
                this.instructionMap.put(sceneGraphObjectArray[i][0], this.commandList[n3]);
            }
            ++n3;
        }
        if (this.terminate) {
            this.instructionMap.clear();
            return;
        }
        this.commandList[n3].pbuffer = null;
        this.commandList[n3].renderData = renderEnvironmentDataArray[n4];
        this.sortSingle(cullOutputDetailsArray[n4], nArray[n4], this.commandList[n3]);
        if (this.terminate) {
            this.instructionMap.clear();
            return;
        }
        ++n3;
        if (this.receiver != null) {
            this.receiver.sortedOutput(this.commandList, n);
        }
        this.instructionMap.clear();
    }

    public void setSortedGeometryReceiver(SortedGeometryReceiver sortedGeometryReceiver) {
        this.receiver = sortedGeometryReceiver;
    }

    public void halt() {
        this.terminate = true;
    }

    private void sortSingle(CullOutputDetails[] cullOutputDetailsArray, int n, RenderInstructions renderInstructions) {
        int n2;
        int n3;
        int n4;
        int n5 = 2 + n << 1;
        for (n4 = 0; n4 < n; ++n4) {
            n5 += cullOutputDetailsArray[n4].numLights << 1;
        }
        if (renderInstructions.renderList.length < n5) {
            RenderDetails[] renderDetailsArray = new RenderDetails[n5];
            System.arraycopy(renderInstructions.renderList, 0, renderDetailsArray, 0, renderInstructions.renderList.length);
            for (n3 = renderInstructions.renderList.length; n3 < n5; ++n3) {
                renderDetailsArray[n3] = new RenderDetails();
            }
            renderInstructions.renderList = renderDetailsArray;
            renderInstructions.renderOps = new int[n5];
        }
        if (this.transparentList.length < n5) {
            this.transparentList = new CullOutputDetails[n5];
        }
        n4 = 0;
        n3 = 0;
        for (n2 = 0; n2 < n && !this.terminate; ++n2) {
            if (cullOutputDetailsArray[n2].renderable instanceof Shape3D) {
                NodeComponent nodeComponent;
                Shape3D shape3D = (Shape3D)cullOutputDetailsArray[n2].renderable;
                Appearance appearance = shape3D.getAppearance();
                if (appearance != null) {
                    nodeComponent = appearance.getMaterial();
                    if (nodeComponent != null && ((Material)nodeComponent).getTransparency() != 1.0f) {
                        this.transparentList[n3++] = cullOutputDetailsArray[n2];
                        continue;
                    }
                    int n6 = appearance.numTextureUnits();
                    if (n6 != 0) {
                        boolean bl = false;
                        appearance.getTextureUnits(this.textureTmp);
                        for (int i = 0; i < n6; ++i) {
                            Texture texture = this.textureTmp[i].getTexture();
                            if (texture == null) continue;
                            switch (texture.getFormat()) {
                                case 6406: 
                                case 6408: 
                                case 6410: {
                                    this.transparentList[n3++] = cullOutputDetailsArray[n2];
                                    bl = true;
                                    i = n6;
                                }
                            }
                        }
                        if (bl) continue;
                    }
                }
                if (((Geometry)(nodeComponent = shape3D.getGeometry())).hasTransparency()) {
                    this.transparentList[n3++] = cullOutputDetailsArray[n2];
                    continue;
                }
            } else if (cullOutputDetailsArray[n2].renderable instanceof CustomRenderable) {
                if (((CustomRenderable)cullOutputDetailsArray[n2].renderable).hasTransparency()) {
                    this.transparentList[n3++] = cullOutputDetailsArray[n2];
                    continue;
                }
            } else {
                System.out.println("Non-shape node in sorter " + cullOutputDetailsArray[n2].renderable);
                continue;
            }
            n4 = this.appendOutputShape(n4, cullOutputDetailsArray[n2], renderInstructions);
        }
        if (n3 == 0) {
            renderInstructions.numValid = n4;
            return;
        }
        renderInstructions.renderOps[n4++] = 11;
        for (n2 = 0; n2 < n3 && !this.terminate; ++n2) {
            n4 = this.appendOutputShape(n4, this.transparentList[n2], renderInstructions);
            this.transparentList[n2] = null;
        }
        renderInstructions.renderOps[n4++] = 12;
        renderInstructions.numValid = n4;
    }

    private int appendOutputShape(int n, CullOutputDetails cullOutputDetails, RenderInstructions renderInstructions) {
        Object object;
        Object object2;
        int n2;
        if (cullOutputDetails.numLights != 0) {
            for (n2 = 0; n2 < cullOutputDetails.numLights; ++n2) {
                object2 = cullOutputDetails.lights[n2];
                renderInstructions.renderList[n].renderable = ((LightDetails)object2).getLight();
                System.arraycopy(((LightDetails)object2).getTransform(), 0, renderInstructions.renderList[n].transform, 0, 16);
                ++this.lastGlobalId;
                renderInstructions.renderList[n].id = renderInstructions.renderList[n].id;
                renderInstructions.renderOps[n] = 9;
                ++n;
            }
        }
        if (cullOutputDetails.numClipPlanes != 0) {
            for (n2 = 0; n2 < cullOutputDetails.numClipPlanes; ++n2) {
                object2 = cullOutputDetails.clipPlanes[n2];
                renderInstructions.renderList[n].renderable = ((ClipDetails)object2).getClipPlane();
                System.arraycopy(((ClipDetails)object2).getTransform(), 0, renderInstructions.renderList[n].transform, 0, 16);
                ++this.lastGlobalId;
                renderInstructions.renderList[n].id = renderInstructions.renderList[n].id;
                renderInstructions.renderOps[n] = 17;
                ++n;
            }
        }
        n2 = 0;
        if (cullOutputDetails.localFog != null) {
            renderInstructions.renderList[n].id = n2 = this.lastGlobalId++;
            renderInstructions.renderList[n].renderable = cullOutputDetails.localFog;
            renderInstructions.renderOps[n] = 19;
            ++n;
        }
        if (cullOutputDetails.renderable instanceof Shape3D) {
            renderInstructions.renderList[n].renderable = cullOutputDetails.renderable;
            renderInstructions.renderList[n].transform[0] = cullOutputDetails.transform.m00;
            renderInstructions.renderList[n].transform[1] = cullOutputDetails.transform.m10;
            renderInstructions.renderList[n].transform[2] = cullOutputDetails.transform.m20;
            renderInstructions.renderList[n].transform[3] = cullOutputDetails.transform.m30;
            renderInstructions.renderList[n].transform[4] = cullOutputDetails.transform.m01;
            renderInstructions.renderList[n].transform[5] = cullOutputDetails.transform.m11;
            renderInstructions.renderList[n].transform[6] = cullOutputDetails.transform.m21;
            renderInstructions.renderList[n].transform[7] = cullOutputDetails.transform.m31;
            renderInstructions.renderList[n].transform[8] = cullOutputDetails.transform.m02;
            renderInstructions.renderList[n].transform[9] = cullOutputDetails.transform.m12;
            renderInstructions.renderList[n].transform[10] = cullOutputDetails.transform.m22;
            renderInstructions.renderList[n].transform[11] = cullOutputDetails.transform.m32;
            renderInstructions.renderList[n].transform[12] = cullOutputDetails.transform.m03;
            renderInstructions.renderList[n].transform[13] = cullOutputDetails.transform.m13;
            renderInstructions.renderList[n].transform[14] = cullOutputDetails.transform.m23;
            renderInstructions.renderList[n].transform[15] = cullOutputDetails.transform.m33;
            renderInstructions.renderOps[n] = 1;
            renderInstructions.renderList[++n].renderable = cullOutputDetails.renderable;
            renderInstructions.renderOps[n] = 2;
            ++n;
        } else if (cullOutputDetails.renderable instanceof CustomRenderable) {
            renderInstructions.renderList[n].renderable = cullOutputDetails.renderable;
            renderInstructions.renderList[n].instructions = cullOutputDetails.customData;
            renderInstructions.renderList[n].transform[0] = cullOutputDetails.transform.m00;
            renderInstructions.renderList[n].transform[1] = cullOutputDetails.transform.m10;
            renderInstructions.renderList[n].transform[2] = cullOutputDetails.transform.m20;
            renderInstructions.renderList[n].transform[3] = cullOutputDetails.transform.m30;
            renderInstructions.renderList[n].transform[4] = cullOutputDetails.transform.m01;
            renderInstructions.renderList[n].transform[5] = cullOutputDetails.transform.m11;
            renderInstructions.renderList[n].transform[6] = cullOutputDetails.transform.m21;
            renderInstructions.renderList[n].transform[7] = cullOutputDetails.transform.m31;
            renderInstructions.renderList[n].transform[8] = cullOutputDetails.transform.m02;
            renderInstructions.renderList[n].transform[9] = cullOutputDetails.transform.m12;
            renderInstructions.renderList[n].transform[10] = cullOutputDetails.transform.m22;
            renderInstructions.renderList[n].transform[11] = cullOutputDetails.transform.m32;
            renderInstructions.renderList[n].transform[12] = cullOutputDetails.transform.m03;
            renderInstructions.renderList[n].transform[13] = cullOutputDetails.transform.m13;
            renderInstructions.renderList[n].transform[14] = cullOutputDetails.transform.m23;
            renderInstructions.renderList[n].transform[15] = cullOutputDetails.transform.m33;
            renderInstructions.renderOps[n] = 4;
            ++n;
        }
        if (cullOutputDetails.localFog != null) {
            renderInstructions.renderList[n].id = n2;
            renderInstructions.renderList[n].renderable = cullOutputDetails.localFog;
            renderInstructions.renderOps[n] = 20;
            ++n;
        }
        if (cullOutputDetails.numClipPlanes != 0) {
            for (int i = cullOutputDetails.numClipPlanes - 1; i >= 0; --i) {
                object = cullOutputDetails.clipPlanes[i];
                renderInstructions.renderList[n].renderable = ((ClipDetails)object).getClipPlane();
                renderInstructions.renderList[n].id = this.lastGlobalId - (1 + i);
                renderInstructions.renderOps[n] = 18;
                ++n;
            }
        }
        if (cullOutputDetails.numLights != 0) {
            for (int i = cullOutputDetails.numLights - 1; i >= 0; --i) {
                object = cullOutputDetails.lights[i];
                renderInstructions.renderList[n].renderable = ((LightDetails)object).getLight();
                renderInstructions.renderList[n].id = this.lastGlobalId - (1 + i);
                renderInstructions.renderOps[n] = 10;
                ++n;
            }
        }
        return n;
    }
}

