/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.j3d.aviatrix3d.ApplicationUpdateObserver;
import org.j3d.aviatrix3d.AudioDevice;
import org.j3d.aviatrix3d.AudioPipeline;
import org.j3d.aviatrix3d.DeletableSceneGraphObject;
import org.j3d.aviatrix3d.DrawableSurface;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.InternalNodeUpdateListener;
import org.j3d.aviatrix3d.InvalidListenerSetTimingException;
import org.j3d.aviatrix3d.Layer;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.PickingHandler;
import org.j3d.aviatrix3d.RenderPipeline;
import org.j3d.aviatrix3d.RenderPipelineManager;
import org.j3d.aviatrix3d.Scene;
import org.j3d.aviatrix3d.ShaderSceneGraphObject;
import org.j3d.aviatrix3d.pipeline.DefaultPickingHandler;
import org.j3d.aviatrix3d.pipeline.ShutdownThread;
import org.j3d.aviatrix3d.pipeline.ThreadPrivilegedAction;
import org.j3d.aviatrix3d.pipeline.WorldRootGroup;
import org.j3d.util.HashSet;

public class SingleThreadRenderManager
implements Runnable,
NodeUpdateHandler,
RenderPipelineManager {
    private static final String ACTIVE_RENDERING_MSG = "You cannot make this call now because the system is currently rendering. To make this call, first disable the rendering. ";
    private static final int CHANGELIST_START_SIZE = 200;
    private static final int CHANGELIST_INCREMENT = 100;
    private static final int SHADERLIST_START_SIZE = 64;
    private static final int SHADERLIST_INCREMENT = 32;
    private WorldRootGroup root;
    private Scene worldScene;
    private NodeUpdateListener[] dataChangeList = new NodeUpdateListener[200];
    private NodeUpdateListener[] boundsChangeList;
    private Object[] dataSourceList = new Object[200];
    private Object[] boundsSourceList;
    private InternalNodeUpdateListener[] boundsInternalList;
    private int lastDataChangeItem = 0;
    private int lastBoundsChangeItem = 0;
    private HashSet dataChangeListenerSet = new HashSet(200);
    private HashSet dataChangeSrcSet = new HashSet(200);
    private HashSet boundsChangeListenerSet;
    private HashSet boundsChangeSrcSet;
    private ShaderSceneGraphObject[] shaderInitList;
    private ShaderSceneGraphObject[] shaderLogList;
    private int lastShaderInitItem = 0;
    private int lastShaderLogItem = 0;
    private HashSet shaderInitSet;
    private HashSet shaderLogSet;
    private DrawableSurface drawable;
    private AudioDevice audioDevice;
    private RenderPipeline pipeline;
    private AudioPipeline audioPipeline;
    private PickingHandler pickHandler;
    private int minimumCycleTime = 0;
    private boolean enabled = false;
    private Thread runtimeThread;
    private boolean terminate = false;
    private ApplicationUpdateObserver observer;
    private ReferenceQueue deletionQueue;
    private boolean pickPermitted = false;
    private Object writableBoundsObject;
    private Object writableDataObject;
    private boolean processing = false;
    private boolean sceneChanged = false;
    private Thread shutdownThread;

    public SingleThreadRenderManager() {
        this.boundsChangeList = new NodeUpdateListener[200];
        this.boundsInternalList = new InternalNodeUpdateListener[200];
        this.boundsSourceList = new Object[200];
        this.boundsChangeListenerSet = new HashSet(200);
        this.boundsChangeSrcSet = new HashSet(200);
        this.shaderInitList = new ShaderSceneGraphObject[64];
        this.shaderInitSet = new HashSet(64);
        this.shaderLogList = new ShaderSceneGraphObject[64];
        this.shaderLogSet = new HashSet(64);
        this.pickHandler = new DefaultPickingHandler();
        this.deletionQueue = new ReferenceQueue();
        this.root = new WorldRootGroup();
        this.root.addChild(null);
        this.root.setUpdateHandler(this);
        this.root.setLive(true);
        this.shutdownThread = new ShutdownThread(this);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Runtime runtime = Runtime.getRuntime();
                runtime.addShutdownHook(SingleThreadRenderManager.this.shutdownThread);
                return null;
            }
        });
    }

    public SingleThreadRenderManager(RenderPipeline renderPipeline, DrawableSurface drawableSurface) {
        this();
        this.pipeline = renderPipeline;
        this.drawable = drawableSurface;
    }

    public SingleThreadRenderManager(RenderPipeline renderPipeline, AudioPipeline audioPipeline, DrawableSurface drawableSurface, AudioDevice audioDevice) {
        this();
        this.pipeline = renderPipeline;
        this.audioPipeline = audioPipeline;
        this.drawable = drawableSurface;
        this.audioDevice = audioDevice;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled == bl) {
            return;
        }
        if (bl) {
            this.enabled = true;
            this.terminate = false;
            this.pickPermitted = false;
            if (this.runtimeThread == null) {
                ThreadPrivilegedAction threadPrivilegedAction = new ThreadPrivilegedAction(this);
                this.runtimeThread = threadPrivilegedAction.getThread();
            }
        } else {
            this.enabled = false;
            this.terminate = true;
            this.pickPermitted = true;
            if (this.pipeline != null) {
                this.pipeline.halt();
            }
            if (this.audioPipeline != null) {
                this.audioPipeline.halt();
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void renderOnce() throws IllegalStateException {
        if (this.enabled) {
            throw new IllegalStateException(ACTIVE_RENDERING_MSG);
        }
        this.processChangeList();
        this.processShaderLists();
        this.drawable.setRenderControlThread(Thread.currentThread());
        this.pipeline.render();
        this.pipeline.swapBuffers();
        this.drawable.setRenderControlThread(null);
    }

    public void requestFullSceneRender() {
        this.sceneChanged = true;
    }

    public void setScene(Scene scene) {
        Group group = null;
        if (scene != null) {
            group = scene.getRenderedGeometry();
        }
        this.worldScene = scene;
        this.writableBoundsObject = this.root;
        this.root.setChild(group, 0);
        this.writableBoundsObject = null;
        if (this.pipeline != null) {
            this.pipeline.setRenderableScene(scene);
        }
        if (this.audioPipeline != null) {
            this.audioPipeline.setRenderableScene(scene);
        }
        this.sceneChanged = true;
    }

    public Scene getScene() {
        return this.worldScene;
    }

    public void setLayers(Layer[] layerArray, int n) {
    }

    public int numLayers() {
        return 0;
    }

    public void getLayers(Layer[] layerArray) {
    }

    public void setMinimumFrameInterval(int n) {
        this.minimumCycleTime = n;
    }

    public int getMinimumFrameInterval() {
        return this.minimumCycleTime;
    }

    public void addPipeline(RenderPipeline renderPipeline) throws IllegalStateException {
        if (this.enabled) {
            throw new IllegalStateException(ACTIVE_RENDERING_MSG);
        }
        if (this.pipeline != null) {
            this.pipeline.setDrawableSurface(null);
        }
        this.pipeline = renderPipeline;
        if (this.pipeline != null) {
            if (this.pipeline.getDrawableSurface() == null) {
                this.pipeline.setDrawableSurface(this.drawable);
            }
            this.pipeline.setRenderableScene(this.worldScene);
        }
    }

    public void addAudioPipeline(AudioPipeline audioPipeline) throws IllegalStateException {
        if (this.enabled) {
            throw new IllegalStateException(ACTIVE_RENDERING_MSG);
        }
        if (this.audioPipeline != null) {
            this.audioPipeline.setAudioDevice(null);
        }
        this.audioPipeline = audioPipeline;
        if (this.audioPipeline != null) {
            if (this.audioPipeline.getAudioDevice() == null) {
                this.audioPipeline.setAudioDevice(this.audioDevice);
            }
            this.audioPipeline.setRenderableScene(this.worldScene);
        }
    }

    public void removePipeline(RenderPipeline renderPipeline) throws IllegalStateException {
        if (this.enabled) {
            throw new IllegalStateException(ACTIVE_RENDERING_MSG);
        }
        if (renderPipeline == this.pipeline) {
            this.pipeline.setDrawableSurface(null);
            this.pipeline.setRenderableScene(null);
            this.pipeline = null;
        }
    }

    public void removeAudioPipeline(AudioPipeline audioPipeline) throws IllegalStateException {
        if (this.enabled) {
            throw new IllegalStateException(ACTIVE_RENDERING_MSG);
        }
        if (audioPipeline == this.audioPipeline) {
            this.audioPipeline.setAudioDevice(null);
            this.audioPipeline.setRenderableScene(null);
            this.audioPipeline = null;
        }
    }

    public void setApplicationObserver(ApplicationUpdateObserver applicationUpdateObserver) {
        this.observer = applicationUpdateObserver;
    }

    public void disableInternalShutdown() {
        if (this.shutdownThread != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Runtime runtime = Runtime.getRuntime();
                    runtime.removeShutdownHook(SingleThreadRenderManager.this.shutdownThread);
                    return null;
                }
            });
            this.shutdownThread = null;
        }
    }

    public void shutdown() {
        if (this.terminate || !this.enabled) {
            return;
        }
        this.terminate = true;
        this.setEnabled(false);
        this.runtimeThread.interrupt();
        if (this.drawable != null) {
            this.drawable.dispose();
        }
        if (this.audioDevice != null) {
            this.audioDevice.dispose();
        }
        if (this.shutdownThread != null && this.observer != null) {
            try {
                this.observer.appShutdown();
            }
            catch (Exception exception) {
                System.out.println("Error in user callback for shutdown " + exception.getMessage());
                exception.printStackTrace();
            }
            this.observer = null;
        }
    }

    public void run() {
        this.drawable.setRenderControlThread(this.runtimeThread);
        while (!this.terminate) {
            Reference reference;
            long l = System.currentTimeMillis();
            if (!this.terminate && this.observer != null) {
                this.pickPermitted = true;
                this.observer.updateSceneGraph();
                this.pickPermitted = false;
            }
            if (this.terminate) break;
            while ((reference = this.deletionQueue.poll()) != null) {
                DeletableSceneGraphObject deletableSceneGraphObject = (DeletableSceneGraphObject)reference.get();
                this.drawable.queueDeletedObject(deletableSceneGraphObject);
            }
            if (this.terminate) break;
            this.processShaderLists();
            if (this.terminate) break;
            if (this.lastDataChangeItem == 0 && this.lastBoundsChangeItem == 0 && !this.sceneChanged) {
                this.pipeline.displayOnly();
                if (this.terminate) break;
                if (this.audioPipeline != null) {
                    this.audioPipeline.displayOnly();
                }
            } else {
                this.processChangeList();
                if (this.terminate) break;
                this.sceneChanged = false;
                this.pipeline.render();
                if (this.terminate) break;
                if (this.audioPipeline != null) {
                    this.audioPipeline.render();
                }
            }
            if (this.terminate) break;
            this.pipeline.swapBuffers();
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            if (l3 < (long)this.minimumCycleTime) {
                try {
                    Thread.sleep((long)this.minimumCycleTime - l3);
                }
                catch (InterruptedException interruptedException) {
                    if (this.terminate) break;
                }
            }
            Thread.yield();
        }
        this.runtimeThread = null;
        this.drawable.setRenderControlThread(null);
        if (this.audioDevice != null) {
            this.audioDevice.setRenderControlThread(null);
        }
    }

    public boolean isDataWritePermitted(Object object) {
        return object == this.writableDataObject || !this.enabled;
    }

    public boolean isBoundsWritePermitted(Object object) {
        return object == this.writableBoundsObject || !this.enabled;
    }

    public boolean isPickingPermitted() {
        return this.pickPermitted;
    }

    public synchronized boolean boundsChanged(NodeUpdateListener nodeUpdateListener, Object object, InternalNodeUpdateListener internalNodeUpdateListener) throws InvalidListenerSetTimingException {
        if (this.processing) {
            throw new InvalidListenerSetTimingException("boundsChanged cannot be called outside the App Thread");
        }
        if (this.boundsChangeSrcSet.contains(object) && this.boundsChangeListenerSet.contains((Object)nodeUpdateListener)) {
            return false;
        }
        this.boundsChangeListenerSet.add((Object)nodeUpdateListener);
        this.boundsChangeSrcSet.add(object);
        this.resizeBoundsChangeList();
        this.boundsChangeList[this.lastBoundsChangeItem] = nodeUpdateListener;
        this.boundsInternalList[this.lastBoundsChangeItem] = internalNodeUpdateListener;
        this.boundsSourceList[this.lastBoundsChangeItem] = object;
        ++this.lastBoundsChangeItem;
        return true;
    }

    public synchronized void dataChanged(NodeUpdateListener nodeUpdateListener, Object object) throws InvalidListenerSetTimingException {
        if (this.processing) {
            throw new InvalidListenerSetTimingException("dataChanged cannot be called in NodeUpdateListener");
        }
        if (this.dataChangeSrcSet.contains(object) && this.dataChangeListenerSet.contains((Object)nodeUpdateListener)) {
            return;
        }
        this.dataChangeListenerSet.add((Object)nodeUpdateListener);
        this.dataChangeSrcSet.add(object);
        this.resizeDataChangeList();
        this.dataChangeList[this.lastDataChangeItem] = nodeUpdateListener;
        this.dataSourceList[this.lastDataChangeItem] = object;
        ++this.lastDataChangeItem;
    }

    public void objectRemoved(DeletableSceneGraphObject deletableSceneGraphObject) {
        new SoftReference<DeletableSceneGraphObject>(deletableSceneGraphObject, this.deletionQueue);
    }

    public PickingHandler getPickHandler() {
        return this.pickHandler;
    }

    public void shaderRequiresInit(ShaderSceneGraphObject shaderSceneGraphObject, boolean bl) {
        if (this.processing && !bl) {
            throw new RuntimeException("shaderRequiresInit cannot be called in NodeUpdateListener");
        }
        if (this.shaderInitSet.contains((Object)shaderSceneGraphObject)) {
            return;
        }
        this.shaderInitSet.add((Object)shaderSceneGraphObject);
        this.resizeShaderInitList();
        this.shaderInitList[this.lastShaderInitItem] = shaderSceneGraphObject;
        ++this.lastShaderInitItem;
    }

    public void shaderRequiresLogInfo(ShaderSceneGraphObject shaderSceneGraphObject, boolean bl) {
        if (this.processing && !bl) {
            throw new RuntimeException("shaderRequiresLog cannot be called in NodeUpdateListener");
        }
        if (this.shaderLogSet.contains((Object)shaderSceneGraphObject)) {
            return;
        }
        this.shaderLogSet.add((Object)shaderSceneGraphObject);
        this.resizeShaderLogList();
        this.shaderLogList[this.lastShaderLogItem] = shaderSceneGraphObject;
        ++this.lastShaderLogItem;
    }

    public void setDrawableSurface(DrawableSurface drawableSurface) {
        if (drawableSurface != null) {
            if (this.pipeline.getDrawableSurface() == null) {
                this.pipeline.setDrawableSurface(drawableSurface);
            }
        } else if (this.pipeline.getDrawableSurface() == drawableSurface) {
            this.pipeline.setDrawableSurface(null);
        }
        this.drawable = drawableSurface;
    }

    public void setAudioDevice(AudioDevice audioDevice) {
        if (audioDevice != null) {
            if (this.audioPipeline.getAudioDevice() == null) {
                this.audioPipeline.setAudioDevice(audioDevice);
            }
        } else if (this.audioPipeline.getAudioDevice() == audioDevice) {
            this.audioPipeline.setAudioDevice(null);
        }
        this.audioDevice = audioDevice;
    }

    private void processChangeList() {
        int n;
        this.processing = true;
        for (n = 0; n < this.lastBoundsChangeItem; ++n) {
            this.writableBoundsObject = this.boundsSourceList[n];
            this.boundsChangeList[n].updateNodeBoundsChanges(this.boundsSourceList[n]);
            this.boundsChangeList[n] = null;
            this.boundsSourceList[n] = null;
        }
        this.writableBoundsObject = null;
        for (n = 0; n < this.lastBoundsChangeItem; ++n) {
            this.boundsInternalList[n].updateBoundsAndNotify();
            this.boundsInternalList[n] = null;
        }
        this.lastBoundsChangeItem = 0;
        this.boundsChangeSrcSet.clear();
        this.boundsChangeListenerSet.clear();
        for (n = 0; n < this.lastDataChangeItem; ++n) {
            this.writableDataObject = this.dataSourceList[n];
            this.dataChangeList[n].updateNodeDataChanges(this.dataSourceList[n]);
            this.dataChangeList[n] = null;
            this.dataSourceList[n] = null;
        }
        this.writableDataObject = null;
        this.lastDataChangeItem = 0;
        this.dataChangeSrcSet.clear();
        this.dataChangeListenerSet.clear();
        this.processing = false;
    }

    private void processShaderLists() {
        int n;
        if (this.lastShaderInitItem == 0 && this.lastShaderLogItem == 0) {
            return;
        }
        this.drawable.queueShaderRequests(this.shaderInitList, this.lastShaderInitItem, this.shaderLogList, this.lastShaderLogItem);
        for (n = 0; n < this.lastShaderInitItem; ++n) {
            this.shaderInitList[0] = null;
        }
        for (n = 0; n < this.lastShaderLogItem; ++n) {
            this.shaderLogList[0] = null;
        }
        this.lastShaderInitItem = 0;
        this.lastShaderLogItem = 0;
        this.shaderInitSet.clear();
        this.shaderLogSet.clear();
    }

    private final void resizeDataChangeList() {
        if (this.lastDataChangeItem + 1 == this.dataChangeList.length) {
            int n = this.dataChangeList.length;
            int n2 = n + 100;
            NodeUpdateListener[] nodeUpdateListenerArray = new NodeUpdateListener[n2];
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.dataChangeList, 0, nodeUpdateListenerArray, 0, n);
            System.arraycopy(this.dataSourceList, 0, objectArray, 0, n);
            this.dataChangeList = nodeUpdateListenerArray;
            this.dataSourceList = objectArray;
        }
    }

    private final void resizeBoundsChangeList() {
        if (this.lastBoundsChangeItem + 1 == this.boundsChangeList.length) {
            int n = this.boundsChangeList.length;
            int n2 = n + 100;
            NodeUpdateListener[] nodeUpdateListenerArray = new NodeUpdateListener[n2];
            InternalNodeUpdateListener[] internalNodeUpdateListenerArray = new InternalNodeUpdateListener[n2];
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.boundsChangeList, 0, nodeUpdateListenerArray, 0, n);
            System.arraycopy(this.boundsSourceList, 0, objectArray, 0, n);
            System.arraycopy(this.boundsInternalList, 0, internalNodeUpdateListenerArray, 0, n);
            this.boundsChangeList = nodeUpdateListenerArray;
            this.boundsSourceList = objectArray;
            this.boundsInternalList = internalNodeUpdateListenerArray;
        }
    }

    private final void resizeShaderInitList() {
        if (this.lastShaderInitItem + 1 == this.shaderInitList.length) {
            int n = this.shaderInitList.length;
            int n2 = n + 32;
            ShaderSceneGraphObject[] shaderSceneGraphObjectArray = new ShaderSceneGraphObject[n2];
            System.arraycopy(this.shaderInitList, 0, shaderSceneGraphObjectArray, 0, n);
            this.shaderInitList = shaderSceneGraphObjectArray;
        }
    }

    private final void resizeShaderLogList() {
        if (this.lastShaderLogItem + 1 == this.shaderLogList.length) {
            int n = this.shaderLogList.length;
            int n2 = n + 32;
            ShaderSceneGraphObject[] shaderSceneGraphObjectArray = new ShaderSceneGraphObject[n2];
            System.arraycopy(this.shaderLogList, 0, shaderSceneGraphObjectArray, 0, n);
            this.shaderLogList = shaderSceneGraphObjectArray;
        }
    }
}

