/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline;

import java.util.Arrays;
import java.util.HashMap;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import org.j3d.aviatrix3d.Appearance;
import org.j3d.aviatrix3d.BlendAttributes;
import org.j3d.aviatrix3d.BoundingVolume;
import org.j3d.aviatrix3d.ClipDetails;
import org.j3d.aviatrix3d.CullOutputDetails;
import org.j3d.aviatrix3d.CustomRenderable;
import org.j3d.aviatrix3d.Fog;
import org.j3d.aviatrix3d.FragmentShader;
import org.j3d.aviatrix3d.GL14Shader;
import org.j3d.aviatrix3d.GLSLangShader;
import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.LightDetails;
import org.j3d.aviatrix3d.LineAttributes;
import org.j3d.aviatrix3d.Material;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeComponent;
import org.j3d.aviatrix3d.PBufferTextureSource;
import org.j3d.aviatrix3d.PointAttributes;
import org.j3d.aviatrix3d.PolygonAttributes;
import org.j3d.aviatrix3d.RenderDetails;
import org.j3d.aviatrix3d.RenderEnvironmentData;
import org.j3d.aviatrix3d.RenderInstructions;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.Shader;
import org.j3d.aviatrix3d.ShaderArguments;
import org.j3d.aviatrix3d.ShaderProgram;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.SortStage;
import org.j3d.aviatrix3d.SortedGeometryReceiver;
import org.j3d.aviatrix3d.Texture;
import org.j3d.aviatrix3d.TextureUnit;
import org.j3d.aviatrix3d.VertexShader;
import org.j3d.aviatrix3d.pipeline.StateSortComparator;
import org.j3d.util.HashSet;
import org.j3d.util.MatrixUtils;

public class StateAndTransparencyDepthSortStage
implements SortStage {
    private static final String INVALID_DEPTH_MSG = "The depthBits must be greater than or equal to 1";
    private static final int LIST_START_SIZE = 1;
    private static final int TRANSPARENT_LIST_SIZE = 200;
    private static final int REALLOC_SIZE = 1024;
    private static final int GUESS_NUM_COMPONENTS = 5;
    private static final int DEFAULT_DEPTH_BITS = 16;
    private static final Integer[] TEX_IDS = new Integer[32];
    private final int depthAccuracy;
    private SortedGeometryReceiver receiver;
    private RenderInstructions[] commandList;
    private CullOutputDetails[] transparentList;
    private CullOutputDetails[] unsortedTransparentList;
    private CullOutputDetails[] opaqueList;
    private float[] depthList1;
    private int[] depthList2;
    private int[] countList;
    private TextureUnit[] textureTmp;
    private int lastGlobalId;
    private HashMap instructionMap;
    private StateSortComparator stateComparator;
    private Matrix4f modelMatrix;
    private Matrix4f cameraMatrix;
    private Point3f wkPoint;
    private float[] center;
    private LightDetails[] newLights;
    private Object[] lightTmp;
    private HashSet currentLights;
    private HashSet oldLights;
    private HashSet keepLights;
    private HashMap lightIdMap;
    private ClipDetails[] newClipPlanes;
    private Object[] clipTmp;
    private HashSet currentClipPlanes;
    private HashSet oldClipPlanes;
    private HashSet keepClipPlanes;
    private HashMap clipIdMap;
    private Appearance currentAppearance;
    private Material currentMaterial;
    private PolygonAttributes currentPolyAttr;
    private LineAttributes currentLineAttr;
    private PointAttributes currentPointAttr;
    private BlendAttributes currentBlendAttr;
    private Shader currentShader;
    private ShaderProgram currentShaderProgram;
    private ShaderArguments currentShaderArgs;
    private VertexShader currentVtxShader;
    private FragmentShader currentFragShader;
    private Fog currentFog;
    private TextureUnit[] currentTextures;
    private int numTextures;
    private int req_size;
    private MatrixUtils matrixUtils;
    private boolean terminate;

    public StateAndTransparencyDepthSortStage() {
        this(1, 16);
    }

    public StateAndTransparencyDepthSortStage(int n) {
        this(n, 16);
    }

    public StateAndTransparencyDepthSortStage(int n, int n2) {
        int n3;
        if (n2 < 1) {
            throw new IllegalArgumentException(INVALID_DEPTH_MSG);
        }
        int n4 = 1;
        for (n3 = 1; n3 < n2; ++n3) {
            n4 <<= 1;
        }
        this.depthAccuracy = n4;
        this.transparentList = new CullOutputDetails[200];
        this.unsortedTransparentList = new CullOutputDetails[200];
        this.opaqueList = new CullOutputDetails[200];
        this.depthList1 = new float[200];
        this.depthList2 = new int[200];
        this.countList = new int[this.depthAccuracy];
        this.instructionMap = new HashMap();
        this.wkPoint = new Point3f();
        this.modelMatrix = new Matrix4f();
        this.cameraMatrix = new Matrix4f();
        this.center = new float[3];
        this.lastGlobalId = 0;
        this.commandList = new RenderInstructions[n];
        for (n3 = 0; n3 < n; ++n3) {
            this.commandList[n3] = new RenderInstructions();
        }
        this.instructionMap = new HashMap();
        this.stateComparator = new StateSortComparator();
        this.currentLights = new HashSet();
        this.keepLights = new HashSet();
        this.oldLights = new HashSet();
        this.lightIdMap = new HashMap();
        this.lightTmp = new Object[24];
        this.newLights = new LightDetails[32];
        this.currentClipPlanes = new HashSet();
        this.keepClipPlanes = new HashSet();
        this.oldClipPlanes = new HashSet();
        this.clipIdMap = new HashMap();
        this.clipTmp = new Object[24];
        this.newClipPlanes = new ClipDetails[32];
        this.currentTextures = new TextureUnit[32];
        this.textureTmp = new TextureUnit[32];
        this.matrixUtils = new MatrixUtils();
    }

    public void sort(RenderEnvironmentData[] renderEnvironmentDataArray, CullOutputDetails[][] cullOutputDetailsArray, int[] nArray, SceneGraphObject[][] sceneGraphObjectArray, int n, int n2) {
        int n3;
        this.terminate = false;
        if (this.commandList.length < n) {
            RenderInstructions[] renderInstructionsArray = new RenderInstructions[n];
            System.arraycopy(this.commandList, 0, renderInstructionsArray, 0, this.commandList.length);
            for (n3 = this.commandList.length; n3 < n; ++n3) {
                renderInstructionsArray[n3] = new RenderInstructions();
            }
            this.commandList = renderInstructionsArray;
        }
        int n4 = 0;
        n3 = 0;
        for (int i = 0; i < n && !this.terminate; ++i) {
            if (sceneGraphObjectArray[i][0] == null) {
                n4 = i;
                continue;
            }
            this.commandList[n3].pbuffer = (PBufferTextureSource)((Object)sceneGraphObjectArray[i][0]);
            this.commandList[n3].parentSource = (PBufferTextureSource)((Object)sceneGraphObjectArray[i][1]);
            this.commandList[n3].renderData = renderEnvironmentDataArray[i];
            RenderInstructions renderInstructions = (RenderInstructions)this.instructionMap.get(sceneGraphObjectArray[i][0]);
            if (renderInstructions != null) {
                this.commandList[n3].copyOf = renderInstructions;
            } else {
                this.commandList[n3].copyOf = null;
                this.sortSingle(renderEnvironmentDataArray[i].viewTransform, cullOutputDetailsArray[i], nArray[i], this.commandList[n3]);
                this.instructionMap.put(sceneGraphObjectArray[i][0], this.commandList[n3]);
            }
            ++n3;
        }
        if (this.terminate) {
            this.instructionMap.clear();
            return;
        }
        this.commandList[n3].pbuffer = null;
        this.commandList[n3].renderData = renderEnvironmentDataArray[n4];
        if (this.terminate) {
            this.instructionMap.clear();
            return;
        }
        this.sortSingle(renderEnvironmentDataArray[n4].viewTransform, cullOutputDetailsArray[n4], nArray[n4], this.commandList[n3]);
        if (this.terminate) {
            this.instructionMap.clear();
            return;
        }
        ++n3;
        if (this.receiver != null) {
            this.receiver.sortedOutput(this.commandList, n);
        }
        this.instructionMap.clear();
    }

    public void setSortedGeometryReceiver(SortedGeometryReceiver sortedGeometryReceiver) {
        this.receiver = sortedGeometryReceiver;
    }

    public void halt() {
        this.terminate = true;
    }

    private void sortSingle(Matrix4f matrix4f, CullOutputDetails[] cullOutputDetailsArray, int n, RenderInstructions renderInstructions) {
        int n2;
        int n3;
        SceneGraphObject sceneGraphObject;
        int n4;
        int n5 = 2 + n * 5;
        if (n5 > this.req_size) {
            this.req_size = n5;
        }
        if (this.transparentList.length < this.req_size) {
            this.transparentList = new CullOutputDetails[this.req_size];
            this.unsortedTransparentList = new CullOutputDetails[this.req_size];
            this.depthList1 = new float[this.req_size];
            this.depthList2 = new int[this.req_size];
            this.opaqueList = new CullOutputDetails[this.req_size];
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (n4 = 0; n4 < n && !this.terminate; ++n4) {
            if (cullOutputDetailsArray[n4].renderable instanceof Shape3D) {
                NodeComponent nodeComponent;
                Shape3D shape3D = (Shape3D)cullOutputDetailsArray[n4].renderable;
                Appearance appearance = shape3D.getAppearance();
                if (appearance != null) {
                    nodeComponent = appearance.getBlendAttributes();
                    if (nodeComponent != null) {
                        this.opaqueList[n8++] = cullOutputDetailsArray[n4];
                        continue;
                    }
                    Shader shader = appearance.getShader();
                    if (shader != null) {
                        this.opaqueList[n8++] = cullOutputDetailsArray[n4];
                        continue;
                    }
                    sceneGraphObject = appearance.getMaterial();
                    if (sceneGraphObject != null && ((Material)sceneGraphObject).getTransparency() != 1.0f) {
                        this.unsortedTransparentList[n7++] = cullOutputDetailsArray[n4];
                        continue;
                    }
                    int n9 = appearance.numTextureUnits();
                    if (n9 != 0) {
                        n3 = 0;
                        appearance.getTextureUnits(this.textureTmp);
                        for (int i = 0; i < n9; ++i) {
                            Texture texture = this.textureTmp[i].getTexture();
                            if (texture == null) continue;
                            switch (texture.getFormat()) {
                                case 6406: 
                                case 6408: 
                                case 6410: {
                                    this.unsortedTransparentList[n7++] = cullOutputDetailsArray[n4];
                                    n3 = 1;
                                    i = n9;
                                }
                            }
                        }
                        if (n3 != 0) continue;
                    }
                }
                if (((Geometry)(nodeComponent = shape3D.getGeometry())).hasTransparency()) {
                    ++n5;
                    this.unsortedTransparentList[n7++] = cullOutputDetailsArray[n4];
                    continue;
                }
            } else if (cullOutputDetailsArray[n4].renderable instanceof CustomRenderable) {
                if (((CustomRenderable)cullOutputDetailsArray[n4].renderable).hasTransparency()) {
                    ++n5;
                    this.unsortedTransparentList[n7++] = cullOutputDetailsArray[n4];
                } else {
                    this.opaqueList[n8++] = cullOutputDetailsArray[n4];
                }
            } else {
                System.out.println("Non-shape node in sorter " + cullOutputDetailsArray[n4].renderable);
                continue;
            }
            this.opaqueList[n8++] = cullOutputDetailsArray[n4];
        }
        if (this.terminate) {
            return;
        }
        Arrays.sort(this.opaqueList, 0, n8, this.stateComparator);
        if (this.terminate) {
            return;
        }
        if (renderInstructions.renderList.length < n5) {
            this.req_size = n5;
            if (this.req_size - renderInstructions.renderList.length < 1024) {
                this.req_size = renderInstructions.renderList.length + 1024;
            }
            RenderDetails[] renderDetailsArray = new RenderDetails[this.req_size];
            System.arraycopy(renderInstructions.renderList, 0, renderDetailsArray, 0, renderInstructions.renderList.length);
            for (int i = renderInstructions.renderList.length; i < this.req_size; ++i) {
                renderDetailsArray[i] = new RenderDetails();
            }
            renderInstructions.renderList = renderDetailsArray;
            renderInstructions.renderOps = new int[this.req_size];
        }
        n4 = 0;
        boolean bl = false;
        while (!bl) {
            try {
                for (int i = n4; i < n8 && !this.terminate; ++i) {
                    n6 = this.appendObject(this.opaqueList[i], renderInstructions, n6);
                }
                bl = true;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n4 = n6;
                this.realloc(renderInstructions);
            }
        }
        bl = false;
        while (!bl) {
            try {
                n6 = this.cleanupVisuals(renderInstructions, n6);
                bl = true;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.realloc(renderInstructions);
            }
        }
        n5 = n6 + 1 + n7 << 1;
        if (n5 > this.req_size) {
            this.req_size = n5;
        }
        if (n7 > 0 && renderInstructions.renderList.length < this.req_size) {
            this.realloc(renderInstructions);
        }
        if (this.terminate) {
            return;
        }
        switch (n7) {
            case 0: {
                renderInstructions.numValid = n6;
                bl = false;
                while (!bl) {
                    try {
                        n6 = this.cleanupObjects(renderInstructions, n6);
                        bl = true;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        this.realloc(renderInstructions);
                    }
                }
                renderInstructions.numValid = n6;
                return;
            }
            case 1: {
                renderInstructions.renderOps[n6++] = 11;
                n6 = this.appendObject(this.unsortedTransparentList[0], renderInstructions, n6);
                this.unsortedTransparentList[0] = null;
                bl = false;
                while (!bl) {
                    try {
                        n6 = this.cleanupObjects(renderInstructions, n6);
                        bl = true;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        this.realloc(renderInstructions);
                    }
                }
                renderInstructions.renderOps[n6++] = 12;
                renderInstructions.numValid = n6;
                return;
            }
        }
        float f = Float.NEGATIVE_INFINITY;
        float f2 = Float.POSITIVE_INFINITY;
        this.matrixUtils.inverse(matrix4f, this.cameraMatrix);
        for (int i = 0; i < n7 && !this.terminate; ++i) {
            this.modelMatrix.set(this.unsortedTransparentList[i].transform);
            sceneGraphObject = (Shape3D)this.unsortedTransparentList[i].renderable;
            BoundingVolume boundingVolume = ((Node)sceneGraphObject).getBounds();
            boundingVolume.getCenter(this.center);
            this.wkPoint.x = this.center[0];
            this.wkPoint.y = this.center[1];
            this.wkPoint.z = this.center[2];
            this.modelMatrix.transform(this.wkPoint);
            this.cameraMatrix.transform(this.wkPoint);
            this.depthList1[i] = this.wkPoint.z;
            if (f < this.wkPoint.z) {
                f = this.wkPoint.z;
            }
            if (!(f2 > this.wkPoint.z)) continue;
            f2 = this.wkPoint.z;
        }
        float f3 = f - f2;
        float f4 = (float)(this.depthAccuracy - 1) / f3;
        for (n2 = 0; n2 < n7; ++n2) {
            this.depthList2[n2] = (int)((this.depthList1[n2] - f2) * f4);
        }
        for (n2 = 0; n2 < this.depthAccuracy; ++n2) {
            this.countList[n2] = 0;
        }
        for (n2 = 0; n2 < n7; ++n2) {
            int n10 = this.depthList2[n2];
            this.countList[n10] = this.countList[n10] + 1;
        }
        if (this.terminate) {
            return;
        }
        for (n2 = 1; n2 < this.depthAccuracy; ++n2) {
            int n11 = n2;
            this.countList[n11] = this.countList[n11] + this.countList[n2 - 1];
        }
        if (this.terminate) {
            return;
        }
        n2 = n7;
        while (--n2 >= 0) {
            n3 = this.depthList2[n2];
            this.transparentList[this.countList[n3] - 1] = this.unsortedTransparentList[n2];
            int n12 = n3;
            this.countList[n12] = this.countList[n12] - 1;
        }
        renderInstructions.renderOps[n6++] = 11;
        bl = false;
        n4 = 0;
        while (!bl) {
            try {
                for (int i = n4; i < n7 && !this.terminate; ++i) {
                    n6 = this.appendObject(this.transparentList[i], renderInstructions, n6);
                    this.transparentList[i] = null;
                }
                bl = true;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n4 = n6;
                this.realloc(renderInstructions);
            }
        }
        bl = false;
        while (!bl) {
            try {
                n6 = this.cleanupObjects(renderInstructions, n6);
                bl = true;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.realloc(renderInstructions);
            }
        }
        renderInstructions.renderOps[n6++] = 12;
        renderInstructions.numValid = n6;
    }

    private int appendObject(CullOutputDetails cullOutputDetails, RenderInstructions renderInstructions, int n) {
        int n2 = n;
        n2 = this.appendLights(cullOutputDetails, renderInstructions, n2);
        n2 = this.appendClipPlanes(cullOutputDetails, renderInstructions, n2);
        n2 = this.updateFog(cullOutputDetails.localFog, renderInstructions, n2);
        if (cullOutputDetails.renderable instanceof Shape3D) {
            Shape3D shape3D = (Shape3D)cullOutputDetails.renderable;
            Appearance appearance = shape3D.getAppearance();
            Geometry geometry = shape3D.getGeometry();
            if (this.currentAppearance != appearance) {
                if (appearance == null) {
                    n2 = this.cleanupVisuals(renderInstructions, n2);
                } else {
                    n2 = this.updateMaterial(appearance, renderInstructions, n2);
                    n2 = this.updatePolyAttribs(appearance, renderInstructions, n2);
                    n2 = this.updateLineAttribs(appearance, renderInstructions, n2);
                    n2 = this.updatePointAttribs(appearance, renderInstructions, n2);
                    n2 = this.updateBlendAttribs(appearance, renderInstructions, n2);
                    n2 = this.updateTextures(appearance, renderInstructions, n2);
                    n2 = this.updateShader(appearance, renderInstructions, n2);
                }
                this.currentAppearance = appearance;
            }
            renderInstructions.renderList[n2].renderable = geometry;
            Matrix4f matrix4f = cullOutputDetails.transform;
            renderInstructions.renderList[n2].transform[0] = matrix4f.m00;
            renderInstructions.renderList[n2].transform[1] = matrix4f.m10;
            renderInstructions.renderList[n2].transform[2] = matrix4f.m20;
            renderInstructions.renderList[n2].transform[3] = matrix4f.m30;
            renderInstructions.renderList[n2].transform[4] = matrix4f.m01;
            renderInstructions.renderList[n2].transform[5] = matrix4f.m11;
            renderInstructions.renderList[n2].transform[6] = matrix4f.m21;
            renderInstructions.renderList[n2].transform[7] = matrix4f.m31;
            renderInstructions.renderList[n2].transform[8] = matrix4f.m02;
            renderInstructions.renderList[n2].transform[9] = matrix4f.m12;
            renderInstructions.renderList[n2].transform[10] = matrix4f.m22;
            renderInstructions.renderList[n2].transform[11] = matrix4f.m32;
            renderInstructions.renderList[n2].transform[12] = matrix4f.m03;
            renderInstructions.renderList[n2].transform[13] = matrix4f.m13;
            renderInstructions.renderList[n2].transform[14] = matrix4f.m23;
            renderInstructions.renderList[n2].transform[15] = matrix4f.m33;
            renderInstructions.renderOps[n2] = 3;
            ++n2;
        } else if (cullOutputDetails.renderable instanceof CustomRenderable) {
            n2 = this.cleanupVisuals(renderInstructions, n2);
            renderInstructions.renderList[n2].renderable = cullOutputDetails.renderable;
            renderInstructions.renderList[n2].instructions = cullOutputDetails.customData;
            Matrix4f matrix4f = cullOutputDetails.transform;
            renderInstructions.renderList[n2].transform[0] = matrix4f.m00;
            renderInstructions.renderList[n2].transform[1] = matrix4f.m10;
            renderInstructions.renderList[n2].transform[2] = matrix4f.m20;
            renderInstructions.renderList[n2].transform[3] = matrix4f.m30;
            renderInstructions.renderList[n2].transform[4] = matrix4f.m01;
            renderInstructions.renderList[n2].transform[5] = matrix4f.m11;
            renderInstructions.renderList[n2].transform[6] = matrix4f.m21;
            renderInstructions.renderList[n2].transform[7] = matrix4f.m31;
            renderInstructions.renderList[n2].transform[8] = matrix4f.m02;
            renderInstructions.renderList[n2].transform[9] = matrix4f.m12;
            renderInstructions.renderList[n2].transform[10] = matrix4f.m22;
            renderInstructions.renderList[n2].transform[11] = matrix4f.m32;
            renderInstructions.renderList[n2].transform[12] = matrix4f.m03;
            renderInstructions.renderList[n2].transform[13] = matrix4f.m13;
            renderInstructions.renderList[n2].transform[14] = matrix4f.m23;
            renderInstructions.renderList[n2].transform[15] = matrix4f.m33;
            renderInstructions.renderOps[n2] = 4;
            ++n2;
        } else {
            System.out.println("Non-shape node in sorter " + cullOutputDetails.renderable);
        }
        return n2;
    }

    private int appendLights(CullOutputDetails cullOutputDetails, RenderInstructions renderInstructions, int n) {
        LightDetails lightDetails;
        int n2;
        if (cullOutputDetails.numLights == 0 && this.currentLights.size() == 0) {
            return n;
        }
        int n3 = n;
        int n4 = 0;
        for (n2 = 0; n2 < cullOutputDetails.numLights; ++n2) {
            LightDetails lightDetails2 = cullOutputDetails.lights[n2];
            if (this.currentLights.contains((Object)lightDetails2)) {
                this.keepLights.add((Object)lightDetails2);
                continue;
            }
            this.newLights[n4++] = lightDetails2;
        }
        this.currentLights.retainAll(this.keepLights, this.oldLights);
        this.keepLights.clear();
        n2 = this.oldLights.size();
        if (n2 != 0) {
            if (n2 > this.lightTmp.length) {
                this.lightTmp = new Object[n2];
            }
            this.oldLights.toArray(this.lightTmp);
            this.oldLights.clear();
            for (int i = 0; i < n2; ++i) {
                lightDetails = (LightDetails)this.lightTmp[i];
                Integer n5 = (Integer)this.lightIdMap.remove(lightDetails);
                renderInstructions.renderList[n3].renderable = lightDetails.getLight();
                renderInstructions.renderList[n3].id = n5;
                renderInstructions.renderOps[n3] = 10;
                ++n3;
                this.lightTmp[i] = null;
            }
        }
        if (n4 != 0) {
            for (int i = 0; i < n4; ++i) {
                lightDetails = this.newLights[i];
                this.currentLights.add((Object)lightDetails);
                renderInstructions.renderList[n3].renderable = lightDetails.getLight();
                System.arraycopy(lightDetails.getTransform(), 0, renderInstructions.renderList[n3].transform, 0, 16);
                this.lightIdMap.put(lightDetails, new Integer(this.lastGlobalId));
                ++this.lastGlobalId;
                renderInstructions.renderList[n3].id = renderInstructions.renderList[n3].id;
                renderInstructions.renderOps[n3] = 9;
                ++n3;
                this.newLights[i] = null;
            }
        }
        return n3;
    }

    private int appendClipPlanes(CullOutputDetails cullOutputDetails, RenderInstructions renderInstructions, int n) {
        ClipDetails clipDetails;
        int n2;
        if (cullOutputDetails.numClipPlanes == 0 && this.currentClipPlanes.size() == 0) {
            return n;
        }
        int n3 = n;
        int n4 = 0;
        for (n2 = 0; n2 < cullOutputDetails.numClipPlanes; ++n2) {
            ClipDetails clipDetails2 = cullOutputDetails.clipPlanes[n2];
            if (this.currentClipPlanes.contains((Object)clipDetails2)) {
                this.keepClipPlanes.add((Object)clipDetails2);
                continue;
            }
            this.newClipPlanes[n4++] = clipDetails2;
        }
        this.currentClipPlanes.retainAll(this.keepClipPlanes, this.oldClipPlanes);
        this.keepClipPlanes.clear();
        n2 = this.oldClipPlanes.size();
        if (n2 != 0) {
            if (n2 > this.clipTmp.length) {
                this.clipTmp = new Object[n2];
            }
            this.oldClipPlanes.toArray(this.clipTmp);
            this.oldClipPlanes.clear();
            for (int i = 0; i < n2; ++i) {
                clipDetails = (ClipDetails)this.clipTmp[i];
                Integer n5 = (Integer)this.clipIdMap.remove(clipDetails);
                renderInstructions.renderList[n3].renderable = clipDetails.getClipPlane();
                renderInstructions.renderList[n3].id = n5;
                renderInstructions.renderOps[n3] = 18;
                ++n3;
                this.clipTmp[i] = null;
            }
        }
        if (n4 != 0) {
            for (int i = 0; i < n4; ++i) {
                clipDetails = this.newClipPlanes[i];
                this.currentClipPlanes.add((Object)clipDetails);
                renderInstructions.renderList[n3].renderable = clipDetails.getClipPlane();
                System.arraycopy(clipDetails.getTransform(), 0, renderInstructions.renderList[n3].transform, 0, 16);
                this.clipIdMap.put(clipDetails, new Integer(this.lastGlobalId));
                ++this.lastGlobalId;
                renderInstructions.renderList[n3].id = renderInstructions.renderList[n3].id;
                renderInstructions.renderOps[n3] = 17;
                ++n3;
                this.newClipPlanes[i] = null;
            }
        }
        return n3;
    }

    private int updateShader(Appearance appearance, RenderInstructions renderInstructions, int n) {
        Shader shader = appearance.getShader();
        if (shader == this.currentShader) {
            return n;
        }
        int n2 = n;
        if (shader instanceof GLSLangShader) {
            if (this.currentShader instanceof GLSLangShader) {
                GLSLangShader gLSLangShader = (GLSLangShader)shader;
                ShaderProgram shaderProgram = gLSLangShader.getShaderProgram();
                if (shaderProgram != null) {
                    ShaderArguments shaderArguments;
                    if (this.currentShaderProgram != shaderProgram) {
                        this.currentShaderProgram = shaderProgram;
                        renderInstructions.renderList[n2].renderable = this.currentShaderProgram;
                        renderInstructions.renderOps[n2] = 21;
                        ++n2;
                    }
                    if (this.currentShaderArgs != (shaderArguments = gLSLangShader.getShaderArguments())) {
                        this.currentShaderArgs = shaderArguments;
                        renderInstructions.renderList[n2].renderable = this.currentShaderArgs;
                        renderInstructions.renderOps[n2] = 23;
                        ++n2;
                    }
                } else {
                    renderInstructions.renderList[n2].renderable = this.currentShaderProgram;
                    renderInstructions.renderOps[n2] = 22;
                    ++n2;
                    this.currentShader = null;
                    this.currentShaderProgram = null;
                    this.currentShaderArgs = null;
                }
            } else if (this.currentShader instanceof GL14Shader) {
                renderInstructions.renderList[n2].renderable = this.currentShader;
                renderInstructions.renderOps[n2] = 6;
                ++n2;
                GLSLangShader gLSLangShader = (GLSLangShader)shader;
                this.currentShaderProgram = gLSLangShader.getShaderProgram();
                if (this.currentShaderProgram != null) {
                    renderInstructions.renderList[n2].renderable = this.currentShaderProgram;
                    renderInstructions.renderOps[n2] = 21;
                    ++n2;
                    this.currentShaderArgs = gLSLangShader.getShaderArguments();
                    if (this.currentShaderArgs != null) {
                        renderInstructions.renderList[n2].renderable = this.currentShaderArgs;
                        renderInstructions.renderOps[n2] = 23;
                        ++n2;
                    }
                    this.currentShader = shader;
                }
            } else {
                GLSLangShader gLSLangShader = (GLSLangShader)shader;
                this.currentShaderProgram = gLSLangShader.getShaderProgram();
                if (this.currentShaderProgram != null) {
                    renderInstructions.renderList[n2].renderable = this.currentShaderProgram;
                    renderInstructions.renderOps[n2] = 21;
                    this.currentShaderArgs = gLSLangShader.getShaderArguments();
                    renderInstructions.renderList[++n2].renderable = this.currentShaderArgs;
                    renderInstructions.renderOps[n2] = 23;
                    ++n2;
                    this.currentShader = shader;
                }
            }
        } else if (shader instanceof GL14Shader) {
            if (shader != null) {
                if (!shader.equals(this.currentShader)) {
                    if (this.currentShader != null) {
                        if (this.currentShader instanceof GLSLangShader) {
                            renderInstructions.renderList[n2].renderable = this.currentShader;
                            renderInstructions.renderOps[n2] = 22;
                            ++n2;
                            this.currentShaderProgram = null;
                            this.currentShaderArgs = null;
                        } else {
                            renderInstructions.renderList[n2].renderable = this.currentShader;
                            renderInstructions.renderOps[n2] = 6;
                            ++n2;
                        }
                    }
                    renderInstructions.renderList[n2].renderable = shader;
                    renderInstructions.renderOps[n2] = 6;
                    ++n2;
                }
                this.currentShader = shader;
            } else {
                renderInstructions.renderList[n2].renderable = this.currentShader;
                renderInstructions.renderOps[n2] = 6;
                ++n2;
                this.currentShader = null;
            }
        } else if (shader != null) {
            if (!shader.equals(this.currentShader)) {
                if (this.currentShader != null) {
                    if (this.currentShader instanceof GLSLangShader) {
                        renderInstructions.renderList[n2].renderable = this.currentShader;
                        renderInstructions.renderOps[n2] = 22;
                        ++n2;
                        this.currentShaderProgram = null;
                        this.currentShaderArgs = null;
                    } else {
                        renderInstructions.renderList[n2].renderable = this.currentShader;
                        renderInstructions.renderOps[n2] = 6;
                        ++n2;
                    }
                }
                renderInstructions.renderList[n2].renderable = shader;
                renderInstructions.renderOps[n2] = 5;
                ++n2;
                this.currentShader = shader;
            }
        } else if (this.currentShader instanceof GLSLangShader) {
            GLSLangShader gLSLangShader = (GLSLangShader)shader;
            renderInstructions.renderList[n2].renderable = this.currentShaderProgram;
            renderInstructions.renderOps[n2] = 22;
            ++n2;
            this.currentShaderProgram = null;
            this.currentShaderArgs = null;
            this.currentShader = null;
        } else if (this.currentShader instanceof GL14Shader) {
            renderInstructions.renderList[n2].renderable = this.currentShader;
            renderInstructions.renderOps[n2] = 6;
            ++n2;
            this.currentShader = null;
        } else if (this.currentShader != null) {
            renderInstructions.renderList[n2].renderable = this.currentShader;
            renderInstructions.renderOps[n2] = 6;
            ++n2;
        }
        return n2;
    }

    private int updateFog(Fog fog, RenderInstructions renderInstructions, int n) {
        int n2 = n;
        if (fog != this.currentFog) {
            if (fog != null) {
                if (!fog.equals(this.currentFog)) {
                    if (this.currentFog != null) {
                        renderInstructions.renderList[n2].renderable = this.currentFog;
                        renderInstructions.renderOps[n2] = 20;
                        ++n2;
                    }
                    renderInstructions.renderList[n2].renderable = fog;
                    renderInstructions.renderOps[n2] = 19;
                    ++n2;
                }
                this.currentFog = fog;
            } else {
                renderInstructions.renderList[n2].renderable = this.currentFog;
                renderInstructions.renderOps[n2] = 20;
                ++n2;
                this.currentFog = null;
            }
        }
        return n2;
    }

    private int updateMaterial(Appearance appearance, RenderInstructions renderInstructions, int n) {
        int n2 = n;
        Material material = appearance.getMaterial();
        if (material != this.currentMaterial) {
            if (material != null) {
                if (!material.equals(this.currentMaterial)) {
                    if (this.currentMaterial != null) {
                        renderInstructions.renderList[n2].renderable = this.currentMaterial;
                        renderInstructions.renderOps[n2] = 6;
                        ++n2;
                    }
                    renderInstructions.renderList[n2].renderable = material;
                    renderInstructions.renderOps[n2] = 5;
                    ++n2;
                }
                this.currentMaterial = material;
            } else {
                renderInstructions.renderList[n2].renderable = this.currentMaterial;
                renderInstructions.renderOps[n2] = 6;
                ++n2;
                this.currentMaterial = null;
            }
        }
        return n2;
    }

    private int updatePolyAttribs(Appearance appearance, RenderInstructions renderInstructions, int n) {
        int n2 = n;
        PolygonAttributes polygonAttributes = appearance.getPolygonAttributes();
        if (polygonAttributes != this.currentPolyAttr) {
            if (polygonAttributes != null) {
                if (!polygonAttributes.equals(this.currentPolyAttr)) {
                    if (this.currentPolyAttr != null) {
                        renderInstructions.renderList[n2].renderable = this.currentPolyAttr;
                        renderInstructions.renderOps[n2] = 6;
                        ++n2;
                    }
                    renderInstructions.renderList[n2].renderable = polygonAttributes;
                    renderInstructions.renderOps[n2] = 5;
                    ++n2;
                }
                this.currentPolyAttr = polygonAttributes;
            } else {
                renderInstructions.renderList[n2].renderable = this.currentPolyAttr;
                renderInstructions.renderOps[n2] = 6;
                ++n2;
                this.currentPolyAttr = null;
            }
        }
        return n2;
    }

    private int updateLineAttribs(Appearance appearance, RenderInstructions renderInstructions, int n) {
        int n2 = n;
        LineAttributes lineAttributes = appearance.getLineAttributes();
        if (lineAttributes != this.currentLineAttr) {
            if (lineAttributes != null) {
                if (!lineAttributes.equals(this.currentLineAttr)) {
                    if (this.currentLineAttr != null) {
                        renderInstructions.renderList[n2].renderable = this.currentLineAttr;
                        renderInstructions.renderOps[n2] = 6;
                        ++n2;
                    }
                    renderInstructions.renderList[n2].renderable = lineAttributes;
                    renderInstructions.renderOps[n2] = 5;
                    ++n2;
                }
                this.currentLineAttr = lineAttributes;
            } else {
                renderInstructions.renderList[n2].renderable = this.currentLineAttr;
                renderInstructions.renderOps[n2] = 6;
                ++n2;
                this.currentLineAttr = null;
            }
        }
        return n2;
    }

    private int updatePointAttribs(Appearance appearance, RenderInstructions renderInstructions, int n) {
        int n2 = n;
        PointAttributes pointAttributes = appearance.getPointAttributes();
        if (pointAttributes != this.currentPointAttr) {
            if (pointAttributes != null) {
                if (!pointAttributes.equals(this.currentPointAttr)) {
                    if (this.currentPointAttr != null) {
                        renderInstructions.renderList[n2].renderable = this.currentPointAttr;
                        renderInstructions.renderOps[n2] = 6;
                        ++n2;
                    }
                    renderInstructions.renderList[n2].renderable = pointAttributes;
                    renderInstructions.renderOps[n2] = 5;
                    ++n2;
                }
                this.currentPointAttr = pointAttributes;
            } else {
                renderInstructions.renderList[n2].renderable = this.currentPointAttr;
                renderInstructions.renderOps[n2] = 6;
                ++n2;
                this.currentPointAttr = null;
            }
        }
        return n2;
    }

    private int updateBlendAttribs(Appearance appearance, RenderInstructions renderInstructions, int n) {
        int n2 = n;
        BlendAttributes blendAttributes = appearance.getBlendAttributes();
        if (blendAttributes != this.currentBlendAttr) {
            if (blendAttributes != null) {
                if (!blendAttributes.equals(this.currentBlendAttr)) {
                    if (this.currentBlendAttr != null) {
                        renderInstructions.renderList[n2].renderable = this.currentBlendAttr;
                        renderInstructions.renderOps[n2] = 6;
                        ++n2;
                    }
                    renderInstructions.renderList[n2].renderable = blendAttributes;
                    renderInstructions.renderOps[n2] = 5;
                    ++n2;
                }
                this.currentBlendAttr = blendAttributes;
            } else {
                renderInstructions.renderList[n2].renderable = this.currentBlendAttr;
                renderInstructions.renderOps[n2] = 6;
                ++n2;
                this.currentBlendAttr = null;
            }
        }
        return n2;
    }

    private int updateTextures(Appearance appearance, RenderInstructions renderInstructions, int n) {
        int n2 = n;
        int n3 = appearance.numTextureUnits();
        if (this.textureTmp.length < n3) {
            this.textureTmp = new TextureUnit[n3];
        }
        appearance.getTextureUnits(this.textureTmp);
        if (n3 != this.numTextures) {
            if (n3 == 0) {
                for (int i = 0; i < this.numTextures; ++i) {
                    renderInstructions.renderList[n2].renderable = this.currentTextures[i];
                    renderInstructions.renderList[n2].instructions = TEX_IDS[i];
                    renderInstructions.renderOps[n2] = 25;
                    ++n2;
                    this.currentTextures[i] = null;
                    this.textureTmp[i] = null;
                }
            } else if (this.numTextures == 0) {
                for (int i = 0; i < n3; ++i) {
                    renderInstructions.renderList[n2].renderable = this.textureTmp[i];
                    renderInstructions.renderList[n2].instructions = TEX_IDS[i];
                    renderInstructions.renderOps[n2] = 24;
                    ++n2;
                    this.currentTextures[i] = this.textureTmp[i];
                    this.textureTmp[i] = null;
                }
            } else {
                int n4;
                int n5 = this.numTextures < n3 ? this.numTextures : n3;
                for (n4 = 0; n4 < n5; ++n4) {
                    if (this.textureTmp[n4].equals(this.currentTextures[n4])) continue;
                    renderInstructions.renderList[n2].renderable = this.currentTextures[n4];
                    renderInstructions.renderList[n2].instructions = TEX_IDS[n4];
                    renderInstructions.renderOps[n2] = 25;
                    renderInstructions.renderList[++n2].renderable = this.textureTmp[n4];
                    renderInstructions.renderList[n2].instructions = TEX_IDS[n4];
                    renderInstructions.renderOps[n2] = 24;
                    ++n2;
                    this.currentTextures[n4] = this.textureTmp[n4];
                    this.textureTmp[n4] = null;
                }
                if (this.numTextures < n3) {
                    for (n4 = n5; n4 < n3; ++n4) {
                        renderInstructions.renderList[n2].renderable = this.textureTmp[n4];
                        renderInstructions.renderList[n2].instructions = TEX_IDS[n4];
                        renderInstructions.renderOps[n2] = 24;
                        ++n2;
                        this.currentTextures[n4] = this.textureTmp[n4];
                        this.textureTmp[n4] = null;
                    }
                } else {
                    for (n4 = n5; n4 < this.numTextures; ++n4) {
                        renderInstructions.renderList[n2].renderable = this.currentTextures[n4];
                        renderInstructions.renderList[n2].instructions = TEX_IDS[n4];
                        renderInstructions.renderOps[n2] = 25;
                        ++n2;
                        this.currentTextures[n4] = null;
                    }
                }
            }
            this.numTextures = n3;
        } else if (n3 != 0) {
            if (n3 == 1) {
                if (!this.textureTmp[0].equals(this.currentTextures[0])) {
                    renderInstructions.renderList[n2].renderable = this.currentTextures[0];
                    renderInstructions.renderList[n2].instructions = TEX_IDS[0];
                    renderInstructions.renderOps[n2] = 25;
                    renderInstructions.renderList[++n2].renderable = this.textureTmp[0];
                    renderInstructions.renderList[n2].instructions = TEX_IDS[0];
                    renderInstructions.renderOps[n2] = 24;
                    ++n2;
                    this.currentTextures[0] = this.textureTmp[0];
                    this.textureTmp[0] = null;
                }
            } else {
                for (int i = 0; i < this.numTextures; ++i) {
                    if (this.textureTmp[i].equals(this.currentTextures[i])) continue;
                    renderInstructions.renderList[n2].renderable = this.currentTextures[i];
                    renderInstructions.renderList[n2].instructions = TEX_IDS[i];
                    renderInstructions.renderOps[n2] = 25;
                    renderInstructions.renderList[++n2].renderable = this.textureTmp[i];
                    renderInstructions.renderList[n2].instructions = TEX_IDS[i];
                    renderInstructions.renderOps[n2] = 24;
                    ++n2;
                    this.currentTextures[i] = this.textureTmp[i];
                    this.textureTmp[i] = null;
                }
            }
        }
        return n2;
    }

    private int cleanupObjects(RenderInstructions renderInstructions, int n) {
        Object object;
        int n2;
        int n3 = n;
        int n4 = this.currentLights.size();
        if (n4 != 0) {
            if (n4 > this.lightTmp.length) {
                this.lightTmp = new Object[n4];
            }
            this.currentLights.toArray(this.lightTmp);
            this.currentLights.clear();
            for (n2 = 0; n2 < n4; ++n2) {
                LightDetails lightDetails = (LightDetails)this.lightTmp[n2];
                object = (Integer)this.lightIdMap.remove(lightDetails);
                renderInstructions.renderList[n3].renderable = lightDetails.getLight();
                renderInstructions.renderList[n3].id = (Integer)object;
                renderInstructions.renderOps[n3] = 10;
                ++n3;
                this.lightTmp[n2] = null;
            }
        }
        if ((n2 = this.currentClipPlanes.size()) != 0) {
            if (n2 > this.clipTmp.length) {
                this.clipTmp = new Object[n2];
            }
            this.currentClipPlanes.toArray(this.clipTmp);
            this.currentClipPlanes.clear();
            for (int i = 0; i < n2; ++i) {
                object = (ClipDetails)this.clipTmp[i];
                Integer n5 = (Integer)this.clipIdMap.remove(object);
                renderInstructions.renderList[n3].renderable = ((ClipDetails)object).getClipPlane();
                renderInstructions.renderList[n3].id = n5;
                renderInstructions.renderOps[n3] = 18;
                ++n3;
                this.clipTmp[i] = null;
            }
        }
        return this.cleanupVisuals(renderInstructions, n3);
    }

    private int cleanupVisuals(RenderInstructions renderInstructions, int n) {
        int n2 = n;
        if (this.currentMaterial != null) {
            renderInstructions.renderList[n2].renderable = this.currentMaterial;
            renderInstructions.renderOps[n2] = 6;
            ++n2;
            this.currentMaterial = null;
        }
        if (this.currentShader != null) {
            if (this.currentShader instanceof GLSLangShader) {
                renderInstructions.renderList[n2].renderable = this.currentShaderProgram;
                renderInstructions.renderOps[n2] = 22;
                ++n2;
                this.currentShaderProgram = null;
                this.currentShaderArgs = null;
            } else {
                renderInstructions.renderList[n2].renderable = this.currentShader;
                renderInstructions.renderOps[n2] = 6;
                ++n2;
            }
            this.currentShader = null;
        }
        if (this.currentPolyAttr != null) {
            renderInstructions.renderList[n2].renderable = this.currentPolyAttr;
            renderInstructions.renderOps[n2] = 6;
            ++n2;
            this.currentPolyAttr = null;
        }
        if (this.currentLineAttr != null) {
            renderInstructions.renderList[n2].renderable = this.currentLineAttr;
            renderInstructions.renderOps[n2] = 6;
            ++n2;
            this.currentLineAttr = null;
        }
        if (this.currentPointAttr != null) {
            renderInstructions.renderList[n2].renderable = this.currentPointAttr;
            renderInstructions.renderOps[n2] = 6;
            ++n2;
            this.currentPointAttr = null;
        }
        if (this.currentBlendAttr != null) {
            renderInstructions.renderList[n2].renderable = this.currentBlendAttr;
            renderInstructions.renderOps[n2] = 6;
            ++n2;
            this.currentBlendAttr = null;
        }
        for (int i = 0; i < this.numTextures; ++i) {
            renderInstructions.renderList[n2].renderable = this.currentTextures[i];
            renderInstructions.renderList[n2].instructions = TEX_IDS[i];
            renderInstructions.renderOps[n2] = 25;
            ++n2;
            this.currentTextures[i] = null;
            this.textureTmp[i] = null;
        }
        if (this.currentFog != null) {
            renderInstructions.renderList[n2].renderable = this.currentFog;
            renderInstructions.renderOps[n2] = 20;
            ++n2;
            this.currentFog = null;
        }
        this.numTextures = 0;
        this.currentAppearance = null;
        return n2;
    }

    private void realloc(RenderInstructions renderInstructions) {
        if (this.req_size - renderInstructions.renderList.length < 1024) {
            this.req_size += 1024;
        }
        RenderDetails[] renderDetailsArray = new RenderDetails[this.req_size];
        int[] nArray = new int[this.req_size];
        System.arraycopy(renderInstructions.renderList, 0, renderDetailsArray, 0, renderInstructions.renderList.length);
        System.arraycopy(renderInstructions.renderOps, 0, nArray, 0, renderInstructions.renderOps.length);
        for (int i = renderInstructions.renderList.length; i < this.req_size; ++i) {
            renderDetailsArray[i] = new RenderDetails();
        }
        renderInstructions.renderList = renderDetailsArray;
        renderInstructions.renderOps = nArray;
    }

    static {
        for (int i = 0; i < 32; ++i) {
            StateAndTransparencyDepthSortStage.TEX_IDS[i] = new Integer(33984 + i);
        }
    }
}

