/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline;

import java.util.Comparator;
import org.j3d.aviatrix3d.Appearance;
import org.j3d.aviatrix3d.BlendAttributes;
import org.j3d.aviatrix3d.ClipDetails;
import org.j3d.aviatrix3d.CullOutputDetails;
import org.j3d.aviatrix3d.Fog;
import org.j3d.aviatrix3d.FragmentShader;
import org.j3d.aviatrix3d.GL14Shader;
import org.j3d.aviatrix3d.GLSLangShader;
import org.j3d.aviatrix3d.LightDetails;
import org.j3d.aviatrix3d.LineAttributes;
import org.j3d.aviatrix3d.Material;
import org.j3d.aviatrix3d.PointAttributes;
import org.j3d.aviatrix3d.PolygonAttributes;
import org.j3d.aviatrix3d.Shader;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.TextureUnit;
import org.j3d.aviatrix3d.VertexShader;

public class StateSortComparator
implements Comparator {
    public static final int LIGHTS = 1;
    public static final int MATERIALS = 2;
    public static final int FRAGMENT_SHADERS = 3;
    public static final int VERTEX_SHADERS = 4;
    public static final int SHADER_OBJECTS = 5;
    public static final int TEXTURE_ATTRIBS = 6;
    public static final int POLYGON_ATTRIBS = 7;
    public static final int LINE_ATTRIBS = 8;
    public static final int POINT_ATTRIBS = 9;
    public static final int BLEND_ATTRIBS = 10;
    public static final int CLIP_PLANES = 11;
    public static final int LOCAL_FOG = 12;
    public static final int TEXTURE_UNIT_0 = 32;
    public static final int TEXTURE_UNIT_1 = 33;
    public static final int TEXTURE_UNIT_2 = 34;
    public static final int TEXTURE_UNIT_3 = 35;
    private static final int[] DEFAULT_PRIORITIES = new int[]{1, 32, 33, 34, 35, 4, 3, 2, 12, 7, 8, 9, 10, 11};
    private int[] priorityOrder;
    private TextureUnit[] tUnit1;
    private TextureUnit[] tUnit2;

    public StateSortComparator() {
        this(null);
    }

    public StateSortComparator(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            nArray = DEFAULT_PRIORITIES;
        }
        this.priorityOrder = new int[nArray.length];
        this.tUnit1 = new TextureUnit[32];
        this.tUnit2 = new TextureUnit[32];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < n; ++j) {
                if (this.priorityOrder[j] != nArray[i]) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.priorityOrder[n++] = nArray[i];
        }
    }

    public int compare(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        CullOutputDetails cullOutputDetails = (CullOutputDetails)object;
        CullOutputDetails cullOutputDetails2 = (CullOutputDetails)object2;
        Shape3D shape3D = null;
        Shape3D shape3D2 = null;
        Appearance appearance = null;
        Appearance appearance2 = null;
        if (cullOutputDetails.renderable instanceof Shape3D) {
            shape3D = (Shape3D)cullOutputDetails.renderable;
            appearance = shape3D.getAppearance();
        }
        if (cullOutputDetails2.renderable instanceof Shape3D) {
            shape3D2 = (Shape3D)cullOutputDetails2.renderable;
            appearance2 = shape3D2.getAppearance();
        }
        if (shape3D == shape3D2 || appearance == appearance2) {
            if (cullOutputDetails.numLights == cullOutputDetails2.numLights) {
                LightDetails[] lightDetailsArray;
                LightDetails[] lightDetailsArray2;
                if (cullOutputDetails.numLights == 0) {
                    lightDetailsArray2 = cullOutputDetails.localFog;
                    lightDetailsArray = cullOutputDetails2.localFog;
                    if (lightDetailsArray2 != lightDetailsArray) {
                        if (lightDetailsArray2 == null) {
                            return -1;
                        }
                        if (lightDetailsArray == null) {
                            return 1;
                        }
                        int n = lightDetailsArray2.compareTo((Fog)lightDetailsArray);
                        if (n != 0) {
                            return n;
                        }
                    }
                    if (cullOutputDetails.numClipPlanes == cullOutputDetails2.numClipPlanes) {
                        if (cullOutputDetails.numClipPlanes == 0) {
                            return 0;
                        }
                        ClipDetails[] clipDetailsArray = cullOutputDetails.clipPlanes;
                        ClipDetails[] clipDetailsArray2 = cullOutputDetails2.clipPlanes;
                        for (int i = 0; i < cullOutputDetails.numClipPlanes; ++i) {
                            int n = clipDetailsArray[i].compareTo(clipDetailsArray2[i]);
                            if (n == 0) continue;
                            return n;
                        }
                    } else {
                        return cullOutputDetails.numClipPlanes < cullOutputDetails2.numClipPlanes ? -1 : 1;
                    }
                }
                lightDetailsArray2 = cullOutputDetails.lights;
                lightDetailsArray = cullOutputDetails2.lights;
                for (int i = 0; i < cullOutputDetails.numLights; ++i) {
                    int n = lightDetailsArray2[i].compareTo(lightDetailsArray[i]);
                    if (n == 0) continue;
                    return n;
                }
            } else {
                return cullOutputDetails.numLights < cullOutputDetails2.numLights ? -1 : 1;
            }
            return 0;
        }
        if (appearance == null) {
            return -1;
        }
        if (appearance2 == null) {
            return 1;
        }
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        block15: for (int i = 0; i < this.priorityOrder.length; ++i) {
            switch (this.priorityOrder[i]) {
                case 1: {
                    int n3;
                    LightDetails[] lightDetailsArray;
                    LightDetails[] lightDetailsArray3;
                    if (cullOutputDetails.numLights == cullOutputDetails2.numLights) {
                        if (cullOutputDetails.numLights == 0) continue block15;
                        lightDetailsArray3 = cullOutputDetails.lights;
                        lightDetailsArray = cullOutputDetails2.lights;
                        for (n3 = 0; n3 < cullOutputDetails.numLights; ++n3) {
                            int n4 = lightDetailsArray3[n3].compareTo(lightDetailsArray[n3]);
                            if (n4 == 0) continue;
                            return n4;
                        }
                        continue block15;
                    }
                    return cullOutputDetails.numLights < cullOutputDetails2.numLights ? -1 : 1;
                }
                case 2: {
                    LightDetails[] lightDetailsArray3 = appearance.getMaterial();
                    LightDetails[] lightDetailsArray = appearance2.getMaterial();
                    if (lightDetailsArray3 == lightDetailsArray) continue block15;
                    if (lightDetailsArray3 == null) {
                        return -1;
                    }
                    if (lightDetailsArray == null) {
                        return 1;
                    }
                    int n3 = lightDetailsArray3.compareTo((Material)lightDetailsArray);
                    if (n3 == 0) continue block15;
                    return n3;
                }
                case 12: {
                    Fog fog = cullOutputDetails.localFog;
                    Fog fog2 = cullOutputDetails2.localFog;
                    if (fog == fog2) continue block15;
                    if (fog == null) {
                        return -1;
                    }
                    if (fog2 == null) {
                        return 1;
                    }
                    int n3 = fog.compareTo(fog2);
                    if (n3 == 0) continue block15;
                    return n3;
                }
                case 5: {
                    Shader shader = appearance.getShader();
                    Shader shader2 = appearance2.getShader();
                    if (shader == shader2) continue block15;
                    if (shader == null || !(shader instanceof GLSLangShader)) {
                        return -1;
                    }
                    if (shader2 == null || !(shader2 instanceof GLSLangShader)) {
                        return 1;
                    }
                    int n3 = ((GLSLangShader)shader).compareTo(shader2);
                    if (n3 == 0) continue block15;
                    return n3;
                }
                case 3: {
                    FragmentShader fragmentShader;
                    Shader shader = appearance.getShader();
                    Shader shader2 = appearance2.getShader();
                    if (shader == shader2) continue block15;
                    if (shader == null || !(shader instanceof GL14Shader)) {
                        return -1;
                    }
                    if (shader2 == null || !(shader2 instanceof GL14Shader)) {
                        return 1;
                    }
                    FragmentShader fragmentShader2 = ((GL14Shader)shader).getFragmentShader();
                    if (fragmentShader2 == (fragmentShader = ((GL14Shader)shader2).getFragmentShader())) continue block15;
                    if (fragmentShader2 == null) {
                        return -1;
                    }
                    if (fragmentShader != null) continue block15;
                    return 1;
                }
                case 4: {
                    VertexShader vertexShader;
                    Shader shader = appearance.getShader();
                    Shader shader2 = appearance2.getShader();
                    if (shader == shader2) continue block15;
                    if (shader == null || !(shader instanceof GL14Shader)) {
                        return -1;
                    }
                    if (shader2 == null || !(shader2 instanceof GL14Shader)) {
                        return 1;
                    }
                    VertexShader vertexShader2 = ((GL14Shader)shader).getVertexShader();
                    if (vertexShader2 == (vertexShader = ((GL14Shader)shader2).getVertexShader())) continue block15;
                    if (vertexShader2 == null) {
                        return -1;
                    }
                    if (vertexShader != null) continue block15;
                    return 1;
                }
                case 7: {
                    PolygonAttributes polygonAttributes = appearance.getPolygonAttributes();
                    PolygonAttributes polygonAttributes2 = appearance2.getPolygonAttributes();
                    if (polygonAttributes == polygonAttributes2) continue block15;
                    if (polygonAttributes == null) {
                        return -1;
                    }
                    if (polygonAttributes2 == null) {
                        return 1;
                    }
                    int n3 = polygonAttributes.compareTo(polygonAttributes2);
                    if (n3 == 0) continue block15;
                    return n3;
                }
                case 8: {
                    LineAttributes lineAttributes = appearance.getLineAttributes();
                    LineAttributes lineAttributes2 = appearance2.getLineAttributes();
                    if (lineAttributes == lineAttributes2) continue block15;
                    if (lineAttributes == null) {
                        return -1;
                    }
                    if (lineAttributes2 == null) {
                        return 1;
                    }
                    int n3 = lineAttributes.compareTo(lineAttributes2);
                    if (n3 == 0) continue block15;
                    return n3;
                }
                case 9: {
                    PointAttributes pointAttributes = appearance.getPointAttributes();
                    PointAttributes pointAttributes2 = appearance2.getPointAttributes();
                    if (pointAttributes == pointAttributes2) continue block15;
                    if (pointAttributes == null) {
                        return -1;
                    }
                    if (pointAttributes2 == null) {
                        return 1;
                    }
                    int n3 = pointAttributes.compareTo(pointAttributes2);
                    if (n3 == 0) continue block15;
                    return n3;
                }
                case 10: {
                    BlendAttributes blendAttributes = appearance.getBlendAttributes();
                    BlendAttributes blendAttributes2 = appearance2.getBlendAttributes();
                    if (blendAttributes == blendAttributes2) continue block15;
                    if (blendAttributes == null) {
                        return -1;
                    }
                    if (blendAttributes2 == null) {
                        return 1;
                    }
                    int n3 = blendAttributes.compareTo(blendAttributes2);
                    if (n3 == 0) continue block15;
                    return n3;
                }
                case 11: {
                    Object object3;
                    int n3;
                    if (cullOutputDetails.numClipPlanes == cullOutputDetails2.numClipPlanes) {
                        if (cullOutputDetails.numClipPlanes == 0) continue block15;
                        ClipDetails[] clipDetailsArray = cullOutputDetails.clipPlanes;
                        object3 = cullOutputDetails2.clipPlanes;
                        for (int j = 0; j < cullOutputDetails.numClipPlanes; ++j) {
                            n3 = clipDetailsArray[j].compareTo(object3[j]);
                            if (n3 == 0) continue;
                            return n3;
                        }
                        continue block15;
                    }
                    return cullOutputDetails.numClipPlanes < cullOutputDetails2.numClipPlanes ? -1 : 1;
                }
                default: {
                    int n5;
                    if (this.priorityOrder[i] < 32 || (n5 = this.priorityOrder[i] - 32) > 32) continue block15;
                    if (!bl) {
                        n = appearance.numTextureUnits();
                        n2 = appearance2.numTextureUnits();
                        appearance.getTextureUnits(this.tUnit1);
                        appearance2.getTextureUnits(this.tUnit2);
                        bl = true;
                    }
                    Object object3 = this.tUnit1[n5];
                    TextureUnit textureUnit = this.tUnit2[n5];
                    if (n == 0 && n2 == 0 || object3 == textureUnit) continue block15;
                    if (n == 0 || object3 == null) {
                        return -1;
                    }
                    if (n2 == 0 || textureUnit == null) {
                        return 1;
                    }
                    int n3 = ((TextureUnit)object3).compareTo(textureUnit);
                    if (n3 == 0) continue block15;
                    return n3;
                }
            }
        }
        return 0;
    }

    public boolean equals(Object object) {
        return object instanceof StateSortComparator;
    }
}

