/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.surface;

import java.awt.Rectangle;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLDrawable;
import net.java.games.jogl.GLEventListener;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.Background;
import org.j3d.aviatrix3d.CustomRenderable;
import org.j3d.aviatrix3d.DeletableSceneGraphObject;
import org.j3d.aviatrix3d.Fog;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.RenderDetails;
import org.j3d.aviatrix3d.RenderEffectsProcessor;
import org.j3d.aviatrix3d.RenderEnvironmentData;
import org.j3d.aviatrix3d.RenderableComponent;
import org.j3d.aviatrix3d.RenderableObject;
import org.j3d.aviatrix3d.ShaderProgram;
import org.j3d.aviatrix3d.ShaderSceneGraphObject;
import org.j3d.aviatrix3d.SharedGroup;
import org.j3d.aviatrix3d.SharedNode;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.aviatrix3d.ViewEnvironment;
import org.j3d.aviatrix3d.Viewpoint;
import org.j3d.aviatrix3d.surface.Renderer;
import org.j3d.util.IntHashMap;
import org.j3d.util.MatrixUtils;

public class BaseRenderingProcessor
implements GLEventListener,
Renderer {
    protected static final int LIST_START_SIZE = 400;
    protected static final int INITIAL_PATH_DEPTH = 64;
    protected static final int INITIAL_DELETE_SIZE = 20;
    protected static final int SHADERLIST_START_SIZE = 64;
    protected static final Integer INVALID_SHADER = new Integer(-1);
    protected static final String NOT_LIVE_VP_MSG = "The viewpoint given is not part of a live scene graph";
    protected static final String SHARED_VP_MSG = "The path from the root of the scene graph to the viewpoint contains a SharedGroup or SharedNode instance. This is not permitted.";
    protected static final String NOT_LIVE_FOG_MSG = "The Fog given is not part of a live scene graph";
    protected static final String SHARED_FOG_MSG = "The path from the root of the scene graph to the fog contains a SharedGroup or SharedNode instance. This is not permitted.";
    protected static final String NOT_LIVE_BG_MSG = "The background given is not part of a live scene graph";
    protected static final String SHARED_BG_MSG = "The path from the root of the scene graph to the Background contains a SharedGroup or SharedNode instance. This is not permitted.";
    protected Object userData;
    protected RenderEffectsProcessor effectsProcessor;
    protected Viewpoint currentViewpoint;
    protected Fog currentFog;
    protected TransformGroup[] currentFogPath;
    protected Background currentBackground;
    protected TransformGroup[] currentBackgroundPath;
    protected float[] clearColor = new float[4];
    protected ViewEnvironment viewEnvironment;
    protected ViewEnvironment defaultEnvironment;
    protected double[] currentFrustum;
    protected boolean resetColor;
    protected RenderDetails[] renderableList;
    protected int[] operationList;
    protected int numRenderables;
    protected double aspectRatio;
    protected int windowWidth;
    protected int windowHeight;
    protected boolean viewEnvironmentChanged;
    protected boolean viewportChanged;
    protected DeletableSceneGraphObject[] deleteQueue;
    protected int numDeletions;
    protected ShaderSceneGraphObject[] shaderInitList;
    protected ShaderSceneGraphObject[] shaderLogList;
    protected int lastShaderInitIdx;
    protected int lastShaderLogIdx;
    protected Integer currentShaderProgramId;
    protected Integer[] availableLights;
    protected int lastLightIdx;
    protected IntHashMap lightIdMap;
    protected Integer[] availableClips;
    protected int lastClipIdx;
    protected IntHashMap clipIdMap;
    protected float[] viewMatrix = new float[16];
    protected float[] backgroundMatrix = new float[16];
    protected Matrix4f cameraMatrix = new Matrix4f();
    protected Matrix4f surfaceMatrix = new Matrix4f();
    protected float[] eyePoint;
    protected boolean recalcAspect;
    protected MatrixUtils matrixUtils;
    protected boolean explicitViewport;
    protected Rectangle currentViewport;
    protected boolean terminate;

    BaseRenderingProcessor() {
        this.currentFrustum = new double[6];
        this.eyePoint = new float[3];
        this.viewEnvironment = this.defaultEnvironment = new ViewEnvironment();
        this.viewEnvironment.generateViewFrustum(this.currentFrustum);
        this.aspectRatio = this.defaultEnvironment.getAspectRatio();
        this.resetColor = false;
        this.terminate = false;
        this.numRenderables = 0;
        this.currentFogPath = new TransformGroup[64];
        this.currentBackgroundPath = new TransformGroup[64];
        this.lightIdMap = new IntHashMap();
        this.clipIdMap = new IntHashMap();
        this.lastLightIdx = 0;
        this.lastClipIdx = 0;
        this.lastShaderInitIdx = 0;
        this.lastShaderLogIdx = 0;
        this.currentShaderProgramId = INVALID_SHADER;
        this.recalcAspect = false;
        this.deleteQueue = new DeletableSceneGraphObject[20];
        this.shaderInitList = new ShaderSceneGraphObject[64];
        this.shaderLogList = new ShaderSceneGraphObject[64];
        this.matrixUtils = new MatrixUtils();
        this.explicitViewport = false;
        this.currentViewport = new Rectangle();
    }

    public void init(GLDrawable gLDrawable) {
        int n;
        GL gL = gLDrawable.getGL();
        GLU gLU = gLDrawable.getGLU();
        gL.glClearColor(this.clearColor[0], this.clearColor[1], this.clearColor[2], this.clearColor[3]);
        gL.glEnable(2929);
        gL.glEnable(2977);
        gL.glEnable(2884);
        gL.glCullFace(1029);
        gL.glBlendFunc(770, 771);
        gL.glHint(3152, 4354);
        gL.glHint(3156, 4354);
        this.updateProjectionMatrix(gL, gLU);
        int[] nArray = new int[1];
        gL.glGetIntegerv(3378, nArray);
        this.availableClips = new Integer[nArray[0]];
        for (n = 0; n < nArray[0]; ++n) {
            this.availableClips[n] = new Integer(12288 + n);
        }
        gL.glGetIntegerv(3377, nArray);
        this.availableLights = new Integer[nArray[0]];
        for (n = 0; n < nArray[0]; ++n) {
            this.availableLights[n] = new Integer(16385 + n);
        }
    }

    public void reshape(GLDrawable gLDrawable, int n, int n2, int n3, int n4) {
        this.windowWidth = n3;
        this.windowHeight = n4;
        this.aspectRatio = (float)n3 / (float)n4;
        if (this.recalcAspect) {
            this.viewEnvironment.setAspectRatio(this.aspectRatio);
            this.viewEnvironment.generateViewFrustum(this.currentFrustum);
        }
        GL gL = gLDrawable.getGL();
        GLU gLU = gLDrawable.getGLU();
        if (!this.explicitViewport) {
            gL.glViewport(0, 0, n3, n4);
        }
        this.updateProjectionMatrix(gL, gLU);
    }

    public void displayChanged(GLDrawable gLDrawable, boolean bl, boolean bl2) {
    }

    public void display(GLDrawable gLDrawable) {
        int n;
        GL gL = gLDrawable.getGL();
        GLU gLU = gLDrawable.getGLU();
        if (this.numDeletions != 0) {
            for (n = 0; n < this.numDeletions; ++n) {
                this.deleteQueue[n].cleanup(gL, gLU);
                this.deleteQueue[n] = null;
            }
            this.numDeletions = 0;
        }
        if (this.lastShaderInitIdx != 0) {
            for (n = 0; n < this.lastShaderInitIdx; ++n) {
                this.shaderInitList[n].initialize(gL, gLU);
                this.shaderInitList[n] = null;
            }
            this.lastShaderInitIdx = 0;
        }
        if (this.lastShaderLogIdx != 0) {
            for (n = 0; n < this.lastShaderLogIdx; ++n) {
                this.shaderLogList[n].fetchLogInfo(gL, gLU);
                this.shaderLogList[n] = null;
            }
            this.lastShaderLogIdx = 0;
        }
        if (this.terminate) {
            return;
        }
        if (this.effectsProcessor != null) {
            this.effectsProcessor.preDraw(gLDrawable, this.userData);
        }
        if (this.terminate) {
            return;
        }
        if (this.viewportChanged) {
            if (this.explicitViewport) {
                gL.glViewport(this.currentViewport.x, this.currentViewport.y, this.currentViewport.width, this.currentViewport.height);
            } else {
                gL.glViewport(0, 0, this.windowWidth, this.windowHeight);
            }
            this.viewportChanged = false;
        }
        if (this.terminate) {
            return;
        }
        if (this.currentBackground != null) {
            gL.glMatrixMode(5889);
            gL.glPushMatrix();
            gL.glLoadIdentity();
            this.setupBackgroundFrustum(gL, 0.01, 1.1, this.viewEnvironment.getFieldOfView());
            gL.glClear(256);
            gL.glMatrixMode(5888);
            gL.glPushMatrix();
            gL.glLoadMatrixf(this.backgroundMatrix);
            gL.glDepthMask(false);
            gL.glDisable(3042);
            gL.glDisable(2929);
            this.currentBackground.render(gL, gLU);
            this.currentBackground.postRender(gL, gLU);
            gL.glDepthMask(true);
            gL.glEnable(2929);
            gL.glEnable(3042);
            gL.glPopMatrix();
            gL.glMatrixMode(5889);
            gL.glPopMatrix();
            gL.glMatrixMode(5888);
            this.renderViewpoint(gL, gLU);
        } else {
            if (this.resetColor) {
                gL.glClearColor(this.clearColor[0], this.clearColor[1], this.clearColor[2], this.clearColor[3]);
            }
            gL.glClear(16640);
            this.renderViewpoint(gL, gLU);
        }
        if (this.terminate) {
            return;
        }
        n = 0;
        if (this.currentFog != null) {
            n = 1;
            gL.glEnable(2912);
            this.currentFog.render(gL, gLU);
        }
        block24: for (int i = 0; i < this.numRenderables && !this.terminate; ++i) {
            switch (this.operationList[i]) {
                case 1: {
                    gL.glPushMatrix();
                    gL.glMultMatrixf(this.renderableList[i].transform);
                    RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                    renderableObject.render(gL, gLU);
                    continue block24;
                }
                case 2: {
                    RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                    renderableObject.postRender(gL, gLU);
                    gL.glPopMatrix();
                    continue block24;
                }
                case 3: {
                    gL.glPushMatrix();
                    gL.glMultMatrixf(this.renderableList[i].transform);
                    RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                    renderableObject.render(gL, gLU);
                    gL.glPopMatrix();
                    continue block24;
                }
                case 4: {
                    gL.glPushMatrix();
                    gL.glMultMatrixf(this.renderableList[i].transform);
                    CustomRenderable customRenderable = (CustomRenderable)this.renderableList[i].renderable;
                    customRenderable.render(gL, gLU, this.renderableList[i].instructions);
                    gL.glPopMatrix();
                    continue block24;
                }
                case 5: {
                    RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                    renderableObject.render(gL, gLU);
                    continue block24;
                }
                case 6: {
                    RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                    renderableObject.postRender(gL, gLU);
                    continue block24;
                }
                case 9: {
                    if (this.lastLightIdx >= this.availableLights.length) continue block24;
                    Integer n2 = this.availableLights[this.lastLightIdx++];
                    this.lightIdMap.put(this.renderableList[i].id, (Object)n2);
                    gL.glPushMatrix();
                    gL.glMultMatrixf(this.renderableList[i].transform);
                    RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                    renderableComponent.render(gL, gLU, n2);
                    gL.glPopMatrix();
                    continue block24;
                }
                case 10: {
                    if (this.lastLightIdx >= this.availableLights.length) continue block24;
                    Integer n2 = (Integer)this.lightIdMap.remove(this.renderableList[i].id);
                    RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                    renderableComponent.postRender(gL, gLU, n2);
                    this.availableLights[--this.lastLightIdx] = n2;
                    continue block24;
                }
                case 17: {
                    if (this.lastClipIdx >= this.availableClips.length) continue block24;
                    Integer n3 = this.availableClips[this.lastClipIdx++];
                    this.clipIdMap.put(this.renderableList[i].id, (Object)n3);
                    gL.glPushMatrix();
                    gL.glMultMatrixf(this.renderableList[i].transform);
                    RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                    renderableComponent.render(gL, gLU, n3);
                    gL.glPopMatrix();
                    continue block24;
                }
                case 18: {
                    if (this.lastClipIdx >= this.availableClips.length) continue block24;
                    Integer n3 = (Integer)this.clipIdMap.remove(this.renderableList[i].id);
                    RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                    renderableComponent.postRender(gL, gLU, n3);
                    this.availableClips[--this.lastClipIdx] = n3;
                    continue block24;
                }
                case 11: {
                    gL.glDepthMask(false);
                    gL.glEnable(3042);
                    gL.glBlendFunc(770, 771);
                    continue block24;
                }
                case 12: {
                    gL.glDisable(3042);
                    gL.glDepthMask(true);
                    continue block24;
                }
                case 19: {
                    if (n == 0) {
                        gL.glEnable(2912);
                        n = 1;
                    }
                    RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                    renderableObject.render(gL, gLU);
                    continue block24;
                }
                case 20: {
                    if (this.currentFog != null) {
                        this.currentFog.render(gL, gLU);
                        continue block24;
                    }
                    RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                    renderableObject.postRender(gL, gLU);
                    n = 0;
                    gL.glDisable(2912);
                    continue block24;
                }
                case 21: {
                    ShaderProgram shaderProgram = (ShaderProgram)this.renderableList[i].renderable;
                    if (!shaderProgram.isValid(gL)) {
                        this.currentShaderProgramId = INVALID_SHADER;
                        continue block24;
                    }
                    this.currentShaderProgramId = new Integer(shaderProgram.getProgramId(gL));
                    shaderProgram.render(gL, gLU);
                    continue block24;
                }
                case 22: {
                    if (this.currentShaderProgramId == INVALID_SHADER) continue block24;
                    RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                    renderableObject.postRender(gL, gLU);
                    this.currentShaderProgramId = INVALID_SHADER;
                    continue block24;
                }
                case 23: {
                    if (this.currentShaderProgramId == INVALID_SHADER) continue block24;
                    RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                    renderableComponent.render(gL, gLU, this.currentShaderProgramId);
                    continue block24;
                }
                case 24: {
                    RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                    Integer n4 = (Integer)this.renderableList[i].instructions;
                    renderableComponent.render(gL, gLU, n4);
                    continue block24;
                }
                case 25: {
                    RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                    Integer n4 = (Integer)this.renderableList[i].instructions;
                    renderableComponent.postRender(gL, gLU, n4);
                }
            }
        }
        if (this.terminate) {
            return;
        }
        if (this.currentFog != null) {
            this.currentFog.postRender(gL, gLU);
            gL.glDisable(2912);
        }
        if (this.terminate) {
            return;
        }
        if (this.effectsProcessor != null) {
            this.effectsProcessor.postDraw(gLDrawable, this.userData);
        }
        if (this.terminate) {
            return;
        }
        if (this.currentViewpoint != null) {
            this.currentViewpoint.postRender(gL, gLU);
        }
        if (this.terminate) {
            return;
        }
        gL.glFlush();
    }

    public void halt() {
        this.terminate = true;
    }

    public void queueDeletedObject(DeletableSceneGraphObject deletableSceneGraphObject) {
        if (this.deleteQueue.length == this.numDeletions) {
            int n = this.deleteQueue.length;
            DeletableSceneGraphObject[] deletableSceneGraphObjectArray = new DeletableSceneGraphObject[n << 1];
            System.arraycopy(this.deleteQueue, 0, deletableSceneGraphObjectArray, 0, n);
            this.deleteQueue = deletableSceneGraphObjectArray;
        }
        this.deleteQueue[this.numDeletions++] = deletableSceneGraphObject;
    }

    public void queueShaderRequests(ShaderSceneGraphObject[] shaderSceneGraphObjectArray, int n, ShaderSceneGraphObject[] shaderSceneGraphObjectArray2, int n2) {
        if (n > this.shaderInitList.length) {
            this.shaderInitList = new ShaderSceneGraphObject[n];
        }
        if (n2 > this.shaderLogList.length) {
            this.shaderLogList = new ShaderSceneGraphObject[n2];
        }
        System.arraycopy(shaderSceneGraphObjectArray, 0, this.shaderInitList, 0, n);
        System.arraycopy(shaderSceneGraphObjectArray2, 0, this.shaderLogList, 0, n2);
        this.lastShaderInitIdx = n;
        this.lastShaderLogIdx = n2;
    }

    public void setEnvironmentData(RenderEnvironmentData renderEnvironmentData) throws IllegalArgumentException {
        this.setActiveView(renderEnvironmentData.viewpoint);
        this.setActiveBackground(renderEnvironmentData.background);
        this.setActiveFog(renderEnvironmentData.fog);
        if (renderEnvironmentData.viewEnvironment == null || renderEnvironmentData.viewEnvironment.getAspectRatio() <= 0.0) {
            this.recalcAspect = true;
        }
        this.setViewEnvironment(renderEnvironmentData.viewEnvironment);
        this.viewEnvironmentChanged = true;
        if (renderEnvironmentData.hasViewport != this.explicitViewport || renderEnvironmentData.hasViewport && !renderEnvironmentData.viewport.equals(this.currentViewport)) {
            this.viewportChanged = true;
            this.explicitViewport = renderEnvironmentData.hasViewport;
            this.currentViewport.setBounds(renderEnvironmentData.viewport);
        }
        this.setRenderEffects(renderEnvironmentData.effectsProcessor, renderEnvironmentData.userData);
        this.currentFrustum[0] = renderEnvironmentData.viewFrustum[0];
        this.currentFrustum[1] = renderEnvironmentData.viewFrustum[1];
        this.currentFrustum[2] = renderEnvironmentData.viewFrustum[2];
        this.currentFrustum[3] = renderEnvironmentData.viewFrustum[3];
        this.currentFrustum[4] = renderEnvironmentData.viewFrustum[4];
        this.currentFrustum[5] = renderEnvironmentData.viewFrustum[5];
        this.eyePoint[0] = renderEnvironmentData.eyeOffset[0];
        this.eyePoint[1] = renderEnvironmentData.eyeOffset[1];
        this.eyePoint[2] = renderEnvironmentData.eyeOffset[2];
        this.matrixUtils.inverse(renderEnvironmentData.viewTransform, this.cameraMatrix);
        this.viewMatrix[0] = this.cameraMatrix.m00;
        this.viewMatrix[1] = this.cameraMatrix.m10;
        this.viewMatrix[2] = this.cameraMatrix.m20;
        this.viewMatrix[3] = this.cameraMatrix.m30;
        this.viewMatrix[4] = this.cameraMatrix.m01;
        this.viewMatrix[5] = this.cameraMatrix.m11;
        this.viewMatrix[6] = this.cameraMatrix.m21;
        this.viewMatrix[7] = this.cameraMatrix.m31;
        this.viewMatrix[8] = this.cameraMatrix.m02;
        this.viewMatrix[9] = this.cameraMatrix.m12;
        this.viewMatrix[10] = this.cameraMatrix.m22;
        this.viewMatrix[11] = this.cameraMatrix.m32;
        this.viewMatrix[12] = this.cameraMatrix.m03;
        this.viewMatrix[13] = this.cameraMatrix.m13;
        this.viewMatrix[14] = this.cameraMatrix.m23;
        this.viewMatrix[15] = this.cameraMatrix.m33;
        Matrix4f matrix4f = renderEnvironmentData.backgroundTransform;
        matrix4f.mul(renderEnvironmentData.viewTransform);
        this.backgroundMatrix[0] = matrix4f.m00;
        this.backgroundMatrix[1] = matrix4f.m01;
        this.backgroundMatrix[2] = matrix4f.m02;
        this.backgroundMatrix[3] = 0.0f;
        this.backgroundMatrix[4] = matrix4f.m10;
        this.backgroundMatrix[5] = matrix4f.m11;
        this.backgroundMatrix[6] = matrix4f.m12;
        this.backgroundMatrix[7] = 0.0f;
        this.backgroundMatrix[8] = matrix4f.m20;
        this.backgroundMatrix[9] = matrix4f.m21;
        this.backgroundMatrix[10] = matrix4f.m22;
        this.backgroundMatrix[11] = 0.0f;
        this.backgroundMatrix[12] = matrix4f.m30;
        this.backgroundMatrix[13] = matrix4f.m31;
        this.backgroundMatrix[14] = matrix4f.m32;
        this.backgroundMatrix[15] = matrix4f.m33;
        this.surfaceMatrix.set(renderEnvironmentData.viewTransform);
    }

    public void setActiveView(Viewpoint viewpoint) throws IllegalArgumentException {
        if (viewpoint == null) {
            this.currentViewpoint = viewpoint;
            return;
        }
        if (!viewpoint.isLive()) {
            throw new IllegalArgumentException(NOT_LIVE_VP_MSG);
        }
        this.currentViewpoint = viewpoint;
    }

    public void setActiveFog(Fog fog) throws IllegalArgumentException {
        if (fog == null) {
            this.currentFog = fog;
            return;
        }
        if (!fog.isLive()) {
            throw new IllegalArgumentException(NOT_LIVE_FOG_MSG);
        }
        Node node = fog.getParent();
        int n = 0;
        while (node != null) {
            if (node instanceof SharedGroup || node instanceof SharedNode) {
                throw new IllegalArgumentException(SHARED_FOG_MSG);
            }
            node = node.getParent();
            ++n;
        }
        this.currentFog = fog;
        if (this.currentFogPath.length < n) {
            this.currentFogPath = new TransformGroup[n];
        }
    }

    public void setActiveBackground(Background background) throws IllegalArgumentException {
        if (background == null) {
            this.currentBackground = background;
            return;
        }
        if (!background.isLive()) {
            throw new IllegalArgumentException(NOT_LIVE_BG_MSG);
        }
        Node node = background.getParent();
        int n = 0;
        while (node != null) {
            if (node instanceof SharedGroup || node instanceof SharedNode) {
                throw new IllegalArgumentException(SHARED_BG_MSG);
            }
            node = node.getParent();
            ++n;
        }
        this.currentBackground = background;
        if (this.currentBackgroundPath.length < n) {
            this.currentBackgroundPath = new TransformGroup[n];
        }
    }

    public void setViewEnvironment(ViewEnvironment viewEnvironment) {
        this.viewEnvironment = viewEnvironment;
        if (viewEnvironment == null) {
            this.viewEnvironment = this.defaultEnvironment;
        } else if (this.viewEnvironment.getAspectRatio() <= 0.0) {
            this.recalcAspect = true;
            this.viewEnvironment.setAspectRatio(this.aspectRatio);
        }
    }

    public void setRenderEffects(RenderEffectsProcessor renderEffectsProcessor, Object object) {
        this.effectsProcessor = renderEffectsProcessor;
        this.userData = object;
    }

    public void setClearColor(float f, float f2, float f3, float f4) {
        this.clearColor[0] = f;
        this.clearColor[1] = f2;
        this.clearColor[2] = f3;
        this.clearColor[3] = f4;
        this.resetColor = true;
    }

    public void setDrawableObjects(RenderDetails[] renderDetailsArray, int[] nArray, int n) {
        this.renderableList = renderDetailsArray;
        this.operationList = nArray;
        this.numRenderables = n;
    }

    public void getSurfaceToVWorld(Matrix4f matrix4f) {
        matrix4f.set(this.surfaceMatrix);
    }

    public void getPixelLocationInSurface(float f, float f2, Point3f point3f) {
        if (this.windowWidth == 0) {
            return;
        }
        point3f.x = (float)((this.currentFrustum[1] - this.currentFrustum[0]) * (double)(f / (float)this.windowWidth - 0.5f));
        point3f.y = (float)((this.currentFrustum[3] - this.currentFrustum[2]) * (double)(((float)this.windowHeight - f2) / (float)this.windowHeight - 0.5f));
        point3f.z = (float)(-this.currentFrustum[4]);
    }

    public void getCenterEyeInSurface(Point3f point3f) {
        point3f.set(this.eyePoint);
    }

    protected void renderViewpoint(GL gL, GLU gLU) {
        if (this.currentViewpoint == null) {
            return;
        }
        if (this.viewEnvironmentChanged) {
            this.updateProjectionMatrix(gL, gLU);
        }
        gL.glLoadIdentity();
        this.currentViewpoint.render(gL, gLU);
        gL.glMultMatrixf(this.viewMatrix);
    }

    protected void updateProjectionMatrix(GL gL, GLU gLU) {
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        switch (this.viewEnvironment.getProjectionType()) {
            case 1: {
                gL.glFrustum(this.currentFrustum[0], this.currentFrustum[1], this.currentFrustum[2], this.currentFrustum[3], this.currentFrustum[4], this.currentFrustum[5]);
                break;
            }
            case 2: {
                double d = this.viewEnvironment.getNearClipDistance();
                double d2 = this.viewEnvironment.getFarClipDistance();
                gL.glOrtho(0.0, (double)this.windowWidth, 0.0, (double)this.windowHeight, d, d2);
                break;
            }
            default: {
                System.out.println("unknown projection type");
            }
        }
        this.viewEnvironmentChanged = false;
        gL.glMatrixMode(5888);
    }

    protected void setupBackgroundFrustum(GL gL, double d, double d2, double d3) {
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        d7 = d * Math.tan(d3 * Math.PI / 360.0);
        d6 = -d7;
        if (this.aspectRatio <= 0.0) {
            System.out.println("Negative aspect ratio in background calc");
        } else {
            d4 = d6 * this.aspectRatio;
            d5 = d7 * this.aspectRatio;
        }
        gL.glFrustum(d4, d5, d6, d7, d, d2);
    }
}

