/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.surface;

import net.java.games.jogl.GL;
import net.java.games.jogl.GLDrawable;
import net.java.games.jogl.GLEventListener;
import net.java.games.jogl.GLU;
import net.java.games.jogl.TraceGL;
import org.j3d.aviatrix3d.CustomRenderable;
import org.j3d.aviatrix3d.RenderDetails;
import org.j3d.aviatrix3d.Renderable;
import org.j3d.aviatrix3d.RenderableComponent;
import org.j3d.aviatrix3d.RenderableObject;
import org.j3d.aviatrix3d.ShaderProgram;
import org.j3d.aviatrix3d.surface.BaseRenderingProcessor;
import org.j3d.aviatrix3d.surface.Renderer;

class DebugRenderingProcessor
extends BaseRenderingProcessor
implements GLEventListener,
Renderer {
    private TraceGL debugGL;
    private boolean dumpNextFrame = false;

    DebugRenderingProcessor() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void display(GLDrawable gLDrawable) {
        int n;
        GL gL = gLDrawable.getGL();
        GLU gLU = gLDrawable.getGLU();
        if (this.numDeletions != 0) {
            for (n = 0; n < this.numDeletions; ++n) {
                this.deleteQueue[n].cleanup(gL, gLU);
                this.deleteQueue[n] = null;
            }
            this.numDeletions = 0;
        }
        if (this.lastShaderInitIdx != 0) {
            for (n = 0; n < this.lastShaderInitIdx; ++n) {
                this.shaderInitList[n].initialize(gL, gLU);
                this.shaderInitList[n] = null;
            }
            this.lastShaderInitIdx = 0;
        }
        if (this.lastShaderLogIdx != 0) {
            for (n = 0; n < this.lastShaderLogIdx; ++n) {
                this.shaderLogList[n].fetchLogInfo(gL, gLU);
                this.shaderLogList[n] = null;
            }
            this.lastShaderLogIdx = 0;
        }
        if (this.terminate) {
            return;
        }
        if (this.effectsProcessor != null) {
            this.effectsProcessor.preDraw(gLDrawable, this.userData);
        }
        if (this.terminate) {
            return;
        }
        if (this.dumpNextFrame) {
            this.debugGL = new TraceGL(gL, System.out);
            gL = this.debugGL;
        }
        if (this.terminate) {
            return;
        }
        if (this.viewportChanged) {
            if (this.explicitViewport) {
                gL.glViewport(this.currentViewport.x, this.currentViewport.y, this.currentViewport.width, this.currentViewport.height);
            } else {
                gL.glViewport(0, 0, this.windowWidth, this.windowHeight);
            }
            this.viewportChanged = false;
        }
        if (this.terminate) {
            return;
        }
        if (this.currentBackground != null) {
            gL.glMatrixMode(5889);
            gL.glPushMatrix();
            gL.glLoadIdentity();
            this.setupBackgroundFrustum(gL, 0.01, 1.1, this.viewEnvironment.getFieldOfView());
            gL.glClear(256);
            gL.glMatrixMode(5888);
            gL.glPushMatrix();
            gL.glLoadMatrixf(this.backgroundMatrix);
            gL.glDepthMask(false);
            gL.glDisable(3042);
            gL.glDisable(2929);
            this.currentBackground.render(gL, gLU);
            this.currentBackground.postRender(gL, gLU);
            gL.glDepthMask(true);
            gL.glEnable(2929);
            gL.glEnable(3042);
            gL.glPopMatrix();
            gL.glMatrixMode(5889);
            gL.glPopMatrix();
            gL.glMatrixMode(5888);
            this.renderViewpoint(gL, gLU);
        } else {
            if (this.resetColor) {
                gL.glClearColor(this.clearColor[0], this.clearColor[1], this.clearColor[2], this.clearColor[3]);
            }
            gL.glClear(16640);
            this.renderViewpoint(gL, gLU);
        }
        if (this.terminate) {
            return;
        }
        n = 0;
        if (this.currentFog != null) {
            n = 1;
            gL.glEnable(2912);
            this.currentFog.render(gL, gLU);
        }
        block24: for (int i = 0; i < this.numRenderables && !this.terminate; ++i) {
            int n2;
            switch (this.operationList[i]) {
                case 1: {
                    if (this.dumpNextFrame) {
                        Renderable renderable = this.renderableList[i].renderable;
                        System.out.println("Start render " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    gL.glPushMatrix();
                    gL.glMultMatrixf(this.renderableList[i].transform);
                    RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                    renderableObject.render(gL, gLU);
                    break;
                }
                case 2: {
                    if (this.dumpNextFrame) {
                        Renderable renderable = this.renderableList[i].renderable;
                        System.out.println("Stop render " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                    renderableObject.postRender(gL, gLU);
                    gL.glPopMatrix();
                    break;
                }
                case 3: {
                    if (this.dumpNextFrame) {
                        Renderable renderable = this.renderableList[i].renderable;
                        System.out.println("Render geometry " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    gL.glPushMatrix();
                    gL.glMultMatrixf(this.renderableList[i].transform);
                    RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                    renderableObject.render(gL, gLU);
                    gL.glPopMatrix();
                    break;
                }
                case 4: {
                    if (this.dumpNextFrame) {
                        Renderable renderable = this.renderableList[i].renderable;
                        System.out.println("Render custom " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    gL.glPushMatrix();
                    gL.glMultMatrixf(this.renderableList[i].transform);
                    CustomRenderable customRenderable = (CustomRenderable)this.renderableList[i].renderable;
                    customRenderable.render(gL, gLU, this.renderableList[i].instructions);
                    gL.glPopMatrix();
                    break;
                }
                case 5: {
                    Object object2;
                    if (this.dumpNextFrame) {
                        object2 = this.renderableList[i].renderable;
                        System.out.println("Start state " + object2.getClass() + " 0x" + Integer.toHexString(object2.hashCode()));
                    }
                    RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                    renderableObject.render(gL, gLU);
                    break;
                }
                case 6: {
                    Object object2;
                    if (this.dumpNextFrame) {
                        object2 = this.renderableList[i].renderable;
                        System.out.println("Stop state " + object2.getClass() + " 0x" + Integer.toHexString(object2.hashCode()));
                    }
                    RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                    renderableObject.postRender(gL, gLU);
                    break;
                }
                case 9: {
                    Object object2;
                    if (this.dumpNextFrame) {
                        object2 = this.renderableList[i].renderable;
                        System.out.println("Start light " + object2.getClass() + " 0x" + Integer.toHexString(object2.hashCode()));
                    }
                    if (this.lastLightIdx >= this.availableLights.length) continue block24;
                    object2 = this.availableLights[this.lastLightIdx++];
                    this.lightIdMap.put(this.renderableList[i].id, object2);
                    gL.glPushMatrix();
                    gL.glMultMatrixf(this.renderableList[i].transform);
                    RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                    renderableComponent.render(gL, gLU, object2);
                    gL.glPopMatrix();
                    break;
                }
                case 10: {
                    Object object;
                    if (this.dumpNextFrame) {
                        object = this.renderableList[i].renderable;
                        System.out.println("Stop light " + object.getClass() + " 0x" + Integer.toHexString(object.hashCode()));
                    }
                    if (this.lastLightIdx >= this.availableLights.length) continue block24;
                    Object object2 = (Integer)this.lightIdMap.remove(this.renderableList[i].id);
                    RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                    renderableComponent.postRender(gL, gLU, object2);
                    this.availableLights[--this.lastLightIdx] = object2;
                    break;
                }
                case 17: {
                    Object object;
                    if (this.dumpNextFrame) {
                        object = this.renderableList[i].renderable;
                        System.out.println("Start clip plane " + object.getClass() + " 0x" + Integer.toHexString(object.hashCode()));
                    }
                    if (this.lastClipIdx >= this.availableClips.length) continue block24;
                    object = this.availableClips[this.lastClipIdx++];
                    this.clipIdMap.put(this.renderableList[i].id, object);
                    gL.glPushMatrix();
                    gL.glMultMatrixf(this.renderableList[i].transform);
                    RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                    renderableComponent.render(gL, gLU, object);
                    gL.glPopMatrix();
                    break;
                }
                case 18: {
                    Renderable renderable;
                    if (this.dumpNextFrame) {
                        renderable = this.renderableList[i].renderable;
                        System.out.println("Stop clip plane " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    if (this.lastClipIdx >= this.availableClips.length) continue block24;
                    Object object = (Integer)this.clipIdMap.remove(this.renderableList[i].id);
                    RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                    renderableComponent.postRender(gL, gLU, object);
                    this.availableClips[--this.lastClipIdx] = object;
                    break;
                }
                case 11: {
                    if (this.dumpNextFrame) {
                        System.out.println("Start transparency");
                    }
                    gL.glDepthMask(false);
                    gL.glEnable(3042);
                    gL.glBlendFunc(770, 771);
                    break;
                }
                case 12: {
                    if (this.dumpNextFrame) {
                        System.out.println("Stop transparency");
                    }
                    gL.glDisable(3042);
                    gL.glDepthMask(true);
                    break;
                }
                case 19: {
                    Renderable renderable;
                    if (this.dumpNextFrame) {
                        renderable = this.renderableList[i].renderable;
                        System.out.println("Start fog " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    if (n == 0) {
                        gL.glEnable(2912);
                        n = 1;
                    }
                    RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                    renderableObject.render(gL, gLU);
                    break;
                }
                case 20: {
                    Renderable renderable;
                    if (this.dumpNextFrame) {
                        renderable = this.renderableList[i].renderable;
                        System.out.println("Stop fog " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    if (this.currentFog != null) {
                        this.currentFog.render(gL, gLU);
                        break;
                    }
                    RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                    renderableObject.postRender(gL, gLU);
                    n = 0;
                    gL.glDisable(2912);
                    break;
                }
                case 21: {
                    Renderable renderable;
                    if (this.dumpNextFrame) {
                        renderable = this.renderableList[i].renderable;
                        System.out.println("Start shader program " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    if (!((ShaderProgram)(renderable = (ShaderProgram)this.renderableList[i].renderable)).isValid(gL)) {
                        this.currentShaderProgramId = INVALID_SHADER;
                        continue block24;
                    }
                    this.currentShaderProgramId = new Integer(((ShaderProgram)renderable).getProgramId(gL));
                    ((ShaderProgram)renderable).render(gL, gLU);
                    break;
                }
                case 22: {
                    Object object;
                    if (this.dumpNextFrame) {
                        object = this.renderableList[i].renderable;
                        System.out.println("Stop shader program " + object.getClass() + " 0x" + Integer.toHexString(object.hashCode()));
                    }
                    if (this.currentShaderProgramId == INVALID_SHADER) continue block24;
                    RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                    renderableObject.postRender(gL, gLU);
                    this.currentShaderProgramId = INVALID_SHADER;
                    break;
                }
                case 23: {
                    Object object;
                    if (this.dumpNextFrame) {
                        object = this.renderableList[i].renderable;
                        System.out.println("Set shader args " + object.getClass() + " 0x" + Integer.toHexString(object.hashCode()));
                    }
                    if (this.currentShaderProgramId == INVALID_SHADER) continue block24;
                    RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                    renderableComponent.render(gL, gLU, this.currentShaderProgramId);
                    break;
                }
                case 24: {
                    Object object;
                    if (this.dumpNextFrame) {
                        object = this.renderableList[i].renderable;
                        System.out.println("Start texture " + object.getClass() + " 0x" + Integer.toHexString(object.hashCode()));
                    }
                    RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                    object = (Integer)this.renderableList[i].instructions;
                    renderableComponent.render(gL, gLU, object);
                    break;
                }
                case 25: {
                    if (this.dumpNextFrame) {
                        Renderable renderable = this.renderableList[i].renderable;
                        System.out.println("Stop texture " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                    Object object = (Integer)this.renderableList[i].instructions;
                    renderableComponent.postRender(gL, gLU, object);
                }
            }
            if (!this.dumpNextFrame || (n2 = gL.glGetError()) == 0) continue;
            System.out.println("Error: after " + this.renderableList[i].renderable);
            System.out.println(gLU.gluErrorString(n2));
        }
        if (this.terminate) {
            return;
        }
        if (this.currentFog != null) {
            this.currentFog.postRender(gL, gLU);
            gL.glDisable(2912);
        }
        if (this.terminate) {
            return;
        }
        if (this.effectsProcessor != null) {
            this.effectsProcessor.postDraw(gLDrawable, this.userData);
        }
        if (this.terminate) {
            return;
        }
        if (this.currentViewpoint != null) {
            this.currentViewpoint.postRender(gL, gLU);
        }
        if (this.terminate) {
            return;
        }
        gL.glFlush();
        this.dumpNextFrame = false;
    }

    void traceNextFrame() {
        this.dumpNextFrame = true;
    }

    public void setDrawableObjects(RenderDetails[] renderDetailsArray, int[] nArray, int n) {
        super.setDrawableObjects(renderDetailsArray, nArray, n);
    }
}

