/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.surface;

import javax.vecmath.Point3f;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLDrawable;
import net.java.games.jogl.GLEventListener;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.CustomRenderable;
import org.j3d.aviatrix3d.RenderableComponent;
import org.j3d.aviatrix3d.RenderableObject;
import org.j3d.aviatrix3d.ShaderProgram;
import org.j3d.aviatrix3d.surface.BaseRenderingProcessor;
import org.j3d.aviatrix3d.surface.Renderer;
import org.j3d.device.output.elumens.SPI;
import org.j3d.util.MatrixUtils;

class ElumensRenderingProcessor
extends BaseRenderingProcessor
implements GLEventListener,
Renderer {
    private SPI spi = new SPI();
    private boolean initSpi = true;
    private boolean initComplete;
    private int newNumChannels = 3;
    private int numChannels;
    private int spiFormat = 2049;
    private double lastNear;
    private double lastFar;
    private MatrixUtils matrixUtils;
    private boolean terminate;
    private float[] eyePos;
    private float[] lensPos;
    private double[] screenOrientation;
    private int[] chanSize = new int[]{1024, 1024};

    ElumensRenderingProcessor() {
    }

    public void setChanLensPosition(int n, float f, float f2, float f3) {
        this.lensPos = new float[]{f, f2, f3};
        if (this.initComplete) {
            this.spi.setChanLensPosition(n, this.lensPos[0], this.lensPos[1], this.lensPos[2]);
        }
    }

    public void setChanEyePosition(int n, float f, float f2, float f3) {
        this.eyePos = new float[]{f, f2, f3};
        if (this.initComplete) {
            this.spi.setChanEyePosition(n, this.eyePos[0], this.eyePos[1], this.eyePos[2]);
        }
    }

    public void setScreenOrientation(double d, double d2, double d3) {
        this.screenOrientation = new double[]{d, d2, d3};
        if (this.initComplete) {
            this.spi.setScreenOrientation(this.screenOrientation[0], this.screenOrientation[1], this.screenOrientation[2]);
        }
    }

    public void setChanSize(int n, int n2, int n3) {
        this.chanSize = new int[]{n2, n3};
        if (this.initComplete) {
            this.spi.setChanSize(n, n2, n3);
        }
    }

    public void init(GLDrawable gLDrawable) {
        super.init(gLDrawable);
        this.spi = new SPI();
        this.initializeSPI();
    }

    public void reshape(GLDrawable gLDrawable, int n, int n2, int n3, int n4) {
        super.reshape(gLDrawable, n, n2, n3, n4);
        int n5 = this.windowWidth > this.chanSize[0] ? this.chanSize[0] : this.windowWidth;
        int n6 = this.windowHeight > this.chanSize[1] ? this.chanSize[1] : this.windowHeight;
        for (int i = 0; i < this.numChannels; ++i) {
            this.spi.setChanSize(this.getSpiToken(i), n5, n6);
        }
        this.initComplete = true;
    }

    public void display(GLDrawable gLDrawable) {
        int n;
        GL gL = gLDrawable.getGL();
        GLU gLU = gLDrawable.getGLU();
        if (this.numDeletions != 0) {
            for (n = 0; n < this.numDeletions; ++n) {
                this.deleteQueue[n].cleanup(gL, gLU);
                this.deleteQueue[n] = null;
            }
            this.numDeletions = 0;
        }
        if (this.lastShaderInitIdx != 0) {
            for (n = 0; n < this.lastShaderInitIdx; ++n) {
                this.shaderInitList[n].initialize(gL, gLU);
                this.shaderInitList[n] = null;
            }
            this.lastShaderInitIdx = 0;
        }
        if (this.lastShaderLogIdx != 0) {
            for (n = 0; n < this.lastShaderLogIdx; ++n) {
                this.shaderLogList[n].fetchLogInfo(gL, gLU);
                this.shaderLogList[n] = null;
            }
            this.lastShaderLogIdx = 0;
        }
        if (this.terminate) {
            return;
        }
        if (this.initSpi) {
            this.initializeSPI();
        }
        if (this.terminate) {
            return;
        }
        this.renderViewpoint(gL, gLU);
        if (this.terminate) {
            return;
        }
        this.spi.begin();
        if (this.terminate) {
            return;
        }
        for (n = 0; n < this.numChannels && !this.terminate; ++n) {
            int n2 = this.getSpiToken(n);
            this.spi.preRender(n2);
            if (this.terminate) {
                return;
            }
            if (this.effectsProcessor != null) {
                this.effectsProcessor.preDraw(gLDrawable, this.userData);
            }
            if (this.terminate) {
                return;
            }
            if (this.currentBackground != null) {
                gL.glClear(256);
                gL.glMatrixMode(5888);
                gL.glPushMatrix();
                gL.glLoadIdentity();
                gL.glMultMatrixf(this.backgroundMatrix);
                gL.glScaled(this.currentFrustum[5], this.currentFrustum[5], this.currentFrustum[5]);
                gL.glDepthMask(false);
                gL.glDisable(3042);
                gL.glDisable(2929);
                this.currentBackground.render(gL, gLU);
                this.currentBackground.postRender(gL, gLU);
                gL.glDepthMask(true);
                gL.glEnable(2929);
                gL.glEnable(3042);
                gL.glPopMatrix();
                gL.glMatrixMode(5889);
                gL.glPopMatrix();
                gL.glMatrixMode(5888);
                this.renderViewpoint(gL, gLU);
            } else {
                if (this.resetColor) {
                    gL.glClearColor(this.clearColor[0], this.clearColor[1], this.clearColor[2], this.clearColor[3]);
                }
                gL.glClear(16640);
                this.renderViewpoint(gL, gLU);
            }
            if (this.terminate) {
                return;
            }
            boolean bl = false;
            if (this.currentFog != null) {
                bl = true;
                gL.glEnable(2912);
                this.currentFog.render(gL, gLU);
            }
            block31: for (int i = 0; i < this.numRenderables && !this.terminate; ++i) {
                switch (this.operationList[i]) {
                    case 1: {
                        gL.glPushMatrix();
                        gL.glMultMatrixf(this.renderableList[i].transform);
                        RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                        renderableObject.render(gL, gLU);
                        continue block31;
                    }
                    case 2: {
                        RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                        renderableObject.postRender(gL, gLU);
                        gL.glPopMatrix();
                        continue block31;
                    }
                    case 3: {
                        gL.glPushMatrix();
                        gL.glMultMatrixf(this.renderableList[i].transform);
                        RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                        renderableObject.render(gL, gLU);
                        gL.glPopMatrix();
                        continue block31;
                    }
                    case 4: {
                        gL.glPushMatrix();
                        gL.glMultMatrixf(this.renderableList[i].transform);
                        CustomRenderable customRenderable = (CustomRenderable)this.renderableList[i].renderable;
                        customRenderable.render(gL, gLU, this.renderableList[i].instructions);
                        gL.glPopMatrix();
                        continue block31;
                    }
                    case 5: {
                        RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                        renderableObject.render(gL, gLU);
                        continue block31;
                    }
                    case 6: {
                        RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                        renderableObject.postRender(gL, gLU);
                        continue block31;
                    }
                    case 9: {
                        if (this.lastLightIdx >= this.availableLights.length) continue block31;
                        Integer n3 = this.availableLights[this.lastLightIdx++];
                        this.lightIdMap.put(this.renderableList[i].id, (Object)n3);
                        gL.glPushMatrix();
                        gL.glMultMatrixf(this.renderableList[i].transform);
                        RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                        renderableComponent.render(gL, gLU, n3);
                        gL.glPopMatrix();
                        continue block31;
                    }
                    case 10: {
                        if (this.lastLightIdx >= this.availableLights.length) continue block31;
                        Integer n3 = (Integer)this.lightIdMap.remove(this.renderableList[i].id);
                        RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                        renderableComponent.postRender(gL, gLU, n3);
                        this.availableLights[--this.lastLightIdx] = n3;
                        continue block31;
                    }
                    case 17: {
                        if (this.lastClipIdx >= this.availableClips.length) continue block31;
                        Integer n4 = this.availableClips[this.lastClipIdx++];
                        this.clipIdMap.put(this.renderableList[i].id, (Object)n4);
                        gL.glPushMatrix();
                        gL.glMultMatrixf(this.renderableList[i].transform);
                        RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                        renderableComponent.render(gL, gLU, n4);
                        gL.glPopMatrix();
                        continue block31;
                    }
                    case 18: {
                        if (this.lastClipIdx >= this.availableClips.length) continue block31;
                        Integer n4 = (Integer)this.clipIdMap.remove(this.renderableList[i].id);
                        RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                        renderableComponent.postRender(gL, gLU, n4);
                        this.availableClips[--this.lastClipIdx] = n4;
                        continue block31;
                    }
                    case 11: {
                        gL.glDepthMask(false);
                        gL.glEnable(3042);
                        gL.glBlendFunc(770, 771);
                        continue block31;
                    }
                    case 12: {
                        gL.glDisable(3042);
                        gL.glDepthMask(true);
                        continue block31;
                    }
                    case 19: {
                        if (!bl) {
                            gL.glEnable(2912);
                            bl = true;
                        }
                        RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                        renderableObject.render(gL, gLU);
                        continue block31;
                    }
                    case 20: {
                        if (this.currentFog != null) {
                            this.currentFog.render(gL, gLU);
                            continue block31;
                        }
                        RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                        renderableObject.postRender(gL, gLU);
                        bl = false;
                        gL.glDisable(2912);
                        continue block31;
                    }
                    case 21: {
                        ShaderProgram shaderProgram = (ShaderProgram)this.renderableList[i].renderable;
                        if (!shaderProgram.isValid(gL)) {
                            this.currentShaderProgramId = INVALID_SHADER;
                            continue block31;
                        }
                        this.currentShaderProgramId = new Integer(shaderProgram.getProgramId(gL));
                        shaderProgram.render(gL, gLU);
                        continue block31;
                    }
                    case 22: {
                        if (this.currentShaderProgramId == INVALID_SHADER) continue block31;
                        RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                        renderableObject.postRender(gL, gLU);
                        this.currentShaderProgramId = INVALID_SHADER;
                        continue block31;
                    }
                    case 23: {
                        if (this.currentShaderProgramId == INVALID_SHADER) continue block31;
                        RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                        renderableComponent.render(gL, gLU, this.currentShaderProgramId);
                        continue block31;
                    }
                    case 24: {
                        RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                        Integer n5 = (Integer)this.renderableList[i].instructions;
                        renderableComponent.render(gL, gLU, n5);
                        continue block31;
                    }
                    case 25: {
                        RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                        Integer n5 = (Integer)this.renderableList[i].instructions;
                        renderableComponent.postRender(gL, gLU, n5);
                    }
                }
            }
            if (this.terminate) {
                return;
            }
            if (this.currentFog != null) {
                this.currentFog.postRender(gL, gLU);
                gL.glDisable(2912);
            }
            if (this.terminate) {
                return;
            }
            if (this.effectsProcessor != null) {
                this.effectsProcessor.postDraw(gLDrawable, this.userData);
            }
            if (this.terminate) {
                return;
            }
            gL.glFlush();
            if (this.terminate) {
                return;
            }
            this.spi.postRender(n2);
        }
        if (this.terminate) {
            return;
        }
        if (this.currentViewpoint != null) {
            this.currentViewpoint.postRender(gL, gLU);
        }
        if (this.terminate) {
            return;
        }
        this.spi.end();
        gL.glClearColor(0.0f, 0.0f, 0.4f, 1.0f);
        gL.glClear(0x4000 | 0x100);
        switch (this.numChannels) {
            case 1: {
                this.spi.flush(1);
                break;
            }
            case 2: {
                this.spi.flush(6);
                break;
            }
            case 3: {
                this.spi.flush(56);
                break;
            }
            case 4: {
                this.spi.flush(120);
            }
        }
    }

    public void getPixelLocationInSurface(float f, float f2, Point3f point3f) {
        if (this.windowWidth == 0) {
            return;
        }
        point3f.x = (float)((this.currentFrustum[1] - this.currentFrustum[0]) * (double)(f / (float)this.windowWidth - 0.5f));
        point3f.y = (float)((this.currentFrustum[3] - this.currentFrustum[2]) * (double)(((float)this.windowHeight - f2) / (float)this.windowHeight - 0.5f));
        point3f.z = (float)(-this.currentFrustum[4]);
    }

    public void getCenterEyeInSurface(Point3f point3f) {
        point3f.set(this.eyePoint);
    }

    public void setNumberOfChannels(int n) {
        this.newNumChannels = n;
        this.initSpi = true;
    }

    private int getSpiToken(int n) {
        switch (this.numChannels) {
            case 1: {
                return 1;
            }
            case 2: {
                switch (n) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 4;
                    }
                }
                System.out.println("Unknown wall: " + n);
            }
            case 3: {
                switch (n) {
                    case 0: {
                        return 8;
                    }
                    case 1: {
                        return 16;
                    }
                    case 2: {
                        return 32;
                    }
                }
                System.out.println("Unknown wall: " + n);
            }
            case 4: {
                switch (n) {
                    case 0: {
                        return 8;
                    }
                    case 1: {
                        return 16;
                    }
                    case 2: {
                        return 32;
                    }
                    case 3: {
                        return 64;
                    }
                }
                System.out.println("Unknown wall: " + n);
            }
        }
        System.out.println("Unsupported number of channels in: " + this);
        return 0;
    }

    private int getSpiFormat() {
        int n = 1;
        switch (this.numChannels) {
            case 1: {
                return 0x200 | n;
            }
            case 2: {
                return 0x400 | n;
            }
            case 3: {
                return 0x800 | n;
            }
            case 4: {
                return 0x1000 | n;
            }
        }
        System.out.println("Unsupported number of channels in: " + this);
        return 0;
    }

    private void initializeSPI() {
        this.numChannels = this.newNumChannels;
        this.spiFormat = this.getSpiFormat();
        this.spi.initialize(this.spiFormat, this.numChannels);
        float f = 0.1f;
        float f2 = 3000.0f;
        this.lastNear = f;
        this.lastFar = f2;
        this.spi.setNearFar(f, f2);
        int n = 0;
        switch (this.numChannels) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 6;
                break;
            }
            case 3: {
                n = 56;
                break;
            }
            case 4: {
                n = 120;
            }
        }
        if (this.initComplete) {
            int n2 = this.windowWidth > this.chanSize[0] ? this.chanSize[0] : this.windowWidth;
            int n3 = this.windowHeight > this.chanSize[1] ? this.chanSize[1] : this.windowHeight;
            switch (this.numChannels) {
                case 1: {
                    this.spi.setChanSize(1, n2, n3);
                    break;
                }
                case 2: {
                    this.spi.setChanSize(6, n2, n3);
                    break;
                }
                case 3: {
                    this.spi.setChanSize(56, n2, n3);
                    break;
                }
                case 4: {
                    this.spi.setChanSize(120, n2, n3);
                }
            }
        }
        if (this.lensPos != null) {
            System.out.println("Setting lensPosition: " + this.lensPos[0] + " " + this.lensPos[1] + " " + this.lensPos[2]);
            this.spi.setChanLensPosition(n, this.lensPos[0], this.lensPos[1], this.lensPos[2]);
        }
        if (this.eyePos != null) {
            System.out.println("Setting eyePosition: " + this.eyePos[0] + " " + this.eyePos[1] + " " + this.eyePos[2]);
            this.spi.setChanEyePosition(n, this.eyePos[0], this.eyePos[1], this.eyePos[2]);
        }
        if (this.screenOrientation != null) {
            System.out.println("Setting screenOrientation: " + this.screenOrientation[0] + " " + this.screenOrientation[1] + " " + this.screenOrientation[2]);
            this.spi.setScreenOrientation(this.screenOrientation[0], this.screenOrientation[1], this.screenOrientation[2]);
        }
        this.initSpi = false;
    }

    protected void updateProjectionMatrix(GL gL, GLU gLU) {
        super.updateProjectionMatrix(gL, gLU);
        this.spi.setNearFar((float)this.currentFrustum[4], (float)this.currentFrustum[5]);
    }
}

