/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.surface;

import net.java.games.jogl.GL;
import net.java.games.jogl.GLDrawable;
import net.java.games.jogl.GLEventListener;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.CustomRenderable;
import org.j3d.aviatrix3d.RenderableComponent;
import org.j3d.aviatrix3d.RenderableObject;
import org.j3d.aviatrix3d.ShaderProgram;
import org.j3d.aviatrix3d.surface.BaseRenderingProcessor;
import org.j3d.aviatrix3d.surface.StereoRenderer;

class SingleEyeStereoRenderer
extends BaseRenderingProcessor
implements GLEventListener,
StereoRenderer {
    private float eyeSeparation = 0.005f;
    private boolean stereoAvailability = false;
    private boolean renderLeftEye = true;

    SingleEyeStereoRenderer() {
    }

    public void reshape(GLDrawable gLDrawable, int n, int n2, int n3, int n4) {
        this.windowWidth = n3;
        this.windowHeight = n4;
        this.aspectRatio = (float)n3 / (float)n4;
        if (this.recalcAspect) {
            this.viewEnvironment.setAspectRatio(this.aspectRatio);
        }
        GL gL = gLDrawable.getGL();
        GLU gLU = gLDrawable.getGLU();
        gL.glViewport(0, 0, n3, n4);
        byte[] byArray = new byte[1];
        gL.glGetBooleanv(3123, byArray);
        this.stereoAvailability = byArray[0] == 1;
    }

    public void display(GLDrawable gLDrawable) {
        int n;
        GL gL = gLDrawable.getGL();
        GLU gLU = gLDrawable.getGLU();
        if (this.numDeletions != 0) {
            for (n = 0; n < this.numDeletions; ++n) {
                this.deleteQueue[n].cleanup(gL, gLU);
                this.deleteQueue[n] = null;
            }
            this.numDeletions = 0;
        }
        if (this.lastShaderInitIdx != 0) {
            for (n = 0; n < this.lastShaderInitIdx; ++n) {
                this.shaderInitList[n].initialize(gL, gLU);
                this.shaderInitList[n] = null;
            }
            this.lastShaderInitIdx = 0;
        }
        if (this.lastShaderLogIdx != 0) {
            for (n = 0; n < this.lastShaderLogIdx; ++n) {
                this.shaderLogList[n].fetchLogInfo(gL, gLU);
                this.shaderLogList[n] = null;
            }
            this.lastShaderLogIdx = 0;
        }
        if (this.terminate) {
            return;
        }
        gL.glMatrixMode(5888);
        gL.glDrawBuffer(1026);
        if (this.terminate) {
            return;
        }
        this.render(gLDrawable, gL, gLU, this.renderLeftEye);
    }

    public boolean isStereoAvailable() {
        return this.stereoAvailability;
    }

    public void setStereoEyeSeparation(float f) {
        this.eyeSeparation = f < 0.0f ? -f : f;
    }

    public float getStereoEyeSeparation() {
        return this.eyeSeparation;
    }

    void setEyeToRender(boolean bl) {
        this.renderLeftEye = bl;
    }

    private void renderViewpoint(GL gL, GLU gLU, boolean bl) {
        if (this.currentViewpoint == null) {
            return;
        }
        this.updateProjectionMatrix(gL, gLU, bl);
        gL.glLoadIdentity();
        if (bl) {
            gL.glTranslated(0.0, 0.0, (double)(-this.eyeSeparation));
        } else {
            gL.glTranslated(0.0, 0.0, (double)this.eyeSeparation);
        }
        this.currentViewpoint.render(gL, gLU);
        gL.glMultMatrixf(this.viewMatrix);
    }

    private void updateProjectionMatrix(GL gL, GLU gLU, boolean bl) {
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        switch (this.viewEnvironment.getProjectionType()) {
            case 1: {
                if (bl) {
                    gL.glFrustum(this.currentFrustum[0] - (double)this.eyeSeparation, this.currentFrustum[1] - (double)this.eyeSeparation, this.currentFrustum[2], this.currentFrustum[3], this.currentFrustum[4], this.currentFrustum[5]);
                    break;
                }
                gL.glFrustum(this.currentFrustum[0] + (double)this.eyeSeparation, this.currentFrustum[1] + (double)this.eyeSeparation, this.currentFrustum[2], this.currentFrustum[3], this.currentFrustum[4], this.currentFrustum[5]);
                break;
            }
            case 2: {
                double d = this.viewEnvironment.getNearClipDistance();
                double d2 = this.viewEnvironment.getFarClipDistance();
                gL.glOrtho(0.0, (double)this.windowWidth, 0.0, (double)this.windowHeight, d, d2);
                break;
            }
            default: {
                System.out.println("unknown projection type");
            }
        }
        gL.glMatrixMode(5888);
    }

    private void render(GLDrawable gLDrawable, GL gL, GLU gLU, boolean bl) {
        if (this.effectsProcessor != null) {
            this.effectsProcessor.preDraw(gLDrawable, this.userData);
        }
        if (this.terminate) {
            return;
        }
        if (this.currentBackground != null) {
            gL.glMatrixMode(5889);
            gL.glPushMatrix();
            gL.glLoadIdentity();
            this.setupBackgroundFrustum(gL, 0.01, 1.1, this.viewEnvironment.getFieldOfView());
            gL.glClear(256);
            gL.glMatrixMode(5888);
            gL.glPushMatrix();
            gL.glLoadMatrixf(this.backgroundMatrix);
            gL.glDepthMask(false);
            gL.glDisable(3042);
            gL.glDisable(2929);
            this.currentBackground.render(gL, gLU);
            this.currentBackground.postRender(gL, gLU);
            gL.glDepthMask(true);
            gL.glEnable(2929);
            gL.glEnable(3042);
            gL.glPopMatrix();
            gL.glMatrixMode(5889);
            gL.glPopMatrix();
            gL.glMatrixMode(5888);
            this.renderViewpoint(gL, gLU, bl);
        } else {
            if (this.resetColor) {
                gL.glClearColor(this.clearColor[0], this.clearColor[1], this.clearColor[2], this.clearColor[3]);
            }
            gL.glClear(16640);
            this.renderViewpoint(gL, gLU, bl);
        }
        if (this.terminate) {
            return;
        }
        boolean bl2 = false;
        if (this.currentFog != null) {
            bl2 = true;
            gL.glEnable(2912);
            this.currentFog.render(gL, gLU);
        }
        if (this.terminate) {
            return;
        }
        block21: for (int i = 0; i < this.numRenderables && !this.terminate; ++i) {
            switch (this.operationList[i]) {
                case 1: {
                    gL.glPushMatrix();
                    gL.glMultMatrixf(this.renderableList[i].transform);
                    RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                    renderableObject.render(gL, gLU);
                    continue block21;
                }
                case 2: {
                    RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                    renderableObject.postRender(gL, gLU);
                    gL.glPopMatrix();
                    continue block21;
                }
                case 3: {
                    gL.glPushMatrix();
                    gL.glMultMatrixf(this.renderableList[i].transform);
                    RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                    renderableObject.render(gL, gLU);
                    gL.glPopMatrix();
                    continue block21;
                }
                case 4: {
                    gL.glPushMatrix();
                    gL.glMultMatrixf(this.renderableList[i].transform);
                    CustomRenderable customRenderable = (CustomRenderable)this.renderableList[i].renderable;
                    customRenderable.render(gL, gLU, this.renderableList[i].instructions);
                    gL.glPopMatrix();
                    continue block21;
                }
                case 5: {
                    RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                    renderableObject.render(gL, gLU);
                    continue block21;
                }
                case 6: {
                    RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                    renderableObject.postRender(gL, gLU);
                    continue block21;
                }
                case 9: {
                    if (this.lastLightIdx >= this.availableLights.length) continue block21;
                    Integer n = this.availableLights[this.lastLightIdx++];
                    this.lightIdMap.put(this.renderableList[i].id, (Object)n);
                    gL.glPushMatrix();
                    gL.glMultMatrixf(this.renderableList[i].transform);
                    RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                    renderableComponent.render(gL, gLU, n);
                    gL.glPopMatrix();
                    continue block21;
                }
                case 10: {
                    if (this.lastLightIdx >= this.availableLights.length) continue block21;
                    Integer n = (Integer)this.lightIdMap.remove(this.renderableList[i].id);
                    RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                    renderableComponent.postRender(gL, gLU, n);
                    this.availableLights[--this.lastLightIdx] = n;
                    continue block21;
                }
                case 17: {
                    if (this.lastClipIdx >= this.availableClips.length) continue block21;
                    Integer n = this.availableClips[this.lastClipIdx++];
                    this.clipIdMap.put(this.renderableList[i].id, (Object)n);
                    gL.glPushMatrix();
                    gL.glMultMatrixf(this.renderableList[i].transform);
                    RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                    renderableComponent.render(gL, gLU, n);
                    gL.glPopMatrix();
                    continue block21;
                }
                case 18: {
                    if (this.lastClipIdx >= this.availableClips.length) continue block21;
                    Integer n = (Integer)this.clipIdMap.remove(this.renderableList[i].id);
                    RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                    renderableComponent.postRender(gL, gLU, n);
                    this.availableClips[--this.lastClipIdx] = n;
                    continue block21;
                }
                case 11: {
                    gL.glDepthMask(false);
                    gL.glEnable(3042);
                    gL.glBlendFunc(770, 771);
                    continue block21;
                }
                case 12: {
                    gL.glDisable(3042);
                    gL.glDepthMask(true);
                    continue block21;
                }
                case 19: {
                    if (!bl2) {
                        gL.glEnable(2912);
                        bl2 = true;
                    }
                    RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                    renderableObject.render(gL, gLU);
                    continue block21;
                }
                case 20: {
                    if (this.currentFog != null) {
                        this.currentFog.render(gL, gLU);
                        continue block21;
                    }
                    RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                    renderableObject.postRender(gL, gLU);
                    bl2 = false;
                    gL.glDisable(2912);
                    continue block21;
                }
                case 21: {
                    ShaderProgram shaderProgram = (ShaderProgram)this.renderableList[i].renderable;
                    if (!shaderProgram.isValid(gL)) {
                        this.currentShaderProgramId = INVALID_SHADER;
                        continue block21;
                    }
                    this.currentShaderProgramId = new Integer(shaderProgram.getProgramId(gL));
                    shaderProgram.render(gL, gLU);
                    continue block21;
                }
                case 22: {
                    if (this.currentShaderProgramId == INVALID_SHADER) continue block21;
                    RenderableObject renderableObject = (RenderableObject)this.renderableList[i].renderable;
                    renderableObject.postRender(gL, gLU);
                    this.currentShaderProgramId = INVALID_SHADER;
                    continue block21;
                }
                case 23: {
                    if (this.currentShaderProgramId == INVALID_SHADER) continue block21;
                    RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                    renderableComponent.render(gL, gLU, this.currentShaderProgramId);
                    continue block21;
                }
                case 24: {
                    RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                    Integer n = (Integer)this.renderableList[i].instructions;
                    renderableComponent.render(gL, gLU, n);
                    continue block21;
                }
                case 25: {
                    RenderableComponent renderableComponent = (RenderableComponent)this.renderableList[i].renderable;
                    Integer n = (Integer)this.renderableList[i].instructions;
                    renderableComponent.postRender(gL, gLU, n);
                }
            }
        }
        if (this.terminate) {
            return;
        }
        if (this.currentFog != null) {
            this.currentFog.postRender(gL, gLU);
            gL.glDisable(2912);
        }
        if (this.terminate) {
            return;
        }
        if (this.effectsProcessor != null) {
            this.effectsProcessor.postDraw(gLDrawable, this.userData);
        }
        if (this.terminate) {
            return;
        }
        if (this.currentViewpoint != null) {
            this.currentViewpoint.postRender(gL, gLU);
        }
        if (this.terminate) {
            return;
        }
        gL.glFlush();
    }
}

