/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.surface;

import java.util.HashMap;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLCanvas;
import net.java.games.jogl.GLCapabilities;
import net.java.games.jogl.GLDrawable;
import net.java.games.jogl.GLDrawableFactory;
import net.java.games.jogl.GLEventListener;
import net.java.games.jogl.GLPbuffer;
import org.j3d.aviatrix3d.DeletableSceneGraphObject;
import org.j3d.aviatrix3d.DrawableSurface;
import org.j3d.aviatrix3d.PBufferTextureSource;
import org.j3d.aviatrix3d.RenderInstructions;
import org.j3d.aviatrix3d.ShaderSceneGraphObject;
import org.j3d.aviatrix3d.surface.QuadBufferStereoRenderer;
import org.j3d.aviatrix3d.surface.Renderer;
import org.j3d.aviatrix3d.surface.RenderingProcessor;
import org.j3d.aviatrix3d.surface.SingleEyeStereoRenderer;
import org.j3d.aviatrix3d.surface.StereoRenderer;

public class StereoAWTSurface
implements DrawableSurface,
GLEventListener {
    private static final int LIST_START_SIZE = 20;
    private GLCanvas canvas;
    private Renderer canvasRenderer;
    private GLPbuffer[] renderableList;
    private int numRenderables;
    private boolean initComplete;
    private String[] extensionList;
    private int numExtensions;
    private HashMap rendererMap;
    private HashMap glDrawableMap;
    private float[] colourTmp;
    private int stereoRenderType;
    private boolean quadBuffersAvailable;
    private float eyeSeparation;
    private GLCapabilities requestedCapabilities;
    private boolean renderLeftFrame;

    public StereoAWTSurface(GLCapabilities gLCapabilities) {
        this.requestedCapabilities = gLCapabilities;
        this.renderLeftFrame = true;
        this.stereoRenderType = 0;
        this.quadBuffersAvailable = false;
        this.eyeSeparation = 0.001f;
        this.colourTmp = new float[4];
        this.canvasRenderer = new RenderingProcessor();
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory();
        this.canvas = gLDrawableFactory.createGLCanvas(gLCapabilities);
        this.canvas.setAutoSwapBufferMode(false);
        this.canvas.setNoAutoRedrawMode(true);
        GLEventListener gLEventListener = (GLEventListener)this.canvasRenderer;
        this.canvas.addGLEventListener(gLEventListener);
        this.canvas.addGLEventListener((GLEventListener)this);
        this.initComplete = false;
        this.renderableList = new GLPbuffer[20];
        this.numRenderables = 0;
        this.numExtensions = 0;
        this.rendererMap = new HashMap();
        this.glDrawableMap = new HashMap();
    }

    public boolean isStereoAvailable() {
        return true;
    }

    public boolean isQuadStereoAvailable() {
        return this.quadBuffersAvailable;
    }

    public void setStereoEyeSeparation(float f) {
        float f2 = this.eyeSeparation = f < 0.0f ? -f : f;
        if (this.canvasRenderer instanceof StereoRenderer) {
            StereoRenderer stereoRenderer = (StereoRenderer)this.canvasRenderer;
            stereoRenderer.setStereoEyeSeparation(f);
        }
    }

    public float getStereoEyeSeparation() {
        return this.eyeSeparation;
    }

    public void setStereoRenderingPolicy(int n) {
        Object object;
        switch (n) {
            case 0: {
                this.canvasRenderer = new RenderingProcessor();
                break;
            }
            case 1: {
                this.canvasRenderer = new QuadBufferStereoRenderer();
                object = (StereoRenderer)this.canvasRenderer;
                object.setStereoEyeSeparation(this.eyeSeparation);
                break;
            }
            case 2: {
                this.canvasRenderer = new SingleEyeStereoRenderer();
                object = (StereoRenderer)this.canvasRenderer;
                object.setStereoEyeSeparation(this.eyeSeparation);
                break;
            }
            case 3: {
                System.out.println("Dual canvas stereo is not implemented yet");
                return;
            }
            default: {
                throw new IllegalArgumentException("Unknown stereo policy");
            }
        }
        object = GLDrawableFactory.getFactory();
        this.canvas = object.createGLCanvas(this.requestedCapabilities);
        this.canvas.setAutoSwapBufferMode(false);
        GLEventListener gLEventListener = (GLEventListener)this.canvasRenderer;
        this.canvas.addGLEventListener(gLEventListener);
        this.canvas.addGLEventListener((GLEventListener)this);
        this.stereoRenderType = n;
    }

    public int getStereoRenderingPolicy() {
        return this.stereoRenderType;
    }

    public void queueDeletedObject(DeletableSceneGraphObject deletableSceneGraphObject) {
        this.canvasRenderer.queueDeletedObject(deletableSceneGraphObject);
        int n = this.numRenderables;
        GLPbuffer[] gLPbufferArray = this.renderableList;
        if (n > 1) {
            for (int i = 0; i < n; ++i) {
                if (gLPbufferArray[i] == null) continue;
                RenderingProcessor renderingProcessor = (RenderingProcessor)this.rendererMap.get(gLPbufferArray[i]);
                renderingProcessor.queueDeletedObject(deletableSceneGraphObject);
            }
        }
    }

    public void queueShaderRequests(ShaderSceneGraphObject[] shaderSceneGraphObjectArray, int n, ShaderSceneGraphObject[] shaderSceneGraphObjectArray2, int n2) {
        this.canvasRenderer.queueShaderRequests(shaderSceneGraphObjectArray, n, shaderSceneGraphObjectArray2, n2);
        int n3 = this.numRenderables;
        GLPbuffer[] gLPbufferArray = this.renderableList;
        if (n3 > 1) {
            for (int i = 0; i < n3; ++i) {
                if (gLPbufferArray[i] == null) continue;
                RenderingProcessor renderingProcessor = (RenderingProcessor)this.rendererMap.get(gLPbufferArray[i]);
                renderingProcessor.queueShaderRequests(shaderSceneGraphObjectArray, n, shaderSceneGraphObjectArray2, n2);
            }
        }
    }

    public void setClearColor(float f, float f2, float f3, float f4) {
        this.canvasRenderer.setClearColor(f, f2, f3, f4);
    }

    public void setDrawableObjects(RenderInstructions[] renderInstructionsArray, int n) {
        int n2;
        if (this.renderableList.length < n) {
            this.renderableList = new GLPbuffer[n];
        } else {
            for (n2 = n; n2 < this.renderableList.length; ++n2) {
                this.renderableList[n2] = null;
            }
        }
        n2 = this.numRenderables = n;
        while (--n2 >= 0) {
            RenderInstructions renderInstructions = renderInstructionsArray[n2];
            if (renderInstructions.pbuffer != null) {
                PBufferTextureSource pBufferTextureSource = renderInstructions.pbuffer;
                GLPbuffer gLPbuffer = (GLPbuffer)this.glDrawableMap.get(pBufferTextureSource);
                RenderingProcessor renderingProcessor = null;
                if (gLPbuffer == null) {
                    Object object = renderInstructions.parentSource == null ? this.canvas : (GLDrawable)this.glDrawableMap.get(renderInstructions.parentSource);
                    if (!object.canCreateOffscreenDrawable()) continue;
                    GLCapabilities gLCapabilities = pBufferTextureSource.getGLSetup();
                    int n3 = pBufferTextureSource.getWidth();
                    int n4 = pBufferTextureSource.getHeight();
                    renderingProcessor = new RenderingProcessor();
                    gLPbuffer = object.createOffscreenDrawable(gLCapabilities, n3, n4);
                    gLPbuffer.addGLEventListener((GLEventListener)renderingProcessor);
                    pBufferTextureSource.registerBuffer(object.getGL(), gLPbuffer);
                    this.rendererMap.put(gLPbuffer, renderingProcessor);
                    this.glDrawableMap.put(pBufferTextureSource, gLPbuffer);
                } else {
                    renderingProcessor = (RenderingProcessor)this.rendererMap.get(gLPbuffer);
                }
                this.renderableList[n2] = gLPbuffer;
                if (renderInstructions.copyOf != null) {
                    renderInstructions = renderInstructions.copyOf;
                }
                pBufferTextureSource.getClearColor(this.colourTmp);
                renderingProcessor.setClearColor(this.colourTmp[0], this.colourTmp[1], this.colourTmp[2], this.colourTmp[3]);
                renderingProcessor.setEnvironmentData(renderInstructions.renderData);
                renderingProcessor.setDrawableObjects(renderInstructions.renderList, renderInstructions.renderOps, renderInstructions.numValid);
                continue;
            }
            this.canvasRenderer.setEnvironmentData(renderInstructions.renderData);
            this.canvasRenderer.setDrawableObjects(renderInstructions.renderList, renderInstructions.renderOps, renderInstructions.numValid);
            this.renderableList[n2] = null;
        }
    }

    public void draw() {
        if (!this.initComplete) {
            return;
        }
        int n = this.numRenderables;
        GLPbuffer[] gLPbufferArray = this.renderableList;
        if (n > 1) {
            for (int i = 0; i < n; ++i) {
                if (gLPbufferArray[i] == null) continue;
                gLPbufferArray[i].display();
            }
        }
        switch (this.stereoRenderType) {
            case 2: {
                SingleEyeStereoRenderer singleEyeStereoRenderer = (SingleEyeStereoRenderer)this.canvasRenderer;
                singleEyeStereoRenderer.setEyeToRender(this.renderLeftFrame);
                this.canvas.display();
                this.renderLeftFrame = !this.renderLeftFrame;
                break;
            }
            default: {
                this.canvas.display();
            }
        }
    }

    public void swap() {
        this.canvas.swapBuffers();
    }

    public Object getSurfaceObject() {
        return this.canvas;
    }

    public void getSurfaceToVWorld(Matrix4f matrix4f) {
        this.canvasRenderer.getSurfaceToVWorld(matrix4f);
    }

    public void getPixelLocationInSurface(float f, float f2, Point3f point3f) {
        this.canvasRenderer.getPixelLocationInSurface(f, f2, point3f);
    }

    public void getCenterEyeInSurface(Point3f point3f) {
        this.canvasRenderer.getCenterEyeInSurface(point3f);
    }

    public void dispose() {
        this.canvasRenderer.halt();
        for (int i = 1; i < this.numRenderables; ++i) {
            RenderingProcessor renderingProcessor = (RenderingProcessor)this.rendererMap.get(this.renderableList[i]);
            renderingProcessor.halt();
        }
        GLEventListener gLEventListener = (GLEventListener)this.canvasRenderer;
        this.canvas.removeGLEventListener(gLEventListener);
    }

    public void setRenderControlThread(Thread thread) {
        if (this.canvas.getRenderingThread() == thread) {
            return;
        }
        this.canvas.setRenderingThread(thread);
    }

    public void init(GLDrawable gLDrawable) {
        int n;
        GL gL = gLDrawable.getGL();
        for (n = 0; n < this.numExtensions; ++n) {
            if (gL.isExtensionAvailable(this.extensionList[n])) continue;
            System.out.println("Extension " + this.extensionList[n] + " not available");
        }
        for (n = 0; n < this.numRenderables; ++n) {
            if (this.renderableList[n] == null) continue;
            this.renderableList[n].display();
        }
        byte[] byArray = new byte[1];
        gL.glGetBooleanv(3123, byArray);
        this.quadBuffersAvailable = byArray[0] == 1;
        this.canvas.removeGLEventListener((GLEventListener)this);
        this.initComplete = true;
    }

    public void reshape(GLDrawable gLDrawable, int n, int n2, int n3, int n4) {
    }

    public void displayChanged(GLDrawable gLDrawable, boolean bl, boolean bl2) {
    }

    public void display(GLDrawable gLDrawable) {
    }

    public void resychronizeRenderTarget() {
    }

    public void checkForExtension(String string) {
        if (this.extensionList == null || this.extensionList.length == this.numExtensions) {
            String[] stringArray = new String[this.numExtensions + 5];
            if (this.extensionList != null) {
                System.arraycopy(this.extensionList, 0, stringArray, 0, this.numExtensions);
            }
            this.extensionList = stringArray;
        }
        this.extensionList[this.numExtensions++] = string;
    }
}

