/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.geom;

import org.j3d.aviatrix3d.Appearance;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.TriangleStripArray;
import org.j3d.aviatrix3d.VertexGeometry;
import org.j3d.geom.BoxGenerator;
import org.j3d.geom.GeometryData;

public class Box
extends Shape3D
implements NodeUpdateListener {
    private static final float DEFAULT_SIZE = 2.0f;
    private BoxGenerator generator;
    private GeometryData data = new GeometryData();

    public Box() {
        this(2.0f, 2.0f, 2.0f, null);
    }

    public Box(Appearance appearance) {
        this(2.0f, 2.0f, 2.0f, appearance);
    }

    public Box(float f, float f2, float f3) {
        this(f, f2, f3, null);
    }

    public Box(float f, float f2, float f3, Appearance appearance) {
        this.data.geometryType = 3;
        this.data.geometryComponents = 2;
        this.generator = new BoxGenerator(f, f2, f3);
        this.generator.generate(this.data);
        TriangleStripArray triangleStripArray = new TriangleStripArray();
        triangleStripArray.setVertices(3, this.data.coordinates, this.data.vertexCount);
        triangleStripArray.setStripCount(this.data.stripCounts, this.data.numStrips);
        triangleStripArray.setNormals(this.data.normals);
        triangleStripArray.setUserData(this.data);
        this.setAppearance(appearance);
        this.setGeometry(triangleStripArray);
    }

    public void updateNodeBoundsChanges(Object object) {
        VertexGeometry vertexGeometry = (VertexGeometry)object;
        vertexGeometry.setVertices(3, this.data.coordinates, this.data.vertexCount);
    }

    public void updateNodeDataChanges(Object object) {
    }

    public void setDimensions(float f, float f2, float f3) {
        this.generator.setDimensions(f, f2, f3);
        this.generator.generate(this.data);
        VertexGeometry vertexGeometry = (VertexGeometry)this.getGeometry();
        vertexGeometry.boundsChanged(this);
    }
}

