/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.geom.hanim;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.geom.hanim.HAnimHumanoid;
import org.j3d.geom.hanim.HAnimObject;
import org.j3d.renderer.aviatrix3d.geom.hanim.AVHumanoidPart;

public abstract class AVHumanoid
extends HAnimHumanoid
implements NodeUpdateListener {
    private static final String NODE_CHILD_ERR = "Viewpoint must extend the Aviatrix3D Node base class";
    private static final String PART_CHILD_ERR = "Skeleton object must implement the AVHumanoidPart interface";
    private TransformGroup rootTransform;
    private Group skeletonGroup = new Group();
    private Group viewpointGroup = new Group();
    private boolean boundsChanged;
    private BoundingBox bounds;

    AVHumanoid() {
        this.rootTransform = new TransformGroup();
        this.rootTransform.addChild(this.skeletonGroup);
        this.rootTransform.addChild(this.viewpointGroup);
        this.boundsChanged = false;
    }

    public void updateNodeBoundsChanges(Object object) {
        block6: {
            block5: {
                if (object != this.rootTransform) break block5;
                this.rootTransform.setTransform(this.localMatrix);
                if (!this.boundsChanged) break block6;
                this.boundsChanged = false;
                this.rootTransform.setBounds(this.bounds);
                break block6;
            }
            if (object == this.skeletonGroup) {
                this.skeletonGroup.removeAllChildren();
                for (int i = 0; i < this.numSkeleton; ++i) {
                    Node node = ((AVHumanoidPart)this.skeleton[i]).getSceneGraphObject();
                    this.skeletonGroup.addChild(node);
                }
            } else if (object == this.viewpointGroup) {
                this.viewpointGroup.removeAllChildren();
                for (int i = 0; i < this.numViewpoints; ++i) {
                    this.viewpointGroup.addChild((Node)this.viewpoints[i]);
                }
            }
        }
    }

    public void updateNodeDataChanges(Object object) {
    }

    public void setBboxCenter(float[] fArray) {
        super.setBboxCenter(fArray);
        if (this.bboxSize[0] == -1.0f && this.bboxSize[1] == -1.0f && this.bboxSize[2] == 0.0f) {
            return;
        }
        if (this.bounds == null) {
            this.bounds = new BoundingBox();
        }
        float f = this.bboxCenter[0] - this.bboxSize[0];
        float f2 = this.bboxCenter[1] - this.bboxSize[1];
        float f3 = this.bboxCenter[2] - this.bboxSize[2];
        this.bounds.setMinimum(f, f2, f3);
        f = this.bboxCenter[0] + this.bboxSize[0];
        f2 = this.bboxCenter[1] + this.bboxSize[1];
        f3 = this.bboxCenter[2] + this.bboxSize[2];
        this.bounds.setMaximum(f, f2, f3);
        if (this.rootTransform.isLive()) {
            this.boundsChanged = true;
            this.rootTransform.boundsChanged(this);
        } else {
            this.rootTransform.setBounds(this.bounds);
        }
    }

    public void setBboxSize(float[] fArray) {
        super.setBboxSize(fArray);
        if (fArray[0] == -1.0f && fArray[1] == -1.0f && fArray[2] == 0.0f) {
            this.bounds = null;
        } else if (this.bounds == null) {
            this.bounds = new BoundingBox();
            float f = this.bboxCenter[0] - this.bboxSize[0];
            float f2 = this.bboxCenter[1] - this.bboxSize[1];
            float f3 = this.bboxCenter[2] - this.bboxSize[2];
            this.bounds.setMinimum(f, f2, f3);
            f = this.bboxCenter[0] + this.bboxSize[0];
            f2 = this.bboxCenter[1] + this.bboxSize[1];
            f3 = this.bboxCenter[2] + this.bboxSize[2];
            this.bounds.setMaximum(f, f2, f3);
        }
        if (this.rootTransform.isLive()) {
            this.boundsChanged = true;
            this.rootTransform.boundsChanged(this);
        } else {
            this.rootTransform.setBounds(this.bounds);
        }
    }

    public void setViewpoints(Object[] objectArray, int n) {
        if (this.viewpointGroup.isLive()) {
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] instanceof Node) continue;
                throw new IllegalArgumentException(NODE_CHILD_ERR);
            }
            this.viewpointGroup.boundsChanged(this);
        } else {
            this.viewpointGroup.removeAllChildren();
            for (int i = 0; i < n; ++i) {
                if (!(objectArray[i] instanceof Node)) {
                    throw new IllegalArgumentException(NODE_CHILD_ERR);
                }
                this.viewpointGroup.addChild((Node)objectArray[i]);
            }
        }
        super.setViewpoints(objectArray, n);
    }

    public void setSkeleton(HAnimObject[] hAnimObjectArray, int n) {
        if (this.skeletonGroup.isLive()) {
            for (int i = 0; i < n; ++i) {
                if (hAnimObjectArray[i] instanceof AVHumanoidPart) continue;
                throw new IllegalArgumentException(PART_CHILD_ERR);
            }
            this.skeletonGroup.boundsChanged(this);
        } else {
            this.skeletonGroup.removeAllChildren();
            for (int i = 0; i < n; ++i) {
                if (!(hAnimObjectArray[i] instanceof AVHumanoidPart)) {
                    throw new IllegalArgumentException(PART_CHILD_ERR);
                }
                Node node = ((AVHumanoidPart)hAnimObjectArray[i]).getSceneGraphObject();
                this.skeletonGroup.addChild(node);
            }
        }
        super.setSkeleton(hAnimObjectArray, n);
    }

    public void updateSkeleton() {
        if (this.matrixChanged) {
            if (this.rootTransform.isLive()) {
                this.rootTransform.boundsChanged(this);
            } else {
                this.updateNodeBoundsChanges(this.rootTransform);
            }
        }
        super.updateSkeleton();
    }

    public Node getSceneGraphObject() {
        return this.rootTransform;
    }

    public abstract void setSkin(Node[] var1, int var2);

    void addNode(Node node) {
        this.rootTransform.addChild(node);
    }

    protected FloatBuffer createBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        return floatBuffer;
    }
}

