/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.geom.hanim;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.Shader;
import org.j3d.aviatrix3d.ShaderArguments;
import org.j3d.aviatrix3d.ShaderObject;
import org.j3d.renderer.aviatrix3d.geom.hanim.HAnimShaderProgram;
import org.j3d.util.DefaultErrorReporter;
import org.j3d.util.ErrorReporter;
import org.j3d.util.IntHashMap;

class HAnimShader
extends Shader
implements Comparable {
    protected static final int WEIGHT_ATTRIB_INDEX = 6;
    protected static final int MATRIX_ATTRIB_INDEX = 7;
    private static final String CORE_SHADER_FILE = "org/j3d/renderer/aviatrix3d/geom/hanim/mesh_skin.vert";
    private static final String LIGHTING_SHADER_FILE = "standard/lighting.vert";
    private static final String FOG_SHADER_FILE = "standard/fog.frag";
    private static final String FOG_COORD_SHADER_FILE = "standard/fog.vert";
    private static final String TEXTURE_SHADER_FILE = "standard/texture.frag";
    private IntHashMap idMap = new IntHashMap();
    private ShaderArguments arguments = new ShaderArguments();
    private static HAnimShaderProgram program;
    private boolean shaderLogRecieved = false;
    private ErrorReporter errorReporter;
    private int[] lightState = new int[8];
    private int[] lightEnabled = new int[1];
    private int[] fogType = new int[1];
    private int[] maxTextures = new int[1];
    static /* synthetic */ Class class$org$j3d$renderer$aviatrix3d$geom$hanim$ShaderHumanoid;

    HAnimShader() {
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        if (program != null) {
            program.setUpdateHandler(this.updateHandler);
        }
    }

    protected void setLive(boolean bl) {
        if (bl) {
            ++this.liveCount;
        } else if (this.liveCount > 0) {
            --this.liveCount;
        }
        if (this.liveCount == 0 || !this.alive) {
            if (program != null) {
                program.setLive(bl);
            }
            super.setLive(bl);
        }
    }

    public void render(GL gL, GLU gLU) {
        if (program == null || !program.isValid(gL)) {
            return;
        }
        program.render(gL, gLU);
        int n = program.getProgramId(gL);
        Integer n2 = (Integer)this.idMap.get(n);
        if (n2 == null) {
            n2 = new Integer(n);
            this.idMap.put(n, (Object)n2);
        }
        this.lightState[0] = gL.glIsEnabled(16384) ? 1 : 0;
        this.lightState[1] = gL.glIsEnabled(16385) ? 1 : 0;
        this.lightState[2] = gL.glIsEnabled(16386) ? 1 : 0;
        this.lightState[3] = gL.glIsEnabled(16387) ? 1 : 0;
        this.lightState[4] = gL.glIsEnabled(16388) ? 1 : 0;
        this.lightState[5] = gL.glIsEnabled(16389) ? 1 : 0;
        this.lightState[6] = gL.glIsEnabled(16390) ? 1 : 0;
        this.lightState[7] = gL.glIsEnabled(16391) ? 1 : 0;
        this.lightEnabled[0] = this.lightState[0] + this.lightState[1] + this.lightState[2] + this.lightState[3] + this.lightState[4] + this.lightState[5] + this.lightState[6] + this.lightState[7];
        this.arguments.setUniform("lightingEnabled", 1, this.lightEnabled, 1);
        this.arguments.setUniform("enabledLights", 1, this.lightState, 8);
        if (gL.glIsEnabled(2912)) {
            gL.glGetIntegerv(33872, this.fogType);
            switch (this.fogType[0]) {
                case 33873: {
                    this.fogType[0] = 1;
                    break;
                }
                case 33874: {
                    this.fogType[0] = 2;
                }
            }
        } else {
            this.fogType[0] = 0;
        }
        this.arguments.setUniform("fogSourceType", 1, this.fogType, 1);
        this.arguments.render(gL, gLU, n2);
        if (!this.shaderLogRecieved) {
            String string;
            int n3 = program.getNumShaderObjects();
            ShaderObject[] shaderObjectArray = new ShaderObject[n3];
            program.getShaderObjects(shaderObjectArray);
            for (int i = 0; i < n3; ++i) {
                string = shaderObjectArray[i].getLastInfoLog();
                if (string == null || string.length() == 0) continue;
                this.errorReporter.messageReport("HAnim compile msg (" + i + "): " + string);
            }
            string = program.getLastInfoLog();
            if (string != null && string.length() != 0) {
                this.errorReporter.messageReport("HAnim Link msg: " + string);
            }
            this.shaderLogRecieved = true;
        }
    }

    public void postRender(GL gL, GLU gLU) {
        if (program == null || !program.isValid(gL)) {
            return;
        }
        program.postRender(gL, gLU);
    }

    public int compareTo(Object object) throws ClassCastException {
        HAnimShader hAnimShader = (HAnimShader)object;
        return this.compareTo(hAnimShader);
    }

    public boolean equals(Object object) {
        if (!(object instanceof HAnimShader)) {
            return false;
        }
        return this.equals((HAnimShader)object);
    }

    ShaderArguments getShaderArguments() {
        return this.arguments;
    }

    void setMaxTextureUnits(int n) {
        this.maxTextures[0] = n;
        this.arguments.setUniform("numTextures", 1, this.maxTextures, 1);
    }

    void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    int compareTo(HAnimShader hAnimShader) {
        int n;
        if (hAnimShader == null) {
            return 1;
        }
        if (hAnimShader == this) {
            return 0;
        }
        if (this.arguments != hAnimShader.arguments && (n = this.arguments.compareTo(hAnimShader.arguments)) != 0) {
            return n;
        }
        return 0;
    }

    boolean equals(HAnimShader hAnimShader) {
        if (hAnimShader == this) {
            return true;
        }
        if (hAnimShader == null) {
            return false;
        }
        return this.arguments != null && this.arguments.equals(hAnimShader.arguments);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        InputStream[] inputStreamArray = (InputStream[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                InputStream[] inputStreamArray = new InputStream[]{ClassLoader.getSystemResourceAsStream(HAnimShader.CORE_SHADER_FILE), ClassLoader.getSystemResourceAsStream(HAnimShader.LIGHTING_SHADER_FILE), ClassLoader.getSystemResourceAsStream(HAnimShader.FOG_COORD_SHADER_FILE)};
                return inputStreamArray;
            }
        });
        if (inputStreamArray[0] == null) {
            ClassLoader classLoader = (class$org$j3d$renderer$aviatrix3d$geom$hanim$ShaderHumanoid == null ? (class$org$j3d$renderer$aviatrix3d$geom$hanim$ShaderHumanoid = HAnimShader.class$("org.j3d.renderer.aviatrix3d.geom.hanim.ShaderHumanoid")) : class$org$j3d$renderer$aviatrix3d$geom$hanim$ShaderHumanoid).getClassLoader();
            inputStreamArray[0] = classLoader.getResourceAsStream(CORE_SHADER_FILE);
            inputStreamArray[1] = classLoader.getResourceAsStream(LIGHTING_SHADER_FILE);
            inputStreamArray[2] = classLoader.getResourceAsStream(FOG_COORD_SHADER_FILE);
        }
        if (inputStreamArray[0] == null) {
            throw new RuntimeException("Unable to locate skinning shader");
        }
        program = new HAnimShaderProgram();
        for (int i = 0; i < inputStreamArray.length; ++i) {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStreamArray[i]);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuffer stringBuffer = new StringBuffer(2048);
            char[] cArray = new char[1024];
            try {
                int n;
                while ((n = bufferedReader.read(cArray, 0, 1024)) != -1) {
                    stringBuffer.append(cArray, 0, n);
                }
            }
            catch (IOException iOException) {
                System.out.println("Error reading shader file");
                iOException.printStackTrace();
            }
            String[] stringArray = new String[]{stringBuffer.toString()};
            ShaderObject shaderObject = new ShaderObject(true);
            shaderObject.setSourceStrings(stringArray, 1);
            shaderObject.compile();
            shaderObject.requestInfoLog();
            program.addShaderObject(shaderObject);
        }
        program.bindAttributeName("weight", 6);
        program.bindAttributeName("matrixIndex", 7);
        program.link();
        program.requestLinkConfirmation(true);
        program.requestInfoLog();
    }
}

