/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.geom.hanim;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.VertexGeometry;
import org.j3d.geom.hanim.HAnimObject;
import org.j3d.renderer.aviatrix3d.geom.hanim.AVHumanoid;
import org.j3d.renderer.aviatrix3d.geom.hanim.SoftwareJoint;
import org.j3d.renderer.aviatrix3d.nodes.BufferGeometry;

public abstract class SoftwareHumanoid
extends AVHumanoid
implements NodeUpdateListener {
    protected Group skinGroup;
    protected ArrayList bufferGeometry = new ArrayList();
    protected ArrayList vertexGeometry = new ArrayList();
    protected Node[] skin;
    protected int numSkin;
    protected float[] coordsArray;
    protected float[] normalsArray;
    protected FloatBuffer coordsBuffer;
    protected FloatBuffer normalsBuffer;
    protected boolean[] dirtyCoordinates;

    SoftwareHumanoid() {
        this.skinGroup = new Group();
        this.addNode(this.skinGroup);
    }

    public void updateNodeBoundsChanges(Object object) {
        if (object == this.skinGroup) {
            this.skinGroup.removeAllChildren();
            for (int i = 0; i < this.numSkin; ++i) {
                this.skinGroup.addChild(this.skin[i]);
            }
        } else if (object instanceof BufferGeometry) {
            ((BufferGeometry)object).setVertices(3, this.coordsBuffer);
        } else if (object instanceof VertexGeometry) {
            ((VertexGeometry)object).setVertices(3, this.coordsArray);
        } else {
            super.updateNodeBoundsChanges(object);
        }
    }

    public void updateNodeDataChanges(Object object) {
        if (object instanceof BufferGeometry) {
            ((BufferGeometry)object).setNormals(this.normalsBuffer);
        } else if (object instanceof VertexGeometry) {
            ((VertexGeometry)object).setNormals(this.normalsArray);
        } else {
            super.updateNodeDataChanges(object);
        }
    }

    public void setSkinCoord(float[] fArray, int n) {
        super.setSkinCoord(fArray, n);
        if (this.coordsBuffer == null || this.coordsBuffer.capacity() < n * 3) {
            this.coordsBuffer = this.createBuffer(n * 3);
        }
        this.coordsBuffer.rewind();
        this.coordsBuffer.put(fArray, 0, n * 3);
        if (this.dirtyCoordinates == null || this.dirtyCoordinates.length < n) {
            this.dirtyCoordinates = new boolean[n];
            if (this.rootJoint != null) {
                ((SoftwareJoint)this.rootJoint).setDirtyList(this.dirtyCoordinates);
            }
        }
        for (int i = 0; i < n; ++i) {
            this.dirtyCoordinates[i] = true;
        }
    }

    public void setSkinNormal(float[] fArray, int n) {
        super.setSkinNormal(fArray, n);
        if (this.normalsBuffer == null || this.normalsBuffer.capacity() < n * 3) {
            this.normalsBuffer = this.createBuffer(n * 3);
        }
        this.normalsBuffer.rewind();
        this.normalsBuffer.put(fArray, 0, n * 3);
    }

    public void setSkeleton(HAnimObject[] hAnimObjectArray, int n) {
        super.setSkeleton(hAnimObjectArray, n);
        if (this.rootJoint != null && this.dirtyCoordinates != null) {
            ((SoftwareJoint)this.rootJoint).setDirtyList(this.dirtyCoordinates);
        }
    }

    public void updateSkeleton() {
        int n;
        boolean bl = this.skeletonChanged;
        super.updateSkeleton();
        int n2 = this.numSkinCoords / 3;
        for (n = 0; n < n2; ++n) {
            this.dirtyCoordinates[n] = false;
        }
        if (bl) {
            Geometry geometry;
            if (this.numSkinCoords != 0) {
                n2 = this.bufferGeometry.size();
                for (n = 0; n < n2; ++n) {
                    geometry = (Geometry)this.bufferGeometry.get(n);
                    geometry.boundsChanged(this);
                }
                n2 = this.vertexGeometry.size();
                for (n = 0; n < n2; ++n) {
                    geometry = (Geometry)this.vertexGeometry.get(n);
                    geometry.boundsChanged(this);
                }
            }
            if (this.numSkinNormals != 0) {
                n2 = this.bufferGeometry.size();
                for (n = 0; n < n2; ++n) {
                    geometry = (Geometry)this.bufferGeometry.get(n);
                    geometry.dataChanged(this);
                }
                n2 = this.vertexGeometry.size();
                for (n = 0; n < n2; ++n) {
                    geometry = (Geometry)this.vertexGeometry.get(n);
                    geometry.dataChanged(this);
                }
            }
        }
    }

    public void setSkin(Node[] nodeArray, int n) {
        int n2;
        this.bufferGeometry.clear();
        this.vertexGeometry.clear();
        for (n2 = 0; n2 < n; ++n2) {
            if (nodeArray[n2] instanceof Shape3D) {
                Geometry geometry = ((Shape3D)nodeArray[n2]).getGeometry();
                if (geometry instanceof BufferGeometry) {
                    this.bufferGeometry.add(geometry);
                    continue;
                }
                if (!(geometry instanceof VertexGeometry)) continue;
                this.vertexGeometry.add(geometry);
                continue;
            }
            if (!(nodeArray[n2] instanceof Group)) continue;
            this.descendGroup((Group)nodeArray[n2]);
        }
        if (this.skinGroup.isLive()) {
            this.skinGroup.boundsChanged(this);
        } else {
            for (n2 = 0; n2 < n; ++n2) {
                this.skinGroup.addChild(nodeArray[n2]);
            }
        }
    }

    public abstract Object getUpdatedSkinCoords();

    public abstract Object getUpdatedSkinNormals();

    private void descendGroup(Group group) {
        int n = group.numChildren();
        for (int i = 0; i < n; ++i) {
            Node node = group.getChild(i);
            if (node instanceof Shape3D) {
                Geometry geometry = ((Shape3D)node).getGeometry();
                if (geometry instanceof BufferGeometry) {
                    this.bufferGeometry.add(geometry);
                    continue;
                }
                if (!(geometry instanceof VertexGeometry)) continue;
                this.vertexGeometry.add(geometry);
                continue;
            }
            if (!(node instanceof Group)) continue;
            this.descendGroup((Group)node);
        }
    }
}

