/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.geom.hanim;

import org.j3d.renderer.aviatrix3d.geom.hanim.SoftwareHumanoid;

class SoftwareSpeedHumanoid
extends SoftwareHumanoid {
    SoftwareSpeedHumanoid() {
    }

    public void setSkinCoord(float[] fArray, int n) {
        super.setSkinCoord(fArray, n);
        if (this.coordsArray == null || this.coordsArray.length < n * 3) {
            this.coordsArray = new float[n * 3];
        }
        this.outputCoords = this.coordsArray;
    }

    public void setSkinNormal(float[] fArray, int n) {
        super.setSkinNormal(fArray, n);
        if (this.normalsArray == null || this.normalsArray.length < n * 3) {
            this.normalsArray = new float[n * 3];
        }
        this.outputNormals = this.normalsArray;
    }

    public void updateSkeleton() {
        if (this.outputCoords == null) {
            return;
        }
        boolean bl = this.skeletonChanged;
        if (bl) {
            int n;
            int n2;
            if (this.numSkinCoords != 0) {
                n2 = this.numSkinCoords / 3;
                for (n = 0; n < n2; ++n) {
                    if (!this.dirtyCoordinates[n]) continue;
                    this.coordsArray[n * 3] = 0.0f;
                    this.coordsArray[n * 3 + 1] = 0.0f;
                    this.coordsArray[n * 3 + 2] = 0.0f;
                }
            }
            if (this.numSkinNormals != 0) {
                n2 = this.numSkinNormals / 3;
                for (n = 0; n < n2; ++n) {
                    if (!this.dirtyCoordinates[n]) continue;
                    this.normalsArray[n * 3] = 0.0f;
                    this.normalsArray[n * 3 + 1] = 0.0f;
                    this.normalsArray[n * 3 + 2] = 0.0f;
                }
            }
        }
        super.updateSkeleton();
        if (bl) {
            if (this.numSkinCoords != 0 && this.bufferGeometry.size() != 0) {
                this.coordsBuffer.rewind();
                this.coordsBuffer.put(this.coordsArray, 0, this.numSkinCoords);
            }
            if (this.numSkinNormals != 0 && this.bufferGeometry.size() != 0) {
                this.normalsBuffer.rewind();
                this.normalsBuffer.put(this.normalsArray, 0, this.numSkinNormals);
            }
        }
    }

    public Object getUpdatedSkinCoords() {
        return this.coordsArray;
    }

    public Object getUpdatedSkinNormals() {
        return this.normalsArray;
    }
}

