/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.geom.hanim;

import javax.vecmath.Matrix4f;
import org.j3d.geom.hanim.HAnimObject;
import org.j3d.renderer.aviatrix3d.geom.hanim.SoftwareJoint;

class SoftwareSpeedJoint
extends SoftwareJoint {
    private static final String WRONG_TYPE_MSG = "Conflicting joint optimisation types";

    SoftwareSpeedJoint() {
    }

    public void setChildren(HAnimObject[] hAnimObjectArray, int n) {
        for (int i = 0; i < this.numChildren; ++i) {
            if (hAnimObjectArray[i] instanceof SoftwareSpeedJoint) continue;
            throw new IllegalArgumentException(WRONG_TYPE_MSG);
        }
        super.setChildren(hAnimObjectArray, n);
    }

    public void addChild(HAnimObject hAnimObject) {
        if (!(hAnimObject instanceof SoftwareSpeedJoint)) {
            throw new IllegalArgumentException(WRONG_TYPE_MSG);
        }
        super.addChild(hAnimObject);
    }

    protected void updateSkeleton(Matrix4f matrix4f, boolean bl) {
        super.updateSkeleton(matrix4f, bl);
        if (this.outputCoords == null) {
            return;
        }
        if (this.numSourceNormals == 0) {
            float[] fArray = (float[])this.outputCoords;
            for (int i = 0; i < this.numSkinCoord; ++i) {
                int n = this.skinCoordIndex[i];
                if (!this.dirtyCoordinates[n]) continue;
                float f = this.sourceCoords[n * 3];
                float f2 = this.sourceCoords[n * 3 + 1];
                float f3 = this.sourceCoords[n * 3 + 2];
                float f4 = this.globalMatrix.m00 * f + this.globalMatrix.m01 * f2 + this.globalMatrix.m02 * f3 + this.globalMatrix.m03;
                float f5 = this.globalMatrix.m10 * f + this.globalMatrix.m11 * f2 + this.globalMatrix.m12 * f3 + this.globalMatrix.m13;
                float f6 = this.globalMatrix.m20 * f + this.globalMatrix.m21 * f2 + this.globalMatrix.m22 * f3 + this.globalMatrix.m23;
                int n2 = n * 3;
                fArray[n2] = fArray[n2] + f4 * this.skinCoordWeight[i];
                int n3 = n * 3 + 1;
                fArray[n3] = fArray[n3] + f5 * this.skinCoordWeight[i];
                int n4 = n * 3 + 2;
                fArray[n4] = fArray[n4] + f6 * this.skinCoordWeight[i];
            }
        } else {
            float[] fArray = (float[])this.outputCoords;
            float[] fArray2 = (float[])this.outputNormals;
            for (int i = 0; i < this.numSkinCoord; ++i) {
                int n = this.skinCoordIndex[i];
                if (!this.dirtyCoordinates[n]) continue;
                float f = this.sourceCoords[n * 3];
                float f7 = this.sourceCoords[n * 3 + 1];
                float f8 = this.sourceCoords[n * 3 + 2];
                float f9 = this.sourceNormals[n * 3];
                float f10 = this.sourceNormals[n * 3 + 1];
                float f11 = this.sourceNormals[n * 3 + 2];
                float f12 = this.globalMatrix.m00 * f + this.globalMatrix.m01 * f7 + this.globalMatrix.m02 * f8 + this.globalMatrix.m03;
                float f13 = this.globalMatrix.m10 * f + this.globalMatrix.m11 * f7 + this.globalMatrix.m12 * f8 + this.globalMatrix.m13;
                float f14 = this.globalMatrix.m20 * f + this.globalMatrix.m21 * f7 + this.globalMatrix.m22 * f8 + this.globalMatrix.m23;
                float f15 = this.globalMatrix.m00 * f9 + this.globalMatrix.m01 * f10 + this.globalMatrix.m02 * f11;
                float f16 = this.globalMatrix.m10 * f9 + this.globalMatrix.m11 * f10 + this.globalMatrix.m12 * f11;
                float f17 = this.globalMatrix.m20 * f9 + this.globalMatrix.m21 * f10 + this.globalMatrix.m22 * f11;
                int n5 = n * 3;
                fArray[n5] = fArray[n5] + f12 * this.skinCoordWeight[i];
                int n6 = n * 3 + 1;
                fArray[n6] = fArray[n6] + f13 * this.skinCoordWeight[i];
                int n7 = n * 3 + 2;
                fArray[n7] = fArray[n7] + f14 * this.skinCoordWeight[i];
                int n8 = n * 3;
                fArray2[n8] = fArray2[n8] + f15 * this.skinCoordWeight[i];
                int n9 = n * 3 + 1;
                fArray2[n9] = fArray2[n9] + f16 * this.skinCoordWeight[i];
                int n10 = n * 3 + 2;
                fArray2[n10] = fArray2[n10] + f17 * this.skinCoordWeight[i];
            }
        }
        this.dirty = false;
    }
}

