/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.geom.particle;

import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.geom.particle.ParticleSystem;
import org.j3d.renderer.aviatrix3d.geom.particle.AVParticle;

public abstract class AVParticleSystem
extends ParticleSystem
implements NodeUpdateListener {
    protected float[] vertices;
    protected float[][] texCoords;
    protected float[] colors;
    protected float[] normals;
    protected Geometry particleGeometry;
    protected boolean sendNewArrays = false;

    public AVParticleSystem(String string, int n) {
        super(string, n);
    }

    protected void updateGeometry() {
        int n = this.particleList.size();
        int n2 = this.numColorComponents() * this.coordinatesPerParticle();
        int n3 = this.coordinatesPerParticle() * 3;
        int n4 = this.coordinatesPerParticle() * this.numTexCoordComponents();
        if (this.sendNewArrays) {
            if (n4 == 0 || this.texCoordInterp == null) {
                for (int i = 0; i < n; ++i) {
                    AVParticle aVParticle = (AVParticle)this.particleList.next();
                    aVParticle.updateArrays(this.vertices, this.colors);
                    aVParticle.writeValues(i * n3, i * n2);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    AVParticle aVParticle = (AVParticle)this.particleList.next();
                    aVParticle.updateArrays(this.vertices, this.colors);
                    aVParticle.writeValues(i * n3, i * n2);
                    float f = this.timeNow - aVParticle.getBirthTime();
                    this.texCoordInterp.interpolate(f, i * n4, this.texCoords[0]);
                }
            }
            this.sendNewArrays = false;
        } else if (n4 == 0 || this.texCoordInterp == null) {
            for (int i = 0; i < n; ++i) {
                AVParticle aVParticle = (AVParticle)this.particleList.next();
                aVParticle.writeValues(i * n3, i * n2);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                AVParticle aVParticle = (AVParticle)this.particleList.next();
                aVParticle.writeValues(i * n3, i * n2);
                float f = this.timeNow - aVParticle.getBirthTime();
                this.texCoordInterp.interpolate(f, i * n4, this.texCoords[0]);
            }
        }
        this.particleList.reset();
        this.particleGeometry.boundsChanged(this);
        if (this.colors != null) {
            this.particleGeometry.dataChanged(this);
        }
    }

    public Geometry getNode() {
        return this.particleGeometry;
    }

    protected void initializeArrays() {
        int n = this.maxParticleCount * this.coordinatesPerParticle();
        int n2 = n * 3;
        int n3 = n * this.numColorComponents();
        int n4 = n * 3;
        int n5 = n * this.numTexCoordComponents();
        this.vertices = new float[n2];
        this.normals = new float[n4];
        if (n3 != 0) {
            this.colors = new float[n3];
        }
        if (n5 != 0) {
            this.texCoords = new float[1][n5];
        }
    }

    public void setMaxParticleCount(int n) {
        super.setMaxParticleCount(n);
        if (n * this.coordinatesPerParticle() > this.vertices.length) {
            this.initializeArrays();
            this.sendNewArrays = true;
        }
    }
}

