/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.geom.particle;

import org.j3d.aviatrix3d.PolygonAttributes;
import org.j3d.aviatrix3d.QuadArray;
import org.j3d.aviatrix3d.TextureAttributes;
import org.j3d.geom.particle.Particle;
import org.j3d.renderer.aviatrix3d.geom.particle.AVParticleSystem;
import org.j3d.renderer.aviatrix3d.geom.particle.QuadParticle;

public class QuadParticleSystem
extends AVParticleSystem {
    private static final String COLOR_COMP_MSG = "The number of olor components is only allowed to be 0, 3 or 4";
    private static final int[] TEX_TYPES = new int[]{2};
    private final int numColors;
    private PolygonAttributes polyAttr;
    private TextureAttributes texAttr;
    private int createdParticleCount;
    private boolean haveNewParticle;
    private float particleHeight;
    private float particleWidth;

    public QuadParticleSystem(String string, int n, int n2) {
        super(string, n);
        if (n2 != 0 && n2 != 3 && n2 != 4) {
            throw new IllegalArgumentException(COLOR_COMP_MSG);
        }
        this.numColors = n2;
        this.createdParticleCount = 0;
        this.haveNewParticle = false;
        this.particleWidth = 0.02f;
        this.particleHeight = 0.02f;
        this.particleGeometry = new QuadArray();
        this.initializeArrays();
    }

    public final int coordinatesPerParticle() {
        return 4;
    }

    public final int numColorComponents() {
        return this.numColors;
    }

    public final int numTexCoordComponents() {
        return 2;
    }

    public Particle createParticle() {
        this.particleGeometry.dataChanged(this);
        this.haveNewParticle = true;
        QuadParticle quadParticle = new QuadParticle(this.createdParticleCount++, this.vertices, this.normals, this.colors, this.texCoords[0], this.numColors == 4);
        quadParticle.setHeight(this.particleHeight);
        quadParticle.setWidth(this.particleWidth);
        return quadParticle;
    }

    public void onRemove() {
    }

    public void updateNodeBoundsChanges(Object object) {
        ((QuadArray)this.particleGeometry).setVertices(3, this.vertices, this.particleCount * 4);
    }

    public void updateNodeDataChanges(Object object) {
        QuadArray quadArray = (QuadArray)this.particleGeometry;
        switch (this.numColors) {
            case 3: {
                quadArray.setColors(false, this.colors);
                break;
            }
            case 4: {
                quadArray.setColors(true, this.colors);
            }
        }
        if (this.genTexCoords) {
            quadArray.setTextureCoordinates(TEX_TYPES, this.texCoords, 1);
        }
        if (this.haveNewParticle) {
            quadArray.setNormals(this.normals);
            this.haveNewParticle = false;
        }
    }

    public TextureAttributes getRecommendedTextureAttributes() {
        if (this.texAttr == null) {
            this.texAttr = new TextureAttributes();
            this.texAttr.setTextureMode(7681);
        }
        return this.texAttr;
    }

    public PolygonAttributes getRecommendedPolygonAttributes() {
        if (this.polyAttr == null) {
            this.polyAttr = new PolygonAttributes();
            this.polyAttr.setCulledFace(0);
        }
        return this.polyAttr;
    }

    public void setParticleSize(float f, float f2) {
        this.particleWidth = f;
        this.particleHeight = f2;
    }
}

