/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.geom.volume;

import javax.vecmath.Matrix4f;
import javax.vecmath.Vector4f;
import org.j3d.aviatrix3d.CullInstructions;
import org.j3d.aviatrix3d.Cullable;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Node;

public class OctTree
extends Node
implements Cullable {
    private static final String HIGH_DETAIL_NUM_ERR = "numValid is out of range. It should be [0,8]";
    private static final String NEG_RANGE_MSG = "The range value provided was negative. It should be >= 0";
    private float range;
    private Node lowDetailGeom;
    private Node[] highDetailGeom = new Node[8];
    private int numHighDetailGeom;

    public void cullChildren(CullInstructions cullInstructions, Matrix4f matrix4f, Matrix4f matrix4f2, Vector4f[] vector4fArray, float f) {
        float f2 = matrix4f.m03 - matrix4f2.m03;
        float f3 = matrix4f.m13 - matrix4f2.m13;
        float f4 = matrix4f.m23 - matrix4f2.m23;
        cullInstructions.hasTransform = false;
        if (f2 * f2 + f3 * f3 + f4 * f4 < this.range) {
            cullInstructions.numChildren = this.numHighDetailGeom;
            if (cullInstructions.children.length < 8) {
                cullInstructions.resizeChildren(8);
            }
            System.arraycopy(this.highDetailGeom, 0, cullInstructions.children, 0, this.numHighDetailGeom);
        } else if (this.lowDetailGeom != null) {
            cullInstructions.numChildren = 1;
            cullInstructions.children[0] = this.lowDetailGeom;
        } else {
            cullInstructions.numChildren = 0;
        }
    }

    public void setRange(float f) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (f < 0.0f) {
            throw new IllegalArgumentException(NEG_RANGE_MSG);
        }
        this.range = f * f;
    }

    public float getRange() {
        return (float)Math.sqrt(this.range);
    }

    public void setLowDetail(Node node) throws InvalidWriteTimingException {
        if (this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.lowDetailGeom = node;
    }

    public Node getLowDetail() {
        return this.lowDetailGeom;
    }

    public void setHighDetail(Node[] nodeArray, int n) throws InvalidWriteTimingException {
        if (this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n < 0 || n > 8) {
            throw new IllegalArgumentException(HIGH_DETAIL_NUM_ERR);
        }
        System.arraycopy(nodeArray, 0, this.highDetailGeom, 0, n);
        this.numHighDetailGeom = n;
    }

    public int numHighDetailGeom() {
        return this.numHighDetailGeom;
    }

    public void getHighDetail(Node[] nodeArray) {
        System.arraycopy(this.highDetailGeom, 0, nodeArray, 0, this.numHighDetailGeom);
    }
}

