/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.loader.discreet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.j3d.aviatrix3d.Appearance;
import org.j3d.aviatrix3d.ColorBackground;
import org.j3d.aviatrix3d.DirectionalLight;
import org.j3d.aviatrix3d.Fog;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.IndexedTriangleArray;
import org.j3d.aviatrix3d.Material;
import org.j3d.aviatrix3d.PolygonAttributes;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.SpotLight;
import org.j3d.aviatrix3d.Texture2D;
import org.j3d.aviatrix3d.TextureAttributes;
import org.j3d.aviatrix3d.TextureUnit;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.aviatrix3d.TriangleArray;
import org.j3d.aviatrix3d.Viewpoint;
import org.j3d.loaders.discreet.CameraBlock;
import org.j3d.loaders.discreet.KeyframeBlock;
import org.j3d.loaders.discreet.LightBlock;
import org.j3d.loaders.discreet.MaterialBlock;
import org.j3d.loaders.discreet.MaterialData;
import org.j3d.loaders.discreet.MaxParser;
import org.j3d.loaders.discreet.MaxUtils;
import org.j3d.loaders.discreet.ObjectBlock;
import org.j3d.loaders.discreet.ObjectMesh;
import org.j3d.loaders.discreet.TextureBlock;
import org.j3d.loaders.discreet.TriangleMesh;
import org.j3d.renderer.aviatrix3d.loader.AVLoader;
import org.j3d.renderer.aviatrix3d.loader.AVModel;
import org.j3d.renderer.aviatrix3d.loader.discreet.MaxModel;
import org.j3d.util.MatrixUtils;

public class MaxLoader
implements AVLoader {
    private static final int[] TEX_COORD_TYPES = new int[]{2};
    private int loadFlags = -1;
    private boolean keepModel = false;
    private MaxParser parser;
    private PolygonAttributes oneSidePolyAttrs;
    private PolygonAttributes twoSidePolyAttrs;
    private Matrix4f matrix = new Matrix4f();
    private Point3f eyePosition;
    private Point3f center;
    private Vector3f upVector;
    private MaxUtils maxUtils = new MaxUtils();
    private MatrixUtils matrixUtils;
    private boolean[] facesProcessed;

    public AVModel load(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        ObjectMesh objectMesh = this.parse(inputStream);
        if (objectMesh == null) {
            throw new IOException("Unknown error. Null mesh returned");
        }
        return this.convertMeshToModel(objectMesh);
    }

    public AVModel load(InputStream inputStream) throws IOException {
        ObjectMesh objectMesh = this.parse(inputStream);
        if (objectMesh == null) {
            throw new IOException("Unknown error. Null mesh returned");
        }
        return this.convertMeshToModel(objectMesh);
    }

    public AVModel load(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        ObjectMesh objectMesh = this.parse(fileInputStream);
        if (objectMesh == null) {
            throw new IOException("Unknown error. Null mesh returned");
        }
        return this.convertMeshToModel(objectMesh);
    }

    public void setLoadFlags(int n) {
        this.loadFlags = n;
    }

    public int getLoadFlags() {
        return this.loadFlags;
    }

    public void keepInternalModel(boolean bl) {
        this.keepModel = bl;
    }

    public boolean isInternalModelKept() {
        return this.keepModel;
    }

    private ObjectMesh parse(InputStream inputStream) throws IOException {
        if (this.parser == null) {
            this.parser = new MaxParser(inputStream);
        } else {
            this.parser.reset(inputStream);
        }
        return this.parser.parse();
    }

    private AVModel convertMeshToModel(ObjectMesh objectMesh) {
        int n;
        this.maxUtils.calcAllNormals(objectMesh);
        TransformGroup transformGroup = new TransformGroup();
        if (objectMesh.masterScale != 1.0f) {
            this.matrix.setIdentity();
            this.matrix.setScale(objectMesh.masterScale);
            transformGroup.setTransform(this.matrix);
        }
        MaxModel maxModel = new MaxModel(transformGroup, (ObjectMesh)(this.keepModel ? objectMesh : null));
        for (n = 0; n < objectMesh.numMaterials; ++n) {
            this.processMaterialBlock(maxModel, objectMesh.materials[n]);
        }
        for (n = 0; n < objectMesh.numBlocks; ++n) {
            this.processObjectBlock(maxModel, objectMesh.blocks[n]);
        }
        if ((this.loadFlags & 8) != 0) {
            for (n = 0; n < objectMesh.numKeyframes; ++n) {
                this.processKeyframeBlock(maxModel, objectMesh.keyframes[n]);
            }
        }
        return maxModel;
    }

    private void processMaterialBlock(MaxModel maxModel, MaterialBlock materialBlock) {
        TextureAttributes textureAttributes;
        Texture2D texture2D;
        TextureUnit textureUnit;
        TextureBlock textureBlock;
        if (materialBlock.name == null || materialBlock.name.length() == 0) {
            return;
        }
        Appearance appearance = new Appearance();
        maxModel.addNamedObject(materialBlock.name, appearance);
        Material material = new Material();
        appearance.setMaterial(material);
        material.setShininess(materialBlock.shininessStrength);
        material.setTransparency(materialBlock.transparency);
        if (materialBlock.ambientColor != null) {
            material.setAmbientColor(materialBlock.ambientColor);
        }
        if (materialBlock.diffuseColor != null) {
            material.setDiffuseColor(materialBlock.diffuseColor);
        }
        if (materialBlock.specularColor != null) {
            material.setSpecularColor(materialBlock.specularColor);
        }
        if (materialBlock.twoSidedLighting) {
            if (this.twoSidePolyAttrs == null) {
                this.twoSidePolyAttrs = new PolygonAttributes();
                this.twoSidePolyAttrs.setTwoSidedLighting(true);
                this.twoSidePolyAttrs.setSeparateSpecular(true);
            }
            appearance.setPolygonAttributes(this.twoSidePolyAttrs);
        } else {
            if (this.oneSidePolyAttrs == null) {
                this.oneSidePolyAttrs = new PolygonAttributes();
                this.oneSidePolyAttrs.setSeparateSpecular(true);
            }
            appearance.setPolygonAttributes(this.oneSidePolyAttrs);
        }
        TextureUnit[] textureUnitArray = new TextureUnit[5];
        int n = 0;
        if (materialBlock.bumpMap != null && materialBlock.bumpMap.filename != null) {
            textureBlock = materialBlock.bumpMap;
            textureUnit = new TextureUnit();
            if (textureBlock.uOffset != 0.0f || textureBlock.vOffset != 0.0f || textureBlock.uScale != 1.0f || textureBlock.vScale != 1.0f || textureBlock.angle != 0.0f) {
                this.matrix.setIdentity();
                if (textureBlock.uScale != 0.0f) {
                    this.matrix.m00 = textureBlock.uScale;
                }
                if (textureBlock.vScale != 0.0f) {
                    this.matrix.m11 = textureBlock.vScale;
                }
                this.matrix.m03 = textureBlock.uOffset;
                this.matrix.m13 = textureBlock.vOffset;
                textureUnit.setTextureTransform(this.matrix);
            }
            texture2D = new Texture2D();
            texture2D.setUserData("BUMP_MAP");
            textureUnit.setTexture(texture2D);
            if ((textureBlock.tiling & 0x10) != 0) {
                texture2D.setBoundaryModeS(33071);
                texture2D.setBoundaryModeT(33071);
            } else {
                texture2D.setBoundaryModeS(10497);
                texture2D.setBoundaryModeT(10497);
            }
            maxModel.addExternalObject((SceneGraphObject)texture2D, textureBlock.filename);
            textureAttributes = new TextureAttributes();
            textureAttributes.setTextureMode(34160);
            textureAttributes.setCombineMode(false, 34478);
            textureAttributes.setCombineMode(true, 7681);
            textureAttributes.setCombineSource(false, 0, 5890);
            textureAttributes.setCombineSource(true, 0, 34166);
            if (textureBlock.blendColor1 != null) {
                textureAttributes.setBlendColor(textureBlock.blendColor1[0], textureBlock.blendColor2[1], textureBlock.blendColor2[2], 1.0f);
            }
            textureUnit.setTextureAttributes(textureAttributes);
            textureUnitArray[n++] = textureUnit;
        }
        if (materialBlock.opacityMap != null && materialBlock.opacityMap.filename != null) {
            textureBlock = materialBlock.opacityMap;
            textureUnit = new TextureUnit();
            if (textureBlock.uOffset != 0.0f || textureBlock.vOffset != 0.0f || textureBlock.uScale != 1.0f || textureBlock.vScale != 1.0f || textureBlock.angle != 0.0f) {
                this.matrix.setIdentity();
                if (textureBlock.uScale != 0.0f) {
                    this.matrix.m00 = textureBlock.uScale;
                }
                if (textureBlock.vScale != 0.0f) {
                    this.matrix.m11 = textureBlock.vScale;
                }
                this.matrix.m03 = textureBlock.uOffset;
                this.matrix.m13 = textureBlock.vOffset;
                textureUnit.setTextureTransform(this.matrix);
            }
            texture2D = new Texture2D();
            texture2D.setUserData("OPACITY_MAP");
            textureUnit.setTexture(texture2D);
            if ((textureBlock.tiling & 0x10) != 0) {
                texture2D.setBoundaryModeS(33071);
                texture2D.setBoundaryModeT(33071);
            } else {
                texture2D.setBoundaryModeS(10497);
                texture2D.setBoundaryModeT(10497);
            }
            maxModel.addExternalObject((SceneGraphObject)texture2D, textureBlock.filename);
            textureAttributes = new TextureAttributes();
            textureAttributes.setTextureMode(34160);
            textureAttributes.setCombineMode(false, 7681);
            textureAttributes.setCombineMode(true, 7681);
            textureAttributes.setCombineSource(false, 0, 34168);
            textureAttributes.setCombineSource(true, 0, 5890);
            textureUnit.setTextureAttributes(textureAttributes);
            textureUnitArray[n++] = textureUnit;
        }
        if (materialBlock.textureMap1 != null && materialBlock.textureMap1.filename != null) {
            textureBlock = materialBlock.textureMap1;
            textureUnit = new TextureUnit();
            if (textureBlock.uOffset != 0.0f || textureBlock.vOffset != 0.0f || textureBlock.uScale != 1.0f || textureBlock.vScale != 1.0f || textureBlock.angle != 0.0f) {
                this.matrix.setIdentity();
                if (textureBlock.uScale != 0.0f) {
                    this.matrix.m00 = textureBlock.uScale;
                }
                if (textureBlock.vScale != 0.0f) {
                    this.matrix.m11 = textureBlock.vScale;
                }
                this.matrix.m03 = textureBlock.uOffset;
                this.matrix.m13 = textureBlock.vOffset;
                textureUnit.setTextureTransform(this.matrix);
            }
            texture2D = new Texture2D();
            texture2D.setUserData("BASE_MAP1");
            textureUnit.setTexture(texture2D);
            if ((textureBlock.tiling & 0x10) != 0) {
                texture2D.setBoundaryModeS(33071);
                texture2D.setBoundaryModeT(33071);
            } else {
                texture2D.setBoundaryModeS(10497);
                texture2D.setBoundaryModeT(10497);
            }
            maxModel.addExternalObject((SceneGraphObject)texture2D, textureBlock.filename);
            textureAttributes = new TextureAttributes();
            if ((textureBlock.tiling & 1) != 0) {
                textureAttributes.setTextureMode(8448);
            } else {
                textureAttributes.setTextureMode(7681);
            }
            textureUnit.setTextureAttributes(textureAttributes);
            textureUnitArray[n++] = textureUnit;
        }
        if (materialBlock.specularMap != null && materialBlock.specularMap.filename != null) {
            textureBlock = materialBlock.specularMap;
            textureUnit = new TextureUnit();
            if (textureBlock.uOffset != 0.0f || textureBlock.vOffset != 0.0f || textureBlock.uScale != 1.0f || textureBlock.vScale != 1.0f || textureBlock.angle != 0.0f) {
                this.matrix.setIdentity();
                if (textureBlock.uScale != 0.0f) {
                    this.matrix.m00 = textureBlock.uScale;
                }
                if (textureBlock.vScale != 0.0f) {
                    this.matrix.m11 = textureBlock.vScale;
                }
                this.matrix.m03 = textureBlock.uOffset;
                this.matrix.m13 = textureBlock.vOffset;
                textureUnit.setTextureTransform(this.matrix);
            }
            texture2D = new Texture2D();
            texture2D.setUserData("SPECULAR_MAP");
            textureUnit.setTexture(texture2D);
            if ((textureBlock.tiling & 0x10) != 0) {
                texture2D.setBoundaryModeS(33071);
                texture2D.setBoundaryModeT(33071);
            } else {
                texture2D.setBoundaryModeS(10497);
                texture2D.setBoundaryModeT(10497);
            }
            maxModel.addExternalObject((SceneGraphObject)texture2D, textureBlock.filename);
            textureAttributes = new TextureAttributes();
            textureAttributes.setTextureMode(260);
            textureUnit.setTextureAttributes(textureAttributes);
            textureUnitArray[n++] = textureUnit;
        }
        appearance.setTextureUnits(textureUnitArray, n);
    }

    private void processObjectBlock(MaxModel maxModel, ObjectBlock objectBlock) {
        Group group = this.processObjectMesh(maxModel, objectBlock);
        if ((this.loadFlags & 0x20) != 0) {
            this.processObjectLights(maxModel, objectBlock, group);
        }
        if ((this.loadFlags & 4) != 0) {
            this.processObjectCameras(maxModel, objectBlock, group);
        }
    }

    private Group processObjectMesh(MaxModel maxModel, ObjectBlock objectBlock) {
        Group group = maxModel.getModelRoot();
        Map map = maxModel.getNamedObjects();
        Group group2 = new Group();
        group.addChild(group2);
        for (int i = 0; i < objectBlock.numMeshes; ++i) {
            Object object;
            Object object2;
            Object object3;
            TransformGroup transformGroup = new TransformGroup();
            group2.addChild(transformGroup);
            maxModel.addNamedObject(objectBlock.name + '-' + i, transformGroup);
            TriangleMesh triangleMesh = objectBlock.meshes[i];
            if (triangleMesh.numMaterials > 1 || triangleMesh.numMaterials == 1 && triangleMesh.materials[0].numFaces != 0 && triangleMesh.materials[0].numFaces != triangleMesh.numFaces) {
                int n;
                if (this.facesProcessed == null || this.facesProcessed.length < triangleMesh.numFaces) {
                    this.facesProcessed = new boolean[triangleMesh.numFaces];
                }
                for (n = 0; n < triangleMesh.numFaces; ++n) {
                    this.facesProcessed[n] = false;
                }
                n = 0;
                for (int j = 0; j < triangleMesh.numMaterials; ++j) {
                    int n2;
                    object3 = triangleMesh.materials[j];
                    Shape3D shape3D = new Shape3D();
                    object2 = (Appearance)map.get(object3.materialName);
                    shape3D.setAppearance((Appearance)object2);
                    transformGroup.addChild(shape3D);
                    object = new int[object3.numFaces * 3];
                    int n3 = 0;
                    for (int k = 0; k < object3.numFaces; ++k) {
                        object[n3] = triangleMesh.faces[object3.faceList[k] * 3];
                        object[n3 + 1] = triangleMesh.faces[object3.faceList[k] * 3 + 1];
                        object[n3 + 2] = triangleMesh.faces[object3.faceList[k] * 3 + 2];
                        n3 += 3;
                    }
                    float[] fArray = new float[object3.numFaces * 3 * 3];
                    n3 = 0;
                    for (int k = 0; k < object3.numFaces; ++k) {
                        this.facesProcessed[object[k]] = true;
                        ++n;
                        fArray[n3] = triangleMesh.vertices[object[k * 3] * 3];
                        fArray[n3 + 1] = triangleMesh.vertices[object[k * 3] * 3 + true];
                        fArray[n3 + 2] = triangleMesh.vertices[object[k * 3] * 3 + 2];
                        fArray[n3 + 3] = triangleMesh.vertices[object[k * 3 + 1] * 3];
                        fArray[n3 + 4] = triangleMesh.vertices[object[k * 3 + 1] * 3 + true];
                        fArray[n3 + 5] = triangleMesh.vertices[object[k * 3 + 1] * 3 + 2];
                        fArray[n3 + 6] = triangleMesh.vertices[object[k * 3 + 2] * 3];
                        fArray[n3 + 7] = triangleMesh.vertices[object[k * 3 + 2] * 3 + true];
                        fArray[n3 + 8] = triangleMesh.vertices[object[k * 3 + 2] * 3 + 2];
                        n3 += 9;
                    }
                    TriangleArray triangleArray = new TriangleArray();
                    shape3D.setGeometry(triangleArray);
                    triangleArray.setVertices(3, fArray, object3.numFaces * 3);
                    if (triangleMesh.normals != null) {
                        n3 = 0;
                        fArray = new float[object3.numFaces * 3 * 3];
                        for (int k = 0; k < object3.numFaces * 3; ++k) {
                            fArray[n3] = triangleMesh.normals[object[k] * 3];
                            fArray[n3 + 1] = triangleMesh.normals[object[k] * 3 + true];
                            fArray[n3 + 2] = triangleMesh.normals[object[k] * 3 + 2];
                            n3 += 3;
                        }
                        triangleArray.setNormals(fArray);
                    }
                    if (triangleMesh.numTexCoords == 0) continue;
                    n3 = 0;
                    float[][] fArray2 = new float[1][object3.numFaces * 3 * 2];
                    for (n2 = 0; n2 < object3.numFaces * 3; ++n2) {
                        fArray2[0][n3] = triangleMesh.texCoords[object[n2] * 2];
                        fArray2[0][n3 + 1] = triangleMesh.texCoords[object[n2] * 2 + true];
                        n3 += 2;
                    }
                    triangleArray.setTextureCoordinates(TEX_COORD_TYPES, fArray2, 1);
                    n2 = ((Appearance)object2).numTextureUnits();
                    int[] nArray = new int[n2];
                    triangleArray.setTextureSetMap(nArray);
                }
                continue;
            }
            Shape3D shape3D = new Shape3D();
            IndexedTriangleArray indexedTriangleArray = new IndexedTriangleArray();
            indexedTriangleArray.setVertices(3, triangleMesh.vertices, triangleMesh.numVertices);
            indexedTriangleArray.setIndices(triangleMesh.faces, triangleMesh.numFaces * 3);
            if (triangleMesh.normals != null) {
                indexedTriangleArray.setNormals(triangleMesh.normals);
            }
            shape3D.setGeometry(indexedTriangleArray);
            if (triangleMesh.numMaterials == 1) {
                object3 = triangleMesh.materials[0];
                Appearance appearance = (Appearance)map.get(object3.materialName);
                shape3D.setAppearance(appearance);
            }
            if (triangleMesh.numTexCoords != 0) {
                object3 = new float[][]{triangleMesh.texCoords};
                indexedTriangleArray.setTextureCoordinates(TEX_COORD_TYPES, (float[][])object3, 1);
                int n = 1;
                if (triangleMesh.numMaterials == 1) {
                    object2 = triangleMesh.materials[0];
                    object = (Appearance)map.get(((MaterialData)object2).materialName);
                    n = ((Appearance)object).numTextureUnits();
                }
                object2 = new int[n];
                indexedTriangleArray.setTextureSetMap((int[])object2);
            }
            transformGroup.addChild(shape3D);
        }
        return group2;
    }

    private void processObjectLights(MaxModel maxModel, ObjectBlock objectBlock, Group group) {
        block4: for (int i = 0; i < objectBlock.numLights; ++i) {
            LightBlock lightBlock = objectBlock.lights[i];
            switch (lightBlock.type) {
                case 1: {
                    DirectionalLight directionalLight = new DirectionalLight();
                    directionalLight.setDirection(lightBlock.direction);
                    directionalLight.setDiffuseColor(lightBlock.color);
                    directionalLight.setEnabled(lightBlock.enabled);
                    group.addChild(directionalLight);
                    maxModel.addLight(directionalLight);
                    continue block4;
                }
                case 2: {
                    SpotLight spotLight = new SpotLight();
                    spotLight.setPosition(lightBlock.direction);
                    spotLight.setDiffuseColor(lightBlock.color);
                    spotLight.setEnabled(lightBlock.enabled);
                    spotLight.setDirection(lightBlock.direction[0] - lightBlock.target[0], lightBlock.direction[1] - lightBlock.target[1], lightBlock.direction[2] - lightBlock.target[2]);
                    spotLight.setCutOffAngle(lightBlock.hotspotAngle);
                    spotLight.setAttenuation(lightBlock.attenuation, 0.0f, 0.0f);
                    group.addChild(spotLight);
                    maxModel.addLight(spotLight);
                }
            }
        }
    }

    private void processObjectCameras(MaxModel maxModel, ObjectBlock objectBlock, Group group) {
        if (objectBlock.numCameras == 0) {
            return;
        }
        if (this.matrixUtils == null) {
            this.matrixUtils = new MatrixUtils();
            this.eyePosition = new Point3f();
            this.center = new Point3f();
            this.upVector = new Vector3f();
        }
        if (this.matrix == null) {
            this.matrix = new Matrix4f();
        }
        for (int i = 0; i < objectBlock.numCameras; ++i) {
            CameraBlock cameraBlock = objectBlock.cameras[i];
            this.eyePosition.set(cameraBlock.location);
            this.center.set(cameraBlock.target);
            double d = Math.toRadians(cameraBlock.bankAngle);
            this.upVector.set((float)Math.sin(d), (float)Math.cos(d), 0.0f);
            this.matrixUtils.lookAt(this.eyePosition, this.center, this.upVector, this.matrix);
            this.matrixUtils.inverse(this.matrix, this.matrix);
            TransformGroup transformGroup = new TransformGroup();
            transformGroup.setTransform(this.matrix);
            Viewpoint viewpoint = new Viewpoint();
            transformGroup.addChild(viewpoint);
            group.addChild(transformGroup);
            maxModel.addViewpoint(viewpoint);
        }
    }

    private void processBackground(MaxModel maxModel, ObjectMesh objectMesh) {
        switch (objectMesh.selectedBackground) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                ColorBackground colorBackground = new ColorBackground();
                colorBackground.setColor(objectMesh.solidBackgroundColor);
                Group group = maxModel.getModelRoot();
                group.addChild(colorBackground);
                maxModel.addBackground(colorBackground);
            }
        }
    }

    private void processFog(MaxModel maxModel, ObjectMesh objectMesh) {
        switch (objectMesh.selectedFog) {
            case 4: {
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                Fog fog = new Fog(9729);
                fog.setColor(objectMesh.fogColor);
                fog.setLinearDistance(objectMesh.linearFogDetails[0], objectMesh.linearFogDetails[2]);
                Group group = maxModel.getModelRoot();
                group.addChild(fog);
                maxModel.addFog(fog);
            }
        }
    }

    private void processKeyframeBlock(MaxModel maxModel, KeyframeBlock keyframeBlock) {
    }
}

