/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.loader.stl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.TriangleArray;
import org.j3d.loaders.stl.STLFileReader;
import org.j3d.renderer.aviatrix3d.loader.AVLoader;
import org.j3d.renderer.aviatrix3d.loader.AVModel;
import org.j3d.renderer.aviatrix3d.loader.stl.STLModel;

public class STLLoader
implements AVLoader {
    private static final String INVALID_FACE_COUNT_MSG = "Face count is greater than the number of faces declared";
    private int loadFlags;
    private boolean keepModel;

    public AVModel load(URL uRL) throws IOException {
        STLFileReader sTLFileReader = new STLFileReader(uRL);
        return this.loadInternal(sTLFileReader);
    }

    public AVModel load(InputStream inputStream) throws IOException {
        System.out.println("STLLoader.load(InputStream) not implemented yet");
        return null;
    }

    public AVModel load(File file) throws IOException {
        STLFileReader sTLFileReader = new STLFileReader(file);
        return this.loadInternal(sTLFileReader);
    }

    public void setLoadFlags(int n) {
        this.loadFlags = n;
    }

    public int getLoadFlags() {
        return this.loadFlags;
    }

    public void keepInternalModel(boolean bl) {
        this.keepModel = bl;
    }

    public boolean isInternalModelKept() {
        return this.keepModel;
    }

    private STLModel loadInternal(STLFileReader sTLFileReader) throws IOException {
        Group group = new Group();
        STLModel sTLModel = new STLModel(group);
        int n = sTLFileReader.getNumOfObjects();
        int[] nArray = sTLFileReader.getNumOfFacets();
        String[] stringArray = sTLFileReader.getObjectNames();
        double[] dArray = new double[3];
        double[][] dArray2 = new double[3][3];
        float[] fArray = new float[nArray[0] * 9];
        float[] fArray2 = new float[nArray[0] * 9];
        for (int i = 0; i < n; ++i) {
            if (fArray.length < nArray[i] * 9) {
                fArray = new float[nArray[i] * 9];
                fArray2 = new float[nArray[i] * 9];
            }
            boolean bl = false;
            for (int j = 0; j < nArray[i]; ++j) {
                if (!sTLFileReader.getNextFacet(dArray, dArray2)) {
                    throw new IOException(INVALID_FACE_COUNT_MSG);
                }
                fArray[j * 9] = (float)dArray[0];
                fArray[j * 9 + 1] = (float)dArray[1];
                fArray[j * 9 + 2] = (float)dArray[2];
                fArray[j * 9 + 3] = (float)dArray[0];
                fArray[j * 9 + 4] = (float)dArray[1];
                fArray[j * 9 + 5] = (float)dArray[2];
                fArray[j * 9 + 6] = (float)dArray[0];
                fArray[j * 9 + 7] = (float)dArray[1];
                fArray[j * 9 + 8] = (float)dArray[2];
                fArray2[j * 9] = (float)dArray2[0][0];
                fArray2[j * 9 + 1] = (float)dArray2[0][1];
                fArray2[j * 9 + 2] = (float)dArray2[0][2];
                fArray2[j * 9 + 3] = (float)dArray2[1][0];
                fArray2[j * 9 + 4] = (float)dArray2[1][1];
                fArray2[j * 9 + 5] = (float)dArray2[1][2];
                fArray2[j * 9 + 6] = (float)dArray2[2][0];
                fArray2[j * 9 + 7] = (float)dArray2[2][1];
                fArray2[j * 9 + 8] = (float)dArray2[2][2];
            }
            TriangleArray triangleArray = new TriangleArray();
            triangleArray.setVertices(3, fArray2, nArray[i] * 3);
            triangleArray.setNormals(fArray);
            Shape3D shape3D = new Shape3D();
            shape3D.setGeometry(triangleArray);
            group.addChild(shape3D);
            if (stringArray[i] == null) continue;
            sTLModel.addNamedObject(stringArray[i], shape3D);
        }
        return sTLModel;
    }
}

