/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.loader.vterrain;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.IndexedTriangleStripArray;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.geom.GeometryData;
import org.j3d.geom.terrain.ElevationGridGenerator;
import org.j3d.loaders.HeightMapSource;
import org.j3d.loaders.vterrain.BTHeader;
import org.j3d.loaders.vterrain.BTParser;
import org.j3d.renderer.aviatrix3d.loader.AVLoader;
import org.j3d.renderer.aviatrix3d.loader.AVModel;
import org.j3d.renderer.aviatrix3d.loader.vterrain.BTModel;

public class BTLoader
implements AVLoader,
HeightMapSource {
    private static final int[] TEX_COORD_TYPES = new int[]{2};
    private int loadFlags = -1;
    private boolean keepModel = false;
    private BTParser parser;
    private ElevationGridGenerator generator;
    private float[] gridStepData;

    public AVModel load(URL uRL) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(iOException.getMessage());
        }
        return this.loadInternal(bufferedInputStream);
    }

    public AVModel load(InputStream inputStream) throws IOException {
        return this.loadInternal(inputStream);
    }

    public AVModel load(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        return this.loadInternal(bufferedInputStream);
    }

    public void setLoadFlags(int n) {
        this.loadFlags = n;
    }

    public int getLoadFlags() {
        return this.loadFlags;
    }

    public void keepInternalModel(boolean bl) {
        this.keepModel = bl;
    }

    public boolean isInternalModelKept() {
        return this.keepModel;
    }

    public float[][] getHeights() {
        return this.parser.getHeights();
    }

    public float[] getGridStep() {
        return this.gridStepData;
    }

    public BTHeader getHeader() {
        return this.parser.getHeader();
    }

    private AVModel loadInternal(InputStream inputStream) throws IOException {
        if (this.parser == null) {
            this.parser = new BTParser(inputStream);
        } else {
            this.parser.reset(inputStream);
        }
        float[][] fArray = this.parser.parse();
        BTHeader bTHeader = this.parser.getHeader();
        float f = (float)(bTHeader.rightExtent - bTHeader.leftExtent);
        float f2 = (float)(bTHeader.topExtent - bTHeader.bottomExtent);
        this.gridStepData = new float[2];
        this.gridStepData[0] = f / (float)bTHeader.rows;
        this.gridStepData[1] = f2 / (float)bTHeader.columns;
        if (this.generator == null) {
            this.generator = new ElevationGridGenerator(f, f2, bTHeader.rows, bTHeader.columns, fArray, 0.0f);
        } else {
            this.generator.setDimensions(f, f2, bTHeader.rows, bTHeader.columns);
            this.generator.setTerrainDetail(fArray, 0.0f);
        }
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 7;
        geometryData.geometryComponents = 6;
        this.generator.generate(geometryData);
        if (!this.keepModel) {
            this.parser.clear();
            this.generator = null;
        }
        Group group = new Group();
        BTModel bTModel = new BTModel(group, bTHeader);
        IndexedTriangleStripArray indexedTriangleStripArray = new IndexedTriangleStripArray();
        indexedTriangleStripArray.setVertices(3, geometryData.coordinates, geometryData.vertexCount);
        indexedTriangleStripArray.setIndices(geometryData.indexes, geometryData.indexesCount);
        indexedTriangleStripArray.setStripCount(geometryData.stripCounts, geometryData.stripCounts.length);
        indexedTriangleStripArray.setNormals(geometryData.normals);
        float[][] fArrayArray = new float[][]{geometryData.textureCoordinates};
        indexedTriangleStripArray.setTextureCoordinates(TEX_COORD_TYPES, fArrayArray, 1);
        Shape3D shape3D = new Shape3D();
        shape3D.setGeometry(indexedTriangleStripArray);
        group.addChild(shape3D);
        return bTModel;
    }
}

