/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.navigation;

import javax.vecmath.Matrix4f;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.aviatrix3d.Viewpoint;
import org.j3d.renderer.aviatrix3d.navigation.AVViewpointData;
import org.j3d.renderer.aviatrix3d.navigation.FrameUpdateListener;
import org.j3d.renderer.aviatrix3d.navigation.ViewpointTransition;
import org.j3d.ui.navigation.ViewpointData;
import org.j3d.ui.navigation.ViewpointSelectionListener;
import org.j3d.ui.navigation.ViewpointToolbar;

public class ViewpointManager
implements ViewpointSelectionListener {
    private static final int DEFAULT_TRANSITION_TIME = 2000;
    private ViewpointToolbar toolbar;
    private ViewpointTransition transistor;
    private int transitionTime;
    private Viewpoint view;
    private TransformGroup viewTg;
    private Matrix4f destinationTx;

    public ViewpointManager() {
        this(2000);
    }

    public ViewpointManager(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Negative transition time");
        }
        this.transitionTime = n;
        this.transistor = new ViewpointTransition();
        this.destinationTx = new Matrix4f();
    }

    public void setToolbar(ViewpointToolbar viewpointToolbar) {
        if (this.toolbar != null) {
            this.toolbar.setViewpointSelectionListener(null);
        }
        this.toolbar = viewpointToolbar;
        if (this.toolbar != null) {
            this.toolbar.setEnabled(this.view != null);
            this.toolbar.setViewpointSelectionListener((ViewpointSelectionListener)this);
        }
    }

    public void setTransitionTime(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative transition time");
        }
        this.transitionTime = n;
    }

    public void setViewInfo(Viewpoint viewpoint, TransformGroup transformGroup) {
        if (viewpoint == null || transformGroup == null || viewpoint == null && transformGroup == null) {
            throw new IllegalArgumentException("View or TG is null when the other isn't");
        }
        if (this.toolbar != null) {
            this.toolbar.setEnabled(viewpoint != null);
        }
        this.view = viewpoint;
        this.viewTg = transformGroup;
    }

    public void setFrameUpdateListener(FrameUpdateListener frameUpdateListener) {
        this.transistor.setFrameUpdateListener(frameUpdateListener);
    }

    public void viewpointSelected(ViewpointData viewpointData) {
        if (this.view == null) {
            return;
        }
        if (!(viewpointData instanceof AVViewpointData)) {
            throw new IllegalArgumentException("Not an instance of AVViewpointData");
        }
        ((AVViewpointData)viewpointData).viewTg.getTransform(this.destinationTx);
        this.transistor.transitionTo(this.viewTg, this.destinationTx, this.transitionTime);
    }
}

