/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.nodes;

import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.renderer.aviatrix3d.nodes.BufferGeometry;

public abstract class IndexedBufferGeometry
extends BufferGeometry {
    protected int[] indices;
    protected int numIndices;

    protected boolean isVisible() {
        return super.isVisible() && this.numIndices != 0;
    }

    public void setIndices(int[] nArray, int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.indices == null || this.indices.length < n) {
            this.indices = new int[n];
        }
        this.numIndices = n;
        if (n > 0) {
            System.arraycopy(nArray, 0, this.indices, 0, n);
        }
    }

    public int getValidIndexCount() {
        return this.numIndices;
    }

    public void getIndices(int[] nArray) {
        System.arraycopy(this.indices, 0, nArray, 0, this.numIndices);
    }
}

