/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.nodes;

import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.renderer.aviatrix3d.nodes.IndexedBufferGeometry;

public class IndexedLineStripArray
extends IndexedBufferGeometry {
    private static final String MIN_COUNT_MSG = "A strip with less than 3 vertices is specified at index ";
    private static final String TOTAL_COUNT_MSG = "The total requested indexes in the strip is greater than the number of valid vertices provided.";
    private int[] stripCounts;
    private int numStrips;
    private int[][] stripIndices;

    protected boolean isVisible() {
        return super.isVisible() && this.numStrips != 0;
    }

    public void render(GL gL, GLU gLU) {
        if (this.numStrips == 0 || (this.vertexFormat & 7) == 0) {
            return;
        }
        this.setVertexState(gL, gLU);
        for (int i = 0; i < this.numStrips; ++i) {
            gL.glDrawElements(3, this.stripCounts[i], 5125, this.stripIndices[i]);
        }
        this.clearVertexState(gL, gLU);
    }

    public void postRender(GL gL, GLU gLU) {
    }

    public void setStripCount(int[] nArray, int n) throws InvalidWriteTimingException {
        int n2;
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            if (nArray[n2] < 2) {
                throw new IllegalArgumentException(MIN_COUNT_MSG + n2);
            }
            n3 += nArray[n2];
            if (n4 >= nArray[n2]) continue;
            n4 = nArray[n2];
        }
        if (this.stripCounts == null || this.stripCounts.length < n) {
            this.stripCounts = new int[n];
            this.stripIndices = new int[n][n4];
        }
        if (n4 > this.stripIndices[0].length) {
            this.stripIndices = new int[n][n4];
        }
        this.numStrips = n;
        if (n > 0) {
            System.arraycopy(nArray, 0, this.stripCounts, 0, n);
            n2 = 0;
            for (int i = 0; i < this.numStrips; ++i) {
                System.arraycopy(this.indices, n2, this.stripIndices[i], 0, this.stripCounts[i]);
                n2 += this.stripCounts[i];
            }
        }
    }

    public int getValidStripCount() {
        return this.numStrips;
    }

    public void getStripCount(int[] nArray) {
        System.arraycopy(this.stripCounts, 0, nArray, 0, this.numStrips);
    }
}

