/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.nodes;

import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.NotPickableException;
import org.j3d.renderer.aviatrix3d.nodes.IndexedBufferGeometry;

public class IndexedTriangleFanArray
extends IndexedBufferGeometry {
    private static final String MIN_COUNT_MSG = "A fan with less than 3 vertices is specified at index ";
    private static final String TOTAL_COUNT_MSG = "The total requested indexes in the fan is greater than the number of valid vertices provided.";
    private int[] fanCounts;
    private int numFans;
    private int[][] fanIndices;

    public IndexedTriangleFanArray() {
        this.initPolygonDetails(3);
    }

    protected boolean isVisible() {
        return super.isVisible() && this.numFans != 0;
    }

    public boolean pickLineSegment(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        super.pickLineSegment(fArray, fArray2, bl, fArray3, n);
        System.out.println("IndexedTriangleFanArray.pickLineSegment() not implemented yet");
        return false;
    }

    public boolean pickLineRay(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        super.pickLineRay(fArray, fArray2, bl, fArray3, n);
        System.out.println("IndexedTriangleFanArray.pickLineRay() not implemented yet");
        return false;
    }

    public void render(GL gL, GLU gLU) {
        if (this.numFans == 0 || (this.vertexFormat & 7) == 0) {
            return;
        }
        this.setVertexState(gL, gLU);
        for (int i = 0; i < this.numFans; ++i) {
            gL.glDrawElements(5, this.fanCounts[i], 5125, this.fanIndices[i]);
        }
        this.clearVertexState(gL, gLU);
    }

    public void postRender(GL gL, GLU gLU) {
    }

    public void setFanCount(int[] nArray, int n) throws InvalidWriteTimingException {
        int n2;
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            if (nArray[n2] < 3) {
                throw new IllegalArgumentException(MIN_COUNT_MSG + n2);
            }
            n3 += nArray[n2];
            if (n4 >= nArray[n2]) continue;
            n4 = nArray[n2];
        }
        if (this.fanCounts == null || this.fanCounts.length < n) {
            this.fanCounts = new int[n];
            this.fanIndices = new int[n][n4];
        }
        if (n4 > this.fanIndices[0].length) {
            this.fanIndices = new int[n][n4];
        }
        this.numFans = n;
        if (n > 0) {
            System.arraycopy(nArray, 0, this.fanCounts, 0, n);
            n2 = 0;
            for (int i = 0; i < this.numFans; ++i) {
                System.arraycopy(this.indices, n2, this.fanIndices[i], 0, this.fanCounts[i]);
                n2 += this.fanCounts[i];
            }
        }
    }

    public int getValidFanCount() {
        return this.numFans;
    }

    public void getFanCount(int[] nArray) {
        System.arraycopy(this.fanCounts, 0, nArray, 0, this.numFans);
    }
}

